#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  alignment.py
#  
#  Copyright 2019 Gabriele Orlando <orlando.gabriele89@gmail.com>
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
#  
#  
import numpy as np

from scipy.spatial.distance import euclidean

scaled_blosum={('B', 'N'): 0.5333333333333333, ('S', 'W'): 0.9333333333333333, ('G', 'G'): 0.33333333333333326, ('D', 'G'): 0.8, ('E', 'S'): 0.7333333333333334, ('H', 'W'): 0.8666666666666667, ('D', 'L'): 1.0, ('E', 'Z'): 0.4666666666666667, ('F', 'X'): 0.8, ('I', 'R'): 0.9333333333333333, ('X', 'Z'): 0.8, ('C', 'M'): 0.8, ('N', 'R'): 0.7333333333333334, ('G', 'P'): 0.8666666666666667, ('A', 'N'): 0.8666666666666667, ('L', 'X'): 0.8, ('A', 'Y'): 0.8666666666666667, ('F', 'Y'): 0.5333333333333333, ('P', 'Y'): 0.9333333333333333, ('L', 'Q'): 0.8666666666666667, ('M', 'Y'): 0.8, ('A', 'P'): 0.8, ('C', 'L'): 0.8, ('M', 'P'): 0.8666666666666667, ('N', 'S'): 0.6666666666666667, ('G', 'W'): 0.8666666666666667, ('D', 'W'): 1.0, ('K', 'W'): 0.9333333333333333, ('C', 'Z'): 0.9333333333333333, ('V', 'X'): 0.8, ('D', 'E'): 0.6, ('P', 'R'): 0.8666666666666667, ('F', 'Z'): 0.9333333333333333, ('P', 'V'): 0.8666666666666667, ('I', 'T'): 0.8, ('X', 'X'): 0.8, ('C', 'K'): 0.9333333333333333, ('H', 'K'): 0.8, ('Y', 'Y'): 0.2666666666666666, ('G', 'V'): 0.9333333333333333, ('K', 'V'): 0.8666666666666667, ('C', 'Y'): 0.8666666666666667, ('A', 'I'): 0.8, ('V', 'Y'): 0.8, ('L', 'V'): 0.6666666666666667, ('W', 'W'): 0.0, ('T', 'W'): 0.8666666666666667, ('A', 'R'): 0.8, ('M', 'R'): 0.8, ('N', 'N'): 0.33333333333333326, ('E', 'M'): 0.8666666666666667, ('C', 'X'): 0.8666666666666667, ('D', 'Z'): 0.6666666666666667, ('E', 'T'): 0.8, ('Q', 'T'): 0.8, ('H', 'R'): 0.7333333333333334, ('P', 'P'): 0.2666666666666666, ('D', 'H'): 0.8, ('E', 'F'): 0.9333333333333333, ('Q', 'Q'): 0.4, ('I', 'V'): 0.5333333333333333, ('E', 'I'): 0.9333333333333333, ('C', 'I'): 0.8, ('H', 'I'): 0.9333333333333333, ('F', 'F'): 0.33333333333333326, ('G', 'T'): 0.8666666666666667, ('K', 'T'): 0.8, ('C', 'W'): 0.8666666666666667, ('A', 'K'): 0.8, ('L', 'N'): 0.9333333333333333, ('A', 'B'): 0.8666666666666667, ('B', 'P'): 0.8666666666666667, ('L', 'T'): 0.8, ('L', 'M'): 0.6, ('A', 'T'): 0.7333333333333334, ('B', 'B'): 0.4666666666666667, ('C', 'H'): 0.9333333333333333, ('T', 'Z'): 0.8, ('F', 'N'): 0.9333333333333333, ('F', 'G'): 0.9333333333333333, ('G', 'K'): 0.8666666666666667, ('S', 'Z'): 0.7333333333333334, ('K', 'S'): 0.7333333333333334, ('C', 'V'): 0.8, ('D', 'X'): 0.8, ('E', 'V'): 0.8666666666666667, ('H', 'P'): 0.8666666666666667, ('E', 'Y'): 0.8666666666666667, ('B', 'Q'): 0.7333333333333334, ('H', 'Y'): 0.6, ('I', 'Q'): 0.9333333333333333, ('G', 'Q'): 0.8666666666666667, ('Q', 'S'): 0.7333333333333334, ('F', 'V'): 0.8, ('I', 'X'): 0.8, ('E', 'K'): 0.6666666666666667, ('B', 'C'): 0.9333333333333333, ('C', 'G'): 0.9333333333333333, ('N', 'X'): 0.8, ('S', 'S'): 0.4666666666666667, ('K', 'R'): 0.6, ('F', 'K'): 0.9333333333333333, ('A', 'M'): 0.8, ('A', 'D'): 0.8666666666666667, ('B', 'R'): 0.8, ('L', 'R'): 0.8666666666666667, ('F', 'W'): 0.6666666666666667, ('M', 'W'): 0.8, ('A', 'V'): 0.7333333333333334, ('B', 'D'): 0.4666666666666667, ('C', 'F'): 0.8666666666666667, ('T', 'X'): 0.7333333333333334, ('M', 'N'): 0.8666666666666667, ('N', 'Y'): 0.8666666666666667, ('G', 'I'): 1.0, ('S', 'X'): 0.7333333333333334, ('K', 'Q'): 0.6666666666666667, ('C', 'T'): 0.8, ('D', 'F'): 0.9333333333333333, ('E', 'P'): 0.8, ('V', 'V'): 0.4666666666666667, ('H', 'V'): 0.9333333333333333, ('P', 'T'): 0.8, ('B', 'S'): 0.7333333333333334, ('I', 'S'): 0.8666666666666667, ('F', 'P'): 1.0, ('G', 'Z'): 0.8666666666666667, ('E', 'X'): 0.8, ('I', 'Z'): 0.9333333333333333, ('B', 'E'): 0.6666666666666667, ('C', 'E'): 1.0, ('H', 'M'): 0.8666666666666667, ('N', 'Z'): 0.7333333333333334, ('G', 'H'): 0.8666666666666667, ('I', 'L'): 0.6, ('R', 'R'): 0.4, ('K', 'P'): 0.8, ('C', 'S'): 0.8, ('V', 'W'): 0.9333333333333333, ('F', 'L'): 0.7333333333333334, ('A', 'F'): 0.8666666666666667, ('B', 'T'): 0.8, ('K', 'N'): 0.7333333333333334, ('L', 'P'): 0.9333333333333333, ('A', 'Q'): 0.8, ('F', 'Q'): 0.9333333333333333, ('G', 'Y'): 0.9333333333333333, ('M', 'Q'): 0.7333333333333334, ('B', 'F'): 0.9333333333333333, ('C', 'D'): 0.9333333333333333, ('D', 'V'): 0.9333333333333333, ('Q', 'R'): 0.6666666666666667, ('T', 'T'): 0.4, ('S', 'V'): 0.8666666666666667, ('R', 'S'): 0.8, ('C', 'R'): 0.9333333333333333, ('D', 'D'): 0.33333333333333326, ('E', 'R'): 0.7333333333333334, ('F', 'R'): 0.9333333333333333, ('W', 'Z'): 0.9333333333333333, ('H', 'T'): 0.8666666666666667, ('D', 'M'): 0.9333333333333333, ('E', 'E'): 0.4, ('K', 'M'): 0.8, ('E', 'L'): 0.9333333333333333, ('Q', 'W'): 0.8666666666666667, ('G', 'X'): 0.8, ('S', 'Y'): 0.8666666666666667, ('B', 'G'): 0.8, ('C', 'C'): 0.1333333333333333, ('N', 'P'): 0.8666666666666667, ('G', 'N'): 0.7333333333333334, ('E', 'N'): 0.7333333333333334, ('I', 'N'): 0.9333333333333333, ('R', 'T'): 0.8, ('C', 'Q'): 0.9333333333333333, ('A', 'A'): 0.4666666666666667, ('W', 'Y'): 0.6, ('L', 'Y'): 0.8, ('A', 'X'): 0.7333333333333334, ('B', 'V'): 0.9333333333333333, ('K', 'L'): 0.8666666666666667, ('T', 'V'): 0.7333333333333334, ('M', 'X'): 0.8, ('A', 'S'): 0.6666666666666667, ('F', 'S'): 0.8666666666666667, ('M', 'S'): 0.8, ('D', 'Q'): 0.7333333333333334, ('B', 'H'): 0.7333333333333334, ('D', 'T'): 0.8, ('G', 'M'): 0.9333333333333333, ('S', 'T'): 0.6666666666666667, ('P', 'Z'): 0.8, ('C', 'P'): 0.9333333333333333, ('P', 'S'): 0.8, ('W', 'X'): 0.8666666666666667, ('H', 'Z'): 0.7333333333333334, ('D', 'K'): 0.8, ('E', 'G'): 0.8666666666666667, ('B', 'W'): 1.0, ('K', 'K'): 0.4, ('I', 'W'): 0.9333333333333333, ('X', 'Y'): 0.8, ('N', 'T'): 0.7333333333333334, ('H', 'H'): 0.19999999999999996, ('B', 'I'): 0.9333333333333333, ('I', 'I'): 0.4666666666666667, ('F', 'T'): 0.8666666666666667, ('G', 'L'): 1.0, ('A', 'H'): 0.8666666666666667, ('R', 'V'): 0.9333333333333333, ('A', 'C'): 0.7333333333333334, ('E', 'W'): 0.9333333333333333, ('L', 'W'): 0.8666666666666667, ('A', 'Z'): 0.8, ('B', 'X'): 0.8, ('L', 'L'): 0.4666666666666667, ('M', 'Z'): 0.8, ('V', 'Z'): 0.8666666666666667, ('F', 'M'): 0.7333333333333334, ('M', 'M'): 0.4, ('D', 'R'): 0.8666666666666667, ('P', 'X'): 0.8666666666666667, ('R', 'W'): 0.9333333333333333, ('H', 'S'): 0.8, ('P', 'Q'): 0.8, ('Q', 'Y'): 0.8, ('H', 'X'): 0.8, ('D', 'I'): 0.9333333333333333, ('B', 'Y'): 0.9333333333333333, ('I', 'Y'): 0.8, ('E', 'H'): 0.7333333333333334, ('N', 'V'): 0.9333333333333333, ('H', 'N'): 0.6666666666666667, ('B', 'K'): 0.7333333333333334, ('I', 'K'): 0.9333333333333333, ('R', 'X'): 0.8, ('K', 'Z'): 0.6666666666666667, ('A', 'E'): 0.8, ('Q', 'X'): 0.8, ('B', 'Z'): 0.6666666666666667, ('M', 'T'): 0.8, ('A', 'W'): 0.9333333333333333, ('N', 'W'): 1.0, ('G', 'S'): 0.7333333333333334, ('B', 'L'): 1.0, ('D', 'P'): 0.8, ('D', 'Y'): 0.9333333333333333, ('E', 'Q'): 0.6, ('R', 'Y'): 0.8666666666666667, ('K', 'Y'): 0.8666666666666667, ('H', 'Q'): 0.7333333333333334, ('D', 'N'): 0.6666666666666667, ('P', 'W'): 1.0, ('Q', 'V'): 0.8666666666666667, ('I', 'P'): 0.9333333333333333, ('F', 'H'): 0.8, ('G', 'R'): 0.8666666666666667, ('H', 'L'): 0.9333333333333333, ('B', 'M'): 0.9333333333333333, ('Z', 'Z'): 0.4666666666666667, ('I', 'M'): 0.6666666666666667, ('F', 'I'): 0.7333333333333334, ('A', 'L'): 0.8, ('R', 'Z'): 0.7333333333333334, ('K', 'X'): 0.8, ('L', 'Z'): 0.9333333333333333, ('A', 'G'): 0.7333333333333334, ('Q', 'Z'): 0.5333333333333333, ('D', 'S'): 0.7333333333333334, ('L', 'S'): 0.8666666666666667, ('C', 'N'): 0.9333333333333333, ('M', 'V'): 0.6666666666666667, ('N', 'Q'): 0.7333333333333334, ('Y', 'Z'): 0.8666666666666667, ('T', 'Y'): 0.8666666666666667}

def dtw(x, y, dist, s1,s2, mat, s=1.0, use_aminoacids=True): # shiftcrypt1, shiftcrypt2, seq1, seq2, substitution matrix, gap penality,use_aminoacids in the distance
	penal=0.1 # penality for missing value
	assert len(x)
	assert len(y)
	assert s > 0
	r, c = len(x), len(y)
		
	track=[[(-1,-1)]]

	D1 = np.zeros((r + 1, c + 1))
	for i in range(1,c):
		D1[0,i] = D1[0,i-1]+s
	for i in range(1,r):
		D1[i,0] = D1[i-1,0]+s	
	
	for i in range(c):
		track[0]+=[(0,i)]
		 
	for i in range(1,r+1):
		
		track_tmp=[(i-1,0)]
		for j in range(1,c+1):	
					
			k=1		
			if use_aminoacids:
				if x[i-1]<0 or y[j-1]<0:
					match = D1[i-1][j-1] + mat[tuple(sorted([s1[i-1],s2[j-1]]))]+penal
				else:
					match = D1[i-1][j-1] + mat[tuple(sorted([s1[i-1],s2[j-1]]))]+dist(x[i-1], y[j-1])
			else:
				if x[i-1]<0 or y[j-1]<0:
					match = D1[i-1][j-1] + penal
				else:
					match = D1[i-1][j-1] + dist(x[i-1], y[j-1])
			
			g1 = D1[i-1, j] + s
			g2 = D1[i, j-1] + s
			
			min_list = match
			best=(i-1,j-1)

			if g1 < min_list:
				min_list=g1
				best=(i-1,j)
				
			if g2 < min_list:
				min_list=g2
				best=(i,j-1)
				
			D1[i, j] = min_list
			track_tmp+=[best]

		track+=[track_tmp]
		
	if len(x) == 1:
		path = np.zeros(len(y)), list(range(len(y)))
	elif len(y) == 1:
		path = list(range(len(x))), np.zeros(len(x))
	else:
		path = _traceback(track,s1,s2)
	return D1[-1, -1], path

def _traceback(D,s1,s2):
	iold, jold = len(D)-1,len(D[0])-1
	i,j=D[iold][jold]

	a1, a2 = "", ""

	while (i !=-1) or (j!=-1):
		if i+1==iold and j+1==jold: #match

			a1 = s1[iold-1]+a1
			a2 = s2[jold-1]+a2
			iold, jold=i,j
			i,j=D[i][j]

		elif i+1==iold and j==jold:

			a1 = s1[iold-1]+a1
			a2 = "-"+a2
			iold, jold = i,j
			i,j=D[i][j]

		else: 
			a1 = "-"+a1
			a2 = s2[jold-1]+a2
			iold, jold=i,j
			i,j=D[i][j]

		
	return a1,a2

def alingment(shiftcrypt_1,shiftcrypt_2,seq1,seq2,use_aminoacids=False):

	score, alignment= dtw(shiftcrypt_1, shiftcrypt_2, s1=seq1,s2=seq2,mat=scaled_blosum,dist=euclidean,use_aminoacids=use_aminoacids)
	
	return alignment,score

if __name__ == '__main__':
	#x = np.array([[1,1], [2,2], [3,3], [4,4], [5,5]])
	#y = np.array([[2,2], [3,3], [4,4]])
	import matplotlib.pylab as plt
	s1="HHTEASSLVGKLETDVEIKASADKFHHMFAGKPHHVSKASPGNIQGCDLHEGDWGTVGSIVFWNYVHDGEAKVAKERIEAVEPDKNLITFRVIEGDLMKEYKSFLLTIQVTPKPGGPGSIVHWHLEYEKISEEVAHPETLLQFCVEVSKEIDEHLLAEE"
	x =[-10,-10,0.485701015732885,0.521968352218995,0.415095060013601,0.514123031094929,0.469586867533992,0.350904189747469,0.527420515328354,0.520592907999385,0.938510324430069,0.881455435765703,0.921027172294374,0.597307221518536,0.992056858375062,0.684215478232436,0.605459040812844,0.781348556376369,0.232961550418856,0.538513273240297,-10,0.140699322516659,0.101379165836238,0.19402187561909,0.158418135039498,-10,0.247229139614465,0.28917859758262,0.37875882498156,0.449083279163831,-10,0.642201963193106,0.533358329778247,-10,0.513357560581291,0.411879778975897,0.524164509784333,0.505745597672791,0.452399199569864,-10,0.40724170739504,-10,0.574322361428603,0.488690727360023,0.514709599549999,-10,0.470721653195736,-10,-10,-10,-10,-10,0.32604371368996,-10,0.400414320123983,0.564873982621953,0.165905708179671,0.495417089062218,-10,0.676108555656372,-10,0.665652034815573,-10,-10,0.642322240363705,0.537967393237534,0.787234560037597,0.291246108605997,0.445972094346943,0.779903439006605,0.457823870692052,0.861857317648754,0.785818738651322,0.785221239792337,0.745083205648454,0.816554256001803,0.954534447841203,0.30754377804573,0.590854026342554,0.751550837750622,-10,0.779331967069945,0.10487929638595,0.201396449685311,0.675534969373213,0.431675209241965,0.993703584464281,0.919948975402594,0.818863097568129,0.875738539526937,0.907567535339852,0.299921500026274,0.642441749577382,0.874851292784739,0.711326524363104,-0.013323469914738,0.147843251809338,0.578065191314837,0.357969862597261,0.723864378552894,0.669788221755584,-10,0.702401100696155,0.73448750500021,0.940170052941503,0.982096716752659,0.881386851620088,0.901497277250147,-10,0.602335590279021,0.785772393266573,-10,0.624368694558465,0.34650132237527,-10,0.575945256578327,0.657985081961026,0.525520791571826,0.943985229037232,0.694408148609956,0.3854377601158,0.70083926255199,0.682235566837108,0.790490128439932,0.702526851639163,-10,0.832884865772848,0.846931311430329,-10,0.193006969152392,0.703657422988368,0.29141741785865,0.324718161892173,0.442510305367683,0.610485701428619,0.780805033823436,0.250233801977524,0.200120188812606,0.294371830948002,0.193637841650325,0.066590964706904,0.186303698329347,0.224485130422379,0.003102406855215,0.07748848932941,0.016867546573897,0.069214219120081,0.165392407588209,0.169575002379245,0.080359528872699,0.09122769220095,0.089034759797499,0.074253716722938,0.215551472978671,0.194110992702727,0.307108901407541,0.418596978740641,0.580700485272194,0.047355396827014]
	s2="NPAICRYPLGMSGGQIPDEDITASSQWSESTAAKYGRLDSEEGDGAWCPEIPVEPDDLKEFLQIDLHTLHFITLVGTQGRHAGGHGIEFAPMYKINYSRDGTRWISWRNRHGKQVLDGNSNPYDIFLKDLEPPIVARFVRFIPVTDHSMNVCMRVELYGCV"
	y=[-10,0.665376429505277,0.533672873367637,0.609315632377582,0.977434671544353,0.637126051126439,0.537966035117811,0.646484511666482,0.504881512206391,0.651911797361437,0.541004258934058,0.395503306488076,0.548396931508521,0.526499169134679,0.332650823110254,-10,0.880177412706449,0.333863226316373,0.470447722972396,0.539261685911474,0.648806605621211,0.741330165476398,0.844640548226765,0.425032370364302,0.64222935731304,0.900388827571004,0.379446685605858,0.650618360017768,0.415208493871773,0.540506940884699,0.602396449308697,0.642737551377079,0.423731456094126,0.503147825460464,0.459405049937835,0.476282997439552,0.617136531313169,0.488644880844928,0.45891913921962,0.601020810897116,0.715070154954863,0.615381263005684,0.555125117214881,0.548701390182541,0.526467158621158,0.654264338973476,0.667756701460598,0.986006140852605,-10,0.554191038563619,-10,-10,0.392004938580075,0.706369302354252,0.714623838677242,0.537555323269265,0.528431810965034,0.504769969825693,0.609394002484421,0.705025004146958,0.599453616393983,0.495878072449929,0.946509279265958,0.820471786529291,0.50213929597484,0.475357960882386,-10,0.623680975589291,0.457781837890957,-10,0.574659793406284,0.61048231657929,0.558129627468182,0.671238950533215,0.871335141466813,0.700093083852174,0.879337421935921,0.935081937120325,0.613817743596281,0.684111980412546,0.508973252048497,0.577558995269554,0.523487095513019,0.516478592839863,-10,0.579198758892325,0.691293413622607,0.526983048057793,0.532889641850198,-10,0.862865348810868,0.985748491548327,0.623805994274032,0.852761521913689,0.759427522159468,0.974608794889673,0.780116122542667,-10,-10,0.530967790571978,0.557186195761158,0.508718370818767,0.614432586965989,0.729656530524522,0.617890290791599,0.659933780791242,0.487657412097849,0.666474935366851,0.597206973096049,0.531894816461343,0.753043249691959,0.525955183239243,0.606790528350134,0.727682265117833,0.37761891062002,0.499315909035771,0.508186175155206,0.555442458390086,0.380237119674704,0.603551318997765,-10,-10,0.521788182899307,0.506558718360465,0.570879130757972,0.532416488365109,0.510969928594191,0.686565298350178,0.549414891096318,0.491866443881792,-10,-10,0.84385728470864,0.641411695659112,0.445080229093361,0.812786988701026,0.616179479420609,0.886997603180857,0.675323008346481,0.863930757329127,0.582450254847269,-10,-10,0.559299786869362,0.660062075978235,0.496568631588882,-10,0.496044346805047,0.861659881461139,0.529731306170671,0.678187518463906,0.997991050648861,1.00655540096821,0.697593289758525,0.902687040567169,0.802267883007848,0.736269738400746,0.606335410572304,0.706291810522648,0.954582430261824,0.338910130291077]
	#x=np.linspace(0,1,len(s1)).reshape(-1,1)
	#y=np.linspace(0,1,len(s2)).reshape(-1,1)
	pxx=[]
	pxy=[]
	a,score= alingment(x,y,s1,s2)
	a1,a2=a
	cont=0
	for i in range(len(a1)):
		if a1[i]!="-":
			if x[cont]!=-10:
				pxy+=[x[cont]]
				pxx+=[cont]
			cont+=1
	pyx=[]
	pyy=[]
	a, score = alingment(x,y,s1,s2)
	a1,a2=a
	print("### Score (the lower the better): ",score)
	print(a1)
	print(a2)
	cont=0
	for i in range(len(a2)):
		if a2[i]!="-":
			if y[cont]!=-10:
				pyy+=[y[cont]]
				pyx+=[cont]
			cont+=1
	plt.plot(pxx,pxy,"r")		
	plt.plot(pyx,pyy,"b")
	plt.show()		
		
		
