"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRoute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const virtual_gateway_1 = require("./virtual-gateway");
/**
 * (experimental) GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 * @experimental
 */
class GatewayRoute extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.gatewayRouteName || cdk.Lazy.stringValue({ produce: () => this.node.uniqueId }),
        });
        this.virtualGateway = props.virtualGateway;
        const routeSpecConfig = props.routeSpec.bind(this);
        const gatewayRoute = new appmesh_generated_1.CfnGatewayRoute(this, 'Resource', {
            gatewayRouteName: this.physicalName,
            meshName: props.virtualGateway.mesh.meshName,
            spec: {
                httpRoute: routeSpecConfig.httpSpecConfig,
                http2Route: routeSpecConfig.http2SpecConfig,
                grpcRoute: routeSpecConfig.grpcSpecConfig,
            },
            virtualGatewayName: this.virtualGateway.virtualGatewayName,
        });
        this.gatewayRouteName = this.getResourceNameAttribute(gatewayRoute.attrGatewayRouteName);
        this.gatewayRouteArn = this.getResourceArnAttribute(gatewayRoute.ref, {
            service: 'appmesh',
            resource: `mesh/${props.virtualGateway.mesh.meshName}/virtualRouter/${this.virtualGateway.virtualGatewayName}/gatewayRoute`,
            resourceName: this.physicalName,
        });
    }
    /**
     * (experimental) Import an existing GatewayRoute given an ARN.
     *
     * @experimental
     */
    static fromGatewayRouteArn(scope, id, gatewayRouteArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteArn = gatewayRouteArn;
                this.gatewayRouteName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).parseArn(gatewayRouteArn).resourceName));
                this.virtualGateway = virtual_gateway_1.VirtualGateway.fromVirtualGatewayArn(this, 'virtualGateway', gatewayRouteArn);
            }
        }(scope, id);
    }
    /**
     * (experimental) Import an existing GatewayRoute given attributes.
     *
     * @experimental
     */
    static fromGatewayRouteAttributes(scope, id, attrs) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteName = attrs.gatewayRouteName;
                this.gatewayRouteArn = cdk.Stack.of(scope).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.virtualGateway.mesh.meshName}/virtualGateway/${attrs.virtualGateway.virtualGatewayName}/gatewayRoute`,
                    resourceName: this.gatewayRouteName,
                });
                this.virtualGateway = attrs.virtualGateway;
            }
        }(scope, id);
    }
}
exports.GatewayRoute = GatewayRoute;
_a = JSII_RTTI_SYMBOL_1;
GatewayRoute[_a] = { fqn: "@aws-cdk/aws-appmesh.GatewayRoute", version: "1.96.0" };
//# sourceMappingURL=data:application/json;base64,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