"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRouteSpec = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Used to generate specs with different protocols for a GatewayRoute.
 *
 * @experimental
 */
class GatewayRouteSpec {
    /**
     * (experimental) Creates an HTTP Based GatewayRoute.
     *
     * @param options - no http gateway route.
     * @experimental
     */
    static http(options) {
        return new HttpGatewayRouteSpec(options, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * (experimental) Creates an HTTP2 Based GatewayRoute.
     *
     * @param options - no http2 gateway route.
     * @experimental
     */
    static http2(options) {
        return new HttpGatewayRouteSpec(options, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * (experimental) Creates an GRPC Based GatewayRoute.
     *
     * @param options - no grpc gateway route.
     * @experimental
     */
    static grpc(options) {
        return new GrpcGatewayRouteSpec(options);
    }
}
exports.GatewayRouteSpec = GatewayRouteSpec;
_a = JSII_RTTI_SYMBOL_1;
GatewayRouteSpec[_a] = { fqn: "@aws-cdk/aws-appmesh.GatewayRouteSpec", version: "1.96.0" };
class HttpGatewayRouteSpec extends GatewayRouteSpec {
    constructor(options, protocol) {
        super();
        this.routeTarget = options.routeTarget;
        this.routeType = protocol;
        this.match = options.match;
    }
    bind(_scope) {
        const prefixPath = this.match ? this.match.prefixPath : '/';
        if (prefixPath[0] != '/') {
            throw new Error(`Prefix Path must start with \'/\', got: ${prefixPath}`);
        }
        const httpConfig = {
            match: {
                prefix: prefixPath,
            },
            action: {
                target: {
                    virtualService: {
                        virtualServiceName: this.routeTarget.virtualServiceName,
                    },
                },
            },
        };
        return {
            httpSpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2SpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class GrpcGatewayRouteSpec extends GatewayRouteSpec {
    constructor(options) {
        super();
        this.match = options.match;
        this.routeTarget = options.routeTarget;
    }
    bind(_scope) {
        return {
            grpcSpecConfig: {
                action: {
                    target: {
                        virtualService: {
                            virtualServiceName: this.routeTarget.virtualServiceName,
                        },
                    },
                },
                match: {
                    serviceName: this.match.serviceName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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