"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var CertificateType;
(function (CertificateType) {
    CertificateType["ACMPCA"] = "acm";
    CertificateType["FILE"] = "file";
})(CertificateType || (CertificateType = {}));
/**
 * (experimental) Defines the TLS validation context trust.
 *
 * @experimental
 */
class ClientPolicy {
    /**
     * (experimental) Tells envoy where to fetch the validation context from.
     *
     * @experimental
     */
    static fileTrust(props) {
        return new ClientPolicyImpl(props.ports, CertificateType.FILE, props.certificateChain, undefined);
    }
    /**
     * (experimental) TLS validation context trust for ACM Private Certificate Authority (CA).
     *
     * @experimental
     */
    static acmTrust(props) {
        return new ClientPolicyImpl(props.ports, CertificateType.ACMPCA, undefined, props.certificateAuthorities);
    }
}
exports.ClientPolicy = ClientPolicy;
_a = JSII_RTTI_SYMBOL_1;
ClientPolicy[_a] = { fqn: "@aws-cdk/aws-appmesh.ClientPolicy", version: "1.96.0" };
class ClientPolicyImpl extends ClientPolicy {
    constructor(ports, certificateType, certificateChain, certificateAuthorityArns) {
        super();
        this.ports = ports;
        this.certificateType = certificateType;
        this.certificateChain = certificateChain;
        this.certificateAuthorityArns = certificateAuthorityArns;
    }
    bind(_scope) {
        var _b, _c;
        if (this.certificateType === CertificateType.ACMPCA && ((_b = this.certificateAuthorityArns) === null || _b === void 0 ? void 0 : _b.map(certificateArn => certificateArn.certificateAuthorityArn).length) === 0) {
            throw new Error('You must provide at least one Certificate Authority when creating an ACM Trust ClientPolicy');
        }
        else {
            return {
                clientPolicy: {
                    tls: {
                        ports: this.ports,
                        validation: {
                            trust: {
                                [this.certificateType]: this.certificateType === CertificateType.FILE
                                    ? {
                                        certificateChain: this.certificateChain,
                                    }
                                    : {
                                        certificateAuthorityArns: (_c = this.certificateAuthorityArns) === null || _c === void 0 ? void 0 : _c.map(certificateArn => certificateArn.certificateAuthorityArn),
                                    },
                            },
                        },
                    },
                },
            };
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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