import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type AWSQS::EC2::LinuxBastionQS::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * The Linux distribution for the AMI to be used for the bastion instances.
     *
     * @schema CfnModulePropsParameters#BastionAMIOS
     */
    readonly bastionAmios?: CfnModulePropsParametersBastionAmios;
    /**
     * The value used for the name tag of the bastion host.
     *
     * @schema CfnModulePropsParameters#BastionHostName
     */
    readonly bastionHostName?: CfnModulePropsParametersBastionHostName;
    /**
     * Banner text to display upon login.
     *
     * @schema CfnModulePropsParameters#BastionBanner
     */
    readonly bastionBanner?: CfnModulePropsParametersBastionBanner;
    /**
     * Bastion VPC tenancy (dedicated or default).
     *
     * @schema CfnModulePropsParameters#BastionTenancy
     */
    readonly bastionTenancy?: CfnModulePropsParametersBastionTenancy;
    /**
     * Amazon EC2 instance type for the bastion instances.
     *
     * @schema CfnModulePropsParameters#BastionInstanceType
     */
    readonly bastionInstanceType?: CfnModulePropsParametersBastionInstanceType;
    /**
     * Choose *true* to display a banner when connecting via SSH to the bastion.
     *
     * @schema CfnModulePropsParameters#EnableBanner
     */
    readonly enableBanner?: CfnModulePropsParametersEnableBanner;
    /**
     * To enable TCP forwarding, choose *true*.
     *
     * @schema CfnModulePropsParameters#EnableTCPForwarding
     */
    readonly enableTcpForwarding?: CfnModulePropsParametersEnableTcpForwarding;
    /**
     * To enable X11 forwarding, choose *true*.
     *
     * @schema CfnModulePropsParameters#EnableX11Forwarding
     */
    readonly enableX11Forwarding?: CfnModulePropsParametersEnableX11Forwarding;
    /**
     * Name of an existing public/private key pair.
     *
     * If you do not have one in this AWS Region, please create it before continuing.
     *
     * @schema CfnModulePropsParameters#KeyPairName
     */
    readonly keyPairName?: CfnModulePropsParametersKeyPairName;
    /**
     * The number of bastion hosts to create.
     *
     * The maximum number is four.
     *
     * @schema CfnModulePropsParameters#NumBastionHosts
     */
    readonly numBastionHosts?: CfnModulePropsParametersNumBastionHosts;
    /**
     * ID of the public subnet 1 that you want to provision the first bastion into (e.g., subnet-a0246dcd).
     *
     * @schema CfnModulePropsParameters#PublicSubnet1ID
     */
    readonly publicSubnet1Id?: CfnModulePropsParametersPublicSubnet1Id;
    /**
     * ID of the public subnet 2 that you want to provision the second bastion into (e.g., subnet-e3246d8e).
     *
     * @schema CfnModulePropsParameters#PublicSubnet2ID
     */
    readonly publicSubnet2Id?: CfnModulePropsParametersPublicSubnet2Id;
    /**
     * Name of the S3 bucket for your copy of the Quick Start assets.
     *
     * Keep the default name unless you are customizing the template. Changing the name updates code references to point to a new Quick Start location. This name can include numbers, lowercase letters, uppercase letters, and hyphens, but do not start or end with a hyphen (-). See https://aws-quickstart.github.io/option1.html.
     *
     * @schema CfnModulePropsParameters#QSS3BucketName
     */
    readonly qss3BucketName?: CfnModulePropsParametersQss3BucketName;
    /**
     * The AWS Region where the Quick Start S3 bucket (QSS3BucketName) is hosted.
     *
     * When using your own bucket, you must specify this value.
     *
     * @schema CfnModulePropsParameters#QSS3BucketRegion
     */
    readonly qss3BucketRegion?: CfnModulePropsParametersQss3BucketRegion;
    /**
     * S3 key prefix that is used to simulate a directory for your copy of the Quick Start assets.
     *
     * Keep the default prefix unless you are customizing the template. Changing this prefix updates code references to point to a new Quick Start location. This prefix can include numbers, lowercase letters, uppercase letters, hyphens (-), and forward slashes (/). End with a forward slash. See https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html and https://aws-quickstart.github.io/option1.html.
     *
     * @schema CfnModulePropsParameters#QSS3KeyPrefix
     */
    readonly qss3KeyPrefix?: CfnModulePropsParametersQss3KeyPrefix;
    /**
     * Allowed CIDR block for external SSH access to the bastions.
     *
     * @schema CfnModulePropsParameters#RemoteAccessCIDR
     */
    readonly remoteAccessCidr?: CfnModulePropsParametersRemoteAccessCidr;
    /**
     * ID of the VPC (e.g., vpc-0343606e).
     *
     * @schema CfnModulePropsParameters#VPCID
     */
    readonly vpcid?: CfnModulePropsParametersVpcid;
    /**
     * An alternative initialization script to run during setup.
     *
     * @schema CfnModulePropsParameters#AlternativeInitializationScript
     */
    readonly alternativeInitializationScript?: CfnModulePropsParametersAlternativeInitializationScript;
    /**
     * The Region-specific image to use for the instance.
     *
     * @schema CfnModulePropsParameters#OSImageOverride
     */
    readonly osImageOverride?: CfnModulePropsParametersOsImageOverride;
    /**
     * An existing IAM role name to attach to the bastion.
     *
     * If left blank, a new role will be created.
     *
     * @schema CfnModulePropsParameters#AlternativeIAMRole
     */
    readonly alternativeIamRole?: CfnModulePropsParametersAlternativeIamRole;
    /**
     * A comma-separated list of environment variables for use in bootstrapping.
     *
     * Variables must be in the format `key=value`. `Value` cannot contain commas.
     *
     * @schema CfnModulePropsParameters#EnvironmentVariables
     */
    readonly environmentVariables?: CfnModulePropsParametersEnvironmentVariables;
    /**
     * The size in GB for the root EBS volume.
     *
     * @schema CfnModulePropsParameters#RootVolumeSize
     */
    readonly rootVolumeSize?: CfnModulePropsParametersRootVolumeSize;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#BastionMainLogGroup
     */
    readonly bastionMainLogGroup?: CfnModulePropsResourcesBastionMainLogGroup;
    /**
     * @schema CfnModulePropsResources#SSHMetricFilter
     */
    readonly sshMetricFilter?: CfnModulePropsResourcesSshMetricFilter;
    /**
     * @schema CfnModulePropsResources#BastionHostRole
     */
    readonly bastionHostRole?: CfnModulePropsResourcesBastionHostRole;
    /**
     * @schema CfnModulePropsResources#BastionHostPolicy
     */
    readonly bastionHostPolicy?: CfnModulePropsResourcesBastionHostPolicy;
    /**
     * @schema CfnModulePropsResources#BastionHostProfile
     */
    readonly bastionHostProfile?: CfnModulePropsResourcesBastionHostProfile;
    /**
     * @schema CfnModulePropsResources#EIP1
     */
    readonly eip1?: CfnModulePropsResourcesEip1;
    /**
     * @schema CfnModulePropsResources#EIP2
     */
    readonly eip2?: CfnModulePropsResourcesEip2;
    /**
     * @schema CfnModulePropsResources#EIP3
     */
    readonly eip3?: CfnModulePropsResourcesEip3;
    /**
     * @schema CfnModulePropsResources#EIP4
     */
    readonly eip4?: CfnModulePropsResourcesEip4;
    /**
     * @schema CfnModulePropsResources#BastionAutoScalingGroup
     */
    readonly bastionAutoScalingGroup?: CfnModulePropsResourcesBastionAutoScalingGroup;
    /**
     * @schema CfnModulePropsResources#BastionLaunchConfiguration
     */
    readonly bastionLaunchConfiguration?: CfnModulePropsResourcesBastionLaunchConfiguration;
    /**
     * @schema CfnModulePropsResources#BastionSecurityGroup
     */
    readonly bastionSecurityGroup?: CfnModulePropsResourcesBastionSecurityGroup;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The Linux distribution for the AMI to be used for the bastion instances.
 *
 * @schema CfnModulePropsParametersBastionAmios
 */
export interface CfnModulePropsParametersBastionAmios {
    /**
     * @schema CfnModulePropsParametersBastionAmios#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersBastionAmios#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersBastionAmios' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersBastionAmios(obj: CfnModulePropsParametersBastionAmios | undefined): Record<string, any> | undefined;
/**
 * The value used for the name tag of the bastion host.
 *
 * @schema CfnModulePropsParametersBastionHostName
 */
export interface CfnModulePropsParametersBastionHostName {
    /**
     * @schema CfnModulePropsParametersBastionHostName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersBastionHostName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersBastionHostName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersBastionHostName(obj: CfnModulePropsParametersBastionHostName | undefined): Record<string, any> | undefined;
/**
 * Banner text to display upon login.
 *
 * @schema CfnModulePropsParametersBastionBanner
 */
export interface CfnModulePropsParametersBastionBanner {
    /**
     * @schema CfnModulePropsParametersBastionBanner#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersBastionBanner#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersBastionBanner' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersBastionBanner(obj: CfnModulePropsParametersBastionBanner | undefined): Record<string, any> | undefined;
/**
 * Bastion VPC tenancy (dedicated or default).
 *
 * @schema CfnModulePropsParametersBastionTenancy
 */
export interface CfnModulePropsParametersBastionTenancy {
    /**
     * @schema CfnModulePropsParametersBastionTenancy#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersBastionTenancy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersBastionTenancy' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersBastionTenancy(obj: CfnModulePropsParametersBastionTenancy | undefined): Record<string, any> | undefined;
/**
 * Amazon EC2 instance type for the bastion instances.
 *
 * @schema CfnModulePropsParametersBastionInstanceType
 */
export interface CfnModulePropsParametersBastionInstanceType {
    /**
     * @schema CfnModulePropsParametersBastionInstanceType#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersBastionInstanceType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersBastionInstanceType' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersBastionInstanceType(obj: CfnModulePropsParametersBastionInstanceType | undefined): Record<string, any> | undefined;
/**
 * Choose *true* to display a banner when connecting via SSH to the bastion.
 *
 * @schema CfnModulePropsParametersEnableBanner
 */
export interface CfnModulePropsParametersEnableBanner {
    /**
     * @schema CfnModulePropsParametersEnableBanner#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersEnableBanner#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersEnableBanner' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersEnableBanner(obj: CfnModulePropsParametersEnableBanner | undefined): Record<string, any> | undefined;
/**
 * To enable TCP forwarding, choose *true*.
 *
 * @schema CfnModulePropsParametersEnableTcpForwarding
 */
export interface CfnModulePropsParametersEnableTcpForwarding {
    /**
     * @schema CfnModulePropsParametersEnableTcpForwarding#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersEnableTcpForwarding#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersEnableTcpForwarding' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersEnableTcpForwarding(obj: CfnModulePropsParametersEnableTcpForwarding | undefined): Record<string, any> | undefined;
/**
 * To enable X11 forwarding, choose *true*.
 *
 * @schema CfnModulePropsParametersEnableX11Forwarding
 */
export interface CfnModulePropsParametersEnableX11Forwarding {
    /**
     * @schema CfnModulePropsParametersEnableX11Forwarding#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersEnableX11Forwarding#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersEnableX11Forwarding' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersEnableX11Forwarding(obj: CfnModulePropsParametersEnableX11Forwarding | undefined): Record<string, any> | undefined;
/**
 * Name of an existing public/private key pair.
 *
 * If you do not have one in this AWS Region, please create it before continuing.
 *
 * @schema CfnModulePropsParametersKeyPairName
 */
export interface CfnModulePropsParametersKeyPairName {
    /**
     * @schema CfnModulePropsParametersKeyPairName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersKeyPairName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersKeyPairName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersKeyPairName(obj: CfnModulePropsParametersKeyPairName | undefined): Record<string, any> | undefined;
/**
 * The number of bastion hosts to create.
 *
 * The maximum number is four.
 *
 * @schema CfnModulePropsParametersNumBastionHosts
 */
export interface CfnModulePropsParametersNumBastionHosts {
    /**
     * @schema CfnModulePropsParametersNumBastionHosts#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersNumBastionHosts#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersNumBastionHosts' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersNumBastionHosts(obj: CfnModulePropsParametersNumBastionHosts | undefined): Record<string, any> | undefined;
/**
 * ID of the public subnet 1 that you want to provision the first bastion into (e.g., subnet-a0246dcd).
 *
 * @schema CfnModulePropsParametersPublicSubnet1Id
 */
export interface CfnModulePropsParametersPublicSubnet1Id {
    /**
     * @schema CfnModulePropsParametersPublicSubnet1Id#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet1Id#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet1Id' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet1Id(obj: CfnModulePropsParametersPublicSubnet1Id | undefined): Record<string, any> | undefined;
/**
 * ID of the public subnet 2 that you want to provision the second bastion into (e.g., subnet-e3246d8e).
 *
 * @schema CfnModulePropsParametersPublicSubnet2Id
 */
export interface CfnModulePropsParametersPublicSubnet2Id {
    /**
     * @schema CfnModulePropsParametersPublicSubnet2Id#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet2Id#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet2Id' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet2Id(obj: CfnModulePropsParametersPublicSubnet2Id | undefined): Record<string, any> | undefined;
/**
 * Name of the S3 bucket for your copy of the Quick Start assets.
 *
 * Keep the default name unless you are customizing the template. Changing the name updates code references to point to a new Quick Start location. This name can include numbers, lowercase letters, uppercase letters, and hyphens, but do not start or end with a hyphen (-). See https://aws-quickstart.github.io/option1.html.
 *
 * @schema CfnModulePropsParametersQss3BucketName
 */
export interface CfnModulePropsParametersQss3BucketName {
    /**
     * @schema CfnModulePropsParametersQss3BucketName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersQss3BucketName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersQss3BucketName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersQss3BucketName(obj: CfnModulePropsParametersQss3BucketName | undefined): Record<string, any> | undefined;
/**
 * The AWS Region where the Quick Start S3 bucket (QSS3BucketName) is hosted.
 *
 * When using your own bucket, you must specify this value.
 *
 * @schema CfnModulePropsParametersQss3BucketRegion
 */
export interface CfnModulePropsParametersQss3BucketRegion {
    /**
     * @schema CfnModulePropsParametersQss3BucketRegion#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersQss3BucketRegion#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersQss3BucketRegion' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersQss3BucketRegion(obj: CfnModulePropsParametersQss3BucketRegion | undefined): Record<string, any> | undefined;
/**
 * S3 key prefix that is used to simulate a directory for your copy of the Quick Start assets.
 *
 * Keep the default prefix unless you are customizing the template. Changing this prefix updates code references to point to a new Quick Start location. This prefix can include numbers, lowercase letters, uppercase letters, hyphens (-), and forward slashes (/). End with a forward slash. See https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html and https://aws-quickstart.github.io/option1.html.
 *
 * @schema CfnModulePropsParametersQss3KeyPrefix
 */
export interface CfnModulePropsParametersQss3KeyPrefix {
    /**
     * @schema CfnModulePropsParametersQss3KeyPrefix#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersQss3KeyPrefix#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersQss3KeyPrefix' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersQss3KeyPrefix(obj: CfnModulePropsParametersQss3KeyPrefix | undefined): Record<string, any> | undefined;
/**
 * Allowed CIDR block for external SSH access to the bastions.
 *
 * @schema CfnModulePropsParametersRemoteAccessCidr
 */
export interface CfnModulePropsParametersRemoteAccessCidr {
    /**
     * @schema CfnModulePropsParametersRemoteAccessCidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersRemoteAccessCidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersRemoteAccessCidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersRemoteAccessCidr(obj: CfnModulePropsParametersRemoteAccessCidr | undefined): Record<string, any> | undefined;
/**
 * ID of the VPC (e.g., vpc-0343606e).
 *
 * @schema CfnModulePropsParametersVpcid
 */
export interface CfnModulePropsParametersVpcid {
    /**
     * @schema CfnModulePropsParametersVpcid#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcid#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcid' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcid(obj: CfnModulePropsParametersVpcid | undefined): Record<string, any> | undefined;
/**
 * An alternative initialization script to run during setup.
 *
 * @schema CfnModulePropsParametersAlternativeInitializationScript
 */
export interface CfnModulePropsParametersAlternativeInitializationScript {
    /**
     * @schema CfnModulePropsParametersAlternativeInitializationScript#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAlternativeInitializationScript#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAlternativeInitializationScript' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAlternativeInitializationScript(obj: CfnModulePropsParametersAlternativeInitializationScript | undefined): Record<string, any> | undefined;
/**
 * The Region-specific image to use for the instance.
 *
 * @schema CfnModulePropsParametersOsImageOverride
 */
export interface CfnModulePropsParametersOsImageOverride {
    /**
     * @schema CfnModulePropsParametersOsImageOverride#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersOsImageOverride#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersOsImageOverride' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersOsImageOverride(obj: CfnModulePropsParametersOsImageOverride | undefined): Record<string, any> | undefined;
/**
 * An existing IAM role name to attach to the bastion.
 *
 * If left blank, a new role will be created.
 *
 * @schema CfnModulePropsParametersAlternativeIamRole
 */
export interface CfnModulePropsParametersAlternativeIamRole {
    /**
     * @schema CfnModulePropsParametersAlternativeIamRole#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAlternativeIamRole#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAlternativeIamRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAlternativeIamRole(obj: CfnModulePropsParametersAlternativeIamRole | undefined): Record<string, any> | undefined;
/**
 * A comma-separated list of environment variables for use in bootstrapping.
 *
 * Variables must be in the format `key=value`. `Value` cannot contain commas.
 *
 * @schema CfnModulePropsParametersEnvironmentVariables
 */
export interface CfnModulePropsParametersEnvironmentVariables {
    /**
     * @schema CfnModulePropsParametersEnvironmentVariables#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersEnvironmentVariables#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersEnvironmentVariables' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersEnvironmentVariables(obj: CfnModulePropsParametersEnvironmentVariables | undefined): Record<string, any> | undefined;
/**
 * The size in GB for the root EBS volume.
 *
 * @schema CfnModulePropsParametersRootVolumeSize
 */
export interface CfnModulePropsParametersRootVolumeSize {
    /**
     * @schema CfnModulePropsParametersRootVolumeSize#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersRootVolumeSize#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersRootVolumeSize' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersRootVolumeSize(obj: CfnModulePropsParametersRootVolumeSize | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesBastionMainLogGroup
 */
export interface CfnModulePropsResourcesBastionMainLogGroup {
    /**
     * @schema CfnModulePropsResourcesBastionMainLogGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesBastionMainLogGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesBastionMainLogGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesBastionMainLogGroup(obj: CfnModulePropsResourcesBastionMainLogGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesSshMetricFilter
 */
export interface CfnModulePropsResourcesSshMetricFilter {
    /**
     * @schema CfnModulePropsResourcesSshMetricFilter#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesSshMetricFilter#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesSshMetricFilter' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesSshMetricFilter(obj: CfnModulePropsResourcesSshMetricFilter | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesBastionHostRole
 */
export interface CfnModulePropsResourcesBastionHostRole {
    /**
     * @schema CfnModulePropsResourcesBastionHostRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesBastionHostRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesBastionHostRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesBastionHostRole(obj: CfnModulePropsResourcesBastionHostRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesBastionHostPolicy
 */
export interface CfnModulePropsResourcesBastionHostPolicy {
    /**
     * @schema CfnModulePropsResourcesBastionHostPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesBastionHostPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesBastionHostPolicy' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesBastionHostPolicy(obj: CfnModulePropsResourcesBastionHostPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesBastionHostProfile
 */
export interface CfnModulePropsResourcesBastionHostProfile {
    /**
     * @schema CfnModulePropsResourcesBastionHostProfile#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesBastionHostProfile#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesBastionHostProfile' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesBastionHostProfile(obj: CfnModulePropsResourcesBastionHostProfile | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesEip1
 */
export interface CfnModulePropsResourcesEip1 {
    /**
     * @schema CfnModulePropsResourcesEip1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesEip1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesEip1' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesEip1(obj: CfnModulePropsResourcesEip1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesEip2
 */
export interface CfnModulePropsResourcesEip2 {
    /**
     * @schema CfnModulePropsResourcesEip2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesEip2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesEip2' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesEip2(obj: CfnModulePropsResourcesEip2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesEip3
 */
export interface CfnModulePropsResourcesEip3 {
    /**
     * @schema CfnModulePropsResourcesEip3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesEip3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesEip3' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesEip3(obj: CfnModulePropsResourcesEip3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesEip4
 */
export interface CfnModulePropsResourcesEip4 {
    /**
     * @schema CfnModulePropsResourcesEip4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesEip4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesEip4' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesEip4(obj: CfnModulePropsResourcesEip4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesBastionAutoScalingGroup
 */
export interface CfnModulePropsResourcesBastionAutoScalingGroup {
    /**
     * @schema CfnModulePropsResourcesBastionAutoScalingGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesBastionAutoScalingGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesBastionAutoScalingGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesBastionAutoScalingGroup(obj: CfnModulePropsResourcesBastionAutoScalingGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesBastionLaunchConfiguration
 */
export interface CfnModulePropsResourcesBastionLaunchConfiguration {
    /**
     * @schema CfnModulePropsResourcesBastionLaunchConfiguration#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesBastionLaunchConfiguration#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesBastionLaunchConfiguration' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesBastionLaunchConfiguration(obj: CfnModulePropsResourcesBastionLaunchConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesBastionSecurityGroup
 */
export interface CfnModulePropsResourcesBastionSecurityGroup {
    /**
     * @schema CfnModulePropsResourcesBastionSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesBastionSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesBastionSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesBastionSecurityGroup(obj: CfnModulePropsResourcesBastionSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::EC2::LinuxBastionQS::MODULE`.
 *
 * @external
 * @cloudformationResource AWSQS::EC2::LinuxBastionQS::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::EC2::LinuxBastionQS::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `AWSQS::EC2::LinuxBastionQS::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
