"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterAutoScaler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
__exportStar(require("./policy"), exports);
/**
 * @experimental
 */
class ClusterAutoScaler extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, name, opts) {
        var _b, _c, _d, _e;
        super(scope, name);
        this.serviceAccountName = (_b = opts.serviceAccountName) !== null && _b !== void 0 ? _b : 'cluster-autoscaler';
        this.namespace = (_c = opts.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        this.image = (_d = opts.image) !== null && _d !== void 0 ? _d : 'k8s.gcr.io/autoscaling/cluster-autoscaler:v1.17.3';
        this.createServiceAccount = (_e = opts === null || opts === void 0 ? void 0 : opts.createServiceAccount) !== null && _e !== void 0 ? _e : true;
        if (opts.createServiceAccount === true) {
            new cdk8s.ApiObject(this, 'sa', {
                apiVersion: 'v1',
                kind: 'ServiceAccount',
                metadata: {
                    labels: {
                        'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                        'k8s-app': 'cluster-autoscaler',
                    },
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            });
        }
        new cdk8s.ApiObject(this, 'cluster-role', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'ClusterRole',
            metadata: {
                name: 'cluster-autoscaler',
                labels: {
                    'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                    'k8s-app': 'cluster-autoscaler',
                },
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: [
                        'events',
                        'endpoints',
                    ],
                    verbs: [
                        'create',
                        'patch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/eviction'],
                    verbs: ['create'],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/status'],
                    verbs: ['update'],
                },
                {
                    apiGroups: [''],
                    resources: ['endpoints'],
                    resourceNames: ['cluster-autoscaler'],
                    verbs: [
                        'get',
                        'update',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['nodes'],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                        'update',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: [
                        'pods',
                        'services',
                        'replicationcontrollers',
                        'persistentvolumeclaims',
                        'persistentvolumes',
                    ],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                    ],
                },
                {
                    apiGroups: ['extensions'],
                    resources: [
                        'replicasets',
                        'daemonsets',
                    ],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                    ],
                },
                {
                    apiGroups: ['policy'],
                    resources: ['poddisruptionbudgets'],
                    verbs: [
                        'watch',
                        'list',
                    ],
                },
                {
                    apiGroups: ['apps'],
                    resources: [
                        'statefulsets',
                        'replicasets',
                        'daemonsets',
                    ],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                    ],
                },
                {
                    apiGroups: ['storage.k8s.io'],
                    resources: [
                        'storageclasses',
                        'csinodes',
                    ],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                    ],
                },
                {
                    apiGroups: [
                        'batch',
                        'extensions',
                    ],
                    resources: ['jobs'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                        'patch',
                    ],
                },
                {
                    apiGroups: ['coordination.k8s.io'],
                    resources: ['leases'],
                    verbs: ['create'],
                },
                {
                    apiGroups: ['coordination.k8s.io'],
                    resourceNames: ['cluster-autoscaler'],
                    resources: ['leases'],
                    verbs: [
                        'get',
                        'update',
                    ],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'cluster-role-binding', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'ClusterRoleBinding',
            metadata: {
                name: 'cluster-autoscaler',
                labels: {
                    'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                    'k8s-app': 'cluster-autoscaler',
                },
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: 'cluster-autoscaler',
            },
            subjects: [{
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                }],
        });
        new cdk8s.ApiObject(this, 'role', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'Role',
            metadata: {
                name: 'cluster-autoscaler',
                namespace: this.namespace,
                labels: {
                    'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                    'k8s-app': 'cluster-autoscaler',
                },
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    verbs: [
                        'create',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    resourceNames: [
                        'cluster-autoscaler-status',
                        'cluster-autoscaler-priority-expander',
                    ],
                    verbs: [
                        'delete',
                        'get',
                        'update',
                        'watch',
                    ],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'role-binding', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'RoleBinding',
            metadata: {
                name: 'cluster-autoscaler',
                namespace: this.namespace,
                labels: {
                    'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                    'k8s-app': 'cluster-autoscaler',
                },
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'Role',
                name: 'cluster-autoscaler',
            },
            subjects: [{
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                }],
        });
        new cdk8s.ApiObject(this, 'deployment', {
            apiVersion: 'apps/v1',
            kind: 'Deployment',
            metadata: {
                name: 'cluster-autoscaler',
                namespace: 'kube-system',
                labels: {
                    app: 'cluster-autoscaler',
                },
            },
            spec: {
                replicas: 1,
                selector: {
                    matchLabels: {
                        app: 'cluster-autoscaler',
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            app: 'cluster-autoscaler',
                        },
                        annotations: {
                            'prometheus.io/scrape': 'true',
                            'prometheus.io/port': '8085',
                        },
                    },
                    spec: {
                        serviceAccountName: 'cluster-autoscaler',
                        containers: [{
                                image: this.image,
                                name: 'cluster-autoscaler',
                                resources: {
                                    limits: {
                                        cpu: '100m',
                                        memory: '300Mi',
                                    },
                                    requests: {
                                        cpu: '100m',
                                        memory: '300Mi',
                                    },
                                },
                                command: this.commandFunc(opts.command),
                                volumeMounts: [{
                                        name: 'ssl-certs',
                                        mountPath: '/etc/ssl/certs/ca-certificates.crt',
                                        readOnly: true,
                                    }],
                                imagePullPolicy: 'Always',
                            }],
                        volumes: [{
                                name: 'ssl-certs',
                                hostPath: {
                                    path: '/etc/ssl/certs/ca-bundle.crt',
                                },
                            }],
                    },
                },
            },
        });
    }
    commandFunc(comm) {
        const defaultCommand = [
            './cluster-autoscaler',
            '--v=4',
            '--stderrthreshold=info',
            '--cloud-provider=aws',
            '--skip-nodes-with-local-storage=false',
            '--expander=least-waste',
        ];
        if (comm) {
            comm.forEach(e => defaultCommand.push(e));
        }
        return defaultCommand;
    }
}
exports.ClusterAutoScaler = ClusterAutoScaler;
_a = JSII_RTTI_SYMBOL_1;
ClusterAutoScaler[_a] = { fqn: "@opencdk8s/cdk8s-cluster-autoscaler-aws.ClusterAutoScaler", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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