"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

# A log message and metadata. Logs come in a few different forms:
#
#  1. A tokenized log message (recommended for production)
#  2. A non-tokenized log message (good for development)
#  3. A "log missed" tombstone, indicating that some logs were dropped
#
# Size analysis for tokenized log messages, including each field's proto tag:
#
#  - message     - 6-12 bytes, depending on number and value of arguments
#  - line_level  - 3 bytes; 4 bytes if line > 2048 (uncommon)
#  - timestamp   - 3 bytes; assuming delta encoding
#  - thread_name - 6 bytes
#
# Adding the fields gives the total proto message size:
#
#    6-12 bytes - log
#    9-15 bytes - log + level + line
#   12-18 bytes - log + level + line + timestamp
#
# An analysis of a project's log token database revealed the following
# distribution of the number of arguments to log messages:
#
#   # args   # messages
#     0         2,700
#     1         2,400
#     2         1,200
#     3+        1,000
#
# Note: The below proto makes some compromises compared to what one might
# expect for a "clean" proto design, in order to shave bytes off of the
# messages. It is critical that the log messages are as small as possible to
# enable storing more logs in limited memory. This is why, for example, there
# is no separate "DroppedLog" type, or a "TokenizedLog" and "StringLog", which
# would add at least 2 extra bytes per message
class LogEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MESSAGE_FIELD_NUMBER: builtins.int
    LINE_LEVEL_FIELD_NUMBER: builtins.int
    FLAGS_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    TIME_SINCE_LAST_ENTRY_FIELD_NUMBER: builtins.int
    # The log message, which may be tokenized.
    #
    # If tokenized logging is used, implementations may encode metadata in the
    # log message rather than as separate proto fields. This reduces the size of
    # the protobuf with no overhead.
    #
    # The standard format for encoding metadata in the log message is defined by
    # the pw_log_tokenized module. The message and metadata are encoded as
    # key-value pairs using ■ and ♦ as delimiters. For example:
    #
    #  ■msg♦This is the log message: %d■module♦wifi■file♦../path/to/file.cc
    #
    # See http://pigweed.dev/pw_log_tokenized for full details. When
    # pw_log_tokenized is used, this metadata is automatically included as
    # described.
    #
    # The level and flags are not included since they may be runtime values and
    # thus cannot always be tokenized. The line number is not included because
    # line numbers change frequently and a new token is created for each line.
    #
    # Size analysis when tokenized:
    #
    #   tag+wire = 1 byte
    #   size     = 1 byte; payload will almost always be < 127 bytes
    #   payload  = N bytes; typically 4-10 in practice
    #
    # Total: 2 + N ~= 6-12 bytes
    message: builtins.bytes = ...
    # Packed log level and line number. Structure:
    #
    #   Level: Bottom 3 bits; level = line_level & 0x7
    #   Line: Remaining bits; line = (line_level >> 3)
    #
    # Note: This packing saves two bytes per log message in most cases compared
    # to having line and level separately; and is zero-cost if the log backend
    # omits the line number.
    line_level: builtins.int = ...
    # Some log messages have flags to indicate attributes such as whether they
    # are from an assert or if they contain PII. The particular flags are
    # product- and implementation-dependent.
    flags: builtins.int = ...
    # The absolute timestamp in implementation-defined ticks. Applications
    # determine how to interpret this on the receiving end. In the simplest
    # case, these ticks might be milliseconds or microseconds since boot.
    # Applications could also access clock information out-of-band with a
    # ClockParameters protobuf.
    timestamp: builtins.int = ...
    # Time since the last entry in implementation-defined ticks, as for the
    # timestamp field. This enables delta encoding when batching entries
    # together.
    #
    # Size analysis for this field including tag and varint, assuming 1 kHz
    # ticks:
    #
    #           < 127 ms gap == 127 ms      ==  7 bits == 2 bytes
    #        < 16,000 ms gap ==  16 seconds == 14 bits == 3 bytes
    #     < 2,000,000 ms gap ==  35 minutes == 21 bits == 4 bytes
    #   < 300,000,000 ms gap ==  74 hours   == 28 bits == 5 bytes
    #
    # Log bursts will thus consume just 2 bytes (tag + up to 127ms delta) for
    # the timestamp, which is a good improvement over an absolute timestamp.
    time_since_last_entry: builtins.int = ...
    def __init__(self,
        *,
        message : builtins.bytes = ...,
        line_level : builtins.int = ...,
        flags : builtins.int = ...,
        timestamp : builtins.int = ...,
        time_since_last_entry : builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"_flags",b"_flags",u"_line_level",b"_line_level",u"_message",b"_message",u"flags",b"flags",u"line_level",b"line_level",u"message",b"message",u"time",b"time",u"time_since_last_entry",b"time_since_last_entry",u"timestamp",b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"_flags",b"_flags",u"_line_level",b"_line_level",u"_message",b"_message",u"flags",b"flags",u"line_level",b"line_level",u"message",b"message",u"time",b"time",u"time_since_last_entry",b"time_since_last_entry",u"timestamp",b"timestamp"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_flags",b"_flags"]) -> typing.Optional[typing_extensions.Literal["flags"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_line_level",b"_line_level"]) -> typing.Optional[typing_extensions.Literal["line_level"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_message",b"_message"]) -> typing.Optional[typing_extensions.Literal["message"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"time",b"time"]) -> typing.Optional[typing_extensions.Literal["timestamp","time_since_last_entry"]]: ...
global___LogEntry = LogEntry

# This will include fields for configuring log filtering.
class LogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    def __init__(self,
        ) -> None: ...
global___LogRequest = LogRequest

class LogEntries(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogEntry]: ...
    def __init__(self,
        *,
        entries : typing.Optional[typing.Iterable[global___LogEntry]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"entries",b"entries"]) -> None: ...
global___LogEntries = LogEntries
