from __future__ import annotations

import logging
from pathlib import Path
from typing import Iterator, Sequence

SUPPORTED_SUFFIXES = {".pdf"}


def iter_documents(root: Path, allowed_suffixes: Sequence[str] = tuple(SUPPORTED_SUFFIXES)) -> Iterator[Path]:
    if not root.exists():
        logging.warning("Input directory %s does not exist", root)
        return
    suffixes = {s.lower() for s in allowed_suffixes}
    for path in root.rglob("*"):
        if path.is_file() and path.suffix.lower() in suffixes:
            yield path
