from enum import IntEnum
from typing import Any, List, Optional, Tuple, Type
from vtelem.channel import Channel as Channel
from vtelem.channel.environment import ChannelEnvironment as ChannelEnvironment
from vtelem.classes import DEFAULTS as DEFAULTS
from vtelem.classes.user_enum import UserEnum as UserEnum, from_enum as from_enum
from vtelem.enums.frame import MESSAGE_TYPES as MESSAGE_TYPES
from vtelem.enums.primitive import Primitive as Primitive
from vtelem.registry.enum import EnumRegistry as EnumRegistry
from vtelem.registry.type import get_default as get_default

class TelemetryEnvironment(ChannelEnvironment):
    enum_registry: Any
    type_registry: Any
    enum_channel_types: Any
    def __init__(self, mtu: int, init_time: float = ..., metrics_rate: float = ..., initial_channels: List[Channel] = ..., initial_enums: List[UserEnum] = ..., app_id_basis: float = ..., use_crc: bool = ...): ...
    def command_enum_channel_id(self, chan_id: int, value: str) -> bool: ...
    def command_enum_channel(self, name: str, value: str) -> bool: ...
    def is_enum_channel(self, chan_id: int) -> bool: ...
    def add_enum_channel(self, name: str, enum_name: str, rate: float, track_change: bool = ..., initial: Tuple[str, Optional[float]] = ..., commandable: bool = ...) -> int: ...
    def add_enum_metric(self, name: str, enum_name: str, track_change: bool = ..., initial: Tuple[str, Optional[float]] = ...) -> None: ...
    def set_enum_metric(self, name: str, data: str, time: float = ...) -> None: ...
    def get_enum_metric(self, name: str) -> str: ...
    def get_enum_value(self, chan_id: int) -> str: ...
    def set_enum_now(self, channel_id: int, data: str) -> bool: ...
    def add_from_enum(self, enum_class: Type[IntEnum]) -> int: ...
    def has_enum(self, enum: UserEnum) -> bool: ...
    def add_enum(self, enum: UserEnum) -> int: ...
