from typing import Any, Callable, Iterator
from vtelem.classes import DEFAULTS as DEFAULTS
from vtelem.classes.time_entity import TimeEntity as TimeEntity
from vtelem.classes.user_enum import from_enum as from_enum
from vtelem.enums.daemon import DaemonOperation as DaemonOperation, DaemonState as DaemonState, str_to_operation as str_to_operation
from vtelem.enums.primitive import Primitive as Primitive
from vtelem.names import class_to_snake as class_to_snake
from vtelem.telemetry.environment import TelemetryEnvironment as TelemetryEnvironment

LOG: Any
MainThread = Callable[..., int]

def dummy_thread(*args, **kwargs) -> int: ...

class DaemonBase(TimeEntity):
    states: Any
    operations: Any
    state: Any
    name: Any
    env: Any
    function: Any
    thread: Any
    daemon_ops: Any
    def __init__(self, name: str, env: TelemetryEnvironment = ..., time_keeper: Any = ...): ...
    def perform(self, action: DaemonOperation, *args, **kwargs) -> bool: ...
    def perform_str(self, action: str, *args, **kwargs) -> bool: ...
    def get_metric_name(self, channel_name: str) -> str: ...
    def set_state(self, state: DaemonState) -> bool: ...
    def set_env_metric(self, name: str, value: Any, prim: Primitive = ...) -> None: ...
    def reset_metric(self, name: str) -> None: ...
    def increment_metric(self, name: str, value: Any = ...) -> None: ...
    def decrement_metric(self, name: str, value: Any = ...) -> None: ...
    def get_state(self) -> DaemonState: ...
    def get_state_str(self) -> str: ...
    def run_harness(self, *args, **kwargs) -> None: ...
    def run(self, *_, **__) -> None: ...
    def booted(self, *args, **kwargs) -> Iterator[None]: ...
    def serve(self, *args, main_thread: MainThread = ..., **kwargs) -> int: ...
    def start(self, *args, **kwargs) -> bool: ...
    def paused(self) -> Iterator[None]: ...
    def pause(self) -> bool: ...
    def unpause(self) -> bool: ...
    def begin_stop(self) -> bool: ...
    def restart(self, *args, **kwargs) -> bool: ...
    def stop(self) -> bool: ...
