from .metered_queue import MAX_SIZE as MAX_SIZE, create as create
from .time_entity import LockEntity as LockEntity
from io import BytesIO
from queue import Queue
from threading import Semaphore
from typing import Any, Callable, Tuple
from vtelem.daemon.queue import QueueDaemon as QueueDaemon
from vtelem.frame.channel import ChannelFrame as ChannelFrame
from vtelem.telemetry.environment import TelemetryEnvironment as TelemetryEnvironment

LOG: Any

class StreamWriter(QueueDaemon):
    curr_id: int
    queue_id: int
    streams: Any
    stream_closers: Any
    queues: Any
    error_handle: Any
    def __init__(self, name: str, frame_queue: Queue, error_handle: Callable[[int], None] = ..., env: TelemetryEnvironment = ..., time_keeper: Any = ...) -> None: ...
    def get_queue(self, name: str = ..., maxsize: int = ...) -> Queue: ...
    def add_queue(self, queue: Queue) -> int: ...
    def registered_queue(self, name: str = ..., maxsize: int = ...) -> Tuple[int, Queue]: ...
    def add_stream(self, stream: BytesIO, stream_closer: Callable = ...) -> int: ...
    def add_semaphore_stream(self, stream: BytesIO) -> Tuple[int, Semaphore]: ...
    def remove_stream(self, stream_id: int, call_closer: bool = ...) -> bool: ...
    def remove_queue(self, queue_id: int, inject_none: bool = ...) -> bool: ...

class QueueClientManager(LockEntity):
    name: Any
    writer: Any
    active_client_queues: Any
    def __init__(self, name: str, writer: StreamWriter) -> None: ...
    def add_client_queue(self, addr: Tuple[str, int] = ...) -> Tuple[int, Queue]: ...
    def close_clients(self) -> int: ...

def default_writer(name: str = ..., error_handle: Callable[[int], None] = ..., env: TelemetryEnvironment = ..., time_keeper: Any = ..., maxsize: int = ...) -> Tuple[StreamWriter, Queue]: ...
