from typing import Any, List, Optional, Tuple
from vtelem.channel import Channel as Channel
from vtelem.channel.framer import ChannelFramer as ChannelFramer
from vtelem.channel.registry import ChannelRegistry as ChannelRegistry
from vtelem.classes import LOG_PERIOD as LOG_PERIOD
from vtelem.classes.event_queue import EventQueue as EventQueue
from vtelem.classes.metered_queue import MeteredQueue as MeteredQueue
from vtelem.classes.time_entity import TimeEntity as TimeEntity
from vtelem.classes.type_primitive import TypePrimitive as TypePrimitive
from vtelem.enums.primitive import Primitive as Primitive
from vtelem.frame.channel import ChannelFrame as ChannelFrame
from vtelem.parsing.encapsulation import ParsedFrame as ParsedFrame, decode_frame as decode_frame
from vtelem.registry import Registry as Registry

LOG: Any

class ChannelEnvironment(TimeEntity):
    registries: Any
    channel_registry: Any
    framer: Any
    write_crc: bool
    metrics: Any
    event_queue: Any
    frame_queue: Any
    log_data: Any
    def __init__(self, mtu: int, initial_channels: List[Channel] = ..., metrics_rate: float = ..., init_time: float = ..., app_id_basis: float = ..., use_crc: bool = ...): ...
    @property
    def app_id(self) -> TypePrimitive: ...
    def handle_new_mtu(self, new_mtu: int) -> None: ...
    def register_base_metrics(self, metrics_rate: float) -> None: ...
    def has_metric(self, name: str) -> bool: ...
    def add_metric(self, name: str, instance: Primitive, track_change: bool = ..., initial: Tuple[Any, Optional[float]] = ...) -> None: ...
    def get_metric(self, name: str) -> Any: ...
    def set_now(self, channel_id: int, data: Any) -> bool: ...
    def get_value(self, chan_id: int) -> Any: ...
    def set_metric_rate(self, name: str, rate: float) -> None: ...
    def set_metric(self, name: str, data: Any, time: float = ...) -> None: ...
    def metric_add(self, name: str, data: Any, time: float = ...) -> None: ...
    def set_channel_rate(self, chan_id: int, rate: float) -> None: ...
    def has_channel(self, name: str) -> bool: ...
    def command_channel_id(self, chan_id: int, value: Any) -> bool: ...
    def command_channel(self, name: str, value: Any) -> bool: ...
    def add_channel(self, name: str, instance: Primitive, rate: float, track_change: bool = ..., initial: Tuple[Any, Optional[float]] = ..., commandable: bool = ...) -> int: ...
    def dispatch(self, time: float, should_log: bool = ...) -> int: ...
    def get_next_frame(self, timeout: int = ...) -> ChannelFrame: ...
    def decode_frame(self, data: bytes, size: int, expected_id: Optional[TypePrimitive] = ...) -> Optional[ParsedFrame]: ...
    def dispatch_events(self, time: float) -> Tuple[int, int]: ...
    def dispatch_data(self, time: float) -> Tuple[int, int]: ...
    def dispatch_now(self, *_, should_log: bool = ..., **__) -> int: ...
