from typing import NamedTuple


class SubtaskItem(NamedTuple):
    """A `tuple` representing a subtask generated by the `subtask_list_generator` prompt module.

    Inherits from `NamedTuple`, so the attributes can be accessed with dot notation. e.g.
    ```
    # item: SubtaskItem
    subtask_title: str = item.subtask
    subtask_tag:str = item.tag
    ```

    Attributes:
        subtask (`str`): The generated subtask title / brief description.
        tag (`str`): The tag (variable name) that identifies this subtask.
    """

    subtask: str
    tag: str
