# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AuthorizationRolesArgs', 'AuthorizationRoles']

@pulumi.input_type
class AuthorizationRolesArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cumulative_realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 cumulative_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 default_app: Optional[pulumi.Input[str]] = None,
                 imported_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 search_disk_quota: Optional[pulumi.Input[int]] = None,
                 search_filter: Optional[pulumi.Input[str]] = None,
                 search_indexes_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_indexes_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 search_time_win: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AuthorizationRoles resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of capabilities assigned to role.
        :param pulumi.Input[int] cumulative_realtime_search_jobs_quota: Maximum number of concurrently running real-time searches that all members of this role can have.
        :param pulumi.Input[int] cumulative_search_jobs_quota: Maximum number of concurrently running searches for all role members. Warning message logged when limit is reached.
        :param pulumi.Input[str] default_app: Specify the folder name of the default app to use for this role. A user-specific default app overrides this.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_roles: List of imported roles for this role. <br>Importing other roles imports all aspects of that role, such as capabilities and allowed indexes to search. In combining multiple roles, the effective value for each attribute is value with the broadest permissions.
        :param pulumi.Input[str] name: The name of the user role to create.
        :param pulumi.Input[int] realtime_search_jobs_quota: Specify the maximum number of concurrent real-time search jobs for this role. This count is independent from the normal search jobs limit.
        :param pulumi.Input[int] search_disk_quota: Specifies the maximum disk space in MB that can be used by a user's search jobs. For example, a value of 100 limits this role to 100 MB total.
        :param pulumi.Input[str] search_filter: Specify a search string that restricts the scope of searches run by this role. Search results for this role only show events that also match the search string you specify. In the case that a user has multiple roles with different search filters, they are combined with an OR.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_indexes_alloweds: List of indexes that this role has permissions to search. These may be wildcarded, but the index name must begin with an underscore to match internal indexes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_indexes_defaults: List of indexes to search when no index is specified. These indexes can be wildcarded, with the exception that '*' does not match internal indexes. To match internal indexes, start with '_'. All internal indexes are represented by '_*'. A user with this role can search other indexes using "index= "
        :param pulumi.Input[int] search_jobs_quota: The maximum number of concurrent searches a user with this role is allowed to run. For users with multiple roles, the maximum quota value among all of the roles applies.
        :param pulumi.Input[int] search_time_win: Maximum time span of a search, in seconds. By default, searches are not limited to any specific time window. To override any search time windows from imported roles, set srchTimeWin to '0', as the 'admin' role does.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if cumulative_realtime_search_jobs_quota is not None:
            pulumi.set(__self__, "cumulative_realtime_search_jobs_quota", cumulative_realtime_search_jobs_quota)
        if cumulative_search_jobs_quota is not None:
            pulumi.set(__self__, "cumulative_search_jobs_quota", cumulative_search_jobs_quota)
        if default_app is not None:
            pulumi.set(__self__, "default_app", default_app)
        if imported_roles is not None:
            pulumi.set(__self__, "imported_roles", imported_roles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if realtime_search_jobs_quota is not None:
            pulumi.set(__self__, "realtime_search_jobs_quota", realtime_search_jobs_quota)
        if search_disk_quota is not None:
            pulumi.set(__self__, "search_disk_quota", search_disk_quota)
        if search_filter is not None:
            pulumi.set(__self__, "search_filter", search_filter)
        if search_indexes_alloweds is not None:
            pulumi.set(__self__, "search_indexes_alloweds", search_indexes_alloweds)
        if search_indexes_defaults is not None:
            pulumi.set(__self__, "search_indexes_defaults", search_indexes_defaults)
        if search_jobs_quota is not None:
            pulumi.set(__self__, "search_jobs_quota", search_jobs_quota)
        if search_time_win is not None:
            pulumi.set(__self__, "search_time_win", search_time_win)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of capabilities assigned to role.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="cumulativeRealtimeSearchJobsQuota")
    def cumulative_realtime_search_jobs_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of concurrently running real-time searches that all members of this role can have.
        """
        return pulumi.get(self, "cumulative_realtime_search_jobs_quota")

    @cumulative_realtime_search_jobs_quota.setter
    def cumulative_realtime_search_jobs_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cumulative_realtime_search_jobs_quota", value)

    @property
    @pulumi.getter(name="cumulativeSearchJobsQuota")
    def cumulative_search_jobs_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of concurrently running searches for all role members. Warning message logged when limit is reached.
        """
        return pulumi.get(self, "cumulative_search_jobs_quota")

    @cumulative_search_jobs_quota.setter
    def cumulative_search_jobs_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cumulative_search_jobs_quota", value)

    @property
    @pulumi.getter(name="defaultApp")
    def default_app(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the folder name of the default app to use for this role. A user-specific default app overrides this.
        """
        return pulumi.get(self, "default_app")

    @default_app.setter
    def default_app(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_app", value)

    @property
    @pulumi.getter(name="importedRoles")
    def imported_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of imported roles for this role. <br>Importing other roles imports all aspects of that role, such as capabilities and allowed indexes to search. In combining multiple roles, the effective value for each attribute is value with the broadest permissions.
        """
        return pulumi.get(self, "imported_roles")

    @imported_roles.setter
    def imported_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "imported_roles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user role to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="realtimeSearchJobsQuota")
    def realtime_search_jobs_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the maximum number of concurrent real-time search jobs for this role. This count is independent from the normal search jobs limit.
        """
        return pulumi.get(self, "realtime_search_jobs_quota")

    @realtime_search_jobs_quota.setter
    def realtime_search_jobs_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "realtime_search_jobs_quota", value)

    @property
    @pulumi.getter(name="searchDiskQuota")
    def search_disk_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum disk space in MB that can be used by a user's search jobs. For example, a value of 100 limits this role to 100 MB total.
        """
        return pulumi.get(self, "search_disk_quota")

    @search_disk_quota.setter
    def search_disk_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "search_disk_quota", value)

    @property
    @pulumi.getter(name="searchFilter")
    def search_filter(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a search string that restricts the scope of searches run by this role. Search results for this role only show events that also match the search string you specify. In the case that a user has multiple roles with different search filters, they are combined with an OR.
        """
        return pulumi.get(self, "search_filter")

    @search_filter.setter
    def search_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_filter", value)

    @property
    @pulumi.getter(name="searchIndexesAlloweds")
    def search_indexes_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of indexes that this role has permissions to search. These may be wildcarded, but the index name must begin with an underscore to match internal indexes.
        """
        return pulumi.get(self, "search_indexes_alloweds")

    @search_indexes_alloweds.setter
    def search_indexes_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "search_indexes_alloweds", value)

    @property
    @pulumi.getter(name="searchIndexesDefaults")
    def search_indexes_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of indexes to search when no index is specified. These indexes can be wildcarded, with the exception that '*' does not match internal indexes. To match internal indexes, start with '_'. All internal indexes are represented by '_*'. A user with this role can search other indexes using "index= "
        """
        return pulumi.get(self, "search_indexes_defaults")

    @search_indexes_defaults.setter
    def search_indexes_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "search_indexes_defaults", value)

    @property
    @pulumi.getter(name="searchJobsQuota")
    def search_jobs_quota(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of concurrent searches a user with this role is allowed to run. For users with multiple roles, the maximum quota value among all of the roles applies.
        """
        return pulumi.get(self, "search_jobs_quota")

    @search_jobs_quota.setter
    def search_jobs_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "search_jobs_quota", value)

    @property
    @pulumi.getter(name="searchTimeWin")
    def search_time_win(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum time span of a search, in seconds. By default, searches are not limited to any specific time window. To override any search time windows from imported roles, set srchTimeWin to '0', as the 'admin' role does.
        """
        return pulumi.get(self, "search_time_win")

    @search_time_win.setter
    def search_time_win(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "search_time_win", value)


@pulumi.input_type
class _AuthorizationRolesState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cumulative_realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 cumulative_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 default_app: Optional[pulumi.Input[str]] = None,
                 imported_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 search_disk_quota: Optional[pulumi.Input[int]] = None,
                 search_filter: Optional[pulumi.Input[str]] = None,
                 search_indexes_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_indexes_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 search_time_win: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AuthorizationRoles resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of capabilities assigned to role.
        :param pulumi.Input[int] cumulative_realtime_search_jobs_quota: Maximum number of concurrently running real-time searches that all members of this role can have.
        :param pulumi.Input[int] cumulative_search_jobs_quota: Maximum number of concurrently running searches for all role members. Warning message logged when limit is reached.
        :param pulumi.Input[str] default_app: Specify the folder name of the default app to use for this role. A user-specific default app overrides this.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_roles: List of imported roles for this role. <br>Importing other roles imports all aspects of that role, such as capabilities and allowed indexes to search. In combining multiple roles, the effective value for each attribute is value with the broadest permissions.
        :param pulumi.Input[str] name: The name of the user role to create.
        :param pulumi.Input[int] realtime_search_jobs_quota: Specify the maximum number of concurrent real-time search jobs for this role. This count is independent from the normal search jobs limit.
        :param pulumi.Input[int] search_disk_quota: Specifies the maximum disk space in MB that can be used by a user's search jobs. For example, a value of 100 limits this role to 100 MB total.
        :param pulumi.Input[str] search_filter: Specify a search string that restricts the scope of searches run by this role. Search results for this role only show events that also match the search string you specify. In the case that a user has multiple roles with different search filters, they are combined with an OR.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_indexes_alloweds: List of indexes that this role has permissions to search. These may be wildcarded, but the index name must begin with an underscore to match internal indexes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_indexes_defaults: List of indexes to search when no index is specified. These indexes can be wildcarded, with the exception that '*' does not match internal indexes. To match internal indexes, start with '_'. All internal indexes are represented by '_*'. A user with this role can search other indexes using "index= "
        :param pulumi.Input[int] search_jobs_quota: The maximum number of concurrent searches a user with this role is allowed to run. For users with multiple roles, the maximum quota value among all of the roles applies.
        :param pulumi.Input[int] search_time_win: Maximum time span of a search, in seconds. By default, searches are not limited to any specific time window. To override any search time windows from imported roles, set srchTimeWin to '0', as the 'admin' role does.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if cumulative_realtime_search_jobs_quota is not None:
            pulumi.set(__self__, "cumulative_realtime_search_jobs_quota", cumulative_realtime_search_jobs_quota)
        if cumulative_search_jobs_quota is not None:
            pulumi.set(__self__, "cumulative_search_jobs_quota", cumulative_search_jobs_quota)
        if default_app is not None:
            pulumi.set(__self__, "default_app", default_app)
        if imported_roles is not None:
            pulumi.set(__self__, "imported_roles", imported_roles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if realtime_search_jobs_quota is not None:
            pulumi.set(__self__, "realtime_search_jobs_quota", realtime_search_jobs_quota)
        if search_disk_quota is not None:
            pulumi.set(__self__, "search_disk_quota", search_disk_quota)
        if search_filter is not None:
            pulumi.set(__self__, "search_filter", search_filter)
        if search_indexes_alloweds is not None:
            pulumi.set(__self__, "search_indexes_alloweds", search_indexes_alloweds)
        if search_indexes_defaults is not None:
            pulumi.set(__self__, "search_indexes_defaults", search_indexes_defaults)
        if search_jobs_quota is not None:
            pulumi.set(__self__, "search_jobs_quota", search_jobs_quota)
        if search_time_win is not None:
            pulumi.set(__self__, "search_time_win", search_time_win)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of capabilities assigned to role.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="cumulativeRealtimeSearchJobsQuota")
    def cumulative_realtime_search_jobs_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of concurrently running real-time searches that all members of this role can have.
        """
        return pulumi.get(self, "cumulative_realtime_search_jobs_quota")

    @cumulative_realtime_search_jobs_quota.setter
    def cumulative_realtime_search_jobs_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cumulative_realtime_search_jobs_quota", value)

    @property
    @pulumi.getter(name="cumulativeSearchJobsQuota")
    def cumulative_search_jobs_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of concurrently running searches for all role members. Warning message logged when limit is reached.
        """
        return pulumi.get(self, "cumulative_search_jobs_quota")

    @cumulative_search_jobs_quota.setter
    def cumulative_search_jobs_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cumulative_search_jobs_quota", value)

    @property
    @pulumi.getter(name="defaultApp")
    def default_app(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the folder name of the default app to use for this role. A user-specific default app overrides this.
        """
        return pulumi.get(self, "default_app")

    @default_app.setter
    def default_app(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_app", value)

    @property
    @pulumi.getter(name="importedRoles")
    def imported_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of imported roles for this role. <br>Importing other roles imports all aspects of that role, such as capabilities and allowed indexes to search. In combining multiple roles, the effective value for each attribute is value with the broadest permissions.
        """
        return pulumi.get(self, "imported_roles")

    @imported_roles.setter
    def imported_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "imported_roles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user role to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="realtimeSearchJobsQuota")
    def realtime_search_jobs_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the maximum number of concurrent real-time search jobs for this role. This count is independent from the normal search jobs limit.
        """
        return pulumi.get(self, "realtime_search_jobs_quota")

    @realtime_search_jobs_quota.setter
    def realtime_search_jobs_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "realtime_search_jobs_quota", value)

    @property
    @pulumi.getter(name="searchDiskQuota")
    def search_disk_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum disk space in MB that can be used by a user's search jobs. For example, a value of 100 limits this role to 100 MB total.
        """
        return pulumi.get(self, "search_disk_quota")

    @search_disk_quota.setter
    def search_disk_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "search_disk_quota", value)

    @property
    @pulumi.getter(name="searchFilter")
    def search_filter(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a search string that restricts the scope of searches run by this role. Search results for this role only show events that also match the search string you specify. In the case that a user has multiple roles with different search filters, they are combined with an OR.
        """
        return pulumi.get(self, "search_filter")

    @search_filter.setter
    def search_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_filter", value)

    @property
    @pulumi.getter(name="searchIndexesAlloweds")
    def search_indexes_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of indexes that this role has permissions to search. These may be wildcarded, but the index name must begin with an underscore to match internal indexes.
        """
        return pulumi.get(self, "search_indexes_alloweds")

    @search_indexes_alloweds.setter
    def search_indexes_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "search_indexes_alloweds", value)

    @property
    @pulumi.getter(name="searchIndexesDefaults")
    def search_indexes_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of indexes to search when no index is specified. These indexes can be wildcarded, with the exception that '*' does not match internal indexes. To match internal indexes, start with '_'. All internal indexes are represented by '_*'. A user with this role can search other indexes using "index= "
        """
        return pulumi.get(self, "search_indexes_defaults")

    @search_indexes_defaults.setter
    def search_indexes_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "search_indexes_defaults", value)

    @property
    @pulumi.getter(name="searchJobsQuota")
    def search_jobs_quota(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of concurrent searches a user with this role is allowed to run. For users with multiple roles, the maximum quota value among all of the roles applies.
        """
        return pulumi.get(self, "search_jobs_quota")

    @search_jobs_quota.setter
    def search_jobs_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "search_jobs_quota", value)

    @property
    @pulumi.getter(name="searchTimeWin")
    def search_time_win(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum time span of a search, in seconds. By default, searches are not limited to any specific time window. To override any search time windows from imported roles, set srchTimeWin to '0', as the 'admin' role does.
        """
        return pulumi.get(self, "search_time_win")

    @search_time_win.setter
    def search_time_win(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "search_time_win", value)


class AuthorizationRoles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cumulative_realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 cumulative_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 default_app: Optional[pulumi.Input[str]] = None,
                 imported_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 search_disk_quota: Optional[pulumi.Input[int]] = None,
                 search_filter: Optional[pulumi.Input[str]] = None,
                 search_indexes_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_indexes_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 search_time_win: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## # Resource: AuthorizationRoles

        Create and update role information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        role01 = splunk.AuthorizationRoles("role01",
            capabilities=[
                "accelerate_datamodel",
                "change_authentication",
                "restart_splunkd",
            ],
            default_app="search",
            imported_roles=[
                "power",
                "user",
            ],
            search_indexes_alloweds=[
                "_audit",
                "_internal",
                "main",
            ],
            search_indexes_defaults=[
                "_audit",
                "_internal",
                "main",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of capabilities assigned to role.
        :param pulumi.Input[int] cumulative_realtime_search_jobs_quota: Maximum number of concurrently running real-time searches that all members of this role can have.
        :param pulumi.Input[int] cumulative_search_jobs_quota: Maximum number of concurrently running searches for all role members. Warning message logged when limit is reached.
        :param pulumi.Input[str] default_app: Specify the folder name of the default app to use for this role. A user-specific default app overrides this.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_roles: List of imported roles for this role. <br>Importing other roles imports all aspects of that role, such as capabilities and allowed indexes to search. In combining multiple roles, the effective value for each attribute is value with the broadest permissions.
        :param pulumi.Input[str] name: The name of the user role to create.
        :param pulumi.Input[int] realtime_search_jobs_quota: Specify the maximum number of concurrent real-time search jobs for this role. This count is independent from the normal search jobs limit.
        :param pulumi.Input[int] search_disk_quota: Specifies the maximum disk space in MB that can be used by a user's search jobs. For example, a value of 100 limits this role to 100 MB total.
        :param pulumi.Input[str] search_filter: Specify a search string that restricts the scope of searches run by this role. Search results for this role only show events that also match the search string you specify. In the case that a user has multiple roles with different search filters, they are combined with an OR.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_indexes_alloweds: List of indexes that this role has permissions to search. These may be wildcarded, but the index name must begin with an underscore to match internal indexes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_indexes_defaults: List of indexes to search when no index is specified. These indexes can be wildcarded, with the exception that '*' does not match internal indexes. To match internal indexes, start with '_'. All internal indexes are represented by '_*'. A user with this role can search other indexes using "index= "
        :param pulumi.Input[int] search_jobs_quota: The maximum number of concurrent searches a user with this role is allowed to run. For users with multiple roles, the maximum quota value among all of the roles applies.
        :param pulumi.Input[int] search_time_win: Maximum time span of a search, in seconds. By default, searches are not limited to any specific time window. To override any search time windows from imported roles, set srchTimeWin to '0', as the 'admin' role does.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuthorizationRolesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: AuthorizationRoles

        Create and update role information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        role01 = splunk.AuthorizationRoles("role01",
            capabilities=[
                "accelerate_datamodel",
                "change_authentication",
                "restart_splunkd",
            ],
            default_app="search",
            imported_roles=[
                "power",
                "user",
            ],
            search_indexes_alloweds=[
                "_audit",
                "_internal",
                "main",
            ],
            search_indexes_defaults=[
                "_audit",
                "_internal",
                "main",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizationRolesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizationRolesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cumulative_realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 cumulative_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 default_app: Optional[pulumi.Input[str]] = None,
                 imported_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 search_disk_quota: Optional[pulumi.Input[int]] = None,
                 search_filter: Optional[pulumi.Input[str]] = None,
                 search_indexes_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_indexes_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_jobs_quota: Optional[pulumi.Input[int]] = None,
                 search_time_win: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizationRolesArgs.__new__(AuthorizationRolesArgs)

            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["cumulative_realtime_search_jobs_quota"] = cumulative_realtime_search_jobs_quota
            __props__.__dict__["cumulative_search_jobs_quota"] = cumulative_search_jobs_quota
            __props__.__dict__["default_app"] = default_app
            __props__.__dict__["imported_roles"] = imported_roles
            __props__.__dict__["name"] = name
            __props__.__dict__["realtime_search_jobs_quota"] = realtime_search_jobs_quota
            __props__.__dict__["search_disk_quota"] = search_disk_quota
            __props__.__dict__["search_filter"] = search_filter
            __props__.__dict__["search_indexes_alloweds"] = search_indexes_alloweds
            __props__.__dict__["search_indexes_defaults"] = search_indexes_defaults
            __props__.__dict__["search_jobs_quota"] = search_jobs_quota
            __props__.__dict__["search_time_win"] = search_time_win
        super(AuthorizationRoles, __self__).__init__(
            'splunk:index/authorizationRoles:AuthorizationRoles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cumulative_realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
            cumulative_search_jobs_quota: Optional[pulumi.Input[int]] = None,
            default_app: Optional[pulumi.Input[str]] = None,
            imported_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            realtime_search_jobs_quota: Optional[pulumi.Input[int]] = None,
            search_disk_quota: Optional[pulumi.Input[int]] = None,
            search_filter: Optional[pulumi.Input[str]] = None,
            search_indexes_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            search_indexes_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            search_jobs_quota: Optional[pulumi.Input[int]] = None,
            search_time_win: Optional[pulumi.Input[int]] = None) -> 'AuthorizationRoles':
        """
        Get an existing AuthorizationRoles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of capabilities assigned to role.
        :param pulumi.Input[int] cumulative_realtime_search_jobs_quota: Maximum number of concurrently running real-time searches that all members of this role can have.
        :param pulumi.Input[int] cumulative_search_jobs_quota: Maximum number of concurrently running searches for all role members. Warning message logged when limit is reached.
        :param pulumi.Input[str] default_app: Specify the folder name of the default app to use for this role. A user-specific default app overrides this.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_roles: List of imported roles for this role. <br>Importing other roles imports all aspects of that role, such as capabilities and allowed indexes to search. In combining multiple roles, the effective value for each attribute is value with the broadest permissions.
        :param pulumi.Input[str] name: The name of the user role to create.
        :param pulumi.Input[int] realtime_search_jobs_quota: Specify the maximum number of concurrent real-time search jobs for this role. This count is independent from the normal search jobs limit.
        :param pulumi.Input[int] search_disk_quota: Specifies the maximum disk space in MB that can be used by a user's search jobs. For example, a value of 100 limits this role to 100 MB total.
        :param pulumi.Input[str] search_filter: Specify a search string that restricts the scope of searches run by this role. Search results for this role only show events that also match the search string you specify. In the case that a user has multiple roles with different search filters, they are combined with an OR.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_indexes_alloweds: List of indexes that this role has permissions to search. These may be wildcarded, but the index name must begin with an underscore to match internal indexes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_indexes_defaults: List of indexes to search when no index is specified. These indexes can be wildcarded, with the exception that '*' does not match internal indexes. To match internal indexes, start with '_'. All internal indexes are represented by '_*'. A user with this role can search other indexes using "index= "
        :param pulumi.Input[int] search_jobs_quota: The maximum number of concurrent searches a user with this role is allowed to run. For users with multiple roles, the maximum quota value among all of the roles applies.
        :param pulumi.Input[int] search_time_win: Maximum time span of a search, in seconds. By default, searches are not limited to any specific time window. To override any search time windows from imported roles, set srchTimeWin to '0', as the 'admin' role does.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizationRolesState.__new__(_AuthorizationRolesState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["cumulative_realtime_search_jobs_quota"] = cumulative_realtime_search_jobs_quota
        __props__.__dict__["cumulative_search_jobs_quota"] = cumulative_search_jobs_quota
        __props__.__dict__["default_app"] = default_app
        __props__.__dict__["imported_roles"] = imported_roles
        __props__.__dict__["name"] = name
        __props__.__dict__["realtime_search_jobs_quota"] = realtime_search_jobs_quota
        __props__.__dict__["search_disk_quota"] = search_disk_quota
        __props__.__dict__["search_filter"] = search_filter
        __props__.__dict__["search_indexes_alloweds"] = search_indexes_alloweds
        __props__.__dict__["search_indexes_defaults"] = search_indexes_defaults
        __props__.__dict__["search_jobs_quota"] = search_jobs_quota
        __props__.__dict__["search_time_win"] = search_time_win
        return AuthorizationRoles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence[str]]:
        """
        List of capabilities assigned to role.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="cumulativeRealtimeSearchJobsQuota")
    def cumulative_realtime_search_jobs_quota(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of concurrently running real-time searches that all members of this role can have.
        """
        return pulumi.get(self, "cumulative_realtime_search_jobs_quota")

    @property
    @pulumi.getter(name="cumulativeSearchJobsQuota")
    def cumulative_search_jobs_quota(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of concurrently running searches for all role members. Warning message logged when limit is reached.
        """
        return pulumi.get(self, "cumulative_search_jobs_quota")

    @property
    @pulumi.getter(name="defaultApp")
    def default_app(self) -> pulumi.Output[str]:
        """
        Specify the folder name of the default app to use for this role. A user-specific default app overrides this.
        """
        return pulumi.get(self, "default_app")

    @property
    @pulumi.getter(name="importedRoles")
    def imported_roles(self) -> pulumi.Output[Sequence[str]]:
        """
        List of imported roles for this role. <br>Importing other roles imports all aspects of that role, such as capabilities and allowed indexes to search. In combining multiple roles, the effective value for each attribute is value with the broadest permissions.
        """
        return pulumi.get(self, "imported_roles")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the user role to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="realtimeSearchJobsQuota")
    def realtime_search_jobs_quota(self) -> pulumi.Output[Optional[int]]:
        """
        Specify the maximum number of concurrent real-time search jobs for this role. This count is independent from the normal search jobs limit.
        """
        return pulumi.get(self, "realtime_search_jobs_quota")

    @property
    @pulumi.getter(name="searchDiskQuota")
    def search_disk_quota(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum disk space in MB that can be used by a user's search jobs. For example, a value of 100 limits this role to 100 MB total.
        """
        return pulumi.get(self, "search_disk_quota")

    @property
    @pulumi.getter(name="searchFilter")
    def search_filter(self) -> pulumi.Output[str]:
        """
        Specify a search string that restricts the scope of searches run by this role. Search results for this role only show events that also match the search string you specify. In the case that a user has multiple roles with different search filters, they are combined with an OR.
        """
        return pulumi.get(self, "search_filter")

    @property
    @pulumi.getter(name="searchIndexesAlloweds")
    def search_indexes_alloweds(self) -> pulumi.Output[Sequence[str]]:
        """
        List of indexes that this role has permissions to search. These may be wildcarded, but the index name must begin with an underscore to match internal indexes.
        """
        return pulumi.get(self, "search_indexes_alloweds")

    @property
    @pulumi.getter(name="searchIndexesDefaults")
    def search_indexes_defaults(self) -> pulumi.Output[Sequence[str]]:
        """
        List of indexes to search when no index is specified. These indexes can be wildcarded, with the exception that '*' does not match internal indexes. To match internal indexes, start with '_'. All internal indexes are represented by '_*'. A user with this role can search other indexes using "index= "
        """
        return pulumi.get(self, "search_indexes_defaults")

    @property
    @pulumi.getter(name="searchJobsQuota")
    def search_jobs_quota(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of concurrent searches a user with this role is allowed to run. For users with multiple roles, the maximum quota value among all of the roles applies.
        """
        return pulumi.get(self, "search_jobs_quota")

    @property
    @pulumi.getter(name="searchTimeWin")
    def search_time_win(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum time span of a search, in seconds. By default, searches are not limited to any specific time window. To override any search time windows from imported roles, set srchTimeWin to '0', as the 'admin' role does.
        """
        return pulumi.get(self, "search_time_win")

