"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Subscription = exports.SubscriptionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mns_generated_1 = require("./mns.generated");
Object.defineProperty(exports, "SubscriptionProperty", { enumerable: true, get: function () { return mns_generated_1.RosSubscription; } });
/**
 * A ROS resource type:  `ALIYUN::MNS::Subscription`
 */
class Subscription extends ros.Resource {
    /**
     * Create a new `ALIYUN::MNS::Subscription`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSubscription = new mns_generated_1.RosSubscription(this, id, {
            endpoint: props.endpoint,
            notifyStrategy: props.notifyStrategy ? props.notifyStrategy : 'BACKOFF_RETRY',
            notifyContentFormat: props.notifyContentFormat ? props.notifyContentFormat : 'XML',
            filterTag: props.filterTag,
            subscriptionName: props.subscriptionName,
            topicName: props.topicName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSubscription;
        this.attrSubscriptionName = rosSubscription.attrSubscriptionName;
        this.attrSubscriptionUrl = rosSubscription.attrSubscriptionUrl;
        this.attrTopicName = rosSubscription.attrTopicName;
    }
}
exports.Subscription = Subscription;
//# sourceMappingURL=data:application/json;base64,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