"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Queue = exports.QueueProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mns_generated_1 = require("./mns.generated");
Object.defineProperty(exports, "QueueProperty", { enumerable: true, get: function () { return mns_generated_1.RosQueue; } });
/**
 * A ROS resource type:  `ALIYUN::MNS::Queue`
 */
class Queue extends ros.Resource {
    /**
     * Create a new `ALIYUN::MNS::Queue`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosQueue = new mns_generated_1.RosQueue(this, id, {
            delaySeconds: props.delaySeconds ? props.delaySeconds : 0,
            pollingWaitSeconds: props.pollingWaitSeconds ? props.pollingWaitSeconds : 0,
            messageRetentionPeriod: props.messageRetentionPeriod ? props.messageRetentionPeriod : 345600,
            maximumMessageSize: props.maximumMessageSize ? props.maximumMessageSize : 65536,
            visibilityTimeout: props.visibilityTimeout ? props.visibilityTimeout : 30,
            queueName: props.queueName,
            loggingEnabled: props.loggingEnabled ? props.loggingEnabled : false,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosQueue;
        this.attrArnWithSlash = rosQueue.attrArnWithSlash;
        this.attrQueueName = rosQueue.attrQueueName;
        this.attrQueueUrl = rosQueue.attrQueueUrl;
    }
}
exports.Queue = Queue;
//# sourceMappingURL=data:application/json;base64,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