## -*- coding: utf-8 -*-
<%doc>

camcops_server/templates/menu/view_email.mako

===============================================================================

    Copyright (C) 2012, University of Cambridge, Department of Psychiatry.
    Created by Rudolf Cardinal (rnc1001@cam.ac.uk).

    This file is part of CamCOPS.

    CamCOPS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CamCOPS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CamCOPS. If not, see <https://www.gnu.org/licenses/>.

===============================================================================

</%doc>

<%inherit file="base_web.mako"/>

<%!
from cardinal_pythonlib.httpconst import MimeType
from markupsafe import escape
from camcops_server.cc_modules.cc_pyramid import Icons, Routes, ViewArg, ViewParam
%>

<%include file="db_user_info.mako"/>

<h1>
    ${ req.icon_text(
        icon=Icons.EMAIL_VIEW,
        text=_("View e-mail generated by CamCOPS")
    ) | n }
</h1>

<h2>Message</h2>

<h3>Properties</h3>
<table>
    <colgroup>
        <col style="width:30%">
        <col style="width:70%">
    </colgroup>
    <tr>
        <th>Email ID</th>
        <td>${ email.id }</td>
    </tr>
    <tr>
        <th>Created at (UTC)</th>
        <td>${ email.created_at_utc }</td>
    </tr>

    <!-- Headers -->
    <tr>
        <th>Date</th>
        <td>${ email.date }</td>
    </tr>
    <tr>
        <th>From</th>
        <td>${ email.from_addr or "" }</td>
    </tr>
    <tr>
        <th>Reply-to</th>
        <td>${ email.reply_to or "" }</td>
    </tr>
    <tr>
        <th>To</th>
        <td>${ email.to or "" }</td>
    </tr>
    <tr>
        <th>CC</th>
        <td>${ email.cc or "" }</td>
    </tr>
    <tr>
        <th>BCC</th>
        <td>${ email.bcc or "" }</td>
    </tr>
    <tr>
        <th>Subject</th>
        <td>${ email.subject or "" }</td>
    </tr>
    <tr>
        <th>Content type</th>
        <td>${ email.content_type or "" }</td>
    </tr>
    <tr>
        <th>Character set</th>
        <td>${ email.charset or "" }</td>
    </tr>
</table>

<h3>Body</h3>
%if email.content_type == MimeType.HTML:
    ## The HTML here comes from a rich text editor; it is not user-editable HTML.
    <div>${ email.body | n }</div>
%else:
    <pre>${ email.body or "" }</pre>
%endif

%if email.msg_string:
    <h3>Message as a string</h3>
    <pre>${ email.msg_string }</pre>
%endif

<h2>Server</h2>
<table>
    <colgroup>
        <col style="width:30%">
        <col style="width:70%">
    </colgroup>
    <tbody>
        <tr>
            <th>Host</th>
            <td>${ email.host or "" }</td>
        </tr>
        <tr>
            <th>Port</th>
            <td>${ email.port or "" }</td>
        </tr>
        <tr>
            <th>Username</th>
            <td>${ email.username or "" }</td>
        </tr>
        <tr>
            <th>Use TLS?</th>
            <td>${ email.use_tls }</td>
        </tr>
    </tbody>
</table>

<h2>Status</h2>
<table>
    <colgroup>
        <col style="width:30%">
        <col style="width:70%">
    </colgroup>
    <tbody>
        <tr>
            <th>Sent?</th>
            <td>${ email.sent }</td>
        </tr>
        <tr>
            <th>Sent at (UTC)</th>
            <td>${ email.sent_at_utc }</td>
        </tr>
        <tr>
            <th>Reasons sending failed</th>
            <td>${ email.sending_failure_reason or "" }</td>
        </tr>
    </tbody>
</table>

<%include file="to_main_menu.mako"/>
