import { Grant, IGrantable } from '@aws-cdk/aws-iam';
import { ISecret } from '@aws-cdk/aws-secretsmanager';
import { IParameter } from '@aws-cdk/aws-ssm';
import { KeyType } from './key-type';
export declare abstract class SecretKeyStore {
    readonly secretKeyType: KeyType;
    static fromSSMParameter(secretKeyParameter: IParameter): SecretKeyStore;
    static fromSecretsManager(secretKeySecret: ISecret): SecretKeyStore;
    constructor(secretKeyType: KeyType);
    abstract grantWrite?(grantee: IGrantable): Grant;
    abstract serialize(): string;
}
