# Generated by Django 2.2.1 on 2021-02-07 01:57

from django.db import migrations, models
from uuid import uuid4


def create_uuid(apps, schema_editor):
    Token = apps.get_model('lavender', 'Token')
    for token in Token.objects.filter(uuid__isnull=True).all():
        token.uuid = uuid4()
        token.save()

    Player = apps.get_model('lavender', 'Player')
    for player in Player.objects.filter(token__isnull=True).all():
        token = Token(player=player, uuid=uuid4())
        token.save()


class Migration(migrations.Migration):

    dependencies = [
        ('lavender', '0008_strict_token'),
    ]

    operations = [
        migrations.RunPython(create_uuid),
        migrations.AlterField(
            model_name='token',
            name='uuid',
            field=models.UUIDField(),
        ),
    ]
