# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ProblemDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'message': 'str',
        'line': 'int',
        'column': 'int',
        'main_element_id': 'str',
        'element_ids': 'list[str]'
    }

    attribute_map = {
        'message': 'message',
        'line': 'line',
        'column': 'column',
        'main_element_id': 'mainElementId',
        'element_ids': 'elementIds'
    }

    def __init__(self, message=None, line=None, column=None, main_element_id=None, element_ids=None, local_vars_configuration=None):  # noqa: E501
        """ProblemDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._message = None
        self._line = None
        self._column = None
        self._main_element_id = None
        self._element_ids = None
        self.discriminator = None

        if message is not None:
            self.message = message
        self.line = line
        self.column = column
        if main_element_id is not None:
            self.main_element_id = main_element_id
        if element_ids is not None:
            self.element_ids = element_ids

    @property
    def message(self):
        """Gets the message of this ProblemDto.  # noqa: E501

        The message of the problem.  # noqa: E501

        :return: The message of this ProblemDto.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ProblemDto.

        The message of the problem.  # noqa: E501

        :param message: The message of this ProblemDto.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def line(self):
        """Gets the line of this ProblemDto.  # noqa: E501

        The line where the problem occurred.  # noqa: E501

        :return: The line of this ProblemDto.  # noqa: E501
        :rtype: int
        """
        return self._line

    @line.setter
    def line(self, line):
        """Sets the line of this ProblemDto.

        The line where the problem occurred.  # noqa: E501

        :param line: The line of this ProblemDto.  # noqa: E501
        :type: int
        """

        self._line = line

    @property
    def column(self):
        """Gets the column of this ProblemDto.  # noqa: E501

        The column where the problem occurred.  # noqa: E501

        :return: The column of this ProblemDto.  # noqa: E501
        :rtype: int
        """
        return self._column

    @column.setter
    def column(self, column):
        """Sets the column of this ProblemDto.

        The column where the problem occurred.  # noqa: E501

        :param column: The column of this ProblemDto.  # noqa: E501
        :type: int
        """

        self._column = column

    @property
    def main_element_id(self):
        """Gets the main_element_id of this ProblemDto.  # noqa: E501

        The main element id where the problem occurred.  # noqa: E501

        :return: The main_element_id of this ProblemDto.  # noqa: E501
        :rtype: str
        """
        return self._main_element_id

    @main_element_id.setter
    def main_element_id(self, main_element_id):
        """Sets the main_element_id of this ProblemDto.

        The main element id where the problem occurred.  # noqa: E501

        :param main_element_id: The main_element_id of this ProblemDto.  # noqa: E501
        :type: str
        """

        self._main_element_id = main_element_id

    @property
    def element_ids(self):
        """Gets the element_ids of this ProblemDto.  # noqa: E501

        A list of element id affected by the problem.  # noqa: E501

        :return: The element_ids of this ProblemDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._element_ids

    @element_ids.setter
    def element_ids(self, element_ids):
        """Sets the element_ids of this ProblemDto.

        A list of element id affected by the problem.  # noqa: E501

        :param element_ids: The element_ids of this ProblemDto.  # noqa: E501
        :type: list[str]
        """

        self._element_ids = element_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProblemDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProblemDto):
            return True

        return self.to_dict() != other.to_dict()
