# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class MultiFormDeploymentDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tenant_id': 'str',
        'deployment_source': 'str',
        'deploy_changed_only': 'bool',
        'enable_duplicate_filtering': 'bool',
        'deployment_name': 'str',
        'data': 'file'
    }

    attribute_map = {
        'tenant_id': 'tenant-id',
        'deployment_source': 'deployment-source',
        'deploy_changed_only': 'deploy-changed-only',
        'enable_duplicate_filtering': 'enable-duplicate-filtering',
        'deployment_name': 'deployment-name',
        'data': 'data'
    }

    def __init__(self, tenant_id=None, deployment_source=None, deploy_changed_only=False, enable_duplicate_filtering=False, deployment_name=None, data=None, local_vars_configuration=None):  # noqa: E501
        """MultiFormDeploymentDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._tenant_id = None
        self._deployment_source = None
        self._deploy_changed_only = None
        self._enable_duplicate_filtering = None
        self._deployment_name = None
        self._data = None
        self.discriminator = None

        if tenant_id is not None:
            self.tenant_id = tenant_id
        if deployment_source is not None:
            self.deployment_source = deployment_source
        self.deploy_changed_only = deploy_changed_only
        self.enable_duplicate_filtering = enable_duplicate_filtering
        if deployment_name is not None:
            self.deployment_name = deployment_name
        self.data = data

    @property
    def tenant_id(self):
        """Gets the tenant_id of this MultiFormDeploymentDto.  # noqa: E501

        The tenant id for the deployment to be created.  # noqa: E501

        :return: The tenant_id of this MultiFormDeploymentDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this MultiFormDeploymentDto.

        The tenant id for the deployment to be created.  # noqa: E501

        :param tenant_id: The tenant_id of this MultiFormDeploymentDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def deployment_source(self):
        """Gets the deployment_source of this MultiFormDeploymentDto.  # noqa: E501

        The source for the deployment to be created.  # noqa: E501

        :return: The deployment_source of this MultiFormDeploymentDto.  # noqa: E501
        :rtype: str
        """
        return self._deployment_source

    @deployment_source.setter
    def deployment_source(self, deployment_source):
        """Sets the deployment_source of this MultiFormDeploymentDto.

        The source for the deployment to be created.  # noqa: E501

        :param deployment_source: The deployment_source of this MultiFormDeploymentDto.  # noqa: E501
        :type: str
        """

        self._deployment_source = deployment_source

    @property
    def deploy_changed_only(self):
        """Gets the deploy_changed_only of this MultiFormDeploymentDto.  # noqa: E501

        A flag indicating whether the process engine should perform duplicate checking on a per-resource basis. If set to true, only those resources that have actually changed are deployed. Checks are made against resources included previous deployments of the same name and only against the latest versions of those resources. If set to true, the option enable-duplicate-filtering is overridden and set to true.  # noqa: E501

        :return: The deploy_changed_only of this MultiFormDeploymentDto.  # noqa: E501
        :rtype: bool
        """
        return self._deploy_changed_only

    @deploy_changed_only.setter
    def deploy_changed_only(self, deploy_changed_only):
        """Sets the deploy_changed_only of this MultiFormDeploymentDto.

        A flag indicating whether the process engine should perform duplicate checking on a per-resource basis. If set to true, only those resources that have actually changed are deployed. Checks are made against resources included previous deployments of the same name and only against the latest versions of those resources. If set to true, the option enable-duplicate-filtering is overridden and set to true.  # noqa: E501

        :param deploy_changed_only: The deploy_changed_only of this MultiFormDeploymentDto.  # noqa: E501
        :type: bool
        """

        self._deploy_changed_only = deploy_changed_only

    @property
    def enable_duplicate_filtering(self):
        """Gets the enable_duplicate_filtering of this MultiFormDeploymentDto.  # noqa: E501

        A flag indicating whether the process engine should perform duplicate checking for the deployment or not. This allows you to check if a deployment with the same name and the same resouces already exists and if true, not create a new deployment but instead return the existing deployment. The default value is false.  # noqa: E501

        :return: The enable_duplicate_filtering of this MultiFormDeploymentDto.  # noqa: E501
        :rtype: bool
        """
        return self._enable_duplicate_filtering

    @enable_duplicate_filtering.setter
    def enable_duplicate_filtering(self, enable_duplicate_filtering):
        """Sets the enable_duplicate_filtering of this MultiFormDeploymentDto.

        A flag indicating whether the process engine should perform duplicate checking for the deployment or not. This allows you to check if a deployment with the same name and the same resouces already exists and if true, not create a new deployment but instead return the existing deployment. The default value is false.  # noqa: E501

        :param enable_duplicate_filtering: The enable_duplicate_filtering of this MultiFormDeploymentDto.  # noqa: E501
        :type: bool
        """

        self._enable_duplicate_filtering = enable_duplicate_filtering

    @property
    def deployment_name(self):
        """Gets the deployment_name of this MultiFormDeploymentDto.  # noqa: E501

        The name for the deployment to be created.  # noqa: E501

        :return: The deployment_name of this MultiFormDeploymentDto.  # noqa: E501
        :rtype: str
        """
        return self._deployment_name

    @deployment_name.setter
    def deployment_name(self, deployment_name):
        """Sets the deployment_name of this MultiFormDeploymentDto.

        The name for the deployment to be created.  # noqa: E501

        :param deployment_name: The deployment_name of this MultiFormDeploymentDto.  # noqa: E501
        :type: str
        """

        self._deployment_name = deployment_name

    @property
    def data(self):
        """Gets the data of this MultiFormDeploymentDto.  # noqa: E501

        The binary data to create the deployment resource. It is possible to have more than one form part with different form part names for the binary data to create a deployment.  # noqa: E501

        :return: The data of this MultiFormDeploymentDto.  # noqa: E501
        :rtype: file
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this MultiFormDeploymentDto.

        The binary data to create the deployment resource. It is possible to have more than one form part with different form part names for the binary data to create a deployment.  # noqa: E501

        :param data: The data of this MultiFormDeploymentDto.  # noqa: E501
        :type: file
        """

        self._data = data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MultiFormDeploymentDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MultiFormDeploymentDto):
            return True

        return self.to_dict() != other.to_dict()
