# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class IncidentDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'process_definition_id': 'str',
        'process_instance_id': 'str',
        'execution_id': 'str',
        'incident_timestamp': 'datetime',
        'incident_type': 'str',
        'activity_id': 'str',
        'failed_activity_id': 'str',
        'cause_incident_id': 'str',
        'root_cause_incident_id': 'str',
        'configuration': 'str',
        'tenant_id': 'str',
        'incident_message': 'str',
        'job_definition_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'process_definition_id': 'processDefinitionId',
        'process_instance_id': 'processInstanceId',
        'execution_id': 'executionId',
        'incident_timestamp': 'incidentTimestamp',
        'incident_type': 'incidentType',
        'activity_id': 'activityId',
        'failed_activity_id': 'failedActivityId',
        'cause_incident_id': 'causeIncidentId',
        'root_cause_incident_id': 'rootCauseIncidentId',
        'configuration': 'configuration',
        'tenant_id': 'tenantId',
        'incident_message': 'incidentMessage',
        'job_definition_id': 'jobDefinitionId'
    }

    def __init__(self, id=None, process_definition_id=None, process_instance_id=None, execution_id=None, incident_timestamp=None, incident_type=None, activity_id=None, failed_activity_id=None, cause_incident_id=None, root_cause_incident_id=None, configuration=None, tenant_id=None, incident_message=None, job_definition_id=None, local_vars_configuration=None):  # noqa: E501
        """IncidentDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._process_definition_id = None
        self._process_instance_id = None
        self._execution_id = None
        self._incident_timestamp = None
        self._incident_type = None
        self._activity_id = None
        self._failed_activity_id = None
        self._cause_incident_id = None
        self._root_cause_incident_id = None
        self._configuration = None
        self._tenant_id = None
        self._incident_message = None
        self._job_definition_id = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if process_definition_id is not None:
            self.process_definition_id = process_definition_id
        if process_instance_id is not None:
            self.process_instance_id = process_instance_id
        if execution_id is not None:
            self.execution_id = execution_id
        self.incident_timestamp = incident_timestamp
        if incident_type is not None:
            self.incident_type = incident_type
        if activity_id is not None:
            self.activity_id = activity_id
        if failed_activity_id is not None:
            self.failed_activity_id = failed_activity_id
        if cause_incident_id is not None:
            self.cause_incident_id = cause_incident_id
        if root_cause_incident_id is not None:
            self.root_cause_incident_id = root_cause_incident_id
        if configuration is not None:
            self.configuration = configuration
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if incident_message is not None:
            self.incident_message = incident_message
        if job_definition_id is not None:
            self.job_definition_id = job_definition_id

    @property
    def id(self):
        """Gets the id of this IncidentDto.  # noqa: E501

        The id of the incident.  # noqa: E501

        :return: The id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this IncidentDto.

        The id of the incident.  # noqa: E501

        :param id: The id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this IncidentDto.  # noqa: E501

        The id of the process definition this incident is associated with.  # noqa: E501

        :return: The process_definition_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this IncidentDto.

        The id of the process definition this incident is associated with.  # noqa: E501

        :param process_definition_id: The process_definition_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this IncidentDto.  # noqa: E501

        The id of the process instance this incident is associated with.  # noqa: E501

        :return: The process_instance_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this IncidentDto.

        The id of the process instance this incident is associated with.  # noqa: E501

        :param process_instance_id: The process_instance_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def execution_id(self):
        """Gets the execution_id of this IncidentDto.  # noqa: E501

        The id of the execution this incident is associated with.  # noqa: E501

        :return: The execution_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this IncidentDto.

        The id of the execution this incident is associated with.  # noqa: E501

        :param execution_id: The execution_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def incident_timestamp(self):
        """Gets the incident_timestamp of this IncidentDto.  # noqa: E501

        The time this incident happened. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The incident_timestamp of this IncidentDto.  # noqa: E501
        :rtype: datetime
        """
        return self._incident_timestamp

    @incident_timestamp.setter
    def incident_timestamp(self, incident_timestamp):
        """Sets the incident_timestamp of this IncidentDto.

        The time this incident happened. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param incident_timestamp: The incident_timestamp of this IncidentDto.  # noqa: E501
        :type: datetime
        """

        self._incident_timestamp = incident_timestamp

    @property
    def incident_type(self):
        """Gets the incident_type of this IncidentDto.  # noqa: E501

        The type of incident, for example: `failedJobs` will be returned in case of an incident which identified a failed job during the execution of a process instance. See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :return: The incident_type of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_type

    @incident_type.setter
    def incident_type(self, incident_type):
        """Sets the incident_type of this IncidentDto.

        The type of incident, for example: `failedJobs` will be returned in case of an incident which identified a failed job during the execution of a process instance. See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :param incident_type: The incident_type of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._incident_type = incident_type

    @property
    def activity_id(self):
        """Gets the activity_id of this IncidentDto.  # noqa: E501

        The id of the activity this incident is associated with.  # noqa: E501

        :return: The activity_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this IncidentDto.

        The id of the activity this incident is associated with.  # noqa: E501

        :param activity_id: The activity_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def failed_activity_id(self):
        """Gets the failed_activity_id of this IncidentDto.  # noqa: E501

        The id of the activity on which the last exception occurred.  # noqa: E501

        :return: The failed_activity_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._failed_activity_id

    @failed_activity_id.setter
    def failed_activity_id(self, failed_activity_id):
        """Sets the failed_activity_id of this IncidentDto.

        The id of the activity on which the last exception occurred.  # noqa: E501

        :param failed_activity_id: The failed_activity_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._failed_activity_id = failed_activity_id

    @property
    def cause_incident_id(self):
        """Gets the cause_incident_id of this IncidentDto.  # noqa: E501

        The id of the associated cause incident which has been triggered.  # noqa: E501

        :return: The cause_incident_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._cause_incident_id

    @cause_incident_id.setter
    def cause_incident_id(self, cause_incident_id):
        """Sets the cause_incident_id of this IncidentDto.

        The id of the associated cause incident which has been triggered.  # noqa: E501

        :param cause_incident_id: The cause_incident_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._cause_incident_id = cause_incident_id

    @property
    def root_cause_incident_id(self):
        """Gets the root_cause_incident_id of this IncidentDto.  # noqa: E501

        The id of the associated root cause incident which has been triggered.  # noqa: E501

        :return: The root_cause_incident_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._root_cause_incident_id

    @root_cause_incident_id.setter
    def root_cause_incident_id(self, root_cause_incident_id):
        """Sets the root_cause_incident_id of this IncidentDto.

        The id of the associated root cause incident which has been triggered.  # noqa: E501

        :param root_cause_incident_id: The root_cause_incident_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._root_cause_incident_id = root_cause_incident_id

    @property
    def configuration(self):
        """Gets the configuration of this IncidentDto.  # noqa: E501

        The payload of this incident.  # noqa: E501

        :return: The configuration of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """Sets the configuration of this IncidentDto.

        The payload of this incident.  # noqa: E501

        :param configuration: The configuration of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._configuration = configuration

    @property
    def tenant_id(self):
        """Gets the tenant_id of this IncidentDto.  # noqa: E501

        The id of the tenant this incident is associated with.  # noqa: E501

        :return: The tenant_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this IncidentDto.

        The id of the tenant this incident is associated with.  # noqa: E501

        :param tenant_id: The tenant_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def incident_message(self):
        """Gets the incident_message of this IncidentDto.  # noqa: E501

        The message of this incident.  # noqa: E501

        :return: The incident_message of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_message

    @incident_message.setter
    def incident_message(self, incident_message):
        """Sets the incident_message of this IncidentDto.

        The message of this incident.  # noqa: E501

        :param incident_message: The incident_message of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._incident_message = incident_message

    @property
    def job_definition_id(self):
        """Gets the job_definition_id of this IncidentDto.  # noqa: E501

        The job definition id the incident is associated with.  # noqa: E501

        :return: The job_definition_id of this IncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """Sets the job_definition_id of this IncidentDto.

        The job definition id the incident is associated with.  # noqa: E501

        :param job_definition_id: The job_definition_id of this IncidentDto.  # noqa: E501
        :type: str
        """

        self._job_definition_id = job_definition_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IncidentDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IncidentDto):
            return True

        return self.to_dict() != other.to_dict()
