# generic-camunda-client
OpenApi Spec for Camunda BPM REST API.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 7.14.0
- Package version: 0.0.3
- Build date: 2020-11-17T22:18:16.401769098Z[GMT]
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import generic_camunda_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import generic_camunda_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import generic_camunda_client
from generic_camunda_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080/engine-rest
# See configuration.py for a list of all supported configuration parameters.
configuration = generic_camunda_client.Configuration(
    host = "http://localhost:8080/engine-rest"
)



# Enter a context with an instance of the API client
with generic_camunda_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = generic_camunda_client.ConditionApi(api_client)
    evaluation_condition_dto = {"variables":{"temperature":{"value":24,"type":"Integer","valueInfo":{"transient":true}},"city":{"value":"Parma","type":"String"}},"businessKey":"aBusinessKey","tenantId":"aTenantId"} # EvaluationConditionDto |  (optional)

    try:
        api_response = api_instance.evaluate_condition(evaluation_condition_dto=evaluation_condition_dto)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ConditionApi->evaluate_condition: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080/engine-rest*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConditionApi* | [**evaluate_condition**](docs/ConditionApi.md#evaluate_condition) | **POST** /condition | 
*DeploymentApi* | [**create_deployment**](docs/DeploymentApi.md#create_deployment) | **POST** /deployment/create | 
*DeploymentApi* | [**delete_deployment**](docs/DeploymentApi.md#delete_deployment) | **DELETE** /deployment/{id} | 
*DeploymentApi* | [**get_deployment**](docs/DeploymentApi.md#get_deployment) | **GET** /deployment/{id} | 
*DeploymentApi* | [**get_deployment_resource**](docs/DeploymentApi.md#get_deployment_resource) | **GET** /deployment/{id}/resources/{resourceId} | 
*DeploymentApi* | [**get_deployment_resource_data**](docs/DeploymentApi.md#get_deployment_resource_data) | **GET** /deployment/{id}/resources/{resourceId}/data | 
*DeploymentApi* | [**get_deployment_resources**](docs/DeploymentApi.md#get_deployment_resources) | **GET** /deployment/{id}/resources | 
*DeploymentApi* | [**get_deployments**](docs/DeploymentApi.md#get_deployments) | **GET** /deployment | 
*DeploymentApi* | [**get_deployments_count**](docs/DeploymentApi.md#get_deployments_count) | **GET** /deployment/count | 
*DeploymentApi* | [**redeploy**](docs/DeploymentApi.md#redeploy) | **POST** /deployment/{id}/redeploy | 
*EngineApi* | [**get_process_engine_names**](docs/EngineApi.md#get_process_engine_names) | **GET** /engine | 
*EventSubscriptionApi* | [**get_event_subscriptions**](docs/EventSubscriptionApi.md#get_event_subscriptions) | **GET** /event-subscription | 
*EventSubscriptionApi* | [**get_event_subscriptions_count**](docs/EventSubscriptionApi.md#get_event_subscriptions_count) | **GET** /event-subscription/count | 
*ExternalTaskApi* | [**complete_external_task_resource**](docs/ExternalTaskApi.md#complete_external_task_resource) | **POST** /external-task/{id}/complete | 
*ExternalTaskApi* | [**extend_lock**](docs/ExternalTaskApi.md#extend_lock) | **POST** /external-task/{id}/extendLock | 
*ExternalTaskApi* | [**fetch_and_lock**](docs/ExternalTaskApi.md#fetch_and_lock) | **POST** /external-task/fetchAndLock | 
*ExternalTaskApi* | [**get_external_task**](docs/ExternalTaskApi.md#get_external_task) | **GET** /external-task/{id} | 
*ExternalTaskApi* | [**get_external_task_error_details**](docs/ExternalTaskApi.md#get_external_task_error_details) | **GET** /external-task/{id}/errorDetails | 
*ExternalTaskApi* | [**get_external_tasks**](docs/ExternalTaskApi.md#get_external_tasks) | **GET** /external-task | 
*ExternalTaskApi* | [**get_external_tasks_count**](docs/ExternalTaskApi.md#get_external_tasks_count) | **GET** /external-task/count | 
*ExternalTaskApi* | [**get_topic_names**](docs/ExternalTaskApi.md#get_topic_names) | **GET** /external-task/topic-names | 
*ExternalTaskApi* | [**handle_external_task_bpmn_error**](docs/ExternalTaskApi.md#handle_external_task_bpmn_error) | **POST** /external-task/{id}/bpmnError | 
*ExternalTaskApi* | [**handle_failure**](docs/ExternalTaskApi.md#handle_failure) | **POST** /external-task/{id}/failure | 
*ExternalTaskApi* | [**query_external_tasks**](docs/ExternalTaskApi.md#query_external_tasks) | **POST** /external-task | 
*ExternalTaskApi* | [**query_external_tasks_count**](docs/ExternalTaskApi.md#query_external_tasks_count) | **POST** /external-task/count | 
*ExternalTaskApi* | [**set_external_task_resource_priority**](docs/ExternalTaskApi.md#set_external_task_resource_priority) | **PUT** /external-task/{id}/priority | 
*ExternalTaskApi* | [**set_external_task_resource_retries**](docs/ExternalTaskApi.md#set_external_task_resource_retries) | **PUT** /external-task/{id}/retries | 
*ExternalTaskApi* | [**set_external_task_retries**](docs/ExternalTaskApi.md#set_external_task_retries) | **PUT** /external-task/retries | 
*ExternalTaskApi* | [**set_external_task_retries_async_operation**](docs/ExternalTaskApi.md#set_external_task_retries_async_operation) | **POST** /external-task/retries-async | 
*ExternalTaskApi* | [**unlock**](docs/ExternalTaskApi.md#unlock) | **POST** /external-task/{id}/unlock | 
*HistoricActivityInstanceApi* | [**get_historic_activity_instance**](docs/HistoricActivityInstanceApi.md#get_historic_activity_instance) | **GET** /history/activity-instance/{id} | Get
*HistoricActivityInstanceApi* | [**get_historic_activity_instances**](docs/HistoricActivityInstanceApi.md#get_historic_activity_instances) | **GET** /history/activity-instance | Get List
*HistoricActivityInstanceApi* | [**get_historic_activity_instances_count**](docs/HistoricActivityInstanceApi.md#get_historic_activity_instances_count) | **GET** /history/activity-instance/count | Get List Count
*HistoricActivityInstanceApi* | [**query_historic_activity_instances**](docs/HistoricActivityInstanceApi.md#query_historic_activity_instances) | **POST** /history/activity-instance | Get List (POST)
*HistoricActivityInstanceApi* | [**query_historic_activity_instances_count**](docs/HistoricActivityInstanceApi.md#query_historic_activity_instances_count) | **POST** /history/activity-instance/count | Get List Count (POST)
*HistoricProcessInstanceApi* | [**delete_historic_process_instance**](docs/HistoricProcessInstanceApi.md#delete_historic_process_instance) | **DELETE** /history/process-instance/{id} | Delete
*HistoricProcessInstanceApi* | [**delete_historic_process_instances_async**](docs/HistoricProcessInstanceApi.md#delete_historic_process_instances_async) | **POST** /history/process-instance/delete | Delete Async (POST)
*HistoricProcessInstanceApi* | [**delete_historic_variable_instances_of_historic_process_instance**](docs/HistoricProcessInstanceApi.md#delete_historic_variable_instances_of_historic_process_instance) | **DELETE** /history/process-instance/{id}/variable-instances | Delete Variable Instances
*HistoricProcessInstanceApi* | [**get_historic_process_instance**](docs/HistoricProcessInstanceApi.md#get_historic_process_instance) | **GET** /history/process-instance/{id} | Get
*HistoricProcessInstanceApi* | [**get_historic_process_instance_duration_report**](docs/HistoricProcessInstanceApi.md#get_historic_process_instance_duration_report) | **GET** /history/process-instance/report | Get Duration Report
*HistoricProcessInstanceApi* | [**get_historic_process_instances**](docs/HistoricProcessInstanceApi.md#get_historic_process_instances) | **GET** /history/process-instance | Get List
*HistoricProcessInstanceApi* | [**get_historic_process_instances_count**](docs/HistoricProcessInstanceApi.md#get_historic_process_instances_count) | **GET** /history/process-instance/count | Get List Count
*HistoricProcessInstanceApi* | [**query_historic_process_instances**](docs/HistoricProcessInstanceApi.md#query_historic_process_instances) | **POST** /history/process-instance | Get List (POST)
*HistoricProcessInstanceApi* | [**query_historic_process_instances_count**](docs/HistoricProcessInstanceApi.md#query_historic_process_instances_count) | **POST** /history/process-instance/count | Get List Count (POST)
*HistoricProcessInstanceApi* | [**set_removal_time_async**](docs/HistoricProcessInstanceApi.md#set_removal_time_async) | **POST** /history/process-instance/set-removal-time | Set Removal Time Async (POST)
*IncidentApi* | [**get_incident**](docs/IncidentApi.md#get_incident) | **GET** /incident/{id} | Get Incident
*IncidentApi* | [**get_incidents**](docs/IncidentApi.md#get_incidents) | **GET** /incident | Get List
*IncidentApi* | [**get_incidents_count**](docs/IncidentApi.md#get_incidents_count) | **GET** /incident/count | Get List Count
*IncidentApi* | [**resolve_incident**](docs/IncidentApi.md#resolve_incident) | **DELETE** /incident/{id} | Resolve Incident
*MessageApi* | [**deliver_message**](docs/MessageApi.md#deliver_message) | **POST** /message | 
*MetricsApi* | [**get_metrics**](docs/MetricsApi.md#get_metrics) | **GET** /metrics/{metrics-name}/sum | 
*MetricsApi* | [**interval**](docs/MetricsApi.md#interval) | **GET** /metrics | 
*ProcessDefinitionApi* | [**delete_process_definition**](docs/ProcessDefinitionApi.md#delete_process_definition) | **DELETE** /process-definition/{id} | Delete
*ProcessDefinitionApi* | [**delete_process_definitions_by_key**](docs/ProcessDefinitionApi.md#delete_process_definitions_by_key) | **DELETE** /process-definition/key/{key} | Delete By Key
*ProcessDefinitionApi* | [**delete_process_definitions_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#delete_process_definitions_by_key_and_tenant_id) | **DELETE** /process-definition/key/{key}/tenant-id/{tenant-id} | Delete By Key
*ProcessDefinitionApi* | [**get_activity_statistics**](docs/ProcessDefinitionApi.md#get_activity_statistics) | **GET** /process-definition/{id}/statistics | Get Activity Instance Statistics
*ProcessDefinitionApi* | [**get_activity_statistics_by_process_definition_key**](docs/ProcessDefinitionApi.md#get_activity_statistics_by_process_definition_key) | **GET** /process-definition/key/{key}/statistics | Get Activity Instance Statistics
*ProcessDefinitionApi* | [**get_activity_statistics_by_process_definition_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_activity_statistics_by_process_definition_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/statistics | Get Activity Instance Statistics
*ProcessDefinitionApi* | [**get_deployed_start_form**](docs/ProcessDefinitionApi.md#get_deployed_start_form) | **GET** /process-definition/{id}/deployed-start-form | Get Deployed Start Form
*ProcessDefinitionApi* | [**get_deployed_start_form_by_key**](docs/ProcessDefinitionApi.md#get_deployed_start_form_by_key) | **GET** /process-definition/key/{key}/deployed-start-form | Get Deployed Start Form
*ProcessDefinitionApi* | [**get_deployed_start_form_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_deployed_start_form_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/deployed-start-form | Get Deployed Start Form
*ProcessDefinitionApi* | [**get_latest_process_definition_by_tenant_id**](docs/ProcessDefinitionApi.md#get_latest_process_definition_by_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id} | Get
*ProcessDefinitionApi* | [**get_process_definition**](docs/ProcessDefinitionApi.md#get_process_definition) | **GET** /process-definition/{id} | Get
*ProcessDefinitionApi* | [**get_process_definition_bpmn20_xml**](docs/ProcessDefinitionApi.md#get_process_definition_bpmn20_xml) | **GET** /process-definition/{id}/xml | Get XML
*ProcessDefinitionApi* | [**get_process_definition_bpmn20_xml_by_key**](docs/ProcessDefinitionApi.md#get_process_definition_bpmn20_xml_by_key) | **GET** /process-definition/key/{key}/xml | Get XML
*ProcessDefinitionApi* | [**get_process_definition_bpmn20_xml_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_process_definition_bpmn20_xml_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/xml | Get XML
*ProcessDefinitionApi* | [**get_process_definition_by_key**](docs/ProcessDefinitionApi.md#get_process_definition_by_key) | **GET** /process-definition/key/{key} | Get
*ProcessDefinitionApi* | [**get_process_definition_diagram**](docs/ProcessDefinitionApi.md#get_process_definition_diagram) | **GET** /process-definition/{id}/diagram | Get Diagram
*ProcessDefinitionApi* | [**get_process_definition_diagram_by_key**](docs/ProcessDefinitionApi.md#get_process_definition_diagram_by_key) | **GET** /process-definition/key/{key}/diagram | Get Diagram
*ProcessDefinitionApi* | [**get_process_definition_diagram_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_process_definition_diagram_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/diagram | Get Diagram
*ProcessDefinitionApi* | [**get_process_definition_statistics**](docs/ProcessDefinitionApi.md#get_process_definition_statistics) | **GET** /process-definition/statistics | Get Process Instance Statistics
*ProcessDefinitionApi* | [**get_process_definitions**](docs/ProcessDefinitionApi.md#get_process_definitions) | **GET** /process-definition | Get List
*ProcessDefinitionApi* | [**get_process_definitions_count**](docs/ProcessDefinitionApi.md#get_process_definitions_count) | **GET** /process-definition/count | Get List Count
*ProcessDefinitionApi* | [**get_rendered_start_form**](docs/ProcessDefinitionApi.md#get_rendered_start_form) | **GET** /process-definition/{id}/rendered-form | Get Rendered Start Form
*ProcessDefinitionApi* | [**get_rendered_start_form_by_key**](docs/ProcessDefinitionApi.md#get_rendered_start_form_by_key) | **GET** /process-definition/key/{key}/rendered-form | Get Rendered Start Form
*ProcessDefinitionApi* | [**get_rendered_start_form_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_rendered_start_form_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/rendered-form | Get Rendered Start Form
*ProcessDefinitionApi* | [**get_start_form**](docs/ProcessDefinitionApi.md#get_start_form) | **GET** /process-definition/{id}/startForm | Get Start Form Key
*ProcessDefinitionApi* | [**get_start_form_by_key**](docs/ProcessDefinitionApi.md#get_start_form_by_key) | **GET** /process-definition/key/{key}/startForm | Get Start Form Key
*ProcessDefinitionApi* | [**get_start_form_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_start_form_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/startForm | Get Start Form Key
*ProcessDefinitionApi* | [**get_start_form_variables**](docs/ProcessDefinitionApi.md#get_start_form_variables) | **GET** /process-definition/{id}/form-variables | Get Start Form Variables
*ProcessDefinitionApi* | [**get_start_form_variables_by_key**](docs/ProcessDefinitionApi.md#get_start_form_variables_by_key) | **GET** /process-definition/key/{key}/form-variables | Get Start Form Variables
*ProcessDefinitionApi* | [**get_start_form_variables_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_start_form_variables_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/form-variables | Get Start Form Variables
*ProcessDefinitionApi* | [**restart_process_instance**](docs/ProcessDefinitionApi.md#restart_process_instance) | **POST** /process-definition/{id}/restart | Restart Process Instance
*ProcessDefinitionApi* | [**restart_process_instance_async_operation**](docs/ProcessDefinitionApi.md#restart_process_instance_async_operation) | **POST** /process-definition/{id}/restart-async | Restart Process Instance Async
*ProcessDefinitionApi* | [**start_process_instance**](docs/ProcessDefinitionApi.md#start_process_instance) | **POST** /process-definition/{id}/start | Start Instance
*ProcessDefinitionApi* | [**start_process_instance_by_key**](docs/ProcessDefinitionApi.md#start_process_instance_by_key) | **POST** /process-definition/key/{key}/start | Start Instance
*ProcessDefinitionApi* | [**start_process_instance_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#start_process_instance_by_key_and_tenant_id) | **POST** /process-definition/key/{key}/tenant-id/{tenant-id}/start | Start Instance
*ProcessDefinitionApi* | [**submit_form**](docs/ProcessDefinitionApi.md#submit_form) | **POST** /process-definition/{id}/submit-form | Submit Start Form
*ProcessDefinitionApi* | [**submit_form_by_key**](docs/ProcessDefinitionApi.md#submit_form_by_key) | **POST** /process-definition/key/{key}/submit-form | Submit Start Form
*ProcessDefinitionApi* | [**submit_form_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#submit_form_by_key_and_tenant_id) | **POST** /process-definition/key/{key}/tenant-id/{tenant-id}/submit-form | Submit Start Form
*ProcessDefinitionApi* | [**update_history_time_to_live_by_process_definition_id**](docs/ProcessDefinitionApi.md#update_history_time_to_live_by_process_definition_id) | **PUT** /process-definition/{id}/history-time-to-live | Update History Time to Live
*ProcessDefinitionApi* | [**update_history_time_to_live_by_process_definition_key**](docs/ProcessDefinitionApi.md#update_history_time_to_live_by_process_definition_key) | **PUT** /process-definition/key/{key}/history-time-to-live | Update History Time to Live
*ProcessDefinitionApi* | [**update_history_time_to_live_by_process_definition_key_and_tenant_id**](docs/ProcessDefinitionApi.md#update_history_time_to_live_by_process_definition_key_and_tenant_id) | **PUT** /process-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live | Update History Time to Live
*ProcessDefinitionApi* | [**update_process_definition_suspension_state**](docs/ProcessDefinitionApi.md#update_process_definition_suspension_state) | **PUT** /process-definition/suspended | Activate/Suspend By Key
*ProcessDefinitionApi* | [**update_process_definition_suspension_state_by_id**](docs/ProcessDefinitionApi.md#update_process_definition_suspension_state_by_id) | **PUT** /process-definition/{id}/suspended | Activate/Suspend By Id
*ProcessDefinitionApi* | [**update_process_definition_suspension_state_by_key**](docs/ProcessDefinitionApi.md#update_process_definition_suspension_state_by_key) | **PUT** /process-definition/key/{key}/suspended | Activate/Suspend by Id
*ProcessDefinitionApi* | [**update_process_definition_suspension_state_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#update_process_definition_suspension_state_by_key_and_tenant_id) | **PUT** /process-definition/key/{key}/tenant-id/{tenant-id}/suspended | Activate/Suspend by Id
*ProcessInstanceApi* | [**delete_async_historic_query_based**](docs/ProcessInstanceApi.md#delete_async_historic_query_based) | **POST** /process-instance/delete-historic-query-based | 
*ProcessInstanceApi* | [**delete_process_instance**](docs/ProcessInstanceApi.md#delete_process_instance) | **DELETE** /process-instance/{id} | 
*ProcessInstanceApi* | [**delete_process_instance_variable**](docs/ProcessInstanceApi.md#delete_process_instance_variable) | **DELETE** /process-instance/{id}/variables/{varName} | 
*ProcessInstanceApi* | [**delete_process_instances_async_operation**](docs/ProcessInstanceApi.md#delete_process_instances_async_operation) | **POST** /process-instance/delete | 
*ProcessInstanceApi* | [**get_activity_instance_tree**](docs/ProcessInstanceApi.md#get_activity_instance_tree) | **GET** /process-instance/{id}/activity-instances | 
*ProcessInstanceApi* | [**get_process_instance**](docs/ProcessInstanceApi.md#get_process_instance) | **GET** /process-instance/{id} | Get Process Instance
*ProcessInstanceApi* | [**get_process_instance_variable**](docs/ProcessInstanceApi.md#get_process_instance_variable) | **GET** /process-instance/{id}/variables/{varName} | 
*ProcessInstanceApi* | [**get_process_instance_variable_binary**](docs/ProcessInstanceApi.md#get_process_instance_variable_binary) | **GET** /process-instance/{id}/variables/{varName}/data | 
*ProcessInstanceApi* | [**get_process_instance_variables**](docs/ProcessInstanceApi.md#get_process_instance_variables) | **GET** /process-instance/{id}/variables | 
*ProcessInstanceApi* | [**get_process_instances**](docs/ProcessInstanceApi.md#get_process_instances) | **GET** /process-instance | 
*ProcessInstanceApi* | [**get_process_instances_count**](docs/ProcessInstanceApi.md#get_process_instances_count) | **GET** /process-instance/count | 
*ProcessInstanceApi* | [**modify_process_instance**](docs/ProcessInstanceApi.md#modify_process_instance) | **POST** /process-instance/{id}/modification | 
*ProcessInstanceApi* | [**modify_process_instance_async_operation**](docs/ProcessInstanceApi.md#modify_process_instance_async_operation) | **POST** /process-instance/{id}/modification-async | 
*ProcessInstanceApi* | [**modify_process_instance_variables**](docs/ProcessInstanceApi.md#modify_process_instance_variables) | **POST** /process-instance/{id}/variables | 
*ProcessInstanceApi* | [**query_process_instances**](docs/ProcessInstanceApi.md#query_process_instances) | **POST** /process-instance | 
*ProcessInstanceApi* | [**query_process_instances_count**](docs/ProcessInstanceApi.md#query_process_instances_count) | **POST** /process-instance/count | 
*ProcessInstanceApi* | [**set_process_instance_variable**](docs/ProcessInstanceApi.md#set_process_instance_variable) | **PUT** /process-instance/{id}/variables/{varName} | 
*ProcessInstanceApi* | [**set_process_instance_variable_binary**](docs/ProcessInstanceApi.md#set_process_instance_variable_binary) | **POST** /process-instance/{id}/variables/{varName}/data | 
*ProcessInstanceApi* | [**set_retries_by_process**](docs/ProcessInstanceApi.md#set_retries_by_process) | **POST** /process-instance/job-retries | 
*ProcessInstanceApi* | [**set_retries_by_process_historic_query_based**](docs/ProcessInstanceApi.md#set_retries_by_process_historic_query_based) | **POST** /process-instance/job-retries-historic-query-based | 
*ProcessInstanceApi* | [**set_variables_async_operation**](docs/ProcessInstanceApi.md#set_variables_async_operation) | **POST** /process-instance/variables-async | 
*ProcessInstanceApi* | [**update_suspension_state**](docs/ProcessInstanceApi.md#update_suspension_state) | **PUT** /process-instance/suspended | 
*ProcessInstanceApi* | [**update_suspension_state_async_operation**](docs/ProcessInstanceApi.md#update_suspension_state_async_operation) | **POST** /process-instance/suspended-async | 
*ProcessInstanceApi* | [**update_suspension_state_by_id**](docs/ProcessInstanceApi.md#update_suspension_state_by_id) | **PUT** /process-instance/{id}/suspended | 
*SchemaLogApi* | [**get_schema_log**](docs/SchemaLogApi.md#get_schema_log) | **GET** /schema/log | 
*SchemaLogApi* | [**query_schema_log**](docs/SchemaLogApi.md#query_schema_log) | **POST** /schema/log | 
*SignalApi* | [**throw_signal**](docs/SignalApi.md#throw_signal) | **POST** /signal | 
*TaskApi* | [**claim**](docs/TaskApi.md#claim) | **POST** /task/{id}/claim | 
*TaskApi* | [**complete**](docs/TaskApi.md#complete) | **POST** /task/{id}/complete | 
*TaskApi* | [**create_task**](docs/TaskApi.md#create_task) | **POST** /task/create | 
*TaskApi* | [**delegate_task**](docs/TaskApi.md#delegate_task) | **POST** /task/{id}/delegate | 
*TaskApi* | [**delete_task**](docs/TaskApi.md#delete_task) | **DELETE** /task/{id} | 
*TaskApi* | [**get_deployed_form**](docs/TaskApi.md#get_deployed_form) | **GET** /task/{id}/deployed-form | 
*TaskApi* | [**get_form**](docs/TaskApi.md#get_form) | **GET** /task/{id}/form | 
*TaskApi* | [**get_form_variables**](docs/TaskApi.md#get_form_variables) | **GET** /task/{id}/form-variables | 
*TaskApi* | [**get_rendered_form**](docs/TaskApi.md#get_rendered_form) | **GET** /task/{id}/rendered-form | 
*TaskApi* | [**get_task**](docs/TaskApi.md#get_task) | **GET** /task/{id} | 
*TaskApi* | [**get_tasks**](docs/TaskApi.md#get_tasks) | **GET** /task | 
*TaskApi* | [**get_tasks_count**](docs/TaskApi.md#get_tasks_count) | **GET** /task/count | 
*TaskApi* | [**handle_bpmn_error**](docs/TaskApi.md#handle_bpmn_error) | **POST** /task/{id}/bpmnError | 
*TaskApi* | [**handle_escalation**](docs/TaskApi.md#handle_escalation) | **POST** /task/{id}/bpmnEscalation | 
*TaskApi* | [**query_tasks**](docs/TaskApi.md#query_tasks) | **POST** /task | 
*TaskApi* | [**query_tasks_count**](docs/TaskApi.md#query_tasks_count) | **POST** /task/count | 
*TaskApi* | [**resolve**](docs/TaskApi.md#resolve) | **POST** /task/{id}/resolve | 
*TaskApi* | [**set_assignee**](docs/TaskApi.md#set_assignee) | **POST** /task/{id}/assignee | 
*TaskApi* | [**submit**](docs/TaskApi.md#submit) | **POST** /task/{id}/submit-form | 
*TaskApi* | [**unclaim**](docs/TaskApi.md#unclaim) | **POST** /task/{id}/unclaim | 
*TaskApi* | [**update_task**](docs/TaskApi.md#update_task) | **PUT** /task/{id} | 
*TaskAttachmentApi* | [**add_attachment**](docs/TaskAttachmentApi.md#add_attachment) | **POST** /task/{id}/attachment/create | 
*TaskAttachmentApi* | [**delete_attachment**](docs/TaskAttachmentApi.md#delete_attachment) | **DELETE** /task/{id}/attachment/{attachmentId} | 
*TaskAttachmentApi* | [**get_attachment**](docs/TaskAttachmentApi.md#get_attachment) | **GET** /task/{id}/attachment/{attachmentId} | 
*TaskAttachmentApi* | [**get_attachment_data**](docs/TaskAttachmentApi.md#get_attachment_data) | **GET** /task/{id}/attachment/{attachmentId}/data | 
*TaskAttachmentApi* | [**get_attachments**](docs/TaskAttachmentApi.md#get_attachments) | **GET** /task/{id}/attachment | 
*TaskCommentApi* | [**create_comment**](docs/TaskCommentApi.md#create_comment) | **POST** /task/{id}/comment/create | 
*TaskCommentApi* | [**get_comment**](docs/TaskCommentApi.md#get_comment) | **GET** /task/{id}/comment/{commentId} | 
*TaskCommentApi* | [**get_comments**](docs/TaskCommentApi.md#get_comments) | **GET** /task/{id}/comment | 
*TaskIdentityLinkApi* | [**add_identity_link**](docs/TaskIdentityLinkApi.md#add_identity_link) | **POST** /task/{id}/identity-links | 
*TaskIdentityLinkApi* | [**delete_identity_link**](docs/TaskIdentityLinkApi.md#delete_identity_link) | **POST** /task/{id}/identity-links/delete | 
*TaskIdentityLinkApi* | [**get_identity_links**](docs/TaskIdentityLinkApi.md#get_identity_links) | **GET** /task/{id}/identity-links | 
*TaskLocalVariableApi* | [**delete_task_local_variable**](docs/TaskLocalVariableApi.md#delete_task_local_variable) | **DELETE** /task/{id}/localVariables/{varName} | 
*TaskLocalVariableApi* | [**get_task_local_variable**](docs/TaskLocalVariableApi.md#get_task_local_variable) | **GET** /task/{id}/localVariables/{varName} | 
*TaskLocalVariableApi* | [**get_task_local_variable_binary**](docs/TaskLocalVariableApi.md#get_task_local_variable_binary) | **GET** /task/{id}/localVariables/{varName}/data | 
*TaskLocalVariableApi* | [**get_task_local_variables**](docs/TaskLocalVariableApi.md#get_task_local_variables) | **GET** /task/{id}/localVariables | 
*TaskLocalVariableApi* | [**modify_task_local_variables**](docs/TaskLocalVariableApi.md#modify_task_local_variables) | **POST** /task/{id}/localVariables | 
*TaskLocalVariableApi* | [**put_task_local_variable**](docs/TaskLocalVariableApi.md#put_task_local_variable) | **PUT** /task/{id}/localVariables/{varName} | 
*TaskLocalVariableApi* | [**set_binary_task_local_variable**](docs/TaskLocalVariableApi.md#set_binary_task_local_variable) | **POST** /task/{id}/localVariables/{varName}/data | 
*TaskVariableApi* | [**delete_task_variable**](docs/TaskVariableApi.md#delete_task_variable) | **DELETE** /task/{id}/variables/{varName} | 
*TaskVariableApi* | [**get_task_variable**](docs/TaskVariableApi.md#get_task_variable) | **GET** /task/{id}/variables/{varName} | 
*TaskVariableApi* | [**get_task_variable_binary**](docs/TaskVariableApi.md#get_task_variable_binary) | **GET** /task/{id}/variables/{varName}/data | 
*TaskVariableApi* | [**get_task_variables**](docs/TaskVariableApi.md#get_task_variables) | **GET** /task/{id}/variables | 
*TaskVariableApi* | [**modify_task_variables**](docs/TaskVariableApi.md#modify_task_variables) | **POST** /task/{id}/variables | 
*TaskVariableApi* | [**put_task_variable**](docs/TaskVariableApi.md#put_task_variable) | **PUT** /task/{id}/variables/{varName} | 
*TaskVariableApi* | [**set_binary_task_variable**](docs/TaskVariableApi.md#set_binary_task_variable) | **POST** /task/{id}/variables/{varName}/data | 
*TelemetryApi* | [**configure_telemetry**](docs/TelemetryApi.md#configure_telemetry) | **POST** /telemetry/configuration | Configure Telemetry
*TelemetryApi* | [**get_telemetry_configuration**](docs/TelemetryApi.md#get_telemetry_configuration) | **GET** /telemetry/configuration | Fetch Telemetry Configuration
*UserApi* | [**available_operations**](docs/UserApi.md#available_operations) | **OPTIONS** /user | Options
*UserApi* | [**available_user_operations**](docs/UserApi.md#available_user_operations) | **OPTIONS** /user/{id} | Options
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /user/create | Create
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/{id} | Delete
*UserApi* | [**get_user_count**](docs/UserApi.md#get_user_count) | **GET** /user/count | Get List Count
*UserApi* | [**get_user_profile**](docs/UserApi.md#get_user_profile) | **GET** /user/{id}/profile | Get Profile
*UserApi* | [**get_users**](docs/UserApi.md#get_users) | **GET** /user | Get List
*UserApi* | [**unlock_user**](docs/UserApi.md#unlock_user) | **POST** /user/{id}/unlock | Unlock User
*UserApi* | [**update_credentials**](docs/UserApi.md#update_credentials) | **PUT** /user/{id}/credentials | Update Credentials
*VersionApi* | [**get_rest_api_version**](docs/VersionApi.md#get_rest_api_version) | **GET** /version | 


## Documentation For Models

 - [AbstractSetRemovalTimeDto](docs/AbstractSetRemovalTimeDto.md)
 - [ActivityInstanceDto](docs/ActivityInstanceDto.md)
 - [ActivityInstanceIncidentDto](docs/ActivityInstanceIncidentDto.md)
 - [ActivityStatisticsResultDto](docs/ActivityStatisticsResultDto.md)
 - [AtomLink](docs/AtomLink.md)
 - [AttachmentDto](docs/AttachmentDto.md)
 - [AttachmentDtoAllOf](docs/AttachmentDtoAllOf.md)
 - [AuthorizationExceptionDto](docs/AuthorizationExceptionDto.md)
 - [AuthorizationExceptionDtoAllOf](docs/AuthorizationExceptionDtoAllOf.md)
 - [BatchDto](docs/BatchDto.md)
 - [CaseDefinitionDto](docs/CaseDefinitionDto.md)
 - [CommentDto](docs/CommentDto.md)
 - [CommentDtoAllOf](docs/CommentDtoAllOf.md)
 - [CompleteExternalTaskDto](docs/CompleteExternalTaskDto.md)
 - [CompleteTaskDto](docs/CompleteTaskDto.md)
 - [CorrelationMessageDto](docs/CorrelationMessageDto.md)
 - [CountResultDto](docs/CountResultDto.md)
 - [DecisionDefinitionDto](docs/DecisionDefinitionDto.md)
 - [DecisionRequirementsDefinitionDto](docs/DecisionRequirementsDefinitionDto.md)
 - [DeleteHistoricProcessInstancesDto](docs/DeleteHistoricProcessInstancesDto.md)
 - [DeleteProcessInstancesDto](docs/DeleteProcessInstancesDto.md)
 - [DeploymentDto](docs/DeploymentDto.md)
 - [DeploymentDtoAllOf](docs/DeploymentDtoAllOf.md)
 - [DeploymentResourceDto](docs/DeploymentResourceDto.md)
 - [DeploymentWithDefinitionsDto](docs/DeploymentWithDefinitionsDto.md)
 - [DeploymentWithDefinitionsDtoAllOf](docs/DeploymentWithDefinitionsDtoAllOf.md)
 - [DurationReportResultDto](docs/DurationReportResultDto.md)
 - [EvaluationConditionDto](docs/EvaluationConditionDto.md)
 - [EventSubscriptionDto](docs/EventSubscriptionDto.md)
 - [EventSubscriptionQueryDto](docs/EventSubscriptionQueryDto.md)
 - [EventSubscriptionQueryDtoSorting](docs/EventSubscriptionQueryDtoSorting.md)
 - [ExceptionDto](docs/ExceptionDto.md)
 - [ExecutionDto](docs/ExecutionDto.md)
 - [ExtendLockOnExternalTaskDto](docs/ExtendLockOnExternalTaskDto.md)
 - [ExternalTaskBpmnError](docs/ExternalTaskBpmnError.md)
 - [ExternalTaskBpmnErrorAllOf](docs/ExternalTaskBpmnErrorAllOf.md)
 - [ExternalTaskDto](docs/ExternalTaskDto.md)
 - [ExternalTaskFailureDto](docs/ExternalTaskFailureDto.md)
 - [ExternalTaskQueryDto](docs/ExternalTaskQueryDto.md)
 - [ExternalTaskQueryDtoSorting](docs/ExternalTaskQueryDtoSorting.md)
 - [FetchExternalTaskTopicDto](docs/FetchExternalTaskTopicDto.md)
 - [FetchExternalTasksDto](docs/FetchExternalTasksDto.md)
 - [FormDto](docs/FormDto.md)
 - [HistoricActivityInstanceDto](docs/HistoricActivityInstanceDto.md)
 - [HistoricActivityInstanceQueryDto](docs/HistoricActivityInstanceQueryDto.md)
 - [HistoricActivityInstanceQueryDtoSorting](docs/HistoricActivityInstanceQueryDtoSorting.md)
 - [HistoricProcessInstanceDto](docs/HistoricProcessInstanceDto.md)
 - [HistoricProcessInstanceQueryDto](docs/HistoricProcessInstanceQueryDto.md)
 - [HistoricProcessInstanceQueryDtoSorting](docs/HistoricProcessInstanceQueryDtoSorting.md)
 - [HistoryTimeToLiveDto](docs/HistoryTimeToLiveDto.md)
 - [IdentityLinkDto](docs/IdentityLinkDto.md)
 - [IncidentDto](docs/IncidentDto.md)
 - [IncidentStatisticsResultDto](docs/IncidentStatisticsResultDto.md)
 - [LinkableDto](docs/LinkableDto.md)
 - [LockedExternalTaskDto](docs/LockedExternalTaskDto.md)
 - [MessageCorrelationResultWithVariableDto](docs/MessageCorrelationResultWithVariableDto.md)
 - [MetricsIntervalResultDto](docs/MetricsIntervalResultDto.md)
 - [MetricsResultDto](docs/MetricsResultDto.md)
 - [MissingAuthorizationDto](docs/MissingAuthorizationDto.md)
 - [MultiFormAttachmentDto](docs/MultiFormAttachmentDto.md)
 - [MultiFormDeploymentDto](docs/MultiFormDeploymentDto.md)
 - [MultiFormVariableBinaryDto](docs/MultiFormVariableBinaryDto.md)
 - [ParseExceptionDto](docs/ParseExceptionDto.md)
 - [ParseExceptionDtoAllOf](docs/ParseExceptionDtoAllOf.md)
 - [PatchVariablesDto](docs/PatchVariablesDto.md)
 - [PriorityDto](docs/PriorityDto.md)
 - [ProblemDto](docs/ProblemDto.md)
 - [ProcessDefinitionDiagramDto](docs/ProcessDefinitionDiagramDto.md)
 - [ProcessDefinitionDto](docs/ProcessDefinitionDto.md)
 - [ProcessDefinitionStatisticsResultDto](docs/ProcessDefinitionStatisticsResultDto.md)
 - [ProcessDefinitionSuspensionStateDto](docs/ProcessDefinitionSuspensionStateDto.md)
 - [ProcessEngineDto](docs/ProcessEngineDto.md)
 - [ProcessInstanceDto](docs/ProcessInstanceDto.md)
 - [ProcessInstanceDtoAllOf](docs/ProcessInstanceDtoAllOf.md)
 - [ProcessInstanceModificationDto](docs/ProcessInstanceModificationDto.md)
 - [ProcessInstanceModificationInstructionDto](docs/ProcessInstanceModificationInstructionDto.md)
 - [ProcessInstanceQueryDto](docs/ProcessInstanceQueryDto.md)
 - [ProcessInstanceQueryDtoSorting](docs/ProcessInstanceQueryDtoSorting.md)
 - [ProcessInstanceSuspensionStateAsyncDto](docs/ProcessInstanceSuspensionStateAsyncDto.md)
 - [ProcessInstanceSuspensionStateDto](docs/ProcessInstanceSuspensionStateDto.md)
 - [ProcessInstanceWithVariablesDto](docs/ProcessInstanceWithVariablesDto.md)
 - [ProcessInstanceWithVariablesDtoAllOf](docs/ProcessInstanceWithVariablesDtoAllOf.md)
 - [RedeploymentDto](docs/RedeploymentDto.md)
 - [ResourceOptionsDto](docs/ResourceOptionsDto.md)
 - [ResourceReportDto](docs/ResourceReportDto.md)
 - [RestartProcessInstanceDto](docs/RestartProcessInstanceDto.md)
 - [RestartProcessInstanceModificationInstructionDto](docs/RestartProcessInstanceModificationInstructionDto.md)
 - [RetriesDto](docs/RetriesDto.md)
 - [SchemaLogEntryDto](docs/SchemaLogEntryDto.md)
 - [SchemaLogQueryDto](docs/SchemaLogQueryDto.md)
 - [SchemaLogQueryDtoSorting](docs/SchemaLogQueryDtoSorting.md)
 - [SetJobRetriesByProcessDto](docs/SetJobRetriesByProcessDto.md)
 - [SetRemovalTimeToHistoricProcessInstancesDto](docs/SetRemovalTimeToHistoricProcessInstancesDto.md)
 - [SetRemovalTimeToHistoricProcessInstancesDtoAllOf](docs/SetRemovalTimeToHistoricProcessInstancesDtoAllOf.md)
 - [SetRetriesForExternalTasksDto](docs/SetRetriesForExternalTasksDto.md)
 - [SetVariablesAsyncDto](docs/SetVariablesAsyncDto.md)
 - [SignalDto](docs/SignalDto.md)
 - [SortTaskQueryParametersDto](docs/SortTaskQueryParametersDto.md)
 - [StartProcessInstanceDto](docs/StartProcessInstanceDto.md)
 - [StartProcessInstanceFormDto](docs/StartProcessInstanceFormDto.md)
 - [SuspensionStateDto](docs/SuspensionStateDto.md)
 - [TaskBpmnErrorDto](docs/TaskBpmnErrorDto.md)
 - [TaskDto](docs/TaskDto.md)
 - [TaskEscalationDto](docs/TaskEscalationDto.md)
 - [TaskQueryDto](docs/TaskQueryDto.md)
 - [TaskQueryDtoSorting](docs/TaskQueryDtoSorting.md)
 - [TelemetryConfigurationDto](docs/TelemetryConfigurationDto.md)
 - [TransitionInstanceDto](docs/TransitionInstanceDto.md)
 - [TriggerVariableValueDto](docs/TriggerVariableValueDto.md)
 - [TriggerVariableValueDtoAllOf](docs/TriggerVariableValueDtoAllOf.md)
 - [UserCredentialsDto](docs/UserCredentialsDto.md)
 - [UserDto](docs/UserDto.md)
 - [UserIdDto](docs/UserIdDto.md)
 - [UserProfileDto](docs/UserProfileDto.md)
 - [VariableQueryParameterDto](docs/VariableQueryParameterDto.md)
 - [VariableValueDto](docs/VariableValueDto.md)
 - [VersionDto](docs/VersionDto.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




