from tfads_o_builder.feature_types._Base import _Base


class CountryCode(_Base):
    country_codes = [
        "AA",
        "AC",
        "AD",
        "AE",
        "AF",
        "AG",
        "AJ",
        "AL",
        "AM",
        "AN",
        "AO",
        "AR",
        "AS",
        "AT",
        "AU",
        "AV",
        "AY",
        "BA",
        "BB",
        "BC",
        "BD",
        "BE",
        "BF",
        "BG",
        "BH",
        "BK",
        "BL",
        "BO",
        "BQ",
        "BR",
        "BS",
        "BT",
        "BU",
        "BV",
        "BW",
        "BY",
        "BZ",
        "CA",
        "CB",
        "CE",
        "CF",
        "CG",
        "CH",
        "CI",
        "CK",
        "CL",
        "CM",
        "CN",
        "CO",
        "CR",
        "CS",
        "CT",
        "CU",
        "CV",
        "CW",
        "CX",
        "CY",
        "CZ",
        "DA",
        "DJ",
        "DK",
        "DM",
        "DO",
        "DZ",
        "EC",
        "EE",
        "EG",
        "EH",
        "EN",
        "ER",
        "ES",
        "ET",
        "EU",
        "EZ",
        "FI",
        "FJ",
        "FK",
        "FM",
        "FO",
        "FP",
        "FR",
        "FS",
        "GA",
        "GB",
        "GG",
        "GH",
        "GI",
        "GJ",
        "GL",
        "GM",
        "GO",
        "GP",
        "GQ",
        "GR",
        "GT",
        "GU",
        "GW",
        "GY",
        "HK",
        "HM",
        "HN",
        "HR",
        "HT",
        "HU",
        "ID",
        "IE",
        "IL",
        "IM",
        "IN",
        "IO",
        "IP",
        "IQ",
        "IR",
        "IS",
        "IT",
        "IV",
        "IZ",
        "JA",
        "JE",
        "JM",
        "JO",
        "JQ",
        "JS",
        "KE",
        "KG",
        "KH",
        "KI",
        "KM",
        "KN",
        "KP",
        "KR",
        "KV",
        "KW",
        "KY",
        "KZ",
        "LA",
        "LB",
        "LC",
        "LE",
        "LI",
        "LK",
        "LR",
        "LS",
        "LT",
        "LU",
        "LV",
        "LY",
        "MA",
        "MC",
        "MD",
        "ME",
        "MF",
        "MG",
        "MH",
        "MK",
        "ML",
        "MM",
        "MN",
        "MO",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MX",
        "MY",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "NZ",
        "OM",
        "PA",
        "PC",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QG",
        "QI",
        "QM",
        "QN",
        "QP",
        "QR",
        "QU",
        "QW",
        "QZ",
        "RE",
        "RI",
        "RO",
        "RP",
        "RQ",
        "RS",
        "RW",
        "SA",
        "SB",
        "SC",
        "SD",
        "SE",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SM",
        "SN",
        "SO",
        "SP",
        "SR",
        "SS",
        "ST",
        "SV",
        "SX",
        "SY",
        "SZ",
        "TC",
        "TD",
        "TE",
        "TF",
        "TG",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TN",
        "TO",
        "TP",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UC",
        "UG",
        "UK",
        "UP",
        "US",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VQ",
        "VR",
        "VT",
        "VU",
        "WA",
        "WF",
        "WI",
        "WQ",
        "WS",
        "WZ",
        "YM",
        "YU",
        "ZA",
        "ZI",
        "ZM",
        "ZR",
        "ZW",
    ]

    def __init__(self):
        super().__init__()
        self.field_name = "Country / Country Code"

    def validateValue(self):
        # If the value is not None then assert that it is in the country_codes list
        if self.value is not None:
            assert (
                self.value in self.country_codes
            ), f"The value {self.value} must be in the country codes list {self.country_codes}."
