import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/helpers-internal';
/**
 * Properties for defining a `CfnComputeEnvironment`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 */
export interface CfnComputeEnvironmentProps {
    /**
     * `AWS::Batch::ComputeEnvironment.Type`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
     */
    readonly type: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
     */
    readonly computeEnvironmentName?: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     */
    readonly computeResources?: CfnComputeEnvironment.ComputeResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
     */
    readonly serviceRole?: string;
    /**
     * `AWS::Batch::ComputeEnvironment.State`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
     */
    readonly state?: string;
    /**
     * `AWS::Batch::ComputeEnvironment.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Batch::ComputeEnvironment.UnmanagedvCpus`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-unmanagedvcpus
     */
    readonly unmanagedvCpus?: number;
}
/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`
 *
 *
 *
 * @cloudformationResource AWS::Batch::ComputeEnvironment
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 */
export declare class CfnComputeEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::ComputeEnvironment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnComputeEnvironment;
    /**
     *
     * @cloudformationAttribute ComputeEnvironmentArn
     */
    readonly attrComputeEnvironmentArn: string;
    /**
     * `AWS::Batch::ComputeEnvironment.Type`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
     */
    type: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
     */
    computeEnvironmentName: string | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     */
    computeResources: CfnComputeEnvironment.ComputeResourcesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
     */
    serviceRole: string | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.State`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
     */
    state: string | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Batch::ComputeEnvironment.UnmanagedvCpus`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-unmanagedvcpus
     */
    unmanagedvCpus: number | undefined;
    /**
     * Create a new `AWS::Batch::ComputeEnvironment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnComputeEnvironmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnComputeEnvironment {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html
     */
    interface ComputeResourcesProperty {
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.AllocationStrategy`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.BidPercentage`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage
         */
        readonly bidPercentage?: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.DesiredvCpus`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-desiredvcpus
         */
        readonly desiredvCpus?: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Ec2Configuration`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration
         */
        readonly ec2Configuration?: Array<CfnComputeEnvironment.Ec2ConfigurationObjectProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Ec2KeyPair`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair
         */
        readonly ec2KeyPair?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.ImageId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid
         */
        readonly imageId?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.InstanceRole`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole
         */
        readonly instanceRole?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.InstanceTypes`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes
         */
        readonly instanceTypes?: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.LaunchTemplate`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate
         */
        readonly launchTemplate?: CfnComputeEnvironment.LaunchTemplateSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.MaxvCpus`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus
         */
        readonly maxvCpus: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.MinvCpus`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus
         */
        readonly minvCpus?: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.PlacementGroup`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup
         */
        readonly placementGroup?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.SecurityGroupIds`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.SpotIamFleetRole`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-spotiamfleetrole
         */
        readonly spotIamFleetRole?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Subnets`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets
         */
        readonly subnets: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Tags`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags
         */
        readonly tags?: {
            [key: string]: (string);
        };
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Type`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type
         */
        readonly type: string;
    }
}
export declare namespace CfnComputeEnvironment {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-ec2configurationobject.html
     */
    interface Ec2ConfigurationObjectProperty {
        /**
         * `CfnComputeEnvironment.Ec2ConfigurationObjectProperty.ImageIdOverride`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-ec2configurationobject.html#cfn-batch-computeenvironment-ec2configurationobject-imageidoverride
         */
        readonly imageIdOverride?: string;
        /**
         * `CfnComputeEnvironment.Ec2ConfigurationObjectProperty.ImageType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-ec2configurationobject.html#cfn-batch-computeenvironment-ec2configurationobject-imagetype
         */
        readonly imageType: string;
    }
}
export declare namespace CfnComputeEnvironment {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.Version`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-version
         */
        readonly version?: string;
    }
}
/**
 * Properties for defining a `CfnJobDefinition`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export interface CfnJobDefinitionProps {
    /**
     * `AWS::Batch::JobDefinition.Type`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
     */
    readonly type: string;
    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     */
    readonly containerProperties?: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.JobDefinitionName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::Batch::JobDefinition.NodeProperties`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     */
    readonly nodeProperties?: CfnJobDefinition.NodePropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.Parameters`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
     */
    readonly parameters?: any | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.PlatformCapabilities`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-platformcapabilities
     */
    readonly platformCapabilities?: string[];
    /**
     * `AWS::Batch::JobDefinition.PropagateTags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags
     */
    readonly propagateTags?: boolean | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     */
    readonly retryStrategy?: CfnJobDefinition.RetryStrategyProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.SchedulingPriority`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-schedulingpriority
     */
    readonly schedulingPriority?: number;
    /**
     * `AWS::Batch::JobDefinition.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Batch::JobDefinition.Timeout`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     */
    readonly timeout?: CfnJobDefinition.TimeoutProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`
 *
 *
 *
 * @cloudformationResource AWS::Batch::JobDefinition
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare class CfnJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::JobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnJobDefinition;
    /**
     * `AWS::Batch::JobDefinition.Type`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
     */
    type: string;
    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     */
    containerProperties: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.JobDefinitionName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::Batch::JobDefinition.NodeProperties`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     */
    nodeProperties: CfnJobDefinition.NodePropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.Parameters`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
     */
    parameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.PlatformCapabilities`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-platformcapabilities
     */
    platformCapabilities: string[] | undefined;
    /**
     * `AWS::Batch::JobDefinition.PropagateTags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags
     */
    propagateTags: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     */
    retryStrategy: CfnJobDefinition.RetryStrategyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.SchedulingPriority`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-schedulingpriority
     */
    schedulingPriority: number | undefined;
    /**
     * `AWS::Batch::JobDefinition.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Batch::JobDefinition.Timeout`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     */
    timeout: CfnJobDefinition.TimeoutProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Batch::JobDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html
     */
    interface AuthorizationConfigProperty {
        /**
         * `CfnJobDefinition.AuthorizationConfigProperty.AccessPointId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html#cfn-batch-jobdefinition-authorizationconfig-accesspointid
         */
        readonly accessPointId?: string;
        /**
         * `CfnJobDefinition.AuthorizationConfigProperty.Iam`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html#cfn-batch-jobdefinition-authorizationconfig-iam
         */
        readonly iam?: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html
     */
    interface ContainerPropertiesProperty {
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Command`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-command
         */
        readonly command?: string[];
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Environment`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-environment
         */
        readonly environment?: Array<CfnJobDefinition.EnvironmentProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ExecutionRoleArn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-executionrolearn
         */
        readonly executionRoleArn?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.FargatePlatformConfiguration`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-fargateplatformconfiguration
         */
        readonly fargatePlatformConfiguration?: CfnJobDefinition.FargatePlatformConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Image`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-image
         */
        readonly image: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.InstanceType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.JobRoleArn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-jobrolearn
         */
        readonly jobRoleArn?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.LinuxParameters`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-linuxparameters
         */
        readonly linuxParameters?: CfnJobDefinition.LinuxParametersProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.LogConfiguration`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-logconfiguration
         */
        readonly logConfiguration?: CfnJobDefinition.LogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Memory`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-memory
         */
        readonly memory?: number;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.MountPoints`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-mountpoints
         */
        readonly mountPoints?: Array<CfnJobDefinition.MountPointsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.NetworkConfiguration`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-networkconfiguration
         */
        readonly networkConfiguration?: CfnJobDefinition.NetworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Privileged`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-privileged
         */
        readonly privileged?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ReadonlyRootFilesystem`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-readonlyrootfilesystem
         */
        readonly readonlyRootFilesystem?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ResourceRequirements`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-resourcerequirements
         */
        readonly resourceRequirements?: Array<CfnJobDefinition.ResourceRequirementProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Secrets`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-secrets
         */
        readonly secrets?: Array<CfnJobDefinition.SecretProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Ulimits`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-ulimits
         */
        readonly ulimits?: Array<CfnJobDefinition.UlimitProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.User`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-user
         */
        readonly user?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Vcpus`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-vcpus
         */
        readonly vcpus?: number;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Volumes`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-volumes
         */
        readonly volumes?: Array<CfnJobDefinition.VolumesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html
     */
    interface DeviceProperty {
        /**
         * `CfnJobDefinition.DeviceProperty.ContainerPath`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-containerpath
         */
        readonly containerPath?: string;
        /**
         * `CfnJobDefinition.DeviceProperty.HostPath`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-hostpath
         */
        readonly hostPath?: string;
        /**
         * `CfnJobDefinition.DeviceProperty.Permissions`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-permissions
         */
        readonly permissions?: string[];
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html
     */
    interface EfsVolumeConfigurationProperty {
        /**
         * `CfnJobDefinition.EfsVolumeConfigurationProperty.AuthorizationConfig`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-authorizationconfig
         */
        readonly authorizationConfig?: CfnJobDefinition.AuthorizationConfigProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.EfsVolumeConfigurationProperty.FileSystemId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-filesystemid
         */
        readonly fileSystemId: string;
        /**
         * `CfnJobDefinition.EfsVolumeConfigurationProperty.RootDirectory`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-rootdirectory
         */
        readonly rootDirectory?: string;
        /**
         * `CfnJobDefinition.EfsVolumeConfigurationProperty.TransitEncryption`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-transitencryption
         */
        readonly transitEncryption?: string;
        /**
         * `CfnJobDefinition.EfsVolumeConfigurationProperty.TransitEncryptionPort`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-transitencryptionport
         */
        readonly transitEncryptionPort?: number;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html
     */
    interface EnvironmentProperty {
        /**
         * `CfnJobDefinition.EnvironmentProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-name
         */
        readonly name?: string;
        /**
         * `CfnJobDefinition.EnvironmentProperty.Value`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-value
         */
        readonly value?: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html
     */
    interface EvaluateOnExitProperty {
        /**
         * `CfnJobDefinition.EvaluateOnExitProperty.Action`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-action
         */
        readonly action: string;
        /**
         * `CfnJobDefinition.EvaluateOnExitProperty.OnExitCode`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onexitcode
         */
        readonly onExitCode?: string;
        /**
         * `CfnJobDefinition.EvaluateOnExitProperty.OnReason`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onreason
         */
        readonly onReason?: string;
        /**
         * `CfnJobDefinition.EvaluateOnExitProperty.OnStatusReason`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onstatusreason
         */
        readonly onStatusReason?: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-fargateplatformconfiguration.html
     */
    interface FargatePlatformConfigurationProperty {
        /**
         * `CfnJobDefinition.FargatePlatformConfigurationProperty.PlatformVersion`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-fargateplatformconfiguration.html#cfn-batch-jobdefinition-containerproperties-fargateplatformconfiguration-platformversion
         */
        readonly platformVersion?: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html
     */
    interface LinuxParametersProperty {
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Devices`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-devices
         */
        readonly devices?: Array<CfnJobDefinition.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.InitProcessEnabled`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-initprocessenabled
         */
        readonly initProcessEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.MaxSwap`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-maxswap
         */
        readonly maxSwap?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.SharedMemorySize`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-sharedmemorysize
         */
        readonly sharedMemorySize?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Swappiness`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-swappiness
         */
        readonly swappiness?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Tmpfs`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-tmpfs
         */
        readonly tmpfs?: Array<CfnJobDefinition.TmpfsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html
     */
    interface LogConfigurationProperty {
        /**
         * `CfnJobDefinition.LogConfigurationProperty.LogDriver`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-logdriver
         */
        readonly logDriver: string;
        /**
         * `CfnJobDefinition.LogConfigurationProperty.Options`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-options
         */
        readonly options?: any | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LogConfigurationProperty.SecretOptions`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-secretoptions
         */
        readonly secretOptions?: Array<CfnJobDefinition.SecretProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html
     */
    interface MountPointsProperty {
        /**
         * `CfnJobDefinition.MountPointsProperty.ContainerPath`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-containerpath
         */
        readonly containerPath?: string;
        /**
         * `CfnJobDefinition.MountPointsProperty.ReadOnly`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-readonly
         */
        readonly readOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.MountPointsProperty.SourceVolume`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-sourcevolume
         */
        readonly sourceVolume?: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-networkconfiguration.html
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnJobDefinition.NetworkConfigurationProperty.AssignPublicIp`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-networkconfiguration.html#cfn-batch-jobdefinition-containerproperties-networkconfiguration-assignpublicip
         */
        readonly assignPublicIp?: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html
     */
    interface NodePropertiesProperty {
        /**
         * `CfnJobDefinition.NodePropertiesProperty.MainNode`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-mainnode
         */
        readonly mainNode: number;
        /**
         * `CfnJobDefinition.NodePropertiesProperty.NodeRangeProperties`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-noderangeproperties
         */
        readonly nodeRangeProperties: Array<CfnJobDefinition.NodeRangePropertyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.NodePropertiesProperty.NumNodes`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-numnodes
         */
        readonly numNodes: number;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html
     */
    interface NodeRangePropertyProperty {
        /**
         * `CfnJobDefinition.NodeRangePropertyProperty.Container`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-container
         */
        readonly container?: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.NodeRangePropertyProperty.TargetNodes`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-targetnodes
         */
        readonly targetNodes: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html
     */
    interface ResourceRequirementProperty {
        /**
         * `CfnJobDefinition.ResourceRequirementProperty.Type`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-type
         */
        readonly type?: string;
        /**
         * `CfnJobDefinition.ResourceRequirementProperty.Value`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-value
         */
        readonly value?: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html
     */
    interface RetryStrategyProperty {
        /**
         * `CfnJobDefinition.RetryStrategyProperty.Attempts`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-attempts
         */
        readonly attempts?: number;
        /**
         * `CfnJobDefinition.RetryStrategyProperty.EvaluateOnExit`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-evaluateonexit
         */
        readonly evaluateOnExit?: Array<CfnJobDefinition.EvaluateOnExitProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html
     */
    interface SecretProperty {
        /**
         * `CfnJobDefinition.SecretProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-name
         */
        readonly name: string;
        /**
         * `CfnJobDefinition.SecretProperty.ValueFrom`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-valuefrom
         */
        readonly valueFrom: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html
     */
    interface TimeoutProperty {
        /**
         * `CfnJobDefinition.TimeoutProperty.AttemptDurationSeconds`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html#cfn-batch-jobdefinition-timeout-attemptdurationseconds
         */
        readonly attemptDurationSeconds?: number;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html
     */
    interface TmpfsProperty {
        /**
         * `CfnJobDefinition.TmpfsProperty.ContainerPath`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-containerpath
         */
        readonly containerPath: string;
        /**
         * `CfnJobDefinition.TmpfsProperty.MountOptions`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-mountoptions
         */
        readonly mountOptions?: string[];
        /**
         * `CfnJobDefinition.TmpfsProperty.Size`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-size
         */
        readonly size: number;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html
     */
    interface UlimitProperty {
        /**
         * `CfnJobDefinition.UlimitProperty.HardLimit`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-hardlimit
         */
        readonly hardLimit: number;
        /**
         * `CfnJobDefinition.UlimitProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-name
         */
        readonly name: string;
        /**
         * `CfnJobDefinition.UlimitProperty.SoftLimit`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-softlimit
         */
        readonly softLimit: number;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html
     */
    interface VolumesProperty {
        /**
         * `CfnJobDefinition.VolumesProperty.EfsVolumeConfiguration`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-efsvolumeconfiguration
         */
        readonly efsVolumeConfiguration?: CfnJobDefinition.EfsVolumeConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.VolumesProperty.Host`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-host
         */
        readonly host?: CfnJobDefinition.VolumesHostProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.VolumesProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-name
         */
        readonly name?: string;
    }
}
export declare namespace CfnJobDefinition {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html
     */
    interface VolumesHostProperty {
        /**
         * `CfnJobDefinition.VolumesHostProperty.SourcePath`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html#cfn-batch-jobdefinition-volumeshost-sourcepath
         */
        readonly sourcePath?: string;
    }
}
/**
 * Properties for defining a `CfnJobQueue`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html
 */
export interface CfnJobQueueProps {
    /**
     * `AWS::Batch::JobQueue.ComputeEnvironmentOrder`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-computeenvironmentorder
     */
    readonly computeEnvironmentOrder: Array<CfnJobQueue.ComputeEnvironmentOrderProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Batch::JobQueue.Priority`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-priority
     */
    readonly priority: number;
    /**
     * `AWS::Batch::JobQueue.JobQueueName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobqueuename
     */
    readonly jobQueueName?: string;
    /**
     * `AWS::Batch::JobQueue.SchedulingPolicyArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-schedulingpolicyarn
     */
    readonly schedulingPolicyArn?: string;
    /**
     * `AWS::Batch::JobQueue.State`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-state
     */
    readonly state?: string;
    /**
     * `AWS::Batch::JobQueue.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Batch::JobQueue`
 *
 *
 *
 * @cloudformationResource AWS::Batch::JobQueue
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html
 */
export declare class CfnJobQueue extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::JobQueue";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnJobQueue;
    /**
     *
     * @cloudformationAttribute JobQueueArn
     */
    readonly attrJobQueueArn: string;
    /**
     * `AWS::Batch::JobQueue.ComputeEnvironmentOrder`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-computeenvironmentorder
     */
    computeEnvironmentOrder: Array<CfnJobQueue.ComputeEnvironmentOrderProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Batch::JobQueue.Priority`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-priority
     */
    priority: number;
    /**
     * `AWS::Batch::JobQueue.JobQueueName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobqueuename
     */
    jobQueueName: string | undefined;
    /**
     * `AWS::Batch::JobQueue.SchedulingPolicyArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-schedulingpolicyarn
     */
    schedulingPolicyArn: string | undefined;
    /**
     * `AWS::Batch::JobQueue.State`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-state
     */
    state: string | undefined;
    /**
     * `AWS::Batch::JobQueue.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Batch::JobQueue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobQueueProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnJobQueue {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html
     */
    interface ComputeEnvironmentOrderProperty {
        /**
         * `CfnJobQueue.ComputeEnvironmentOrderProperty.ComputeEnvironment`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html#cfn-batch-jobqueue-computeenvironmentorder-computeenvironment
         */
        readonly computeEnvironment: string;
        /**
         * `CfnJobQueue.ComputeEnvironmentOrderProperty.Order`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html#cfn-batch-jobqueue-computeenvironmentorder-order
         */
        readonly order: number;
    }
}
/**
 * Properties for defining a `CfnSchedulingPolicy`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html
 */
export interface CfnSchedulingPolicyProps {
    /**
     * `AWS::Batch::SchedulingPolicy.FairsharePolicy`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy
     */
    readonly fairsharePolicy?: CfnSchedulingPolicy.FairsharePolicyProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::SchedulingPolicy.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-name
     */
    readonly name?: string;
    /**
     * `AWS::Batch::SchedulingPolicy.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Batch::SchedulingPolicy`
 *
 *
 *
 * @cloudformationResource AWS::Batch::SchedulingPolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html
 */
export declare class CfnSchedulingPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::SchedulingPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSchedulingPolicy;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Batch::SchedulingPolicy.FairsharePolicy`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy
     */
    fairsharePolicy: CfnSchedulingPolicy.FairsharePolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::SchedulingPolicy.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-name
     */
    name: string | undefined;
    /**
     * `AWS::Batch::SchedulingPolicy.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Batch::SchedulingPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnSchedulingPolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSchedulingPolicy {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html
     */
    interface FairsharePolicyProperty {
        /**
         * `CfnSchedulingPolicy.FairsharePolicyProperty.ComputeReservation`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-computereservation
         */
        readonly computeReservation?: number;
        /**
         * `CfnSchedulingPolicy.FairsharePolicyProperty.ShareDecaySeconds`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-sharedecayseconds
         */
        readonly shareDecaySeconds?: number;
        /**
         * `CfnSchedulingPolicy.FairsharePolicyProperty.ShareDistribution`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-sharedistribution
         */
        readonly shareDistribution?: Array<CfnSchedulingPolicy.ShareAttributesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnSchedulingPolicy {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html
     */
    interface ShareAttributesProperty {
        /**
         * `CfnSchedulingPolicy.ShareAttributesProperty.ShareIdentifier`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html#cfn-batch-schedulingpolicy-shareattributes-shareidentifier
         */
        readonly shareIdentifier?: string;
        /**
         * `CfnSchedulingPolicy.ShareAttributesProperty.WeightFactor`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html#cfn-batch-schedulingpolicy-shareattributes-weightfactor
         */
        readonly weightFactor?: number;
    }
}
