import array
from typing import Optional, Any, Sequence, Iterator

class FastaFile:
    def __init__(
        self,
        filename: str,
        filepath_index: Optional[str] = ...,
        filepath_index_compressed: Optional[str] = ...,
    ) -> None: ...
    def is_open(self) -> bool: ...
    def __len__(self) -> int: ...
    def close(self) -> None: ...
    def __enter__(self) -> FastaFile: ...
    def __exit__(self, type, value, traceback) -> Any: ...
    @property
    def closed(self) -> bool: ...
    @property
    def filename(self) -> str: ...
    @property
    def references(self) -> Sequence[str]: ...
    @property
    def nreferences(self) -> Optional[int]: ...
    @property
    def lengths(self) -> Sequence[int]: ...
    def fetch(
        self,
        reference: Optional[str] = ...,
        start: Optional[int] = ...,
        end: Optional[int] = ...,
        region: Optional[str] = ...,
    ) -> str: ...
    def get_reference_length(self, reference: str) -> int: ...
    def __getitem__(self, reference: str) -> str: ...
    def __contains__(self, reference: str) -> bool: ...

class FastxRecord:
    comment: str = ...
    quality: str = ...
    sequence: str = ...
    name: str = ...
    def __init__(
        self,
        name: Optional[str] = ...,
        comment: Optional[str] = ...,
        sequence: Optional[str] = ...,
        quality: Optional[str] = ...,
    ) -> None: ...
    def set_name(self, name: str) -> None: ...
    def set_comment(self, comment: str) -> None: ...
    def set_sequence(self, sequence: str, quality: Optional[str] = ...) -> None: ...
    def get_quality_array(self, offset: int = ...) -> array.array: ...

class FastxFile:
    def __init__(self, filename: str, persist: bool = ...) -> None: ...
    def is_open(self) -> bool: ...
    def close(self) -> None: ...
    def __enter__(self) -> FastxFile: ...
    def __exit__(self, type, value, traceback) -> Any: ...
    @property
    def closed(self) -> bool: ...
    @property
    def filename(self) -> str: ...
    def __iter__(self) -> Iterator[FastxRecord]: ...
    def __next__(self) -> FastxRecord: ...

# deprecated
class FastqFile(FastxFile): ...
