# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['my_autopylot',
 'my_autopylot.Windows.functions',
 'my_autopylot.Windows.functions.blackbox',
 'my_autopylot.Windows.functions.chrome',
 'my_autopylot.Windows.functions.excel',
 'my_autopylot.Windows.functions.extras',
 'my_autopylot.Windows.functions.folder',
 'my_autopylot.Windows.functions.keyboard',
 'my_autopylot.Windows.functions.mouse',
 'my_autopylot.Windows.functions.screen_scraping',
 'my_autopylot.Windows.functions.string',
 'my_autopylot.Windows.functions.voice',
 'my_autopylot.Windows.functions.windows',
 'my_autopylot.cli',
 'my_autopylot.resources']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.0.1,<10.0.0',
 'PyGetWindow>=0.0.9,<0.0.10',
 'PyScreeze>=0.1.28,<0.2.0',
 'SpeechRecognition>=3.8.1,<4.0.0',
 'colored>=1.4.3,<2.0.0',
 'emoji>=1.7.0,<2.0.0',
 'gTTS>=2.2.3,<3.0.0',
 'helium>=3.0.8,<4.0.0',
 'numpy==1.21.5',
 'pandas>=1.4.1,<2.0.0',
 'psutil>=5.9.0,<6.0.0',
 'pyfiglet>=0.8.post1,<0.9',
 'pyinspect>=0.1.0,<0.2.0',
 'pywinauto>=0.6.8,<0.7.0',
 'rich>=11.2.0,<12.0.0',
 'speedtest-cli>=2.1.3,<3.0.0',
 'webdriver-manager>=3.5.3,<4.0.0']

entry_points = \
{'console_scripts': ['ap = my_autopylot.cli.my_autopylot:main',
                     'ap_py = my_autopylot.cli.ap_console:main',
                     'ap_st = my_autopylot.cli.speed_test:main']}

setup_kwargs = {
    'name': 'my-autopylot',
    'version': '0.0.6',
    'description': 'Auto-Pylot is a Python based RPA platform for Software BOT development as an Open Source project. We strive to liberate humans from mundane, repetitive tasks, giving them more time to use their intellect and creativity to solve higher-order business challenges and perform knowledge work. We see a world where every employee will work side by side with Digital Workers, taking the robot out of the human, making them exponentially more productive and far more fulfilled.',
    'long_description': '.. image:: https://raw.githubusercontent.com/py-bots/media-pyles/main/pybots/PyBots%20TriColor%20Logo.png\n\n\nWelcome to My AutoPylot , Made in India with ❤️\n-----------------------------------------------\n\n.. image:: https://raw.githubusercontent.com/py-bots/media-pyles/main/autopylot/Auto%20Pylot%20Figlet%20Dark.png\n\n\n\nWhat is My-AutoPylot?\n=====================\n\nPyBots is an Indian firm based in Vadodara, Gujarat. My-AutoPylot is a\nproduct developed based on Python. Its a RPA framework for developers\nand common people to create Software BOTs. Using AI, we’re working on\nCommon Man’s RPA.\n\n\nInstallation\n============\n\nMy-AutoPylot is currently supported on Windows only ! (For macOS and Linux : Comming soon.)\n\n\nWindows :\n---------\n\n-  My-AutoPylot is compatible with both Windows 10 and Windows 11.\n\n-  Installing on a Windows PC is a breeze.\n\n-  Make certain that Python 3.8 or Python 3.9 is installed.\n\n-  Then, from the command prompt, execute the following command.\n\n   ::\n\n      pip install -U my-autopylot\n\nImporting\n=========\n\nMy-AutoPylot can be accessed using one of two methods.\n\n\nWindows :\n---------\n\n-  Terminal : Opens a Python interpreter using the command " import my-autopylot as ap "\n      \n   ::\n\n      ap_py\n\n-  Code Editor or IDE : Import My-AutoPylot first, and then run the file in Python.\n\n   ::\n\n      # filename : ap_bot.py\n\n      import my_autopylot as ap\n\n      ap.windows_launch_app(\'notepad\')\n\n      \nSave the file and run it.\n\nRun the file using the command " python ap_bot.py "\n\n\nMy-AutoPylot in Action\n-----------------------\n\nNow access more than 100 functions (hit ctrl+space in your IDE)\n==================================================================\n\n**TIP:**\n\nYou can find and inspect all of ClointFusion\'s functions using\nonly one function i.e., ``find()``. Just pass the partial name of the\nfunction.\n\n::\n\n   ap.find("excel")\n\n   ap.find("window")\n\n\n4 functions on Mouse Operations:\n--------------------------------\n\n+-------------------------------------------------------+------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| Function                                              | Accepted Parameters                                                                | Description                                                                                                                                                                                                              |\n+=======================================================+====================================================================================+==========================================================================================================================================================================================================================+\n| ap.mouse\\_click()                                     | x=" ", y=" ", left\\_or\\_right="left", no\\_of\\_clicks=1, type\\_of\\_movement="abs"   | Clicks at the given X Y Co-ordinates on the screen using ingle / double / triple click(s). Has an optional argument for which type of movement will take place where values can will be "abs" (default) or it can be"rel"|\n+-------------------------------------------------------+------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.mouse\\_move()                                      | x=" ", y=" ", type_of_movement="abs"                                               | Moves the cursor to the given X Y Co-ordinates. Has an optional argument for which type of movement will take place where values can will be "abs" (default) or it can be"rel".                                          |\n+-------------------------------------------------------+------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.mouse\\_drag\\_from\\_to()                            | x1=" ", y1=" ", x2=" ",y2=" "                                                      | Clicks and drags from X1 Y1 co-ordinates to X2 Y2 Co-ordinates on the screen                                                                                                                                             |\n+-------------------------------------------------------+------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.mouse\\_search\\_snip\\_return\\_coordinates\\_x\\_y()   | img=" ", wait=180                                                                  | Searches the given image on the screen and returns its center of X Y co-ordinates.                                                                                                                                       |\n+-------------------------------------------------------+------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n\n--------------\n\n8 functions on Window Operations (works only in Windows OS):\n------------------------------------------------------------\n\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n| Function                                         | Accepted Parameters   | Description                                           |\n+==================================================+=======================+=======================================================+\n| ap.window\\_show\\_desktop()                       | None                  | Minimizes all the applications and shows Desktop.     |\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n| ap.window\\_get\\_all\\_opened\\_titles\\_windows()   | None                  | Gives the title of all the existing (open) windows.   |\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n| ap.window\\_activate\\_and\\_maximize\\_windows()    | windowName=" "        | Activates and maximizes the desired window.           |\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n| ap.window\\_minimize\\_windows()                   | windowName=" "        | Activates and minimizes the desired window.           |\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n| ap.window\\_close\\_windows()                      | windowName=" "        | Close the desired window.                             |\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n| ap.windows_launch_app()                          | pathOfExeFile=" "     | Launches any exe or batch file or excel file etc.     |\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n| ap.window_get_active_window()                    | None                  | Gives the title of the current active window          |\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n| ap.window_activate_window()                      | window_title=" "      | Activates the window with the given name.             |\n+--------------------------------------------------+-----------------------+-------------------------------------------------------+\n\n--------------\n\n8 functions on Folder Operations:\n---------------------------------\n\n\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n| Function                                     | Accepted Parameters                                            | Description                                                                                                                 |\n+==============================================+================================================================+=============================================================================================================================+\n| ap.folder\\_read\\_text\\_file()                | txt\\_file\\_path=" "                                            | Reads from a given text file and returns entire contents as a single list                                                   |\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n| ap.folder\\_write\\_text\\_file()               | txt\\_file\\_path=" ", contents=" "                              | Writes given contents to a text file                                                                                        |\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n| ap.folder\\_create()                          | strFolderPath=" "                                              | When you are making leaf directory, if any intermediate-level directory is missing, folder\\_create() method creates them.   |\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n| ap.folder\\_create\\_text\\_file()              | textFolderPath=" ", txtFileName=" "                            | Creates text file in the given path.                                                                                        |\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n| ap.folder\\_get\\_all\\_filenames\\_as\\_list()   | strFolderPath=" ", extension=\'all\'                             | Get all the files of the given folder in a list.                                                                            |\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n| ap.folder\\_delete\\_all\\_files()              | fullPathOfTheFolder=" ", file\\_extension\\_without\\_dot="all"   | Deletes all the files of the given folder                                                                                   |\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n| ap.file\\_rename()                            | old\\_file\\_path=\'\', new\\_file\\_name=\'\', ext=False              | Renames the given file name to new file name with same extension.                                                           |\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n| ap.file\\_get\\_json\\_details()                | path\\_of\\_json\\_file=\'\', section=\'\'                            | Returns all the details of the given section in a dictionary                                                                |\n+----------------------------------------------+----------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------+\n\n--------------\n\n3 functions on Keyboard Operations:\n-----------------------------------\n\n+--------------------------+-------------------------------------------------------------------------------+------------------------------------------------------------------------+\n| Function                 | Accepted Parameters                                                           | Description                                                            |\n+==========================+===============================================================================+========================================================================+\n| ap.key\\_hit\\_enter()     | write\\_to\\_window=" "                                                         | Enter key will be pressed once.                                        |\n+--------------------------+-------------------------------------------------------------------------------+------------------------------------------------------------------------+\n| ap.key\\_press()          | key\\_1=\'\', key\\_2=\'\', key\\_3=\'\', write\\_to\\_window=" "                        | Emulates the given keystrokes.                                         |\n+--------------------------+-------------------------------------------------------------------------------+------------------------------------------------------------------------+\n| ap.key\\_write\\_enter()   | text\\_to\\_write=" ", write\\_to\\_window=" ", delay\\_after\\_typing=1, key="e"   | Writes/Types the given text and press enter (by default) or tab key.   |\n+--------------------------+-------------------------------------------------------------------------------+------------------------------------------------------------------------+\n\n--------------\n\n5 functions on Screen-scraping Operations:\n------------------------------------------\n\n+-------------------------------------------------------+---------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| Function                                              | Accepted Parameters                                                 | Description                                                                                                                                                                   |\n+=======================================================+=====================================================================+===============================================================================================================================================================================+\n| ap.scrape\\_save\\_contents\\_to\\_notepad()              | folderPathToSaveTheNotepad=" ", switch\\_to\\_window=" ",X=0, Y=0     | Copy pastes all the available text on the screen to notepad and saves it.                                                                                                     |\n+-------------------------------------------------------+---------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.scrape\\_get\\_contents\\_by\\_search\\_copy\\_paste()   | highlightText=" "                                                   | Gets the focus on the screen by searching given text using crtl+f and performs copy/paste of all data. Useful in Citrix applications. This is useful in Citrix applications   |\n+-------------------------------------------------------+---------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.screen\\_clear\\_search()                            | delay=0.2                                                           | Clears previously found text (crtl+f highlight)                                                                                                                               |\n+-------------------------------------------------------+---------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.search\\_highlight\\_tab\\_enter\\_open()              | searchText=" ", hitEnterKey="Yes", shift\\_tab=\'No\'                  | Searches for a text on screen using crtl+f and hits enter. This function is useful in Citrix environment.                                                                     |\n+-------------------------------------------------------+---------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.find\\_text\\_on\\_screen()                           | searchText=" ", delay=0.1, occurance=1, isSearchToBeCleared=False   | Clears previous search and finds the provided text on screen.                                                                                                                 |\n+-------------------------------------------------------+---------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n\n--------------\n\n11 functions on Browser Operations:\n-----------------------------------\n\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| Function                          | Accepted Parameters                                                                    | Description                                                     |\n+===================================+========================================================================================+=================================================================+\n| driver = ap.ChromeBrowser()       | None                                                                                   | To initialise a ChromeBrowser class.                            |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.open_browser()             | url=" ", dummy\\_browser=True, incognito=False, profile="Default"                       | Function to launch browser and start the session.               |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.navigate()                 | url=" "                                                                                | Navigates to Specified URL.                                     |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.write()                    | Value=" ", User\\_Visible\\_Text\\_Element=" "                                            | Write a string on the given element.                            |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.mouse_click()              | User\\_Visible\\_Text\\_Element=" ", element=" ", double\\_click=False, right\\_click=False | Click on the given element.                                     |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.browser_locate_element_h() | selector=" ", get\\_text=False, multiple\\_elements=False                                | Find the element by Xpath, id or css selection.                 |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.wait_until()               | text=" ", element="t"                                                                  | Wait until a specific element is found.                         |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.refresh_page()             | None                                                                                   | Refresh the page.                                               |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.close()                    | None                                                                                   | Close the Helium browser.                                       |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.hit_enter()                | None                                                                                   | Hits enter KEY using Browser Helium Functions                   |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.key_press()                | key\\_1=" ", key\\_2=" "                                                                 | Type text using Browser Helium Functions and press hot keys     |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.mouse_hover()              | User\\_Visible\\_Text\\_Element=" "                                                       | Performs a Mouse Hover over the Given User Visible Text Element |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n| driver.scroll()                   | direction="down", weight="100" px                                                      | Scrolls the browser window.                                     |\n+-----------------------------------+----------------------------------------------------------------------------------------+-----------------------------------------------------------------+\n\n--------------\n\n3 functions on String Operations:\n---------------------------------\n\n\n+--------------------------------------------+-----------------------+--------------------------------------------------+\n| Function                                   | Accepted Parameters   | Description                                      |\n+============================================+=======================+==================================================+\n| ap.string\\_remove\\_special\\_characters()   | inputStr=" "          | Removes all the special character.               |\n+--------------------------------------------+-----------------------+--------------------------------------------------+\n| ap.string\\_extract\\_only\\_alphabets()      | inputString=" "       | Returns only alphabets from given input string   |\n+--------------------------------------------+-----------------------+--------------------------------------------------+\n| ap.string\\_extract\\_only\\_numbers()        | inputString=" "       | Returns only numbers from given input string     |\n+--------------------------------------------+-----------------------+--------------------------------------------------+\n\n--------------\n\n18 functions on Excel Operations:\n---------------------------------\n  \n\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| Function                                           | Accepted Parameters                                                                                                       | Description                                                                                |\n+====================================================+===========================================================================================================================+============================================================================================+\n| ap.excel\\_get\\_all\\_sheet\\_names()                 | excelFilePath=" "                                                                                                         | Gives you all names of the sheets in the given excel sheet.                                |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_create\\_excel\\_file\\_in\\_given\\_folder() | fullPathToTheFolder=" ", excelFileName=" ", sheet\\_name="Sheet1"                                                          | Creates an excel file in the desired folder with desired filename                          |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_if\\_value\\_exists()                      | excel\\_path=" ", sheet\\_name="Sheet1", header=0, usecols=" ", value=" "                                                   | Check if a given value exists in given excel. Returns True / False                         |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_copy\\_paste\\_range\\_from\\_to\\_sheet()    | excel\\_path=" ", sheet\\_name="Sheet1", startCol=0, startRow=0, endCol=0, endRow=0, copiedData=" "                         | Pastes the copied data in specific range of the given excel sheet.                         |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_get\\_row\\_column\\_count()                | excel\\_path=" ", sheet\\_name="Sheet1", header=0                                                                           | Gets the row and column count of the provided excel sheet.                                 |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_copy\\_range\\_from\\_sheet()               | excel\\_path=" ", sheet\\_name="Sheet1", startCol=0, startRow=0, endCol=0, endRow=0                                         | Copies the specific range from the provided excel sheet and returns copied data as a list  |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_split\\_by\\_column()                      | excel\\_path=" ", sheet\\_name="Sheet1", header=0, columnName=" "                                                           | Splits the excel file by Column Name                                                       |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_split\\_the\\_file\\_on\\_row\\_count()       | excel\\_path=" ", sheet\\_name = "Sheet1", rowSplitLimit=" ", outputFolderPath=" ", outputTemplateFileName ="Split"         | Splits the excel file as per given row limit                                               |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_merge\\_all\\_files()                      | input\\_folder\\_path=" ", output\\_folder\\_path=" "                                                                         | Merges all the excel files in the given folder                                             |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_drop\\_columns()                          | excel\\_path=" ", sheet\\_name="Sheet1", header=0, columnsToBeDropped = " "                                                 | Drops the desired column from the given excel file                                         |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_clear\\_sheet()                           | excel\\_path=" ",sheet\\_name="Sheet1", header=0                                                                            | Clears the contents of given excel files keeping header row intact                         |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_set\\_single\\_cell()                      | excel\\_path=" ", sheet\\_name="Sheet1", header=0, columnName=" ", cellNumber=0, setText=" "                                | Writes the given text to the desired column/cell number for the given excel file           |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_get\\_single\\_cell()                      | excel\\_path=" ",sheet\\_name="Sheet1", header=0, columnName=" ",cellNumber=0                                               | Gets the text from the desired column/cell number of the given excel file                  |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_remove\\_duplicates()                     | excel\\_path=" ",sheet\\_name="Sheet1", header=0, columnName=" ", saveResultsInSameExcel=True, which\\_one\\_to\\_keep="first" | Drops the duplicates from the desired Column of the given excel file                       |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_get\\_all\\_header\\_columns()              | excel\\_path=" ",sheet\\_name="Sheet1",header=0                                                                             | Gives you all column header names of the given excel sheet                                 |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_describe\\_data()                         | excel\\_path=" ",sheet\\_name="Sheet1",header=0                                                                             | Describe statistical data for the given excel                                              |\n+----------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.isNaN()                                         | value                                                                                                                     | Returns TRUE if a given value is NaN False otherwise                                       |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n| ap.excel\\_to\\_colored\\_html()                      | formatted\\_excel\\_path=" "                                                                                                | Converts given Excel to HTML preserving the Excel format and saves in same folder as .html |\n+----------------------------------------------------+---------------------------------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------+\n\n\nSome of miscellaneous functions related to emoji, capture photo, flash (pop-up) messages etc:\n----------------------------------------------------------------------------------------------\n\n+-------------------------------------------+----------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| Function                                  | Accepted Parameters                                                                                | Description                                                                                                                                                                                            |\n+===========================================+====================================================================================================+========================================================================================================================================================================================================+\n| ap.clear\\_screen()                        | None                                                                                               | Clears Python Interpreter Terminal Window Screen                                                                                                                                                       |\n+-------------------------------------------+----------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.print\\_with\\_magic\\_color()            | strMsg:str=" ", magic:bool=False                                                                   | Function to color and format terminal output                                                                                                                                                           |\n+-------------------------------------------+----------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.show\\_emoji()                          | strInput=" "                                                                                       | Function which prints Emojis                                                                                                                                                                           |\n+-------------------------------------------+----------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.download\\_this\\_file()                 | url=" "                                                                                            | Downloads a given url file to BOT output folder or Browser\'s Download folder                                                                                                                           |\n+-------------------------------------------+----------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ap.pause\\_program()                       | seconds="5"                                                                                        | Stops the program for given seconds                                                                                                                                                                    |\n+-------------------------------------------+----------------------------------------------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n\nWe love your contribution\n=========================\n\nContribute to us by giving a star, writing articles on ``My AutoPylot``,\ngiving comments, reporting bugs, bug fixes, feature enhancements, adding\ndocumentation, and many other ways.\n\nInvitation to our Monthly Branded Hackathon\n-------------------------------------------\n\nWe also invite everyone to take part in our monthly branded event, the\n``My AutoPylot Hackathon``, and stand a chance to work with us.\n\nCheckout our Hackathon Website for more details here: `My AutoPylot\nHackathon <https://sites.google.com/view/My AutoPylot-hackathon>`__\n\nDate ❤️ with My AutoPylot\n-------------------------\n\nThis an initiative for fast track entry into our growing workforce. For\nmore details, please visit: `Date with\nMy AutoPylot <https://lnkd.in/gh_r9YB>`__\n\nAcknowledgements\n----------------\n\nWe sincerely thanks to all it\'s dependent packages for the great\ncontribution, which made ``My AutoPylot`` possible!\n\nPlease find all the dependencies\n\nCredits\n-------\n\nNeed help in Building BOTS?\n---------------------------\n\nWrite us at My support@pybots.ai',
    'author': 'PyBots',
    'author_email': 'support@pybots.ai',
    'maintainer': None,
    'maintainer_email': None,
    'url': '',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<=3.9.40',
}


setup(**setup_kwargs)
