from marshmallow import fields
from cc_py_commons.schemas.camel_case_schema import CamelCaseSchema
from cc_py_commons.carriers.contact_schema import ContactSchema

class CarrierSchema(CamelCaseSchema):
  id = fields.UUID()
  mc = fields.String()
  dot = fields.String()  
  customer_code = fields.String()
  business_name = fields.String()
  doing_business_as = fields.String()
  address1 = fields.String()
  city = fields.String()
  state = fields.String()
  postcode = fields.String()
  country = fields.String()
  latitude = fields.Float()
  longitude = fields.Float()  
  qualified = fields.Boolean()
  drivers = fields.Integer()
  active = fields.Boolean()
  active_checked_on = fields.Date()
  power_units = fields.Integer()
  drivers = fields.Integer()
  credit_score = fields.Integer()
  days_to_pay = fields.Integer()
  needs_review = fields.Boolean()
  is_private = fields.Boolean()
  customer_count = fields.Integer()
  dispatch_service = fields.Boolean()
  default_trailer_type = fields.String()
  carrier_last_fmcsa_update = fields.Date()
  hazmat = fields.Boolean()
  hm_flag = fields.Boolean()
  mcs_150_date = fields.Date()
  mcs_150_mileage = fields.Integer()
  mcs_150_mileage_year = fields.Integer()
  fmcsa_date_added = fields.Date()
  fmcsa_oic_state = fields.String()
  in_network = fields.Boolean()
  last_reviewed = fields.Date()
  internal_remarks = fields.String()
  contact_count = fields.Integer()
  not_reached_count = fields.Integer()
  not_reached_count_first_updated_at = fields.Date()
  lane_count = fields.Integer()
  has_teams = fields.Boolean()
  contact = fields.Nested(ContactSchema)
  