from collections import defaultdict
from contextlib import contextmanager
from random import SystemRandom
from typing import Any, Callable, Iterator, Optional, Tuple

from beeline.propagation import PropagationContext, Request
from libhoney import Client, Event

MAX_INT32: int = ...
SPAN_ID_BYTES: int = ...
TRACE_ID_BYTES: int = ...

class Trace:
    def __init__(self, trace_id: str, dataset: str) -> None: ...
    def copy(self) -> Trace: ...

class Tracer:
    def __init__(self, client: Client) -> None: ...
    @contextmanager
    def __call__(
        self, name: str, trace_id: str = ..., parent_id: str = ...
    ) -> Iterator[Span]: ...
    def start_trace(
        self,
        context: Optional[dict[str, Any]] = ...,
        trace_id: Optional[str] = ...,
        parent_span_id: Optional[str] = ...,
        dataset: Optional[str] = ...,
    ) -> Span: ...
    def start_span(
        self, context: Optional[dict[str, Any]] = ..., parent_id: Optional[str] = ...
    ) -> Span: ...
    def finish_span(self, span: Span) -> None: ...
    def finish_trace(self, span: Span) -> None: ...
    def parse_http_trace(self, request: Request) -> Optional[PropagationContext]: ...
    def propagate_and_start_trace(
        self, context: dict[str, Any], request: Request
    ) -> Span: ...
    def get_propagation_context(self) -> PropagationContext: ...
    def get_active_trace_id(self) -> str: ...
    def get_active_span(self) -> Span: ...
    def add_context_field(self, name: str, value: Any) -> None: ...
    def add_context(self, data: dict[str, Any]) -> None: ...
    def remove_context_field(self, name: str) -> None: ...
    def add_rollup_field(self, name: str, value: float) -> None: ...
    def add_trace_field(self, name: str, value: Any) -> None: ...
    def remove_trace_field(self, name: str) -> None: ...
    def marshal_trace_context(self) -> str: ...
    def register_hooks(
        self,
        presend: Callable[[dict[str, Any]], None] = ...,
        sampler: Callable[[dict[str, Any]], Tuple[bool, int]] = ...,
        http_trace_parser: Callable[[Request], Optional[PropagationContext]] = ...,
        http_trace_propagation: Callable[
            [PropagationContext], Optional[dict[str, str]]
        ] = ...,
    ) -> None: ...

class SynchronousTracer(Tracer):
    def __init__(self, client: Client) -> None: ...

class Span:
    trace_id: str
    parent_id: str
    id: str
    event: Event
    rollup_fields: defaultdict[str, float]
    def __init__(
        self, trace_id: str, parent_id: str, id: str, event: Event, is_root: bool = ...
    ) -> None: ...
    def add_context_field(self, name: str, value: Any) -> None: ...
    def add_context(self, data: dict[str, Any]) -> None: ...
    def remove_context_field(self, name: str) -> None: ...
    def is_root(self) -> bool: ...

system_random: SystemRandom = ...

def generate_span_id() -> str: ...
def generate_trace_id() -> str: ...
