#
# This code has been auto-generated by the MDE Workbench
# Version: 3.0.4.
#
# File: constants.py
# Date: 2022-10-26 07:41
# Time: 07:41
#


# Explosion located at the cloud front (LFL fraction)
EXPL_LOCATION = 0

# Uniform confined Multi Energy explosion method
UNIFORM_CONFINED_EXPLOSION_METHOD_OPTION = 3

# Upper limit of the droplet diameter (m)
MAX_DROP_DIAMETER = 0.01

# Jet fire averaging time (s)
JET_FIRE_AVR_TIME = 20.0

# Planar observer type for radiation modelling
OBSERVER_TYPE = 1

# Calculate surface emissive power for jet fires
CALC_METHOD_SEP_JET_FIRES = 0

# Toxics: tolerance on minimum probability of death
TOXIC_PD_TOLERANCE = 0.01

# Cut-off height for wind speed calculations 
WIND_CUTOFF_HEIGHT = 1.0

# Explosion efficiency for uniform confined multi-energy explosions (%)
ME_EXPL_EFFICIENCY_UNIFORM_CONFINED = 12.5

# Cutoff for short duration effects. Only mass released until this time is used in the fireball calculation (s)
SHORT_DURATION_CUTOFF = 20.0

# Maximum number of flame coordinates for jet fires
MAX_NUMBER_FLAME_COORDINATES = 10

# Method for modelling flame lift-off for Miller model: 0 = Miller method; 1 = DNV
MILLER_LIFT_OFF_OPTION = 1

# Maximum release duration (s)
MAX_RELEASE_DURATION = 3600.0

# Use old method (valid for paraffins only) for calculating the stoichiometric mass fraction
STOICH_MASS_FRAC_METHOD = 0

# Miller jet flame radiative fraction calculation method: 0 = Miller method; 2 = Sandia method
MILLER_FLAME_RAD_FRACTION_METHOD = 0

# Prefer Probit as the toxic calculation method, i.e. if probit data is available that will be the preferred method to use
TOXIC_PROBIT_METHOD = 1

# The absolute minimum temperature allowed for a user-defined source
UDS_MIN_TEMPERATURE = 11.0

# Absolute tolerance for radiation calculations
ABS_TOL_RAD = 0.0000000001

# Miller jet flame trajectory: 0 = Line segments; 1 = Curved line
MILLER_FLAME_TRAJECTORY = 0

# Atmospheric molecular weight (kg/kmol)
ATM_MOLWT = 28.9505

# Jet fire maximum exposure duration (s)
JET_FIRE_EXP_DUR = 20.0

# Reference height for wind speed
REF_HT_WIND_SPEED = 10.0

# Number of time steps for time-varying clouds used in explosion calculations
N_VTIMES_TV = 15

# Probit value B for radiation
RAD_PROBIT_B = 2.56

# Critical separation ratio for concentration grids
CRIT_SEP_RATIO = 0.2

# New standard method for modelling of instantaneous expansion
INEX_FLAG = 2

# Radiation intensity capping method: 0 = No capping; 1 = Max intensity capping; 2 = Stefan Boltzmann's law
MILLER_RAD_INTENSITY_CAP_METHOD = 2

# Flame shape adjusted if grounded for jet fires
ADJUST_GROUND_FLAME = 1

# The absolute maximum temperature allowed for a user-defined source
UDS_MAX_TEMPERATURE = 1200.0

# Atmospheric pressure (bar)
ATM_PRESSURE = 101325.0

# Roberts/TNO hybrid fireball model
FIREBALL_MODEL = 0

# Maximum number of components.
MAXIMUM_COMPONENT_COUNT = 20

# Calculate surface emissive power for fireballs
CALC_METHOD_SEP_FIREBALLS = -1

# Number of nodes on the pipe (start, end + intermediate)
PIPE_NODES_COUNT = 2

# Recommended jet fire correlation
JET_FIRE_CORRELATION = 0

# Unconfined explosion strength (Multi energy method)
UNCONFINED_EXPLOSION_STRENGTH = 2.0

# Fixed velocity capping method
MAX_VELOCITY_FLAG = 0

# Maximum surface emissive power for pool fires (W/m2)
MAX_SEP_POOL_FIRE = 350000.0

# Maximum temperature allowed for dispersion calculations (K)
MAXIMUM_TEMPERATURE_LIMIT = 1200.0

# Number of fixed size output steps for dispersion calculations
NUM_FIXED_STEPS = 20

# Number of steps in the downwind direction per explosion cloud view
NUM_X_VIEW = 21

# Mass modification factor used in calculating the mass of material involved in the fireball
MASS_MOD_FACTOR = 3.0

# Probit value A for radiation
RAD_PROBIT_A = -36.38

# Maximum number of leak diameters for scenario generation
MAXIMUM_LEAK_DIAMETERS_COUNT = 5

# Kinetic energy fraction of discharge expansion energy
FRACTION_TOTAL_TO_KINETIC = 0.04

# Centreline height is used for explosion calculations
REPORTING_HEIGHT_FLAG = 1

# Critical Webber number used in the droplet size calculations
CRIT_WEBER = 12.5

# Radiative fraction for general pool fires
RAD_FRAC_GENERAL = 0.4

# Minimum temperature allowed for dispersion calculations (K)
MINIMUM_TEMPERATURE_LIMIT = 11.0

# Number of integration points to use for multi-point sources: 30 by default
RADS_NUM_INTEGRATOR_POINTS = 30

# Use shape correlation for fireballs
USE_SHAPE_CORRELATION = -1

# DNV recommended atmospheric expansion method from orifice to final state
ATM_EXP_METHOD = 4

# Cut-off droplet diameter below which droplets are no longer modelled (m)
MIN_DROP_DIAMETER = 0.00000001

# Use mass between LFL and UFL for flammable mass estimation in explosion calculations
FLAMM_MASS_CALC_METHOD = 2

# Maximum number of steps in an iteration over PT space
MAXIMUM_PT_STEPS = 441

# Use volumes when specifying size of confined sources
USE_VOLUMES = 2

# Maximum surface emissive power for a jet fire (W/m2)
MAX_SEP_JET_FIRE = 350000.0

# Integration method for multi-point flame sources: 0 = Discrete; 1 = QSIMP; 2 = Gauss-Lobatto
RADS_INTEGRATOR_TYPE = 2

# Maximum integration step for dispersion calculations (s)
MAX_DISP_STEP_SIZE = 300.0

# Method for modelling crosswind effects for Miller model: 0 = modified Johnson approach; 1 = Full deflection
MILLER_CROSSWIND_METHOD = 0

# Toxics: minimum probability of death
TOXIC_MIN_LETHALITY = 0.001

# Product of each as the multi component toxic calculation method
TOXIC_MIX_CALC_METHOD = 3

# Number of time steps for continuous clouds used in explosion calculations
N_VTIMES_CONT = 5

# Velocity for jet fire calculations must be user supplied
USER_INPUT_POST_EXPANSION_VELOCITY = 0

# Jet fire rate modification factor
JET_RATE_MOD_FACTOR = 3.0

# Logarithmic wind profile
WIND_PROFILE_FLAG = 2

# Along wind diffusion method for non instantaneous dispersion
AWD_FLAG = 3

# Standard method for jet fire horizontal options
HORIZONTAL_OPTION = 0

# Maximum number of time steps for time varying releases
MAX_TIMESTEPS = 900

# Explosion efficiency for unconfined multi-energy explosions (%)
ME_EXPL_EFFICIENCY_UNCONFINED = 100.0

# Maximum number of weathers.
MAXIMUM_WEATHER_COUNT = 10

# Maximum number of time steps for explosion calculations
N_VTIMES_MAX = 100

# Flammable result grid step in x-direction (m)
RESULT_GRID_STEP = 10.0

# Flame temperature for TNO fireball model (K)
TNO_FLAME_TEMP = 2000.0

# Unconfined Multi-Energy explosion method
USER_DEFINED_CONFINED_EXPLOSION_METHOD_OPTION = 1

# LFL fraction used to define the flammable cloud for explosions
LFL_FRACTION_EXPLOSIONS = 0.5

# Modified CCPS droplet method
DROPLET_METHOD = 6

# Tail time for indoor toxic calculations (s)
TOXIC_TAIL_TIME = 1800.0

# Maximum release velocity (m/s)
MAX_VELOCITY = 100000000.0

# Maximum surface emissive power for fireballs (W/m2)
MAX_SEP_FIREBALL = 400000.0

# Minimum explosive mass (kg)
MIN_EXPL_MASS = 0.0

# The radiation level used for calculating radiation grids. The value is set equal to the lowest default radiation value present in the VesselLeak apps.
RAD_LEVEL_GRID = 1600.0

# Exclude solar radiation from radiation calculations
USE_SOLAR = 0

# Miller natural gas flow rate matching method: 0 = Miller (2017); 1 = DNV [similarity approach]
MILLER_NG_FLOWRATE_METHOD = 1

# Probit value N for radiation
RAD_PROBIT_N = 1.33

# Application constants.
PWS_CLIENT_ID = 'c02aee6b-4ab8-4fd8-9524-8bcd14617f1e'

# REST API URIs.
ANALYTICS_REST_API_URI = 'https://phastwebservices.dnv.com/api/analytics/v1/'
