# coding=utf-8
# Generated by Django 2.2.24 on 2021-10-19 20:57
"""
Lawrence McDaniel - https://lawrencemcdaniel.com
Oct-2021

Admin registration for openedx_plugin_cms
"""
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import opaque_keys.edx.django.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="CourseChangeLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "operation",
                    models.CharField(
                        choices=[("u", "Upsert"), ("d", "Delete")],
                        default="u",
                        max_length=1,
                    ),
                ),
                (
                    "location",
                    opaque_keys.edx.django.models.UsageKeyField(
                        db_index=True,
                        help_text=(
                            "Example:" " block-v1:edX+DemoX+Demo_Course+type@vertical+block@vertical_1fef54c2b23b"
                        ),
                        max_length=255,
                        verbose_name="Location Usage Key",
                    ),
                ),
                ("display_name", models.CharField(max_length=255)),
                ("ordinal_position", models.IntegerField(blank=True, null=True)),
                (
                    "publication_date",
                    models.DateTimeField(
                        blank=True,
                        help_text="block publication date for this course block",
                        null=True,
                        verbose_name="Publication Date",
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        blank=True,
                        help_text=(
                            "Example:"
                            " https://dev.engineplatform.co.uk/courses/course-v1:edX+DemoX+Demo_Course/jump_to/block-v1:edX+DemoX+Demo_Course+type@vertical+block@vertical_1fef54c2b23b"  # noqa: B950
                        ),
                        null=True,
                        verbose_name="LMS URL",
                    ),
                ),
                (
                    "visible",
                    models.BooleanField(default=True, verbose_name="Is Visible to Students"),
                ),
                (
                    "category",
                    models.CharField(
                        help_text="course, chapter, vertical, sequential, xblock",
                        max_length=255,
                        verbose_name="Block Category",
                    ),
                ),
                (
                    "course_id",
                    opaque_keys.edx.django.models.CourseKeyField(
                        db_index=True,
                        help_text="Example: course-v1:edX+DemoX+Demo_Course",
                        max_length=255,
                        verbose_name="course_id Course Key",
                    ),
                ),
                (
                    "parent_location",
                    opaque_keys.edx.django.models.UsageKeyField(blank=True, db_index=True, max_length=255, null=True),
                ),
                (
                    "parent_url",
                    models.URLField(
                        blank=True,
                        help_text=("The Usage Key for the Parent object in which this block is" " contained."),
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "chapter_location",
                    opaque_keys.edx.django.models.UsageKeyField(blank=True, db_index=True, max_length=255, null=True),
                ),
                (
                    "chapter_url",
                    models.URLField(
                        blank=True,
                        help_text=(
                            "The Usage Key for the Chapter in which this block is"
                            " contained. Example:"
                            " https://dev.engineplatform.co.uk/courses/course-v1:edX+DemoX+Demo_Course/jump_to_id/graded_interactions"  # noqa: B950
                        ),
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "sequential_location",
                    opaque_keys.edx.django.models.UsageKeyField(blank=True, db_index=True, max_length=255, null=True),
                ),
                (
                    "sequential_url",
                    models.URLField(
                        blank=True,
                        help_text=(  # noqa: B950
                            "The Usage Key for the Section in which this block is"
                            " contained. Example:"
                            " https://dev.engineplatform.co.uk/courses/course-v1:edX+DemoX+Demo_Course/jump_to_id/basic_questions"
                        ),
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "vertical_location",
                    opaque_keys.edx.django.models.UsageKeyField(blank=True, db_index=True, max_length=255, null=True),
                ),
                (
                    "vertical_url",
                    models.URLField(
                        blank=True,
                        help_text=(
                            "The Usage Key for the Vertical in which this block is"
                            " contained. Example:"
                            " https://dev.engineplatform.co.uk/courses/course-v1:edX+DemoX+Demo_Course/jump_to_id/vertical_d32bf9b2242c"  # noqa: B950
                        ),
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "edit_info",
                    models.CharField(
                        blank=True,
                        help_text="JSON dict of edit tracking info",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "source_version",
                    opaque_keys.edx.django.models.UsageKeyField(blank=True, max_length=255, null=True),
                ),
                (
                    "update_version",
                    opaque_keys.edx.django.models.UsageKeyField(
                        blank=True,
                        help_text=(  # noqa: B950
                            "Guid for the structure where this XBlock got its current"
                            " field values. May point to a structure not in this"
                            " structure's history (e.g., to a draft branch from which"
                            " this version was published)."
                        ),
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "previous_version",
                    opaque_keys.edx.django.models.UsageKeyField(
                        blank=True,
                        help_text=(  # noqa: B950
                            "Guid for the structure which previously changed this"
                            " XBlock. (Will be the previous value of 'update_version'.)"
                        ),
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "original_usage",
                    opaque_keys.edx.django.models.UsageKeyField(
                        blank=True,
                        help_text=(  # noqa: B950
                            "If this block has been copied from a library using"
                            " copy_from_template, points to the original block in the"
                            " library"
                        ),
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "original_usage_version",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("release_date", models.DateTimeField(blank=True, null=True)),
                (
                    "published_on",
                    models.DateTimeField(
                        blank=True,
                        help_text="Datetime when this XBlock was published.",
                        null=True,
                    ),
                ),
                (
                    "edited_on",
                    models.DateTimeField(
                        blank=True,
                        help_text="Datetime when this XBlock's fields last changed.",
                        null=True,
                    ),
                ),
                (
                    "edited_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="coursechangelog_edited_by",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "published_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="coursechangelog_published_by",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "unique_together": {("location", "publication_date")},
            },
        ),
    ]
