import { Stack } from '@aws-cdk/core';
import { SynthesisMessage } from '@aws-cdk/cx-api';
/**
 * Suite of assertions that can be run on a CDK Stack.
 *
 * Focused on asserting annotations.
 *
 * @stability stable
 */
export declare class Annotations {
    /**
     * Base your assertions on the messages returned by a synthesized CDK `Stack`.
     *
     * @param stack the CDK Stack to run assertions on.
     * @stability stable
     */
    static fromStack(stack: Stack): Annotations;
    private readonly _messages;
    private constructor();
    /**
     * Assert that an error with the given message exists in the synthesized CDK `Stack`.
     *
     * @param constructPath the construct path to the error.
     * @param message the error message as should be expected.
     * @stability stable
     */
    hasError(constructPath: string, message: any): void;
    /**
     * Get the set of matching errors of a given construct path and message.
     *
     * @param constructPath the construct path to the error.
     * @param message the error message as should be expected.
     * @stability stable
     */
    findError(constructPath: string, message: any): SynthesisMessage[];
    /**
     * Assert that an warning with the given message exists in the synthesized CDK `Stack`.
     *
     * @param constructPath the construct path to the warning.
     * @param message the warning message as should be expected.
     * @stability stable
     */
    hasWarning(constructPath: string, message: any): void;
    /**
     * Get the set of matching warning of a given construct path and message.
     *
     * @param constructPath the construct path to the warning.
     * @param message the warning message as should be expected.
     * @stability stable
     */
    findWarning(constructPath: string, message: any): SynthesisMessage[];
    /**
     * Assert that an info with the given message exists in the synthesized CDK `Stack`.
     *
     * @param constructPath the construct path to the info.
     * @param message the info message as should be expected.
     * @stability stable
     */
    hasInfo(constructPath: string, message: any): void;
    /**
     * Get the set of matching infos of a given construct path and message.
     *
     * @param constructPath the construct path to the info.
     * @param message the info message as should be expected.
     * @stability stable
     */
    findInfo(constructPath: string, message: any): SynthesisMessage[];
}
