# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['snektalk', 'snektalk.feat']

package_data = \
{'': ['*'], 'snektalk': ['assets/*', 'assets/scripts/*', 'assets/style/*']}

install_requires = \
['coleo>=0.2.2,<0.3.0',
 'hrepr>=0.3.11,<0.4.0',
 'jurigged>=0.3.1,<0.4.0',
 'ovld>=0.2.10,<0.3.0',
 'ptera>=0.3.3,<0.4.0',
 'sanic>=20.9.1,<21.0.0']

entry_points = \
{'console_scripts': ['sktk = snektalk.cli:main',
                     'snektalk = snektalk.cli:main']}

setup_kwargs = {
    'name': 'snektalk',
    'version': '0.0.12',
    'description': 'Advanced Python REPL',
    'long_description': '\n**Note:** This project is at a very early stage and no aspect of it should be considered stable before v0.1.0 is released.\n\n# S N E K T A L K\n\nSnektalk is a groundbreaking new kind of REPL.\n\n* Live code editing\n* Rich and interactive object representations\n* Built-in debugger\n* Connect to remote processes\n* Not another Jupyter clone\n\n# Install\n\n```bash\npip install snektalk\n```\n\n# Usage\n\nYou can simply use `snektalk` instead of `python` to run a script.\n\n```\nusage: snektalk [-h] [--connect VALUE] [-m VALUE] [--no-watch] [--port NUM]\n                [--socket VALUE] [--thread] [--version]\n                [SCRIPT] ...\n\npositional arguments:\n  SCRIPT                Path to the script to run\n  ARGV                  Script arguments\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --connect VALUE, -c VALUE\n                        Hostname to connect to an existing instance\n  -m VALUE              Module or module:function to run\n  --no-watch            Don\'t watch changes on the filesystem\n  --port NUM, -p NUM    Server port\n  --socket VALUE, -S VALUE\n                        Path to socket\n  --thread, -t          Run the program in a thread\n  --version             Show the version\n```\n\n# Features\n\nAt a glance Snektalk might appear similar to Jupyter notebooks, but it follows different paradigms. It has no "cells" and is meant to be used like a straightforward REPL or command line. At the same time, it has many features neither standard REPLs nor Jupyter tend to have.\n\n## Edit functions and data\n\nSimply type `/edit func` and you will be greeted with a small inline editor for the source code of `func`. You may change it and hit `Ctrl+Enter` to change it in the current process, or `Ctrl+Shift+Enter` to save it back into the original file it came from. You can come back to it at any time, of course.\n\n![edit](https://user-images.githubusercontent.com/599820/116953136-7c74de00-ac5a-11eb-9868-a53da72a1f5d.gif)\n\nVirtually *any* function can be edited, whether it is yours or comes from a third party library or even the standard library.\n\n`/edit` also works on data structures. You will be given an editable sandbox where you can change dictionaries, reorder lists, change the values of the fields of an object, and so on. Objects can even define a custom `__snek_edit__` method to control how they are edited.\n\n![edit-data](https://user-images.githubusercontent.com/599820/116953144-826abf00-ac5a-11eb-93b7-cfdcc46ac166.gif)\n\n## Rich and interactive representations\n\nSnektalk does not print lists, dictionaries or objects as mere text, but as rich HTML objects using [hrepr](https://github.com/breuleux/hrepr).\n\n![repr](https://user-images.githubusercontent.com/599820/116953095-5ea77900-ac5a-11eb-8091-5b27a3a795dc.gif)\n\n`Ctrl+Click` (or `Cmd+Click` on Mac) the representation of an object to put it in a temporary variable. This makes it very easy to test or play with objects that are deeply nested in another.\n\n![click](https://user-images.githubusercontent.com/599820/116953201-ac23e600-ac5a-11eb-9464-3aeccc9632d0.gif)\n\nRepresentations are highly customizable and recursive representations can be defined and configured in a snap. See [here](https://github.com/breuleux/hrepr#custom-representations) for how to define custom representations.\n\nThe representation of exceptions is particularly interesting because each frame is associated to a live editor, so you can simply fix the error right there as you see it.\n\n![exc](https://user-images.githubusercontent.com/599820/116953211-b34af400-ac5a-11eb-9d7e-37b51a7e955f.gif)\n\n## Visualization\n\nSnektalk supports elaborate visualizations: plots, graphs, and so on. Integrating a new or existing JavaScript library is mostly a matter of linking it from a CDN and writing a small wrapper.\n\n![plot](https://user-images.githubusercontent.com/599820/116953224-ba720200-ac5a-11eb-8a4e-aba17fb214bc.gif)\n\nIt is also easy to configure visualizations so that various interactions call Python callbacks. One great use of this feature is the ability to click on nodes or points in a graph to put the underlying data in a variable and paste it into the REPL\'s input box so that you can analyze it further.\n\n![graph](https://user-images.githubusercontent.com/599820/116955206-e2b02f80-ac5f-11eb-8474-dbdcd59cdd3a.gif)\n\n## Debugging\n\n`/debug f(x, y)` will enter a function call in debugger mode. Snektalk\'s debugger is quite similar to `pdb` and the usual `pdb` commands (`step`, `next`, `continue`, etc.) should work just the same.\n\n![debug](https://user-images.githubusercontent.com/599820/116955224-eba10100-ac5f-11eb-81a8-4b042718611b.gif)\n\n## Threads\n\n`/thread f(x, y)` will run `f(x, y)` in a separate thread, which lets you keep working while it\'s running. Each thread is given a mnemonic name so that you can easily `/kill` them.\n\n![thread](https://user-images.githubusercontent.com/599820/116955232-f0fe4b80-ac5f-11eb-8578-079f5e753052.gif)\n\nYou may use `snektalk -t` to start the main script in a thread, giving you immediate access to the REPL. This will allow you to inspect or fiddle with the global state while the script is running, among other things.\n\n# Using on a remote\n\nYou can run `snektalk` on a remote computer and connect to it over SSH. To do so, you will need to run two commands:\n\n**On remote side:**\n\nRun `snektalk` on the remote side with the `-S` option to connect to a UNIX socket on the filesystem. The interface will be served through that socket instead of a port.\n\n```bash\nuser@remote$ snektalk -S ~/sock/script.sock script.py\n```\n\n**On local computer:**\n\nOnce the remote process is running, run `snektalk` with the `-c` option to specify which host to connect to, and `-S` pointing to the socket file.\n\n```bash\nme@local$ snektalk -c user@remote -S sock/script.sock\n```\n\nThis will work for the whole duration of the remote process (note that the local Snektalk invocation doesn\'t do much more than invoke the right SSH command to forward the remote socket to a local port).\n\n**Note about compute nodes:** In order to facilitate use on clusters where the compute nodes may only be available through a connection to the login node, Snektalk will store the hostname in a separate file (`sock/script.host` in the above example) and will attempt to connect to it automatically. Therefore, you should be able to run `snektalk` on a compute node, then give the login node as the argument to `-c`, and Snektalk will use the login node as a jump host to connect to the right compute node.\n\n# Commands\n\n* `/debug expr` -- Debug an expression\n* `/dir expr` -- List all members of the object returned by the expression\n  * `?expr` -- Same as `/dir expr`\n* `/edit expr` -- Open an editor for the object returned by the expression\n* `/quit` -- Quit Snektalk\n* `/shell command` -- Run shell command\n  * `//command` -- Same as `/shell command`\n* `/status` -- List all the status messages received so far\n\n## Thread-related commands\n\n* `/attach thread` -- Switch to the REPL of the named thread (you can also click on the prompt to list the threads, then click on the one you want to attach)\n* `/detach` -- Undo last /attach\n* `/kill thread` -- Stop a named thread\n* `/thread expr` -- Run expression in new thread\n\n# Keyboard and mouse bindings\n\nNote: in what follows, `Cmd+X` means `Cmd+X` on MacOS and `Ctrl+X` on other platforms, unless otherwise specified.\n\n## Global bindings\n\n* `Cmd+P` -- Focus the REPL\n* `Cmd+Click` -- Put object in a variable\n* `Cmd+Alt+Click` -- Pin to the side\n\n## Repl\n\n* `Shift+Enter` -- Add new line in REPL without submitting\n* `Ctrl+Enter` -- Submit\n* `Up/Down` -- Go up/down in history (filtered by contents of REPL)\n* `Ctrl+R` -- Open history popup (fuzzy search)\n  * Note: `Shift-Up/Down` when history popup is active will select multiple entries\n* `Ctrl+L` -- Clear all scrollback\n* `Ctrl+C` (MacOS) -- Interrupt current command\n* `Cmd+K Cmd+K` -- Interrupt current command (that\'s `Cmd+K`, twice)\n* `Cmd+B`, `Cmd+Shift+B` -- Cycle through visible editors and REPL\n\n## Function editor\n\n* `Ctrl+Enter` -- Make live and focus REPL\n* `Ctrl+Shift+Enter` -- Make live, commit to file, and focus REPL\n* `Cmd+S` -- Make live\n* `Cmd+Shift+S` -- Make live and commit to file\n* `Cmd+B`, `Cmd+Shift+B` -- Cycle through visible editors and REPL\n\n# Misc\n\n* The status bar at the bottom can be clicked to view a list of all events\n* Click the prompt to reveal a thread selector; if you put a breakpoint in a function called by a different thread, you need to switch to that thread to interact with the breakpoint.\n',
    'author': 'Olivier Breuleux',
    'author_email': 'breuleux@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/breuleux/snektalk',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
