# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: headscale/v1/apikey.proto, headscale/v1/device.proto, headscale/v1/user.proto, headscale/v1/preauthkey.proto, headscale/v1/machine.proto, headscale/v1/routes.proto, headscale/v1/headscale.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import Dict, List, Optional

import betterproto
import grpclib


class RegisterMethod(betterproto.Enum):
    REGISTER_METHOD_UNSPECIFIED = 0
    REGISTER_METHOD_AUTH_KEY = 1
    REGISTER_METHOD_CLI = 2
    REGISTER_METHOD_OIDC = 3


@dataclass
class ApiKey(betterproto.Message):
    id: int = betterproto.uint64_field(1)
    prefix: str = betterproto.string_field(2)
    expiration: datetime = betterproto.message_field(3)
    created_at: datetime = betterproto.message_field(4)
    last_seen: datetime = betterproto.message_field(5)


@dataclass
class CreateApiKeyRequest(betterproto.Message):
    expiration: datetime = betterproto.message_field(1)


@dataclass
class CreateApiKeyResponse(betterproto.Message):
    api_key: str = betterproto.string_field(1)


@dataclass
class ExpireApiKeyRequest(betterproto.Message):
    prefix: str = betterproto.string_field(1)


@dataclass
class ExpireApiKeyResponse(betterproto.Message):
    pass


@dataclass
class ListApiKeysRequest(betterproto.Message):
    pass


@dataclass
class ListApiKeysResponse(betterproto.Message):
    api_keys: List["ApiKey"] = betterproto.message_field(1)


@dataclass
class Latency(betterproto.Message):
    latency_ms: float = betterproto.float_field(1)
    preferred: bool = betterproto.bool_field(2)


@dataclass
class ClientSupports(betterproto.Message):
    hair_pinning: bool = betterproto.bool_field(1)
    ipv6: bool = betterproto.bool_field(2)
    pcp: bool = betterproto.bool_field(3)
    pmp: bool = betterproto.bool_field(4)
    udp: bool = betterproto.bool_field(5)
    upnp: bool = betterproto.bool_field(6)


@dataclass
class ClientConnectivity(betterproto.Message):
    endpoints: List[str] = betterproto.string_field(1)
    derp: str = betterproto.string_field(2)
    mapping_varies_by_dest_ip: bool = betterproto.bool_field(3)
    latency: Dict[str, "Latency"] = betterproto.map_field(
        4, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    client_supports: "ClientSupports" = betterproto.message_field(5)


@dataclass
class GetDeviceRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class GetDeviceResponse(betterproto.Message):
    addresses: List[str] = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    user: str = betterproto.string_field(3)
    name: str = betterproto.string_field(4)
    hostname: str = betterproto.string_field(5)
    client_version: str = betterproto.string_field(6)
    update_available: bool = betterproto.bool_field(7)
    os: str = betterproto.string_field(8)
    created: datetime = betterproto.message_field(9)
    last_seen: datetime = betterproto.message_field(10)
    key_expiry_disabled: bool = betterproto.bool_field(11)
    expires: datetime = betterproto.message_field(12)
    authorized: bool = betterproto.bool_field(13)
    is_external: bool = betterproto.bool_field(14)
    machine_key: str = betterproto.string_field(15)
    node_key: str = betterproto.string_field(16)
    blocks_incoming_connections: bool = betterproto.bool_field(17)
    enabled_routes: List[str] = betterproto.string_field(18)
    advertised_routes: List[str] = betterproto.string_field(19)
    client_connectivity: "ClientConnectivity" = betterproto.message_field(20)


@dataclass
class DeleteDeviceRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class DeleteDeviceResponse(betterproto.Message):
    pass


@dataclass
class GetDeviceRoutesRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class GetDeviceRoutesResponse(betterproto.Message):
    enabled_routes: List[str] = betterproto.string_field(1)
    advertised_routes: List[str] = betterproto.string_field(2)


@dataclass
class EnableDeviceRoutesRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    routes: List[str] = betterproto.string_field(2)


@dataclass
class EnableDeviceRoutesResponse(betterproto.Message):
    enabled_routes: List[str] = betterproto.string_field(1)
    advertised_routes: List[str] = betterproto.string_field(2)


@dataclass
class User(betterproto.Message):
    id: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)
    created_at: datetime = betterproto.message_field(3)


@dataclass
class GetUserRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass
class GetUserResponse(betterproto.Message):
    user: "User" = betterproto.message_field(1)


@dataclass
class CreateUserRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass
class CreateUserResponse(betterproto.Message):
    user: "User" = betterproto.message_field(1)


@dataclass
class RenameUserRequest(betterproto.Message):
    old_name: str = betterproto.string_field(1)
    new_name: str = betterproto.string_field(2)


@dataclass
class RenameUserResponse(betterproto.Message):
    user: "User" = betterproto.message_field(1)


@dataclass
class DeleteUserRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass
class DeleteUserResponse(betterproto.Message):
    pass


@dataclass
class ListUsersRequest(betterproto.Message):
    pass


@dataclass
class ListUsersResponse(betterproto.Message):
    users: List["User"] = betterproto.message_field(1)


@dataclass
class PreAuthKey(betterproto.Message):
    user: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    key: str = betterproto.string_field(3)
    reusable: bool = betterproto.bool_field(4)
    ephemeral: bool = betterproto.bool_field(5)
    used: bool = betterproto.bool_field(6)
    expiration: datetime = betterproto.message_field(7)
    created_at: datetime = betterproto.message_field(8)
    acl_tags: List[str] = betterproto.string_field(9)


@dataclass
class CreatePreAuthKeyRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    reusable: bool = betterproto.bool_field(2)
    ephemeral: bool = betterproto.bool_field(3)
    expiration: datetime = betterproto.message_field(4)
    acl_tags: List[str] = betterproto.string_field(5)


@dataclass
class CreatePreAuthKeyResponse(betterproto.Message):
    pre_auth_key: "PreAuthKey" = betterproto.message_field(1)


@dataclass
class ExpirePreAuthKeyRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    key: str = betterproto.string_field(2)


@dataclass
class ExpirePreAuthKeyResponse(betterproto.Message):
    pass


@dataclass
class ListPreAuthKeysRequest(betterproto.Message):
    user: str = betterproto.string_field(1)


@dataclass
class ListPreAuthKeysResponse(betterproto.Message):
    pre_auth_keys: List["PreAuthKey"] = betterproto.message_field(1)


@dataclass
class Machine(betterproto.Message):
    id: int = betterproto.uint64_field(1)
    machine_key: str = betterproto.string_field(2)
    node_key: str = betterproto.string_field(3)
    disco_key: str = betterproto.string_field(4)
    ip_addresses: List[str] = betterproto.string_field(5)
    name: str = betterproto.string_field(6)
    user: "User" = betterproto.message_field(7)
    last_seen: datetime = betterproto.message_field(8)
    last_successful_update: datetime = betterproto.message_field(9)
    expiry: datetime = betterproto.message_field(10)
    pre_auth_key: "PreAuthKey" = betterproto.message_field(11)
    created_at: datetime = betterproto.message_field(12)
    register_method: "RegisterMethod" = betterproto.enum_field(13)
    forced_tags: List[str] = betterproto.string_field(18)
    invalid_tags: List[str] = betterproto.string_field(19)
    valid_tags: List[str] = betterproto.string_field(20)
    given_name: str = betterproto.string_field(21)
    online: bool = betterproto.bool_field(22)


@dataclass
class RegisterMachineRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    key: str = betterproto.string_field(2)


@dataclass
class RegisterMachineResponse(betterproto.Message):
    machine: "Machine" = betterproto.message_field(1)


@dataclass
class GetMachineRequest(betterproto.Message):
    machine_id: int = betterproto.uint64_field(1)


@dataclass
class GetMachineResponse(betterproto.Message):
    machine: "Machine" = betterproto.message_field(1)


@dataclass
class SetTagsRequest(betterproto.Message):
    machine_id: int = betterproto.uint64_field(1)
    tags: List[str] = betterproto.string_field(2)


@dataclass
class SetTagsResponse(betterproto.Message):
    machine: "Machine" = betterproto.message_field(1)


@dataclass
class DeleteMachineRequest(betterproto.Message):
    machine_id: int = betterproto.uint64_field(1)


@dataclass
class DeleteMachineResponse(betterproto.Message):
    pass


@dataclass
class ExpireMachineRequest(betterproto.Message):
    machine_id: int = betterproto.uint64_field(1)


@dataclass
class ExpireMachineResponse(betterproto.Message):
    machine: "Machine" = betterproto.message_field(1)


@dataclass
class RenameMachineRequest(betterproto.Message):
    machine_id: int = betterproto.uint64_field(1)
    new_name: str = betterproto.string_field(2)


@dataclass
class RenameMachineResponse(betterproto.Message):
    machine: "Machine" = betterproto.message_field(1)


@dataclass
class ListMachinesRequest(betterproto.Message):
    user: str = betterproto.string_field(1)


@dataclass
class ListMachinesResponse(betterproto.Message):
    machines: List["Machine"] = betterproto.message_field(1)


@dataclass
class MoveMachineRequest(betterproto.Message):
    machine_id: int = betterproto.uint64_field(1)
    user: str = betterproto.string_field(2)


@dataclass
class MoveMachineResponse(betterproto.Message):
    machine: "Machine" = betterproto.message_field(1)


@dataclass
class DebugCreateMachineRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    key: str = betterproto.string_field(2)
    name: str = betterproto.string_field(3)
    routes: List[str] = betterproto.string_field(4)


@dataclass
class DebugCreateMachineResponse(betterproto.Message):
    machine: "Machine" = betterproto.message_field(1)


@dataclass
class Route(betterproto.Message):
    id: int = betterproto.uint64_field(1)
    machine: "Machine" = betterproto.message_field(2)
    prefix: str = betterproto.string_field(3)
    advertised: bool = betterproto.bool_field(4)
    enabled: bool = betterproto.bool_field(5)
    is_primary: bool = betterproto.bool_field(6)
    created_at: datetime = betterproto.message_field(7)
    updated_at: datetime = betterproto.message_field(8)
    deleted_at: datetime = betterproto.message_field(9)


@dataclass
class GetRoutesRequest(betterproto.Message):
    pass


@dataclass
class GetRoutesResponse(betterproto.Message):
    routes: List["Route"] = betterproto.message_field(1)


@dataclass
class EnableRouteRequest(betterproto.Message):
    route_id: int = betterproto.uint64_field(1)


@dataclass
class EnableRouteResponse(betterproto.Message):
    pass


@dataclass
class DisableRouteRequest(betterproto.Message):
    route_id: int = betterproto.uint64_field(1)


@dataclass
class DisableRouteResponse(betterproto.Message):
    pass


@dataclass
class GetMachineRoutesRequest(betterproto.Message):
    machine_id: int = betterproto.uint64_field(1)


@dataclass
class GetMachineRoutesResponse(betterproto.Message):
    routes: List["Route"] = betterproto.message_field(1)


@dataclass
class DeleteRouteRequest(betterproto.Message):
    route_id: int = betterproto.uint64_field(1)


@dataclass
class DeleteRouteResponse(betterproto.Message):
    pass


class HeadscaleServiceStub(betterproto.ServiceStub):
    async def get_user(self, *, name: str = "") -> GetUserResponse:
        """--- User start ---"""

        request = GetUserRequest()
        request.name = name

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/GetUser",
            request,
            GetUserResponse,
        )

    async def create_user(self, *, name: str = "") -> CreateUserResponse:
        request = CreateUserRequest()
        request.name = name

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/CreateUser",
            request,
            CreateUserResponse,
        )

    async def rename_user(
        self, *, old_name: str = "", new_name: str = ""
    ) -> RenameUserResponse:
        request = RenameUserRequest()
        request.old_name = old_name
        request.new_name = new_name

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/RenameUser",
            request,
            RenameUserResponse,
        )

    async def delete_user(self, *, name: str = "") -> DeleteUserResponse:
        request = DeleteUserRequest()
        request.name = name

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/DeleteUser",
            request,
            DeleteUserResponse,
        )

    async def list_users(self) -> ListUsersResponse:
        request = ListUsersRequest()

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/ListUsers",
            request,
            ListUsersResponse,
        )

    async def create_pre_auth_key(
        self,
        *,
        user: str = "",
        reusable: bool = False,
        ephemeral: bool = False,
        expiration: Optional[datetime] = None,
        acl_tags: List[str] = [],
    ) -> CreatePreAuthKeyResponse:
        """--- PreAuthKeys start ---"""

        request = CreatePreAuthKeyRequest()
        request.user = user
        request.reusable = reusable
        request.ephemeral = ephemeral
        if expiration is not None:
            request.expiration = expiration
        request.acl_tags = acl_tags

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/CreatePreAuthKey",
            request,
            CreatePreAuthKeyResponse,
        )

    async def expire_pre_auth_key(
        self, *, user: str = "", key: str = ""
    ) -> ExpirePreAuthKeyResponse:
        request = ExpirePreAuthKeyRequest()
        request.user = user
        request.key = key

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/ExpirePreAuthKey",
            request,
            ExpirePreAuthKeyResponse,
        )

    async def list_pre_auth_keys(self, *, user: str = "") -> ListPreAuthKeysResponse:
        request = ListPreAuthKeysRequest()
        request.user = user

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/ListPreAuthKeys",
            request,
            ListPreAuthKeysResponse,
        )

    async def debug_create_machine(
        self, *, user: str = "", key: str = "", name: str = "", routes: List[str] = []
    ) -> DebugCreateMachineResponse:
        """--- Machine start ---"""

        request = DebugCreateMachineRequest()
        request.user = user
        request.key = key
        request.name = name
        request.routes = routes

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/DebugCreateMachine",
            request,
            DebugCreateMachineResponse,
        )

    async def get_machine(self, *, machine_id: int = 0) -> GetMachineResponse:
        request = GetMachineRequest()
        request.machine_id = machine_id

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/GetMachine",
            request,
            GetMachineResponse,
        )

    async def set_tags(
        self, *, machine_id: int = 0, tags: List[str] = []
    ) -> SetTagsResponse:
        request = SetTagsRequest()
        request.machine_id = machine_id
        request.tags = tags

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/SetTags",
            request,
            SetTagsResponse,
        )

    async def register_machine(
        self, *, user: str = "", key: str = ""
    ) -> RegisterMachineResponse:
        request = RegisterMachineRequest()
        request.user = user
        request.key = key

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/RegisterMachine",
            request,
            RegisterMachineResponse,
        )

    async def delete_machine(self, *, machine_id: int = 0) -> DeleteMachineResponse:
        request = DeleteMachineRequest()
        request.machine_id = machine_id

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/DeleteMachine",
            request,
            DeleteMachineResponse,
        )

    async def expire_machine(self, *, machine_id: int = 0) -> ExpireMachineResponse:
        request = ExpireMachineRequest()
        request.machine_id = machine_id

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/ExpireMachine",
            request,
            ExpireMachineResponse,
        )

    async def rename_machine(
        self, *, machine_id: int = 0, new_name: str = ""
    ) -> RenameMachineResponse:
        request = RenameMachineRequest()
        request.machine_id = machine_id
        request.new_name = new_name

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/RenameMachine",
            request,
            RenameMachineResponse,
        )

    async def list_machines(self, *, user: str = "") -> ListMachinesResponse:
        request = ListMachinesRequest()
        request.user = user

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/ListMachines",
            request,
            ListMachinesResponse,
        )

    async def move_machine(
        self, *, machine_id: int = 0, user: str = ""
    ) -> MoveMachineResponse:
        request = MoveMachineRequest()
        request.machine_id = machine_id
        request.user = user

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/MoveMachine",
            request,
            MoveMachineResponse,
        )

    async def get_routes(self) -> GetRoutesResponse:
        """--- Route start ---"""

        request = GetRoutesRequest()

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/GetRoutes",
            request,
            GetRoutesResponse,
        )

    async def enable_route(self, *, route_id: int = 0) -> EnableRouteResponse:
        request = EnableRouteRequest()
        request.route_id = route_id

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/EnableRoute",
            request,
            EnableRouteResponse,
        )

    async def disable_route(self, *, route_id: int = 0) -> DisableRouteResponse:
        request = DisableRouteRequest()
        request.route_id = route_id

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/DisableRoute",
            request,
            DisableRouteResponse,
        )

    async def get_machine_routes(
        self, *, machine_id: int = 0
    ) -> GetMachineRoutesResponse:
        request = GetMachineRoutesRequest()
        request.machine_id = machine_id

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/GetMachineRoutes",
            request,
            GetMachineRoutesResponse,
        )

    async def delete_route(self, *, route_id: int = 0) -> DeleteRouteResponse:
        request = DeleteRouteRequest()
        request.route_id = route_id

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/DeleteRoute",
            request,
            DeleteRouteResponse,
        )

    async def create_api_key(
        self, *, expiration: Optional[datetime] = None
    ) -> CreateApiKeyResponse:
        """--- ApiKeys start ---"""

        request = CreateApiKeyRequest()
        if expiration is not None:
            request.expiration = expiration

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/CreateApiKey",
            request,
            CreateApiKeyResponse,
        )

    async def expire_api_key(self, *, prefix: str = "") -> ExpireApiKeyResponse:
        request = ExpireApiKeyRequest()
        request.prefix = prefix

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/ExpireApiKey",
            request,
            ExpireApiKeyResponse,
        )

    async def list_api_keys(self) -> ListApiKeysResponse:
        request = ListApiKeysRequest()

        return await self._unary_unary(
            "/headscale.v1.HeadscaleService/ListApiKeys",
            request,
            ListApiKeysResponse,
        )
