# Generated by Django 2.2.9 on 2020-11-02 20:21

from django.db import migrations, models

from ..utils import PageTree


def fix_page_tree(apps, schema_editor):
    Page = apps.get_model('pages', 'Page')
    db_alias = schema_editor.connection.alias
    pages_not_canonical = Page.objects.using(db_alias).filter(models.Q(left__isnull=False) | models.Q(right__isnull=False), models.Q(owner_id__isnull=False) | models.Q(version_for_id__isnull=False))
    for page in pages_not_canonical:
        print(page, f'left: {page.left}, right: {page.right}')
    print(pages_not_canonical.count(), 'non-canonical pages in the MPTT tree.')
    pages_not_canonical.update(left=None, right=None)
    print('Resetting MPTT attributes for canonical pages.')
    homepage = Page.objects.using(db_alias).filter(models.Q(owner_id__isnull=True) & models.Q(version_for_id__isnull=True), parent=None).first()
    if homepage:
        tree = PageTree(homepage, model=Page, db_alias=db_alias, child_filter=models.Q(owner_id__isnull=True) & models.Q(version_for_id__isnull=True))
        tree.set_page_attrs()
        Page.objects.bulk_update(tree.get_pages_flat(), ['left', 'right'])


class Migration(migrations.Migration):

    dependencies = [
        ('pages', '0015_auto_20201102_1250'),
    ]

    operations = [
        migrations.RunPython(
            fix_page_tree,
        ),
        migrations.AddConstraint(
            model_name='page',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('version_for_id__isnull', False), ('left__isnull', True), ('right__isnull', True)), ('version_for_id__isnull', True), _connector='OR'), name='versions_not_in_page_tree'),
        ),
        migrations.AddConstraint(
            model_name='page',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('owner_id__isnull', False), ('left__isnull', True), ('right__isnull', True)), ('owner_id__isnull', True), _connector='OR'), name='translations_not_in_page_tree'),
        ),
        migrations.AddConstraint(
            model_name='page',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('version_for_id__isnull', True), ('owner_id__isnull', True), ('left__isnull', False), ('right__isnull', False)), ('version_for_id__isnull', False), ('owner_id__isnull', False), _connector='OR'), name='page_mptt_values'),
        ),
    ]
