# Novra S400

The Novra S400 is a standalone demodulator, which will receive data from
satellite and output IP packets to the host over the network. Hence, you will
need to configure both the S400 and the host.

<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-generate-toc again -->
**Table of Contents**

- [Novra S400](#novra-s400)
    - [Connections](#connections)
    - [S400's web user interface (UI)](#s400s-web-user-interface-ui)
    - [S400 FW Version](#s400-fw-version)
    - [S400 Configurations](#s400-configurations)
    - [Host Configuration](#host-configuration)
    - [Next Steps](#next-steps)

<!-- markdown-toc end -->

## Connections

The Novra S400 can be connected as follows:

![S400 Connections](img/standalone_connections.png?raw=true "S400 Connections")

- Connect the LNB directly to interface RF1 of the S400 using a coaxial cable
  (an RG6 cable is recommended).
- Connect the S400's LAN1 interface to your computer or network.

## S400's web user interface (UI)

Next, you need to access the web UI of the S400:

- Configure you host's network interface to the same subnet as the
  S400. By default, the S400 is configured with IP address 192.168.1.2
  on LAN1 and 192.168.2.2 on LAN2. So, if you are connecting to LAN1,
  make sure your host's network interface has IP address 192.168.1.x,
  where "x" could be any number higher than 2. For example, you could
  configure your host's network interface with IP address 192.168.1.3.
- From your browser, access 192.168.1.2 (or 192.168.2.2 if connected
  to LAN 2).
- The web management console should open.

## S400 FW Version

In the web UI, go to `System > About`:
Confirm that the version of the Configuration Agent is 1.6.1 or higher.


## S400 Configurations

Some configurations depend on your specific setup. To obtain detailed
instructions, please run the instructions helper as follows:

```
blocksat-cli instructions
```

The configuration helper will print out the instructions that follow, but with
the specific parameters that are needed for your setup.

1. First you need to log in as admin, on the top right of the page.
- Default password: "password"

2. Go to `Interfaces > RF1` and configure as follows:

- DVB Mode: "DVB-S2"

Next, configure the LNB parameters at the bottom of the page:

- LNB Power On: Enable
- L.O. Frequency: your LNB's local oscillator (LO) frequency in MHz
- Polarization: the polarization (horizontal or vertical) of the [satellite that covers your location](https://blockstream.com/satellite/#satellite_network-coverage).
- Band (Tone): "Low/Off" by default. Set to "High/On" only when using a Universal LNB and receiving from [Ku High Band](frequency.md).
- Long Line Compensation: Disabled

After that, configure the DVB Signal Parameters:
- Carrier Freq.: [frequency of the satellite that covers your location, in MHz](frequency.md)
- LBand: leave it with the auto-filled value<sup>*</sup>
- Symbol Rate: 1.0 MBaud
- MODCOD: VCM
- Gold Code: 0
- Input Stream ID: 0

> <sup>*</sup> The L-band frequency is defined automatically once you inform
> both the **L.O. Frequency** and the **Carrier Freq**.

Then click **Apply**.

3. Verify that the S400 is locked to Blockstream Satellite's signal
- Check the "RF 1 Lock" indicator at the top of the page or the status
  LED in the S400's front panel. It should be green (locked) if your
  antenna is already pointed correctly. If not, you can work on the
  antenna pointing afterwards.

4. Go to Services > Tun1:

Scroll to "Manage MPE PIDs"
- Enter 32 on "New PID" and click "Add".
- Enter 33 on "New PID" and click "Add".
- Apply

** Optional configurations:
- If you prefer to use another IP address on LAN1 or LAN2, go to
  Interfaces > Data (LAN1) or Interfaces > M&C (LAN2) and configure
  the IP addresses. Note LAN 1 is the interface that will deliver the
  data packets received over satellite, whereas LAN2 is optional and
  exclusively for management.

## Host Configuration

In order to receive the traffic from the S400, you will need some networking
configurations on your host. Such configurations are indicated and executed by
running:

```
blocksat-cli standalone -i ifname
```

where 'ifname' should be replaced with the name of the host's network interface
that is connected to the S400.

## Next Steps

At this point, if your dish is already correctly pointed, you should be able to
start receiving data on Bitcoin Satellite. Please follow the [instructions for
Bitcoin Satellite configuration](bitcoin.md). If your antenna is not pointed
yet, please follow the [antenna alignment guide](antenna-pointing.md).

