###########################################################################
#
#  Copyright 2020 Google LLC
#
#  Licensed under the Apache License, Version 2.0 (the "License"  "");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      https://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
###########################################################################

"""Object used to generate BigQuery table for mapping US geography.

This object in table form allows joins and expansion of gographic
regions within the US. Unfortunately some Postal Codes map to multiple
DMAs in this implementation.

See: https://blog.cubitplanning.com/2015/05/current-census-demographics-by-dma/

"""

US_GEOGRAPHY_SCHEMA = [
  {"name":"Postal_Code", "type":"INTEGER", "mode":"REQUIRED"},
  {"name":"FIPS", "type":"STRING", "mode":"REQUIRED"},
  {"name":"County", "type":"STRING", "mode":"REQUIRED"},
  {"name":"State", "type":"STRING", "mode":"REQUIRED"},
  {"name":"DMA", "type":"RECORD", "mode":"REQUIRED", "fields":[
    {"name":"Code", "type":"INTEGER", "mode":"NULLABLE"},
    {"name":"Name", "type":"STRING", "mode":"NULLABLE"}
  ]}
]

US_GEOGRAPHY_DATA = [
  {"Postal_Code": "36003", "FIPS": "01001", "County": "Autauga", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36006", "FIPS": "01001", "County": "Autauga", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36008", "FIPS": "01001", "County": "Autauga", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36051", "FIPS": "01001", "County": "Autauga", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36066", "FIPS": "01001", "County": "Autauga", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36067", "FIPS": "01001", "County": "Autauga", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36068", "FIPS": "01001", "County": "Autauga", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36749", "FIPS": "01001", "County": "Autauga", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36507", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36511", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36526", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36527", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36530", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36532", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36533", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36535", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36536", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36542", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36547", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36549", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36550", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36551", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36555", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36559", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36561", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36562", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36564", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36567", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36574", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36576", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36577", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36578", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36579", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36580", "FIPS": "01003", "County": "Baldwin", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36016", "FIPS": "01005", "County": "Barbour", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36017", "FIPS": "01005", "County": "Barbour", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36027", "FIPS": "01005", "County": "Barbour", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36048", "FIPS": "01005", "County": "Barbour", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36053", "FIPS": "01005", "County": "Barbour", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36072", "FIPS": "01005", "County": "Barbour", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "35034", "FIPS": "01007", "County": "Bibb", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35035", "FIPS": "01007", "County": "Bibb", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35042", "FIPS": "01007", "County": "Bibb", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35074", "FIPS": "01007", "County": "Bibb", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35184", "FIPS": "01007", "County": "Bibb", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35188", "FIPS": "01007", "County": "Bibb", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36792", "FIPS": "01007", "County": "Bibb", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36793", "FIPS": "01007", "County": "Bibb", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35013", "FIPS": "01009", "County": "Blount", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35031", "FIPS": "01009", "County": "Blount", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35049", "FIPS": "01009", "County": "Blount", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35079", "FIPS": "01009", "County": "Blount", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35097", "FIPS": "01009", "County": "Blount", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35121", "FIPS": "01009", "County": "Blount", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35133", "FIPS": "01009", "County": "Blount", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35172", "FIPS": "01009", "County": "Blount", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36029", "FIPS": "01011", "County": "Bullock", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36061", "FIPS": "01011", "County": "Bullock", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36089", "FIPS": "01011", "County": "Bullock", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36015", "FIPS": "01013", "County": "Butler", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36030", "FIPS": "01013", "County": "Butler", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36033", "FIPS": "01013", "County": "Butler", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36037", "FIPS": "01013", "County": "Butler", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36456", "FIPS": "01013", "County": "Butler", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36201", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36202", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36203", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36204", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36205", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36206", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36207", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36210", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36250", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36253", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36254", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36257", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36260", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36265", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36271", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36272", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36277", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36279", "FIPS": "01015", "County": "Calhoun", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36854", "FIPS": "01017", "County": "Chambers", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36855", "FIPS": "01017", "County": "Chambers", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36862", "FIPS": "01017", "County": "Chambers", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36863", "FIPS": "01017", "County": "Chambers", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "35959", "FIPS": "01019", "County": "Cherokee", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35960", "FIPS": "01019", "County": "Cherokee", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35973", "FIPS": "01019", "County": "Cherokee", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35983", "FIPS": "01019", "County": "Cherokee", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36275", "FIPS": "01019", "County": "Cherokee", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35045", "FIPS": "01021", "County": "Chilton", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35046", "FIPS": "01021", "County": "Chilton", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35085", "FIPS": "01021", "County": "Chilton", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35171", "FIPS": "01021", "County": "Chilton", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36091", "FIPS": "01021", "County": "Chilton", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36750", "FIPS": "01021", "County": "Chilton", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36790", "FIPS": "01021", "County": "Chilton", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36904", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36908", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36910", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36912", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36913", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36915", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36916", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36919", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36921", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36922", "FIPS": "01023", "County": "Choctaw", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36436", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36446", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36451", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36482", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36501", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36515", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36524", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36540", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36545", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36727", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36762", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36784", "FIPS": "01025", "County": "Clarke", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "35082", "FIPS": "01027", "County": "Clay", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36251", "FIPS": "01027", "County": "Clay", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36255", "FIPS": "01027", "County": "Clay", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36258", "FIPS": "01027", "County": "Clay", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36266", "FIPS": "01027", "County": "Clay", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36267", "FIPS": "01027", "County": "Clay", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36261", "FIPS": "01029", "County": "Cleburne", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36262", "FIPS": "01029", "County": "Cleburne", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36264", "FIPS": "01029", "County": "Cleburne", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36269", "FIPS": "01029", "County": "Cleburne", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36273", "FIPS": "01029", "County": "Cleburne", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36323", "FIPS": "01031", "County": "Coffee", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36330", "FIPS": "01031", "County": "Coffee", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36331", "FIPS": "01031", "County": "Coffee", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36346", "FIPS": "01031", "County": "Coffee", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36351", "FIPS": "01031", "County": "Coffee", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36453", "FIPS": "01031", "County": "Coffee", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "35616", "FIPS": "01033", "County": "Colbert", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35646", "FIPS": "01033", "County": "Colbert", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35660", "FIPS": "01033", "County": "Colbert", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35661", "FIPS": "01033", "County": "Colbert", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35662", "FIPS": "01033", "County": "Colbert", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35674", "FIPS": "01033", "County": "Colbert", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "36401", "FIPS": "01035", "County": "Conecuh", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36429", "FIPS": "01035", "County": "Conecuh", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36432", "FIPS": "01035", "County": "Conecuh", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36454", "FIPS": "01035", "County": "Conecuh", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36473", "FIPS": "01035", "County": "Conecuh", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36475", "FIPS": "01035", "County": "Conecuh", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "35072", "FIPS": "01037", "County": "Coosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35089", "FIPS": "01037", "County": "Coosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35136", "FIPS": "01037", "County": "Coosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35183", "FIPS": "01037", "County": "Coosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36026", "FIPS": "01037", "County": "Coosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36038", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36420", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36421", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36442", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36455", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36467", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36474", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36476", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36483", "FIPS": "01039", "County": "Covington", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36009", "FIPS": "01041", "County": "Crenshaw", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36028", "FIPS": "01041", "County": "Crenshaw", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36034", "FIPS": "01041", "County": "Crenshaw", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36041", "FIPS": "01041", "County": "Crenshaw", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36042", "FIPS": "01041", "County": "Crenshaw", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36049", "FIPS": "01041", "County": "Crenshaw", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36062", "FIPS": "01041", "County": "Crenshaw", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36071", "FIPS": "01041", "County": "Crenshaw", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35019", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35033", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35053", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35055", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35056", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35057", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35058", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35070", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35077", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35083", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35087", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35098", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35179", "FIPS": "01043", "County": "Cullman", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36311", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36322", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36350", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36352", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36360", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36361", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36362", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36371", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36374", "FIPS": "01045", "County": "Dale", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36701", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36702", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36703", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36758", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36759", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36761", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36767", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36773", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36775", "FIPS": "01047", "County": "Dallas", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35961", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35962", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35963", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35967", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35968", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35971", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35974", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35975", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35978", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35981", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35984", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35986", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35988", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35989", "FIPS": "01049", "County": "De Kalb", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "36020", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36022", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36024", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36025", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36045", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36054", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36078", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36080", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36092", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36093", "FIPS": "01051", "County": "Elmore", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36426", "FIPS": "01053", "County": "Escambia", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36427", "FIPS": "01053", "County": "Escambia", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36441", "FIPS": "01053", "County": "Escambia", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36502", "FIPS": "01053", "County": "Escambia", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36503", "FIPS": "01053", "County": "Escambia", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36504", "FIPS": "01053", "County": "Escambia", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36543", "FIPS": "01053", "County": "Escambia", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "35901", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35902", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35903", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35904", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35905", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35906", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35907", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35952", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35954", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35956", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35972", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35990", "FIPS": "01055", "County": "Etowah", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35542", "FIPS": "01057", "County": "Fayette", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35545", "FIPS": "01057", "County": "Fayette", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35546", "FIPS": "01057", "County": "Fayette", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35555", "FIPS": "01057", "County": "Fayette", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35559", "FIPS": "01057", "County": "Fayette", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35571", "FIPS": "01059", "County": "Franklin", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35581", "FIPS": "01059", "County": "Franklin", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35582", "FIPS": "01059", "County": "Franklin", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35585", "FIPS": "01059", "County": "Franklin", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35593", "FIPS": "01059", "County": "Franklin", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35653", "FIPS": "01059", "County": "Franklin", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35654", "FIPS": "01059", "County": "Franklin", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "36313", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36314", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36316", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36318", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36340", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36344", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36349", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36375", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36477", "FIPS": "01061", "County": "Geneva", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "35443", "FIPS": "01063", "County": "Greene", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35448", "FIPS": "01063", "County": "Greene", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35462", "FIPS": "01063", "County": "Greene", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35469", "FIPS": "01063", "County": "Greene", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35491", "FIPS": "01063", "County": "Greene", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36740", "FIPS": "01063", "County": "Greene", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35441", "FIPS": "01065", "County": "Hale", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35474", "FIPS": "01065", "County": "Hale", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36744", "FIPS": "01065", "County": "Hale", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36765", "FIPS": "01065", "County": "Hale", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36776", "FIPS": "01065", "County": "Hale", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36310", "FIPS": "01067", "County": "Henry", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36317", "FIPS": "01067", "County": "Henry", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36345", "FIPS": "01067", "County": "Henry", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36353", "FIPS": "01067", "County": "Henry", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36373", "FIPS": "01067", "County": "Henry", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36301", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36302", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36303", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36304", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36305", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36312", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36319", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36320", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36321", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36343", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36370", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "36376", "FIPS": "01069", "County": "Houston", "State": "AL", "DMA": {"Code": 606, "Name": "DOTHAN"}},
  {"Postal_Code": "35740", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35744", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35745", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35746", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35751", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35752", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35755", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35764", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35765", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35766", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35768", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35769", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35771", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35772", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35774", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35776", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35958", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35966", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35979", "FIPS": "01071", "County": "Jackson", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35005", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35006", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35015", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35020", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35021", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35022", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35023", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35036", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35041", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35048", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35060", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35061", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35062", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35064", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35068", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35071", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35073", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35091", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35094", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35111", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35116", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35117", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35118", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35119", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35123", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35126", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35127", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35139", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35142", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35173", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35180", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35181", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35201", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35202", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35203", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35204", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35205", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35206", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35207", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35208", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35209", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35210", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35211", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35212", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35213", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35214", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35215", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35216", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35217", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35218", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35219", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35220", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35221", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35222", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35223", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35224", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35225", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35226", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35228", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35229", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35230", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35231", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35232", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35233", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35234", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35235", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35236", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35237", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35238", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35240", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35243", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35244", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35245", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35246", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35249", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35253", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35254", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35255", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35259", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35260", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35261", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35263", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35266", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35277", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35278", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35279", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35280", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35281", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35282", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35283", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35285", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35286", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35287", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35288", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35289", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35290", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35291", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35292", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35293", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35294", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35295", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35296", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35297", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35298", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35299", "FIPS": "01073", "County": "Jefferson", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35544", "FIPS": "01075", "County": "Lamar", "State": "AL", "DMA": {"Code": 673, "Name": "COLUMBUS-TUPELO-WEST POINT"}},
  {"Postal_Code": "35552", "FIPS": "01075", "County": "Lamar", "State": "AL", "DMA": {"Code": 673, "Name": "COLUMBUS-TUPELO-WEST POINT"}},
  {"Postal_Code": "35574", "FIPS": "01075", "County": "Lamar", "State": "AL", "DMA": {"Code": 673, "Name": "COLUMBUS-TUPELO-WEST POINT"}},
  {"Postal_Code": "35576", "FIPS": "01075", "County": "Lamar", "State": "AL", "DMA": {"Code": 673, "Name": "COLUMBUS-TUPELO-WEST POINT"}},
  {"Postal_Code": "35586", "FIPS": "01075", "County": "Lamar", "State": "AL", "DMA": {"Code": 673, "Name": "COLUMBUS-TUPELO-WEST POINT"}},
  {"Postal_Code": "35592", "FIPS": "01075", "County": "Lamar", "State": "AL", "DMA": {"Code": 673, "Name": "COLUMBUS-TUPELO-WEST POINT"}},
  {"Postal_Code": "35610", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35617", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35630", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35631", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35632", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35633", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35634", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35645", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35648", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35652", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35677", "FIPS": "01077", "County": "Lauderdale", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35618", "FIPS": "01079", "County": "Lawrence", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35643", "FIPS": "01079", "County": "Lawrence", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35650", "FIPS": "01079", "County": "Lawrence", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35651", "FIPS": "01079", "County": "Lawrence", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35672", "FIPS": "01079", "County": "Lawrence", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "36801", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36802", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36803", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36804", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36830", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36831", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36832", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36849", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36852", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36865", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36870", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36872", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36874", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36877", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36879", "FIPS": "01081", "County": "Lee", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "35611", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35612", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35613", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35614", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35615", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35620", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35647", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35649", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35671", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35739", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35742", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35756", "FIPS": "01083", "County": "Limestone", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "36032", "FIPS": "01085", "County": "Lowndes", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36040", "FIPS": "01085", "County": "Lowndes", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36047", "FIPS": "01085", "County": "Lowndes", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36752", "FIPS": "01085", "County": "Lowndes", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36785", "FIPS": "01085", "County": "Lowndes", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36031", "FIPS": "01087", "County": "Macon", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36039", "FIPS": "01087", "County": "Macon", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36075", "FIPS": "01087", "County": "Macon", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36083", "FIPS": "01087", "County": "Macon", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36087", "FIPS": "01087", "County": "Macon", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36088", "FIPS": "01087", "County": "Macon", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36866", "FIPS": "01087", "County": "Macon", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35741", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35748", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35749", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35750", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35757", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35758", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35759", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35760", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35761", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35762", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35763", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35767", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35773", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35801", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35802", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35803", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35804", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35805", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35806", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35807", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35808", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35809", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35810", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35811", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35812", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35813", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35814", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35815", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35816", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35824", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35893", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35894", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35895", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35896", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35897", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35898", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35899", "FIPS": "01089", "County": "Madison", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "36732", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36736", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36738", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36742", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36745", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36748", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36754", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36763", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36764", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36782", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36783", "FIPS": "01091", "County": "Marengo", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35543", "FIPS": "01093", "County": "Marion", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35548", "FIPS": "01093", "County": "Marion", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35563", "FIPS": "01093", "County": "Marion", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35564", "FIPS": "01093", "County": "Marion", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35570", "FIPS": "01093", "County": "Marion", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35594", "FIPS": "01093", "County": "Marion", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35016", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35175", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35747", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35950", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35951", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35957", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35964", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35976", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35980", "FIPS": "01095", "County": "Marshall", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "36505", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36509", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36512", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36521", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36522", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36523", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36525", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36528", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36541", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36544", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36560", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36568", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36571", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36572", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36575", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36582", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36587", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36590", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36601", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36602", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36603", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36604", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36605", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36606", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36607", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36608", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36609", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36610", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36611", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36612", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36613", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36615", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36616", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36617", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36618", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36619", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36621", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36622", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36625", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36628", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36630", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36633", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36640", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36641", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36644", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36652", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36660", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36663", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36670", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36671", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36675", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36685", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36688", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36689", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36690", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36691", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36693", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36695", "FIPS": "01097", "County": "Mobile", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36425", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36439", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36444", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36445", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36449", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36457", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36458", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36460", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36461", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36462", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36470", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36471", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36480", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36481", "FIPS": "01099", "County": "Monroe", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36013", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36036", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36043", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36046", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36052", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36057", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36064", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36065", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36069", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36101", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36102", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36103", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36104", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36105", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36106", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36107", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36108", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36109", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36110", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36111", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36112", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36113", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36114", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36115", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36116", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36117", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36118", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36119", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36120", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36121", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36123", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36124", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36125", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36130", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36131", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36132", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36133", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36134", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36135", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36140", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36141", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36142", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36177", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36191", "FIPS": "01101", "County": "Montgomery", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35601", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35602", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35603", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35609", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35619", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35621", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35622", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35640", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35670", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35673", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35699", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35754", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "35775", "FIPS": "01103", "County": "Morgan", "State": "AL", "DMA": {"Code": 691, "Name": "HUNTSVILLE-DECATUR-FLORENCE"}},
  {"Postal_Code": "36756", "FIPS": "01105", "County": "Perry", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36786", "FIPS": "01105", "County": "Perry", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35442", "FIPS": "01107", "County": "Pickens", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35447", "FIPS": "01107", "County": "Pickens", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35461", "FIPS": "01107", "County": "Pickens", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35466", "FIPS": "01107", "County": "Pickens", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35471", "FIPS": "01107", "County": "Pickens", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35481", "FIPS": "01107", "County": "Pickens", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36005", "FIPS": "01109", "County": "Pike", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36010", "FIPS": "01109", "County": "Pike", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36035", "FIPS": "01109", "County": "Pike", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36079", "FIPS": "01109", "County": "Pike", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36081", "FIPS": "01109", "County": "Pike", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36082", "FIPS": "01109", "County": "Pike", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36263", "FIPS": "01111", "County": "Randolph", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36274", "FIPS": "01111", "County": "Randolph", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36276", "FIPS": "01111", "County": "Randolph", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36278", "FIPS": "01111", "County": "Randolph", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36280", "FIPS": "01111", "County": "Randolph", "State": "AL", "DMA": {"Code": 524, "Name": "ATLANTA"}},
  {"Postal_Code": "36851", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36856", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36858", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36859", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36860", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36867", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36868", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36869", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36871", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "36875", "FIPS": "01113", "County": "Russell", "State": "AL", "DMA": {"Code": 522, "Name": "COLUMBUS, GA"}},
  {"Postal_Code": "35004", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35052", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35054", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35112", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35120", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35125", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35128", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35131", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35135", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35146", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35182", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35953", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35987", "FIPS": "01115", "County": "Saint Clair", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35007", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35040", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35043", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35051", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35078", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35080", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35114", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35115", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35124", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35137", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35143", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35144", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35147", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35176", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35178", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35185", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35186", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35187", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35242", "FIPS": "01117", "County": "Shelby", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35459", "FIPS": "01119", "County": "Sumter", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "35460", "FIPS": "01119", "County": "Sumter", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "35464", "FIPS": "01119", "County": "Sumter", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "35470", "FIPS": "01119", "County": "Sumter", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "35477", "FIPS": "01119", "County": "Sumter", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36901", "FIPS": "01119", "County": "Sumter", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36907", "FIPS": "01119", "County": "Sumter", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "36925", "FIPS": "01119", "County": "Sumter", "State": "AL", "DMA": {"Code": 711, "Name": "MERIDIAN"}},
  {"Postal_Code": "35014", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35032", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35044", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35096", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35149", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35150", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35151", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35160", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35161", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36268", "FIPS": "01121", "County": "Talladega", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35010", "FIPS": "01123", "County": "Tallapoosa", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35011", "FIPS": "01123", "County": "Tallapoosa", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36023", "FIPS": "01123", "County": "Tallapoosa", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36256", "FIPS": "01123", "County": "Tallapoosa", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36850", "FIPS": "01123", "County": "Tallapoosa", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36853", "FIPS": "01123", "County": "Tallapoosa", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36861", "FIPS": "01123", "County": "Tallapoosa", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35401", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35402", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35403", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35404", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35405", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35406", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35407", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35440", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35444", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35446", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35449", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35452", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35453", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35456", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35457", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35458", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35463", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35468", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35473", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35475", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35476", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35478", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35480", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35482", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35485", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35486", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35487", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35490", "FIPS": "01125", "County": "Tuscaloosa", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35038", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35063", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35130", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35148", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35501", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35502", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35503", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35504", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35549", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35550", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35554", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35560", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35573", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35578", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35579", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35580", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35584", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35587", "FIPS": "01127", "County": "Walker", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "36513", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36518", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36529", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36538", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36539", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36548", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36553", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36556", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36558", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36569", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36581", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36583", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36584", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36585", "FIPS": "01129", "County": "Washington", "State": "AL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "36435", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36720", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36721", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36722", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36723", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36726", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36728", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36741", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36751", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36753", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36766", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36768", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "36769", "FIPS": "01131", "County": "Wilcox", "State": "AL", "DMA": {"Code": 698, "Name": "MONTGOMERY"}},
  {"Postal_Code": "35540", "FIPS": "01133", "County": "Winston", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35541", "FIPS": "01133", "County": "Winston", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35551", "FIPS": "01133", "County": "Winston", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35553", "FIPS": "01133", "County": "Winston", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35565", "FIPS": "01133", "County": "Winston", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35572", "FIPS": "01133", "County": "Winston", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35575", "FIPS": "01133", "County": "Winston", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "35577", "FIPS": "01133", "County": "Winston", "State": "AL", "DMA": {"Code": 630, "Name": "BIRMINGHAM"}},
  {"Postal_Code": "99553", "FIPS": "02013", "County": "Aleutians East", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99571", "FIPS": "02013", "County": "Aleutians East", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99583", "FIPS": "02013", "County": "Aleutians East", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99612", "FIPS": "02013", "County": "Aleutians East", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99661", "FIPS": "02013", "County": "Aleutians East", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99546", "FIPS": "02016", "County": "Aleutians West", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99547", "FIPS": "02016", "County": "Aleutians West", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99591", "FIPS": "02016", "County": "Aleutians West", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99638", "FIPS": "02016", "County": "Aleutians West", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99660", "FIPS": "02016", "County": "Aleutians West", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99685", "FIPS": "02016", "County": "Aleutians West", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99692", "FIPS": "02016", "County": "Aleutians West", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99501", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99502", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99503", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99504", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99505", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99506", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99507", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99508", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99509", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99510", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99511", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99513", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99514", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99515", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99516", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99517", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99518", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99519", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99520", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99521", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99522", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99523", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99524", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99529", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99530", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99540", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99567", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99577", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99587", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99599", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99695", "FIPS": "02020", "County": "Anchorage", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99545", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99551", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99552", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99557", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99559", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99561", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99575", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99578", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99589", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99607", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99609", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99614", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99621", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99622", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99626", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99630", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99634", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99637", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99641", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99651", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99655", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99656", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99668", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99679", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99680", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99681", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99690", "FIPS": "02050", "County": "Bethel", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99613", "FIPS": "02060", "County": "Bristol Bay", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99633", "FIPS": "02060", "County": "Bristol Bay", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99670", "FIPS": "02060", "County": "Bristol Bay", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99704", "FIPS": "02068", "County": "Denali", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99729", "FIPS": "02068", "County": "Denali", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99743", "FIPS": "02068", "County": "Denali", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99744", "FIPS": "02068", "County": "Denali", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99755", "FIPS": "02068", "County": "Denali", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99555", "FIPS": "02070", "County": "Dillingham", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99569", "FIPS": "02070", "County": "Dillingham", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99576", "FIPS": "02070", "County": "Dillingham", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99580", "FIPS": "02070", "County": "Dillingham", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99628", "FIPS": "02070", "County": "Dillingham", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99636", "FIPS": "02070", "County": "Dillingham", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99678", "FIPS": "02070", "County": "Dillingham", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99701", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99702", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99703", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99705", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99706", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99707", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99708", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99709", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99710", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99711", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99712", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99714", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99716", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99725", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99775", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99790", "FIPS": "02090", "County": "Fairbanks North Star", "State": "AK", "DMA": {"Code": 745, "Name": "FAIRBANKS"}},
  {"Postal_Code": "99827", "FIPS": "02100", "County": "Haines", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99801", "FIPS": "02110", "County": "Juneau", "State": "AK", "DMA": {"Code": 747, "Name": "JUNEAU"}},
  {"Postal_Code": "99802", "FIPS": "02110", "County": "Juneau", "State": "AK", "DMA": {"Code": 747, "Name": "JUNEAU"}},
  {"Postal_Code": "99803", "FIPS": "02110", "County": "Juneau", "State": "AK", "DMA": {"Code": 747, "Name": "JUNEAU"}},
  {"Postal_Code": "99811", "FIPS": "02110", "County": "Juneau", "State": "AK", "DMA": {"Code": 747, "Name": "JUNEAU"}},
  {"Postal_Code": "99812", "FIPS": "02110", "County": "Juneau", "State": "AK", "DMA": {"Code": 747, "Name": "JUNEAU"}},
  {"Postal_Code": "99821", "FIPS": "02110", "County": "Juneau", "State": "AK", "DMA": {"Code": 747, "Name": "JUNEAU"}},
  {"Postal_Code": "99824", "FIPS": "02110", "County": "Juneau", "State": "AK", "DMA": {"Code": 747, "Name": "JUNEAU"}},
  {"Postal_Code": "99850", "FIPS": "02110", "County": "Juneau", "State": "AK", "DMA": {"Code": 747, "Name": "JUNEAU"}},
  {"Postal_Code": "99556", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99568", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99572", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99603", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99605", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99610", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99611", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99631", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99635", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99639", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99663", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99664", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99669", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99672", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99682", "FIPS": "02122", "County": "Kenai Peninsula", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99901", "FIPS": "02130", "County": "Ketchikan Gateway", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99928", "FIPS": "02130", "County": "Ketchikan Gateway", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99950", "FIPS": "02130", "County": "Ketchikan Gateway", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99550", "FIPS": "02150", "County": "Kodiak Island", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99608", "FIPS": "02150", "County": "Kodiak Island", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99615", "FIPS": "02150", "County": "Kodiak Island", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99619", "FIPS": "02150", "County": "Kodiak Island", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99624", "FIPS": "02150", "County": "Kodiak Island", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99643", "FIPS": "02150", "County": "Kodiak Island", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99644", "FIPS": "02150", "County": "Kodiak Island", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99697", "FIPS": "02150", "County": "Kodiak Island", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99548", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99549", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99564", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99565", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99579", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99606", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99625", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99640", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99647", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99648", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99649", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99653", "FIPS": "02164", "County": "Lake and Peninsula", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99629", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99645", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99652", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99654", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99667", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99674", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99676", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99683", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99687", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99688", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99694", "FIPS": "02170", "County": "Matanuska Susitna", "State": "AK", "DMA": {"Code": 743, "Name": "ANCHORAGE"}},
  {"Postal_Code": "99659", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99671", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99684", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99739", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99742", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99753", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99762", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99769", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99771", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99772", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99778", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99783", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99784", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99785", "FIPS": "02180", "County": "Nome", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99721", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99723", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99734", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99747", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99759", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99766", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99782", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99789", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99791", "FIPS": "02185", "County": "North Slope", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99727", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99736", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99749", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99750", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99751", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99752", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99761", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99763", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99770", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99773", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99786", "FIPS": "02188", "County": "Northwest Arctic", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99903", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99918", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99919", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99921", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99922", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99923", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99925", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99926", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99927", "FIPS": "02201", "County": "Prince Wales Ketchikan", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99835", "FIPS": "02220", "County": "Sitka", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99820", "FIPS": "02232", "County": "Skagway Hoonah Angoon", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99825", "FIPS": "02232", "County": "Skagway Hoonah Angoon", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99826", "FIPS": "02232", "County": "Skagway Hoonah Angoon", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99829", "FIPS": "02232", "County": "Skagway Hoonah Angoon", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99832", "FIPS": "02232", "County": "Skagway Hoonah Angoon", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99840", "FIPS": "02232", "County": "Skagway Hoonah Angoon", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99841", "FIPS": "02232", "County": "Skagway Hoonah Angoon", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99731", "FIPS": "02240", "County": "Southeast Fairbanks", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99732", "FIPS": "02240", "County": "Southeast Fairbanks", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99737", "FIPS": "02240", "County": "Southeast Fairbanks", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99738", "FIPS": "02240", "County": "Southeast Fairbanks", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99764", "FIPS": "02240", "County": "Southeast Fairbanks", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99776", "FIPS": "02240", "County": "Southeast Fairbanks", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99779", "FIPS": "02240", "County": "Southeast Fairbanks", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99780", "FIPS": "02240", "County": "Southeast Fairbanks", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99566", "FIPS": "02261", "County": "Valdez Cordova", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99573", "FIPS": "02261", "County": "Valdez Cordova", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99574", "FIPS": "02261", "County": "Valdez Cordova", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99586", "FIPS": "02261", "County": "Valdez Cordova", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99588", "FIPS": "02261", "County": "Valdez Cordova", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99677", "FIPS": "02261", "County": "Valdez Cordova", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99686", "FIPS": "02261", "County": "Valdez Cordova", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99693", "FIPS": "02261", "County": "Valdez Cordova", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99554", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99563", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99581", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99585", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99604", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99620", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99632", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99650", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99657", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99658", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99662", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99666", "FIPS": "02270", "County": "Wade Hampton", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99830", "FIPS": "02280", "County": "Wrangell Petersburg", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99833", "FIPS": "02280", "County": "Wrangell Petersburg", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99836", "FIPS": "02280", "County": "Wrangell Petersburg", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99929", "FIPS": "02280", "County": "Wrangell Petersburg", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99689", "FIPS": "02282", "County": "Yakutat", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99558", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99590", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99602", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99627", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99665", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99675", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99691", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99720", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99722", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99724", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99726", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99730", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99733", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99740", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99741", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99745", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99746", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99748", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99754", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99756", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99757", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99758", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99760", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99765", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99767", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99768", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99774", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99777", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99781", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "99788", "FIPS": "02290", "County": "Yukon Koyukuk", "State": "AK", "DMA": {"Code": None, "Name": None}},
  {"Postal_Code": "85920", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85924", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85925", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85927", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85930", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85932", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85936", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85938", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85940", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86028", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86502", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86503", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86504", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86505", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86506", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86507", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86508", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86511", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86512", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86514", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86515", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86535", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86538", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86540", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86544", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86545", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86547", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "86556", "FIPS": "04001", "County": "Apache", "State": "AZ", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "85602", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85603", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85605", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85606", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85607", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85608", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85609", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85610", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85613", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85615", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85616", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85617", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85620", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85625", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85626", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85627", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85630", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85632", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85635", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85636", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85638", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85643", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85644", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85650", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85655", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85670", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85671", "FIPS": "04003", "County": "Cochise", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85931", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86001", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86002", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86003", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86004", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86011", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86015", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86016", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86017", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86018", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86020", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86022", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86023", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86024", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86035", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86036", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86038", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86040", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86044", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86045", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86046", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86052", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86053", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86339", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86435", "FIPS": "04005", "County": "Coconino", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85235", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85292", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85501", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85502", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85532", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85539", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85541", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85542", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85544", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85545", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85547", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85550", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85553", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85554", "FIPS": "04007", "County": "Gila", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85530", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85531", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85535", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85536", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85543", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85546", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85548", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85551", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85552", "FIPS": "04009", "County": "Graham", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85533", "FIPS": "04011", "County": "Greenlee", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85534", "FIPS": "04011", "County": "Greenlee", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85540", "FIPS": "04011", "County": "Greenlee", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85922", "FIPS": "04011", "County": "Greenlee", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85325", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85328", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85334", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85344", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85346", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85348", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85357", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85359", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85371", "FIPS": "04012", "County": "La Paz", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85001", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85002", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85003", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85004", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85005", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85006", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85007", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85008", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85009", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85010", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85011", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85012", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85013", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85014", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85015", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85016", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85017", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85018", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85019", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85020", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85021", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85022", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85023", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85024", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85025", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85026", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85027", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85028", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85029", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85030", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85031", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85032", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85033", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85034", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85035", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85036", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85037", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85038", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85039", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85040", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85041", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85042", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85043", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85044", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85045", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85046", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85048", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85050", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85051", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85053", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85054", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85055", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85060", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85061", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85062", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85063", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85064", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85065", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85066", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85067", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85068", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85069", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85070", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85071", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85072", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85073", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85074", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85075", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85076", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85077", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85078", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85079", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85080", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85082", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85085", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85086", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85087", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85098", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85099", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85201", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85202", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85203", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85204", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85205", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85206", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85207", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85208", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85209", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85210", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85211", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85212", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85213", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85214", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85215", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85216", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85224", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85225", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85226", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85227", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85233", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85234", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85236", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85242", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85244", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85246", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85248", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85249", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85250", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85251", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85252", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85253", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85254", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85255", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85256", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85257", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85258", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85259", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85260", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85261", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85262", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85263", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85264", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85266", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85267", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85268", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85269", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85271", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85274", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85275", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85277", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85280", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85281", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85282", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85283", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85284", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85285", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85287", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85289", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85290", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85296", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85297", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85299", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85301", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85302", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85303", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85304", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85305", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85306", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85307", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85308", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85309", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85310", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85311", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85312", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85313", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85318", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85320", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85322", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85323", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85326", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85327", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85329", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85331", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85335", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85337", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85338", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85339", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85340", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85342", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85343", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85345", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85351", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85353", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85354", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85355", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85358", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85361", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85363", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85372", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85373", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85374", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85375", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85376", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85377", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85378", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85379", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85380", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85381", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85382", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85383", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85385", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85387", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85388", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85390", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85396", "FIPS": "04013", "County": "Maricopa", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85360", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86021", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86401", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86402", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86403", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86404", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86405", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86406", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86409", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86411", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86412", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86413", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86426", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86427", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86429", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86430", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86431", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86432", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86433", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86434", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86436", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86437", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86438", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86439", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86440", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86441", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86442", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86443", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86444", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86445", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86446", "FIPS": "04015", "County": "Mohave", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85901", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85902", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85911", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85912", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85923", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85926", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85928", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85929", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85933", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85934", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85935", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85937", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85939", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85941", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85942", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86025", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86029", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86030", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86031", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86032", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86033", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86034", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86039", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86042", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86043", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86047", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86054", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86510", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86520", "FIPS": "04017", "County": "Navajo", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85321", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85341", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85601", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85614", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85619", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85622", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85629", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85633", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85634", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85639", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85641", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85652", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85653", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85654", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85701", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85702", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85703", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85704", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85705", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85706", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85707", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85708", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85709", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85710", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85711", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85712", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85713", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85714", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85715", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85716", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85717", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85718", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85719", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85720", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85721", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85722", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85723", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85724", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85725", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85726", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85728", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85730", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85731", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85732", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85733", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85734", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85735", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85736", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85737", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85738", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85739", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85740", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85741", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85742", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85743", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85744", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85745", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85746", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85747", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85748", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85749", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85750", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85751", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85752", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85754", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85755", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85757", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85775", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85777", "FIPS": "04019", "County": "Pima", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85217", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85218", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85219", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85220", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85221", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85222", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85223", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85228", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85230", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85231", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85232", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85237", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85239", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85241", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85243", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85245", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85247", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85272", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85273", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85278", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85279", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85291", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85618", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85623", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85631", "FIPS": "04021", "County": "Pinal", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85611", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85621", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85624", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85628", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85637", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85640", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85645", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85646", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85648", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85662", "FIPS": "04023", "County": "Santa Cruz", "State": "AZ", "DMA": {"Code": 789, "Name": "TUCSON-SIERRA VISTA"}},
  {"Postal_Code": "85324", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85332", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85362", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86301", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86302", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86303", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86304", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86305", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86312", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86313", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86314", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86320", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86321", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86322", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86323", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86324", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86325", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86326", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86327", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86329", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86330", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86331", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86332", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86333", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86334", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86335", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86336", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86337", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86338", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86340", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86341", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86342", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86343", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "86351", "FIPS": "04025", "County": "Yavapai", "State": "AZ", "DMA": {"Code": 753, "Name": "PHOENIX"}},
  {"Postal_Code": "85333", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85336", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85347", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85349", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85350", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85352", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85356", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85364", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85365", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85366", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85367", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "85369", "FIPS": "04027", "County": "Yuma", "State": "AZ", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "72003", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72026", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72038", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72042", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72048", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72055", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72073", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72140", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72160", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72166", "FIPS": "05001", "County": "Arkansas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71635", "FIPS": "05003", "County": "Ashley", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71642", "FIPS": "05003", "County": "Ashley", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71646", "FIPS": "05003", "County": "Ashley", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71658", "FIPS": "05003", "County": "Ashley", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71661", "FIPS": "05003", "County": "Ashley", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71663", "FIPS": "05003", "County": "Ashley", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71676", "FIPS": "05003", "County": "Ashley", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "72537", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72544", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72617", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72623", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72626", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72635", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72642", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72651", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72653", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72654", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72658", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72659", "FIPS": "05005", "County": "Baxter", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72711", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72712", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72714", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72715", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72716", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72718", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72719", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72722", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72732", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72733", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72734", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72736", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72739", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72745", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72747", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72751", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72756", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72757", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72758", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72761", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72768", "FIPS": "05007", "County": "Benton", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72601", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72602", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72611", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72615", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72630", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72633", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72644", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72662", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72682", "FIPS": "05009", "County": "Boone", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "71631", "FIPS": "05011", "County": "Bradley", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71647", "FIPS": "05011", "County": "Bradley", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71651", "FIPS": "05011", "County": "Bradley", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71671", "FIPS": "05011", "County": "Bradley", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71744", "FIPS": "05013", "County": "Calhoun", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71745", "FIPS": "05013", "County": "Calhoun", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71766", "FIPS": "05013", "County": "Calhoun", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72613", "FIPS": "05015", "County": "Carroll", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72616", "FIPS": "05015", "County": "Carroll", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72631", "FIPS": "05015", "County": "Carroll", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72632", "FIPS": "05015", "County": "Carroll", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72638", "FIPS": "05015", "County": "Carroll", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72660", "FIPS": "05015", "County": "Carroll", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "71638", "FIPS": "05017", "County": "Chicot", "State": "AR", "DMA": {"Code": 647, "Name": "GREENWOOD-GREENVILLE"}},
  {"Postal_Code": "71640", "FIPS": "05017", "County": "Chicot", "State": "AR", "DMA": {"Code": 647, "Name": "GREENWOOD-GREENVILLE"}},
  {"Postal_Code": "71653", "FIPS": "05017", "County": "Chicot", "State": "AR", "DMA": {"Code": 647, "Name": "GREENWOOD-GREENVILLE"}},
  {"Postal_Code": "71721", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71728", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71743", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71772", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71920", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71921", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71923", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71962", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71998", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71999", "FIPS": "05019", "County": "Clark", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72422", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72424", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72430", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72435", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72441", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72453", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72454", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72456", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72461", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72464", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72470", "FIPS": "05021", "County": "Clay", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72044", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72067", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72130", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72131", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72179", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72523", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72530", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72543", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72545", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72546", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72581", "FIPS": "05023", "County": "Cleburne", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71652", "FIPS": "05025", "County": "Cleveland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71660", "FIPS": "05025", "County": "Cleveland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71665", "FIPS": "05025", "County": "Cleveland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71740", "FIPS": "05027", "County": "Columbia", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71752", "FIPS": "05027", "County": "Columbia", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71753", "FIPS": "05027", "County": "Columbia", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71754", "FIPS": "05027", "County": "Columbia", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71770", "FIPS": "05027", "County": "Columbia", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71861", "FIPS": "05027", "County": "Columbia", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "72027", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72030", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72063", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72080", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72107", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72110", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72127", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72156", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72157", "FIPS": "05029", "County": "Conway", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72401", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72402", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72403", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72404", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72411", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72414", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72416", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72417", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72419", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72421", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72427", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72437", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72447", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72467", "FIPS": "05031", "County": "Craighead", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72921", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72932", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72934", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72935", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72946", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72947", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72948", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72952", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72955", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72956", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72957", "FIPS": "05033", "County": "Crawford", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72301", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72303", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72325", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72327", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72331", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72332", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72339", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72364", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72376", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72384", "FIPS": "05035", "County": "Crittenden", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72324", "FIPS": "05037", "County": "Cross", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72347", "FIPS": "05037", "County": "Cross", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72373", "FIPS": "05037", "County": "Cross", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72387", "FIPS": "05037", "County": "Cross", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72396", "FIPS": "05037", "County": "Cross", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "71725", "FIPS": "05039", "County": "Dallas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71742", "FIPS": "05039", "County": "Dallas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71748", "FIPS": "05039", "County": "Dallas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71763", "FIPS": "05039", "County": "Dallas", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71630", "FIPS": "05041", "County": "Desha", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71639", "FIPS": "05041", "County": "Desha", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71654", "FIPS": "05041", "County": "Desha", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71662", "FIPS": "05041", "County": "Desha", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71666", "FIPS": "05041", "County": "Desha", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71670", "FIPS": "05041", "County": "Desha", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71674", "FIPS": "05041", "County": "Desha", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72379", "FIPS": "05041", "County": "Desha", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71655", "FIPS": "05043", "County": "Drew", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71656", "FIPS": "05043", "County": "Drew", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71657", "FIPS": "05043", "County": "Drew", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71675", "FIPS": "05043", "County": "Drew", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71677", "FIPS": "05043", "County": "Drew", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72032", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72033", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72034", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72035", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72039", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72047", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72058", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72061", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72106", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72111", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72173", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72181", "FIPS": "05045", "County": "Faulkner", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72820", "FIPS": "05047", "County": "Franklin", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72821", "FIPS": "05047", "County": "Franklin", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72928", "FIPS": "05047", "County": "Franklin", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72930", "FIPS": "05047", "County": "Franklin", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72933", "FIPS": "05047", "County": "Franklin", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72949", "FIPS": "05047", "County": "Franklin", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72515", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72520", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72531", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72538", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72539", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72554", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72576", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72578", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72583", "FIPS": "05049", "County": "Fulton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "71901", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71902", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71903", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71909", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71910", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71913", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71914", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71949", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71951", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71956", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71964", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71968", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72087", "FIPS": "05051", "County": "Garland", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72057", "FIPS": "05053", "County": "Grant", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72084", "FIPS": "05053", "County": "Grant", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72128", "FIPS": "05053", "County": "Grant", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72129", "FIPS": "05053", "County": "Grant", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72150", "FIPS": "05053", "County": "Grant", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72412", "FIPS": "05055", "County": "Greene", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72425", "FIPS": "05055", "County": "Greene", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72436", "FIPS": "05055", "County": "Greene", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72439", "FIPS": "05055", "County": "Greene", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72443", "FIPS": "05055", "County": "Greene", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72450", "FIPS": "05055", "County": "Greene", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72451", "FIPS": "05055", "County": "Greene", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72474", "FIPS": "05055", "County": "Greene", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "71801", "FIPS": "05057", "County": "Hempstead", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71802", "FIPS": "05057", "County": "Hempstead", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71825", "FIPS": "05057", "County": "Hempstead", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71831", "FIPS": "05057", "County": "Hempstead", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71838", "FIPS": "05057", "County": "Hempstead", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71847", "FIPS": "05057", "County": "Hempstead", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71855", "FIPS": "05057", "County": "Hempstead", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71862", "FIPS": "05057", "County": "Hempstead", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71929", "FIPS": "05059", "County": "Hot Spring", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71933", "FIPS": "05059", "County": "Hot Spring", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71941", "FIPS": "05059", "County": "Hot Spring", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71942", "FIPS": "05059", "County": "Hot Spring", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72104", "FIPS": "05059", "County": "Hot Spring", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72105", "FIPS": "05059", "County": "Hot Spring", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71833", "FIPS": "05061", "County": "Howard", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71851", "FIPS": "05061", "County": "Howard", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71852", "FIPS": "05061", "County": "Howard", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71859", "FIPS": "05061", "County": "Howard", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71971", "FIPS": "05061", "County": "Howard", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "72165", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72501", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72503", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72522", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72524", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72526", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72527", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72534", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72550", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72553", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72562", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72564", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72568", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72571", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72575", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72579", "FIPS": "05063", "County": "Independence", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72512", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72517", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72519", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72528", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72536", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72540", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72556", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72561", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72565", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72566", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72573", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72584", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72585", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72587", "FIPS": "05065", "County": "Izard", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72005", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72014", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72043", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72075", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72112", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72169", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72431", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72471", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72473", "FIPS": "05067", "County": "Jackson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71601", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71602", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71603", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71611", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71612", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71613", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71659", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72004", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72079", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72132", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72133", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72152", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72168", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72175", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72182", "FIPS": "05069", "County": "Jefferson", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72830", "FIPS": "05071", "County": "Johnson", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72832", "FIPS": "05071", "County": "Johnson", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72839", "FIPS": "05071", "County": "Johnson", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72840", "FIPS": "05071", "County": "Johnson", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72845", "FIPS": "05071", "County": "Johnson", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72846", "FIPS": "05071", "County": "Johnson", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72852", "FIPS": "05071", "County": "Johnson", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72854", "FIPS": "05071", "County": "Johnson", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "71826", "FIPS": "05073", "County": "Lafayette", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71827", "FIPS": "05073", "County": "Lafayette", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71845", "FIPS": "05073", "County": "Lafayette", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71860", "FIPS": "05073", "County": "Lafayette", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "72410", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72415", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72433", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72434", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72440", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72445", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72457", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72458", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72459", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72465", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72466", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72469", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72476", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72572", "FIPS": "05075", "County": "Lawrence", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72311", "FIPS": "05077", "County": "Lee", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72320", "FIPS": "05077", "County": "Lee", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72341", "FIPS": "05077", "County": "Lee", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72352", "FIPS": "05077", "County": "Lee", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72360", "FIPS": "05077", "County": "Lee", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72368", "FIPS": "05077", "County": "Lee", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "71643", "FIPS": "05079", "County": "Lincoln", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71644", "FIPS": "05079", "County": "Lincoln", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71667", "FIPS": "05079", "County": "Lincoln", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71678", "FIPS": "05079", "County": "Lincoln", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71820", "FIPS": "05081", "County": "Little River", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71822", "FIPS": "05081", "County": "Little River", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71836", "FIPS": "05081", "County": "Little River", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71853", "FIPS": "05081", "County": "Little River", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71865", "FIPS": "05081", "County": "Little River", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71866", "FIPS": "05081", "County": "Little River", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "72826", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72835", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72851", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72855", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72863", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72865", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72927", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72943", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72951", "FIPS": "05083", "County": "Logan", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72007", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72023", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72024", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72037", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72046", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72072", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72083", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72086", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72176", "FIPS": "05085", "County": "Lonoke", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72721", "FIPS": "05087", "County": "Madison", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72738", "FIPS": "05087", "County": "Madison", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72740", "FIPS": "05087", "County": "Madison", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72742", "FIPS": "05087", "County": "Madison", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72752", "FIPS": "05087", "County": "Madison", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72760", "FIPS": "05087", "County": "Madison", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72773", "FIPS": "05087", "County": "Madison", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72776", "FIPS": "05087", "County": "Madison", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72619", "FIPS": "05089", "County": "Marion", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72634", "FIPS": "05089", "County": "Marion", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72661", "FIPS": "05089", "County": "Marion", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72668", "FIPS": "05089", "County": "Marion", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72672", "FIPS": "05089", "County": "Marion", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72677", "FIPS": "05089", "County": "Marion", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72687", "FIPS": "05089", "County": "Marion", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "71834", "FIPS": "05091", "County": "Miller", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71837", "FIPS": "05091", "County": "Miller", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71839", "FIPS": "05091", "County": "Miller", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71840", "FIPS": "05091", "County": "Miller", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71854", "FIPS": "05091", "County": "Miller", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "72310", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72313", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72315", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72316", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72319", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72321", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72329", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72330", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72338", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72350", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72351", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72358", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72370", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72391", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72395", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72426", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72428", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72438", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72442", "FIPS": "05093", "County": "Mississippi", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72021", "FIPS": "05095", "County": "Monroe", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72029", "FIPS": "05095", "County": "Monroe", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72069", "FIPS": "05095", "County": "Monroe", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72108", "FIPS": "05095", "County": "Monroe", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72134", "FIPS": "05095", "County": "Monroe", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71935", "FIPS": "05097", "County": "Montgomery", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71957", "FIPS": "05097", "County": "Montgomery", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71960", "FIPS": "05097", "County": "Montgomery", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71961", "FIPS": "05097", "County": "Montgomery", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71965", "FIPS": "05097", "County": "Montgomery", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71966", "FIPS": "05097", "County": "Montgomery", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71969", "FIPS": "05097", "County": "Montgomery", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71970", "FIPS": "05097", "County": "Montgomery", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71722", "FIPS": "05099", "County": "Nevada", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71828", "FIPS": "05099", "County": "Nevada", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71835", "FIPS": "05099", "County": "Nevada", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71844", "FIPS": "05099", "County": "Nevada", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71857", "FIPS": "05099", "County": "Nevada", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71858", "FIPS": "05099", "County": "Nevada", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71864", "FIPS": "05099", "County": "Nevada", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72624", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72628", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72640", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72641", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72648", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72655", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72666", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72670", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72683", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72685", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "72856", "FIPS": "05101", "County": "Newton", "State": "AR", "DMA": {"Code": 619, "Name": "SPRINGFIELD, MO"}},
  {"Postal_Code": "71701", "FIPS": "05103", "County": "Ouachita", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71711", "FIPS": "05103", "County": "Ouachita", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71720", "FIPS": "05103", "County": "Ouachita", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71726", "FIPS": "05103", "County": "Ouachita", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71751", "FIPS": "05103", "County": "Ouachita", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71764", "FIPS": "05103", "County": "Ouachita", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72001", "FIPS": "05105", "County": "Perry", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72016", "FIPS": "05105", "County": "Perry", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72025", "FIPS": "05105", "County": "Perry", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72070", "FIPS": "05105", "County": "Perry", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72125", "FIPS": "05105", "County": "Perry", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72126", "FIPS": "05105", "County": "Perry", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72312", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72328", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72333", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72342", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72353", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72355", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72366", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72367", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72369", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72374", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72383", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72389", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72390", "FIPS": "05107", "County": "Phillips", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "71922", "FIPS": "05109", "County": "Pike", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71940", "FIPS": "05109", "County": "Pike", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71943", "FIPS": "05109", "County": "Pike", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71950", "FIPS": "05109", "County": "Pike", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71952", "FIPS": "05109", "County": "Pike", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71958", "FIPS": "05109", "County": "Pike", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71959", "FIPS": "05109", "County": "Pike", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72354", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72365", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72377", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72386", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72429", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72432", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72472", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72475", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72479", "FIPS": "05111", "County": "Poinsett", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "71932", "FIPS": "05113", "County": "Polk", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71937", "FIPS": "05113", "County": "Polk", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71944", "FIPS": "05113", "County": "Polk", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71945", "FIPS": "05113", "County": "Polk", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71953", "FIPS": "05113", "County": "Polk", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71972", "FIPS": "05113", "County": "Polk", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71973", "FIPS": "05113", "County": "Polk", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72679", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72801", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72802", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72811", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72812", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72823", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72837", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72843", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72847", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72858", "FIPS": "05115", "County": "Pope", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72017", "FIPS": "05117", "County": "Prairie", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72040", "FIPS": "05117", "County": "Prairie", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72041", "FIPS": "05117", "County": "Prairie", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72064", "FIPS": "05117", "County": "Prairie", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72066", "FIPS": "05117", "County": "Prairie", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72170", "FIPS": "05117", "County": "Prairie", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72053", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72076", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72078", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72099", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72113", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72114", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72115", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72116", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72117", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72118", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72119", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72120", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72124", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72135", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72142", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72164", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72180", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72183", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72190", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72198", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72199", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72201", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72202", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72203", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72204", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72205", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72206", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72207", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72209", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72210", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72211", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72212", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72214", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72215", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72216", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72217", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72219", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72221", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72222", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72223", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72225", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72227", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72231", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72260", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72295", "FIPS": "05119", "County": "Pulaski", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72413", "FIPS": "05121", "County": "Randolph", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72444", "FIPS": "05121", "County": "Randolph", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72449", "FIPS": "05121", "County": "Randolph", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72455", "FIPS": "05121", "County": "Randolph", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72460", "FIPS": "05121", "County": "Randolph", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72462", "FIPS": "05121", "County": "Randolph", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72478", "FIPS": "05121", "County": "Randolph", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72322", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72326", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72335", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72336", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72340", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72346", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72348", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72359", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72372", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72392", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72394", "FIPS": "05123", "County": "Saint Francis", "State": "AR", "DMA": {"Code": 640, "Name": "MEMPHIS"}},
  {"Postal_Code": "72002", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72011", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72015", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72018", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72019", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72022", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72065", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72089", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72103", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72122", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72158", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72167", "FIPS": "05125", "County": "Saline", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72841", "FIPS": "05127", "County": "Scott", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72926", "FIPS": "05127", "County": "Scott", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72944", "FIPS": "05127", "County": "Scott", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72950", "FIPS": "05127", "County": "Scott", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72958", "FIPS": "05127", "County": "Scott", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72636", "FIPS": "05129", "County": "Searcy", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72639", "FIPS": "05129", "County": "Searcy", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72645", "FIPS": "05129", "County": "Searcy", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72650", "FIPS": "05129", "County": "Searcy", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72669", "FIPS": "05129", "County": "Searcy", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72675", "FIPS": "05129", "County": "Searcy", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72686", "FIPS": "05129", "County": "Searcy", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72901", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72902", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72903", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72904", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72905", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72906", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72908", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72913", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72914", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72916", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72917", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72918", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72919", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72923", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72936", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72937", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72938", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72940", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72941", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72945", "FIPS": "05131", "County": "Sebastian", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "71823", "FIPS": "05133", "County": "Sevier", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71832", "FIPS": "05133", "County": "Sevier", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71841", "FIPS": "05133", "County": "Sevier", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71842", "FIPS": "05133", "County": "Sevier", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "71846", "FIPS": "05133", "County": "Sevier", "State": "AR", "DMA": {"Code": 612, "Name": "SHREVEPORT"}},
  {"Postal_Code": "72482", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72513", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72521", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72525", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72529", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72532", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72542", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72569", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72577", "FIPS": "05135", "County": "Sharp", "State": "AR", "DMA": {"Code": 734, "Name": "JONESBORO"}},
  {"Postal_Code": "72051", "FIPS": "05137", "County": "Stone", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72533", "FIPS": "05137", "County": "Stone", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72555", "FIPS": "05137", "County": "Stone", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72560", "FIPS": "05137", "County": "Stone", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72567", "FIPS": "05137", "County": "Stone", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72657", "FIPS": "05137", "County": "Stone", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72663", "FIPS": "05137", "County": "Stone", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72680", "FIPS": "05137", "County": "Stone", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "71724", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71730", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71731", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71747", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71749", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71750", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71758", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71759", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71762", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71765", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "71768", "FIPS": "05139", "County": "Union", "State": "AR", "DMA": {"Code": 628, "Name": "MONROE-EL DORADO"}},
  {"Postal_Code": "72013", "FIPS": "05141", "County": "Van Buren", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72028", "FIPS": "05141", "County": "Van Buren", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72031", "FIPS": "05141", "County": "Van Buren", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72088", "FIPS": "05141", "County": "Van Buren", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72141", "FIPS": "05141", "County": "Van Buren", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72153", "FIPS": "05141", "County": "Van Buren", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72629", "FIPS": "05141", "County": "Van Buren", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72701", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72702", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72703", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72704", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72717", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72727", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72728", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72729", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72730", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72735", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72737", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72741", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72744", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72749", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72753", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72762", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72764", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72765", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72766", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72769", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72770", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72774", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72959", "FIPS": "05143", "County": "Washington", "State": "AR", "DMA": {"Code": 670, "Name": "FORT SMITH-FAY-SPRNGDL"}},
  {"Postal_Code": "72010", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72012", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72020", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72045", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72052", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72060", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72068", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72081", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72082", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72085", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72102", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72121", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72136", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72137", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72139", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72143", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72145", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72149", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72178", "FIPS": "05145", "County": "White", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72006", "FIPS": "05147", "County": "Woodruff", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72036", "FIPS": "05147", "County": "Woodruff", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72059", "FIPS": "05147", "County": "Woodruff", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72074", "FIPS": "05147", "County": "Woodruff", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72101", "FIPS": "05147", "County": "Woodruff", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72123", "FIPS": "05147", "County": "Woodruff", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72189", "FIPS": "05147", "County": "Woodruff", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72824", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72827", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72828", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72829", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72833", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72834", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72838", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72842", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72853", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72857", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "72860", "FIPS": "05149", "County": "Yell", "State": "AR", "DMA": {"Code": 693, "Name": "LITTLE ROCK-PINE BLUFF"}},
  {"Postal_Code": "94501", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94502", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94536", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94537", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94538", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94539", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94540", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94541", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94542", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94543", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94544", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94545", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94546", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94550", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94551", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94552", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94555", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94557", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94560", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94566", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94568", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94577", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94578", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94579", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94580", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94586", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94587", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94588", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94601", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94602", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94603", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94604", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94605", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94606", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94607", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94608", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94609", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94610", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94611", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94612", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94613", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94614", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94615", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94617", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94618", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94619", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94620", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94621", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94622", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94623", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94624", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94625", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94649", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94659", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94660", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94661", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94662", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94666", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94701", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94702", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94703", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94704", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94705", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94706", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94707", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94708", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94709", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94710", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94712", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94720", "FIPS": "06001", "County": "Alameda", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95646", "FIPS": "06003", "County": "Alpine", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96120", "FIPS": "06003", "County": "Alpine", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "95601", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95629", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95640", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95642", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95644", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95654", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95665", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95666", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95669", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95675", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95685", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95689", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95699", "FIPS": "06005", "County": "Amador", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95914", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95916", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95917", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95926", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95927", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95928", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95929", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95930", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95938", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95940", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95941", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95942", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95948", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95954", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95958", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95965", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95966", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95967", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95968", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95969", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95973", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95974", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95976", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95978", "FIPS": "06007", "County": "Butte", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95221", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95222", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95223", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95224", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95225", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95226", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95228", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95229", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95232", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95233", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95245", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95246", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95247", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95248", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95249", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95250", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95251", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95252", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95254", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95255", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95257", "FIPS": "06009", "County": "Calaveras", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95912", "FIPS": "06011", "County": "Colusa", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95932", "FIPS": "06011", "County": "Colusa", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95950", "FIPS": "06011", "County": "Colusa", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95955", "FIPS": "06011", "County": "Colusa", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95970", "FIPS": "06011", "County": "Colusa", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95979", "FIPS": "06011", "County": "Colusa", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95987", "FIPS": "06011", "County": "Colusa", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94506", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94507", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94509", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94511", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94513", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94514", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94516", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94517", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94518", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94519", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94520", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94521", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94522", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94523", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94524", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94525", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94526", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94527", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94528", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94529", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94530", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94531", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94547", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94548", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94549", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94553", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94556", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94561", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94563", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94564", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94565", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94569", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94570", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94572", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94575", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94582", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94583", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94595", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94596", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94597", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94598", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94801", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94802", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94803", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94804", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94805", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94806", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94807", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94808", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94820", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94850", "FIPS": "06013", "County": "Contra Costa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95531", "FIPS": "06015", "County": "Del Norte", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95532", "FIPS": "06015", "County": "Del Norte", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95538", "FIPS": "06015", "County": "Del Norte", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95543", "FIPS": "06015", "County": "Del Norte", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95548", "FIPS": "06015", "County": "Del Norte", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95567", "FIPS": "06015", "County": "Del Norte", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95613", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95614", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95619", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95623", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95633", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95634", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95635", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95636", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95651", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95656", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95664", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95667", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95672", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95682", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95684", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95709", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95720", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95721", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95726", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95735", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95762", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96142", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96150", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96151", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96152", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96154", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96155", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96156", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96157", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96158", "FIPS": "06017", "County": "El Dorado", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "93210", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93234", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93242", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93602", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93605", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93606", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93607", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93608", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93609", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93611", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93612", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93613", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93616", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93619", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93621", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93622", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93624", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93625", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93626", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93627", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93628", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93630", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93631", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93634", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93640", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93641", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93642", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93646", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93648", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93649", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93650", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93651", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93652", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93654", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93656", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93657", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93660", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93662", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93664", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93667", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93668", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93675", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93701", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93702", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93703", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93704", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93705", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93706", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93707", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93708", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93709", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93710", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93711", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93712", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93714", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93715", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93716", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93717", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93718", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93720", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93721", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93722", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93723", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93724", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93725", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93726", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93727", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93728", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93729", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93730", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93740", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93741", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93744", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93745", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93747", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93750", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93755", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93760", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93761", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93764", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93765", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93771", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93772", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93773", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93774", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93775", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93776", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93777", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93778", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93779", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93780", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93784", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93786", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93790", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93791", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93792", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93793", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93794", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93844", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93888", "FIPS": "06019", "County": "Fresno", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95913", "FIPS": "06021", "County": "Glenn", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95920", "FIPS": "06021", "County": "Glenn", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95939", "FIPS": "06021", "County": "Glenn", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95943", "FIPS": "06021", "County": "Glenn", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95951", "FIPS": "06021", "County": "Glenn", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95963", "FIPS": "06021", "County": "Glenn", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95988", "FIPS": "06021", "County": "Glenn", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95501", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95502", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95503", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95511", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95514", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95518", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95519", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95521", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95524", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95525", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95526", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95528", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95534", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95536", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95537", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95540", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95542", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95545", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95546", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95547", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95549", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95550", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95551", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95553", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95554", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95555", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95556", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95558", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95559", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95560", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95562", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95564", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95565", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95569", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95570", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95571", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95573", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "95589", "FIPS": "06023", "County": "Humboldt", "State": "CA", "DMA": {"Code": 802, "Name": "EUREKA"}},
  {"Postal_Code": "92222", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92227", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92231", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92232", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92233", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92243", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92244", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92249", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92250", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92251", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92257", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92259", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92266", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92273", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92275", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92281", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92283", "FIPS": "06025", "County": "Imperial", "State": "CA", "DMA": {"Code": 771, "Name": "YUMA-EL CENTRO"}},
  {"Postal_Code": "92328", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92384", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92389", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93513", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93514", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93515", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93522", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93526", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93530", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93542", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93545", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93549", "FIPS": "06027", "County": "Inyo", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93203", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93205", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93206", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93215", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93216", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93220", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93222", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93224", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93225", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93226", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93238", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93240", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93241", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93243", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93249", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93250", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93251", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93252", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93255", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93263", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93268", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93276", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93280", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93283", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93285", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93287", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93301", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93302", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93303", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93304", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93305", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93306", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93307", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93308", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93309", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93311", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93312", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93313", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93314", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93380", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93381", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93382", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93383", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93384", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93385", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93386", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93387", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93388", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93389", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93390", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93501", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93502", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93504", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93505", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93516", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93518", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93519", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93523", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93524", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93527", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93528", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93531", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93554", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93555", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93556", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93560", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93561", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93581", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93596", "FIPS": "06029", "County": "Kern", "State": "CA", "DMA": {"Code": 800, "Name": "BAKERSFIELD"}},
  {"Postal_Code": "93202", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93204", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93212", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93230", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93232", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93239", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93245", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93246", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93266", "FIPS": "06031", "County": "Kings", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95422", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95423", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95424", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95426", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95435", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95443", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95451", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95453", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95457", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95458", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95461", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95464", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95467", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95485", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95493", "FIPS": "06033", "County": "Lake", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "96009", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96056", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96068", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96109", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96113", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96114", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96117", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96119", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96121", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96123", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96127", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96128", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96130", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96132", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96136", "FIPS": "06035", "County": "Lassen", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "90001", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90002", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90003", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90004", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90005", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90006", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90007", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90008", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90009", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90010", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90011", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90012", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90013", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90014", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90015", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90016", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90017", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90018", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90019", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90020", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90021", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90022", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90023", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90024", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90025", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90026", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90027", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90028", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90029", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90030", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90031", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90032", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90033", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90034", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90035", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90036", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90037", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90038", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90039", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90040", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90041", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90042", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90043", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90044", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90045", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90046", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90047", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90048", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90049", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90050", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90051", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90052", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90053", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90054", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90055", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90056", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90057", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90058", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90059", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90060", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90061", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90062", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90063", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90064", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90065", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90066", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90067", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90068", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90069", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90070", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90071", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90072", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90073", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90074", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90075", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90076", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90077", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90078", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90079", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90080", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90081", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90082", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90083", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90084", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90086", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90087", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90088", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90089", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90091", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90093", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90094", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90095", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90096", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90099", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90101", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90102", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90103", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90189", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90201", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90202", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90209", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90210", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90211", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90212", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90213", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90220", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90221", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90222", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90223", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90224", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90230", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90231", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90232", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90233", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90239", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90240", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90241", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90242", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90245", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90247", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90248", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90249", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90250", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90251", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90254", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90255", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90260", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90261", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90262", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90263", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90264", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90265", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90266", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90267", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90270", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90272", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90274", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90275", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90277", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90278", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90280", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90290", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90291", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90292", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90293", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90294", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90295", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90296", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90301", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90302", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90303", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90304", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90305", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90306", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90307", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90308", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90309", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90310", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90311", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90312", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90313", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90397", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90398", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90401", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90402", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90403", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90404", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90405", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90406", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90407", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90408", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90409", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90410", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90411", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90501", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90502", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90503", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90504", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90505", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90506", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90507", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90508", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90509", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90510", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90601", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90602", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90603", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90604", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90605", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90606", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90607", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90608", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90609", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90610", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90612", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90637", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90638", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90639", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90640", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90650", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90651", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90652", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90659", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90660", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90661", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90662", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90670", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90671", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90701", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90702", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90703", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90704", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90706", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90707", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90710", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90711", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90712", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90713", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90714", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90715", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90716", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90717", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90723", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90731", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90732", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90733", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90734", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90744", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90745", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90746", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90747", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90748", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90749", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90755", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90801", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90802", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90803", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90804", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90805", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90806", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90807", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90808", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90809", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90810", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90813", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90814", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90815", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90822", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90831", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90832", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90833", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90834", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90835", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90840", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90842", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90844", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90845", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90846", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90847", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90848", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90853", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90888", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90895", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90899", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91001", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91003", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91006", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91007", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91009", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91010", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91011", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91012", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91016", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91017", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91020", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91021", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91023", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91024", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91025", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91030", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91031", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91040", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91041", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91042", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91043", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91046", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91066", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91077", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91101", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91102", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91103", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91104", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91105", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91106", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91107", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91108", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91109", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91110", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91114", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91115", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91116", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91117", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91118", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91121", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91123", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91124", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91125", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91126", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91129", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91131", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91182", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91184", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91185", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91188", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91189", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91191", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91199", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91201", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91202", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91203", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91204", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91205", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91206", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91207", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91208", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91209", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91210", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91214", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91221", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91222", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91224", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91225", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91226", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91301", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91302", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91303", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91304", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91305", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91306", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91307", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91308", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91309", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91310", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91311", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91313", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91316", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91321", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91322", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91324", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91325", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91326", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91327", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91328", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91329", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91330", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91331", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91333", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91334", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91335", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91337", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91340", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91341", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91342", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91343", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91344", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91345", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91346", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91350", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91351", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91352", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91353", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91354", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91355", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91356", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91357", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91363", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91364", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91365", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91367", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91371", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91372", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91376", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91380", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91381", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91382", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91383", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91384", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91385", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91386", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91387", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91388", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91390", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91392", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91393", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91394", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91395", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91396", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91399", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91401", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91402", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91403", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91404", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91405", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91406", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91407", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91408", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91409", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91410", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91411", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91412", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91413", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91416", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91423", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91426", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91436", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91470", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91482", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91495", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91496", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91497", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91499", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91501", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91502", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91503", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91504", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91505", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91506", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91507", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91508", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91510", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91521", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91522", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91523", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91526", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91601", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91602", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91603", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91604", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91605", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91606", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91607", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91608", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91609", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91610", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91611", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91612", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91614", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91615", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91616", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91617", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91618", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91702", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91706", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91711", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91714", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91715", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91716", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91722", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91723", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91724", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91731", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91732", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91733", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91734", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91735", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91740", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91741", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91744", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91745", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91746", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91747", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91748", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91749", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91750", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91754", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91755", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91756", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91759", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91765", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91766", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91767", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91768", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91769", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91770", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91771", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91772", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91773", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91775", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91776", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91778", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91780", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91788", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91789", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91790", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91791", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91792", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91793", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91795", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91797", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91799", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91801", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91802", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91803", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91804", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91841", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91896", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91899", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93510", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93532", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93534", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93535", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93536", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93539", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93543", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93544", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93550", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93551", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93552", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93553", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93563", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93584", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93586", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93590", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93591", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93599", "FIPS": "06037", "County": "Los Angeles", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93601", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93604", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93610", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93614", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93636", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93637", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93638", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93639", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93643", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93644", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93645", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93653", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93669", "FIPS": "06039", "County": "Madera", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "94901", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94903", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94904", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94912", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94913", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94914", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94915", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94920", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94924", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94925", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94929", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94930", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94933", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94937", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94938", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94939", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94940", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94941", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94942", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94945", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94946", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94947", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94948", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94949", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94950", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94956", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94957", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94960", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94963", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94964", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94965", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94966", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94970", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94971", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94973", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94974", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94976", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94977", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94978", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94979", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94998", "FIPS": "06041", "County": "Marin", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "93623", "FIPS": "06043", "County": "Mariposa", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95306", "FIPS": "06043", "County": "Mariposa", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95311", "FIPS": "06043", "County": "Mariposa", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95318", "FIPS": "06043", "County": "Mariposa", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95325", "FIPS": "06043", "County": "Mariposa", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95338", "FIPS": "06043", "County": "Mariposa", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95345", "FIPS": "06043", "County": "Mariposa", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95389", "FIPS": "06043", "County": "Mariposa", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95410", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95415", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95417", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95418", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95420", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95427", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95428", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95429", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95432", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95437", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95445", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95449", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95454", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95456", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95459", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95460", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95463", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95466", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95468", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95469", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95470", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95481", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95482", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95488", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95490", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95494", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95585", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95587", "FIPS": "06045", "County": "Mendocino", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "93620", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93635", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93661", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93665", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95301", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95303", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95312", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95315", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95317", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95322", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95324", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95333", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95334", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95340", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95341", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95343", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95344", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95348", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95365", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95369", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95374", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95388", "FIPS": "06047", "County": "Merced", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "96006", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96015", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96054", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96101", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96104", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96108", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96110", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96112", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96115", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96116", "FIPS": "06049", "County": "Modoc", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "93512", "FIPS": "06051", "County": "Mono", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "93517", "FIPS": "06051", "County": "Mono", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "93529", "FIPS": "06051", "County": "Mono", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "93541", "FIPS": "06051", "County": "Mono", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "93546", "FIPS": "06051", "County": "Mono", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96107", "FIPS": "06051", "County": "Mono", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "96133", "FIPS": "06051", "County": "Mono", "State": "CA", "DMA": {"Code": 811, "Name": "RENO"}},
  {"Postal_Code": "93426", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93450", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93901", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93902", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93905", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93906", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93907", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93908", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93912", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93915", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93920", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93921", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93922", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93923", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93924", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93925", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93926", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93927", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93928", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93930", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93932", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93933", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93940", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93942", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93943", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93944", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93950", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93953", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93954", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93955", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93960", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "93962", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95004", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95012", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95039", "FIPS": "06053", "County": "Monterey", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "94503", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94508", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94515", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94558", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94559", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94562", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94567", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94573", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94574", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94576", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94581", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94599", "FIPS": "06055", "County": "Napa", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95712", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95724", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95728", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95924", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95945", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95946", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95949", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95959", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95960", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95975", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95977", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95986", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96111", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96160", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96161", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96162", "FIPS": "06057", "County": "Nevada", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "90620", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90621", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90622", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90623", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90624", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90630", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90631", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90632", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90633", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90680", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90720", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90721", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90740", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90742", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "90743", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92602", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92603", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92604", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92605", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92606", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92607", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92609", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92610", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92612", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92614", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92615", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92616", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92617", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92618", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92619", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92620", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92623", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92624", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92625", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92626", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92627", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92628", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92629", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92630", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92637", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92646", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92647", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92648", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92649", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92650", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92651", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92652", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92653", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92654", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92655", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92656", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92657", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92658", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92659", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92660", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92661", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92662", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92663", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92672", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92673", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92674", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92675", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92676", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92677", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92678", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92679", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92683", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92684", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92685", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92688", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92690", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92691", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92692", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92693", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92694", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92697", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92698", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92701", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92702", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92703", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92704", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92705", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92706", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92707", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92708", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92709", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92710", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92711", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92712", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92725", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92728", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92735", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92780", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92781", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92782", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92799", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92801", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92802", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92803", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92804", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92805", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92806", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92807", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92808", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92809", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92811", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92812", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92814", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92815", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92816", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92817", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92821", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92822", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92823", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92825", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92831", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92832", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92833", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92834", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92835", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92836", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92837", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92838", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92840", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92841", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92842", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92843", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92844", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92845", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92846", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92850", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92856", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92857", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92859", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92861", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92862", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92863", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92864", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92865", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92866", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92867", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92868", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92869", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92870", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92871", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92885", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92886", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92887", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92899", "FIPS": "06059", "County": "Orange", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "95602", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95603", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95604", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95631", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95648", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95650", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95658", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95661", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95663", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95677", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95678", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95681", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95701", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95703", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95713", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95714", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95715", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95717", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95722", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95736", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95746", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95747", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95765", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96140", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96141", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96143", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96145", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96146", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96148", "FIPS": "06061", "County": "Placer", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95915", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95923", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95934", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95947", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95956", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95971", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95980", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95983", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95984", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96020", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96103", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96105", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96106", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96122", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96129", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96135", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96137", "FIPS": "06063", "County": "Plumas", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "91752", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92201", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92202", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92203", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92210", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92211", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92220", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92223", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92225", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92226", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92230", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92234", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92235", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92236", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92239", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92240", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92241", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92247", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92248", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92253", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92254", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92255", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92258", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92260", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92261", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92262", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92263", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92264", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92270", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92274", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92276", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92282", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92292", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92320", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92501", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92502", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92503", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92504", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92505", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92506", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92507", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92508", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92509", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92513", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92514", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92515", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92516", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92517", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92518", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92519", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92521", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92522", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92530", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92531", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92532", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92536", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92539", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92543", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92544", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92545", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92546", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92548", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92549", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92551", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92552", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92553", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92554", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92555", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92556", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92557", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92561", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92562", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92563", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92564", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92567", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92570", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92571", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92572", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92581", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92582", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92583", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92584", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92585", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92586", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92587", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92589", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92590", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92591", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92592", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92593", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92595", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92596", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92599", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92860", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92877", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92878", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92879", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92880", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92881", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92882", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92883", "FIPS": "06065", "County": "Riverside", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "94203", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94204", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94205", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94206", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94207", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94208", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94209", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94211", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94229", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94230", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94232", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94234", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94235", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94236", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94237", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94239", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94240", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94244", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94245", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94246", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94247", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94248", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94249", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94250", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94252", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94254", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94256", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94257", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94258", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94259", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94261", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94262", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94263", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94267", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94268", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94269", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94271", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94273", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94274", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94277", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94278", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94279", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94280", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94282", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94283", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94284", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94285", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94286", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94287", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94288", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94289", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94290", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94291", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94293", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94294", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94295", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94296", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94297", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94298", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94299", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95608", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95609", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95610", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95611", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95615", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95621", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95624", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95626", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95628", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95630", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95632", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95638", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95639", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95641", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95652", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95655", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95660", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95662", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95670", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95671", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95673", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95680", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95683", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95690", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95693", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95741", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95742", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95757", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95758", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95759", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95763", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95812", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95813", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95814", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95815", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95816", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95817", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95818", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95819", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95820", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95821", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95822", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95823", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95824", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95825", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95826", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95827", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95828", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95829", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95830", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95831", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95832", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95833", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95834", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95835", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95836", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95837", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95838", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95840", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95841", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95842", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95843", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95851", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95852", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95853", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95860", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95864", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95865", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95866", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95867", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95887", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95894", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95899", "FIPS": "06067", "County": "Sacramento", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95023", "FIPS": "06069", "County": "San Benito", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95024", "FIPS": "06069", "County": "San Benito", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95043", "FIPS": "06069", "County": "San Benito", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95045", "FIPS": "06069", "County": "San Benito", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95075", "FIPS": "06069", "County": "San Benito", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "91701", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91708", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91709", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91710", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91729", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91730", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91737", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91739", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91743", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91758", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91761", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91762", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91763", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91764", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91784", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91785", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91786", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91798", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92242", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92252", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92256", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92267", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92268", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92277", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92278", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92280", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92284", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92285", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92286", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92301", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92304", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92305", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92307", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92308", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92309", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92310", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92311", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92312", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92313", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92314", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92315", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92316", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92317", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92318", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92321", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92322", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92323", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92324", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92325", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92326", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92327", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92329", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92331", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92332", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92333", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92334", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92335", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92336", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92337", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92338", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92339", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92340", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92341", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92342", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92344", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92345", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92346", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92347", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92350", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92352", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92354", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92356", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92357", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92358", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92359", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92363", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92364", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92365", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92366", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92368", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92369", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92371", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92372", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92373", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92374", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92375", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92376", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92377", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92378", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92382", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92385", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92386", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92391", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92392", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92393", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92394", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92395", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92397", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92398", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92399", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92401", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92402", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92403", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92404", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92405", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92406", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92407", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92408", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92410", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92411", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92412", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92413", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92414", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92415", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92418", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92423", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92424", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "92427", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93558", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93562", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93592", "FIPS": "06071", "County": "San Bernardino", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91901", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91902", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91903", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91905", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91906", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91908", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91909", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91910", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91911", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91912", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91913", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91914", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91915", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91916", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91917", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91921", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91931", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91932", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91933", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91934", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91935", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91941", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91942", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91943", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91944", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91945", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91946", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91947", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91948", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91950", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91951", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91962", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91963", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91976", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91977", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91978", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91979", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91980", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91987", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "91990", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92003", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92004", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92007", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92008", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92009", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92010", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92011", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92013", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92014", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92018", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92019", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92020", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92021", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92022", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92023", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92024", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92025", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92026", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92027", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92028", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92029", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92030", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92033", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92036", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92037", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92038", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92039", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92040", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92046", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92049", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92051", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92052", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92054", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92055", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92056", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92057", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92059", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92060", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92061", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92064", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92065", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92066", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92067", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92068", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92069", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92070", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92071", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92072", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92074", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92075", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92078", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92079", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92081", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92082", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92083", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92084", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92085", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92086", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92088", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92090", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92091", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92092", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92093", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92096", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92101", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92102", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92103", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92104", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92105", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92106", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92107", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92108", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92109", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92110", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92111", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92112", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92113", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92114", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92115", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92116", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92117", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92118", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92119", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92120", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92121", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92122", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92123", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92124", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92126", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92127", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92128", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92129", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92130", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92131", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92132", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92133", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92134", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92135", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92136", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92137", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92138", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92139", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92140", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92142", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92143", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92145", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92147", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92149", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92150", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92152", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92153", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92154", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92155", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92158", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92159", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92160", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92161", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92162", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92163", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92164", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92165", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92166", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92167", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92168", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92169", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92170", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92171", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92172", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92173", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92174", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92175", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92176", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92177", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92178", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92179", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92182", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92184", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92186", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92187", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92190", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92191", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92192", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92193", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92194", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92195", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92196", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92197", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92198", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "92199", "FIPS": "06073", "County": "San Diego", "State": "CA", "DMA": {"Code": 825, "Name": "SAN DIEGO"}},
  {"Postal_Code": "94101", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94102", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94103", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94104", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94105", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94106", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94107", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94108", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94109", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94110", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94111", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94112", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94114", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94115", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94116", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94117", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94118", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94119", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94120", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94121", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94122", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94123", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94124", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94125", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94126", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94127", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94129", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94130", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94131", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94132", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94133", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94134", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94135", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94136", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94137", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94138", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94139", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94140", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94141", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94142", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94143", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94144", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94145", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94146", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94147", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94150", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94151", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94152", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94153", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94154", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94155", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94156", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94157", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94158", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94159", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94160", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94161", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94162", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94163", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94164", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94165", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94166", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94167", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94168", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94169", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94170", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94171", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94172", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94175", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94177", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94188", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94199", "FIPS": "06075", "County": "San Francisco", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95201", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95202", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95203", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95204", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95205", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95206", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95207", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95208", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95209", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95210", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95211", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95212", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95213", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95215", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95219", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95220", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95227", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95230", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95231", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95234", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95236", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95237", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95240", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95241", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95242", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95253", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95258", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95267", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95269", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95296", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95297", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95304", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95320", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95330", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95336", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95337", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95366", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95376", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95377", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95378", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95385", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95391", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95686", "FIPS": "06077", "County": "San Joaquin", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "93401", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93402", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93403", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93405", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93406", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93407", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93408", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93409", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93410", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93412", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93420", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93421", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93422", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93423", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93424", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93428", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93430", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93432", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93433", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93435", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93442", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93443", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93444", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93445", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93446", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93447", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93448", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93449", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93451", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93452", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93453", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93461", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93465", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93475", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93483", "FIPS": "06079", "County": "San Luis Obispo", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "94002", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94005", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94010", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94011", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94013", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94014", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94015", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94016", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94017", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94018", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94019", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94020", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94021", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94025", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94026", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94027", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94028", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94030", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94037", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94038", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94044", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94060", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94061", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94062", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94063", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94064", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94065", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94066", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94070", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94074", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94080", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94083", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94096", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94098", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94099", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94128", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94401", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94402", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94403", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94404", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94497", "FIPS": "06081", "County": "San Mateo", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "93013", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93014", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93067", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93101", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93102", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93103", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93105", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93106", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93107", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93108", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93109", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93110", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93111", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93116", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93117", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93118", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93120", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93121", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93130", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93140", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93150", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93160", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93190", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93199", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93254", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93427", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93429", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93434", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93436", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93437", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93438", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93440", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93441", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93454", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93455", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93456", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93457", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93458", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93460", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93463", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "93464", "FIPS": "06083", "County": "Santa Barbara", "State": "CA", "DMA": {"Code": 855, "Name": "SANTA BARBARA-SAN MAR-SAN LUIS OBISPO"}},
  {"Postal_Code": "94022", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94023", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94024", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94035", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94039", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94040", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94041", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94042", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94043", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94085", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94086", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94087", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94088", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94089", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94301", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94302", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94303", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94304", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94305", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94306", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94309", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95002", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95008", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95009", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95011", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95013", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95014", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95015", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95020", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95021", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95026", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95030", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95031", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95032", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95035", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95036", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95037", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95038", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95042", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95044", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95046", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95050", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95051", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95052", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95053", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95054", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95055", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95056", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95070", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95071", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95101", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95103", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95106", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95108", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95109", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95110", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95111", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95112", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95113", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95115", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95116", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95117", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95118", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95119", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95120", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95121", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95122", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95123", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95124", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95125", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95126", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95127", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95128", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95129", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95130", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95131", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95132", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95133", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95134", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95135", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95136", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95138", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95139", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95140", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95141", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95148", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95150", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95151", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95152", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95153", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95154", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95155", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95156", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95157", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95158", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95159", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95160", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95161", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95164", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95170", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95172", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95173", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95190", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95191", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95192", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95193", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95194", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95196", "FIPS": "06085", "County": "Santa Clara", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95001", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95003", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95005", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95006", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95007", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95010", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95017", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95018", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95019", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95033", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95041", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95060", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95061", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95062", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95063", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95064", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95065", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95066", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95067", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95073", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95076", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "95077", "FIPS": "06087", "County": "Santa Cruz", "State": "CA", "DMA": {"Code": 828, "Name": "MONTEREY-SALINAS"}},
  {"Postal_Code": "96001", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96002", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96003", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96007", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96008", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96011", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96013", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96016", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96017", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96019", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96022", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96028", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96033", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96040", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96047", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96049", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96051", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96062", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96065", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96069", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96070", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96071", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96073", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96076", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96079", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96084", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96087", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96088", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96089", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96095", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96096", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96099", "FIPS": "06089", "County": "Shasta", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95910", "FIPS": "06091", "County": "Sierra", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95936", "FIPS": "06091", "County": "Sierra", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95944", "FIPS": "06091", "County": "Sierra", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96118", "FIPS": "06091", "County": "Sierra", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96124", "FIPS": "06091", "County": "Sierra", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96125", "FIPS": "06091", "County": "Sierra", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96126", "FIPS": "06091", "County": "Sierra", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95568", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96014", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96023", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96025", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96027", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96031", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96032", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96034", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96037", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96038", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96039", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96044", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96050", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96057", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96058", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96064", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96067", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96085", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96086", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96094", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96097", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "96134", "FIPS": "06093", "County": "Siskiyou", "State": "CA", "DMA": {"Code": 813, "Name": "MEDFORD-KLAMATH FALLS"}},
  {"Postal_Code": "94510", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94512", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94533", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94534", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94535", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94571", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94585", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94589", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94590", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94591", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94592", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95620", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95625", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95687", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95688", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95696", "FIPS": "06095", "County": "Solano", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "94922", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94923", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94926", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94927", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94928", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94931", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94951", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94952", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94953", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94954", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94955", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94972", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94975", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "94999", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95401", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95402", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95403", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95404", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95405", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95406", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95407", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95408", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95409", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95412", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95416", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95419", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95421", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95425", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95430", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95431", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95433", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95436", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95439", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95441", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95442", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95444", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95446", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95448", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95450", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95452", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95462", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95465", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95471", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95472", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95473", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95476", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95480", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95486", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95487", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95492", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95497", "FIPS": "06097", "County": "Sonoma", "State": "CA", "DMA": {"Code": 807, "Name": "SAN FRANCISCO-OAKLAND-SAN JOSE"}},
  {"Postal_Code": "95307", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95313", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95316", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95319", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95323", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95326", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95328", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95329", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95350", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95351", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95352", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95353", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95354", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95355", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95356", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95357", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95358", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95360", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95361", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95363", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95367", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95368", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95380", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95381", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95382", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95386", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95387", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95397", "FIPS": "06099", "County": "Stanislaus", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95659", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95668", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95674", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95676", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95953", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95957", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95982", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95991", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95992", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95993", "FIPS": "06101", "County": "Sutter", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "96021", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96029", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96035", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96055", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96059", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96061", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96063", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96074", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96075", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96078", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96080", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96090", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96092", "FIPS": "06103", "County": "Tehama", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95527", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95552", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95563", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "95595", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96010", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96024", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96041", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96046", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96048", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96052", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96091", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "96093", "FIPS": "06105", "County": "Trinity", "State": "CA", "DMA": {"Code": 868, "Name": "CHICO-REDDING"}},
  {"Postal_Code": "93201", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93207", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93208", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93218", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93219", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93221", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93223", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93227", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93235", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93237", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93244", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93247", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93256", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93257", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93258", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93260", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93261", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93262", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93265", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93267", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93270", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93271", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93272", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93274", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93275", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93277", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93278", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93279", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93282", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93286", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93290", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93291", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93292", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93603", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93615", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93618", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93633", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93647", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93666", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93670", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "93673", "FIPS": "06107", "County": "Tulare", "State": "CA", "DMA": {"Code": 866, "Name": "FRESNO-VISALIA"}},
  {"Postal_Code": "95305", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95309", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95310", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95314", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95321", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95327", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95335", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95346", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95347", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95364", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95370", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95372", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95373", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95375", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95379", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95383", "FIPS": "06109", "County": "Tuolumne", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "91319", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91320", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91358", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91359", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91360", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91361", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91362", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "91377", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93001", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93002", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93003", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93004", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93005", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93006", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93007", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93009", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93010", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93011", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93012", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93015", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93016", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93020", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93021", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93022", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93023", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93024", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93030", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93031", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93032", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93033", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93034", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93035", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93036", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93040", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93041", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93042", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93043", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93044", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93060", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93061", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93062", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93063", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93064", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93065", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93066", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93093", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93094", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "93099", "FIPS": "06111", "County": "Ventura", "State": "CA", "DMA": {"Code": 803, "Name": "LOS ANGELES"}},
  {"Postal_Code": "95605", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95606", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95607", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95612", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95616", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95617", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95618", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95627", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95637", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95645", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95653", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95679", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95691", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95694", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95695", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95697", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95698", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95776", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95798", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95799", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95937", "FIPS": "06113", "County": "Yolo", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95692", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95901", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95903", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95918", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95919", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95922", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95925", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95935", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95961", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95962", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95972", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "95981", "FIPS": "06115", "County": "Yuba", "State": "CA", "DMA": {"Code": 862, "Name": "SACRAMENTO-STOCKTON-MODESTO"}},
  {"Postal_Code": "80011", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80019", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80022", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80024", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80030", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80031", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80035", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80036", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80037", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80040", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80042", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80045", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80102", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80136", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80137", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80221", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80229", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80233", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80234", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80241", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80260", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80601", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80602", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80614", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80640", "FIPS": "08001", "County": "Adams", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81101", "FIPS": "08003", "County": "Alamosa", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81102", "FIPS": "08003", "County": "Alamosa", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81136", "FIPS": "08003", "County": "Alamosa", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81146", "FIPS": "08003", "County": "Alamosa", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80010", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80012", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80013", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80014", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80015", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80016", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80017", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80018", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80041", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80044", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80046", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80047", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80103", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80105", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80110", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80111", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80112", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80113", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80120", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80121", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80122", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80150", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80151", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80155", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80160", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80161", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80165", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80166", "FIPS": "08005", "County": "Arapahoe", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81121", "FIPS": "08007", "County": "Archuleta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81127", "FIPS": "08007", "County": "Archuleta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81128", "FIPS": "08007", "County": "Archuleta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81147", "FIPS": "08007", "County": "Archuleta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81157", "FIPS": "08007", "County": "Archuleta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81029", "FIPS": "08009", "County": "Baca", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81064", "FIPS": "08009", "County": "Baca", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81073", "FIPS": "08009", "County": "Baca", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81084", "FIPS": "08009", "County": "Baca", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81087", "FIPS": "08009", "County": "Baca", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81090", "FIPS": "08009", "County": "Baca", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81038", "FIPS": "08011", "County": "Bent", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81044", "FIPS": "08011", "County": "Bent", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81054", "FIPS": "08011", "County": "Bent", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81057", "FIPS": "08011", "County": "Bent", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80025", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80026", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80027", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80028", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80301", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80302", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80303", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80304", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80305", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80306", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80307", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80308", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80309", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80310", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80314", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80321", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80322", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80323", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80328", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80329", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80455", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80466", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80471", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80481", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80501", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80502", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80503", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80510", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80533", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80540", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80544", "FIPS": "08013", "County": "Boulder", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80020", "FIPS": "08014", "County": "Broomfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80021", "FIPS": "08014", "County": "Broomfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80038", "FIPS": "08014", "County": "Broomfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81201", "FIPS": "08015", "County": "Chaffee", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81211", "FIPS": "08015", "County": "Chaffee", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81227", "FIPS": "08015", "County": "Chaffee", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81228", "FIPS": "08015", "County": "Chaffee", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81236", "FIPS": "08015", "County": "Chaffee", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81242", "FIPS": "08015", "County": "Chaffee", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80802", "FIPS": "08017", "County": "Cheyenne", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80810", "FIPS": "08017", "County": "Cheyenne", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80825", "FIPS": "08017", "County": "Cheyenne", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80862", "FIPS": "08017", "County": "Cheyenne", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80436", "FIPS": "08019", "County": "Clear Creek", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80438", "FIPS": "08019", "County": "Clear Creek", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80444", "FIPS": "08019", "County": "Clear Creek", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80452", "FIPS": "08019", "County": "Clear Creek", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80476", "FIPS": "08019", "County": "Clear Creek", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81120", "FIPS": "08021", "County": "Conejos", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81124", "FIPS": "08021", "County": "Conejos", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81129", "FIPS": "08021", "County": "Conejos", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81140", "FIPS": "08021", "County": "Conejos", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81141", "FIPS": "08021", "County": "Conejos", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81148", "FIPS": "08021", "County": "Conejos", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81151", "FIPS": "08021", "County": "Conejos", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81123", "FIPS": "08023", "County": "Costilla", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81126", "FIPS": "08023", "County": "Costilla", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81133", "FIPS": "08023", "County": "Costilla", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81134", "FIPS": "08023", "County": "Costilla", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81138", "FIPS": "08023", "County": "Costilla", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81152", "FIPS": "08023", "County": "Costilla", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81153", "FIPS": "08023", "County": "Costilla", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81033", "FIPS": "08025", "County": "Crowley", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81034", "FIPS": "08025", "County": "Crowley", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81062", "FIPS": "08025", "County": "Crowley", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81063", "FIPS": "08025", "County": "Crowley", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81076", "FIPS": "08025", "County": "Crowley", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81252", "FIPS": "08027", "County": "Custer", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81253", "FIPS": "08027", "County": "Custer", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81410", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81413", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81414", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81415", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81416", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81418", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81419", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81420", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81428", "FIPS": "08029", "County": "Delta", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80201", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80202", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80203", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80204", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80205", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80206", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80207", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80208", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80209", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80210", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80211", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80212", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80216", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80217", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80218", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80219", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80220", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80222", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80223", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80224", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80230", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80231", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80236", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80237", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80238", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80239", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80243", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80244", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80246", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80247", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80248", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80249", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80250", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80251", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80252", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80256", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80257", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80259", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80261", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80262", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80263", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80264", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80265", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80266", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80271", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80273", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80274", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80279", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80280", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80281", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80290", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80291", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80293", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80294", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80295", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80299", "FIPS": "08031", "County": "Denver", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81320", "FIPS": "08033", "County": "Dolores", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81324", "FIPS": "08033", "County": "Dolores", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81332", "FIPS": "08033", "County": "Dolores", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80104", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80108", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80109", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80116", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80118", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80124", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80125", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80126", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80129", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80130", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80131", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80134", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80135", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80138", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80163", "FIPS": "08035", "County": "Douglas", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80423", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80426", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80463", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81620", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81621", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81631", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81632", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81637", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81645", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81649", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81655", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81657", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81658", "FIPS": "08037", "County": "Eagle", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80101", "FIPS": "08039", "County": "Elbert", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80107", "FIPS": "08039", "County": "Elbert", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80117", "FIPS": "08039", "County": "Elbert", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80830", "FIPS": "08039", "County": "Elbert", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80835", "FIPS": "08039", "County": "Elbert", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80106", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80132", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80133", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80808", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80809", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80817", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80819", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80829", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80831", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80832", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80833", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80840", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80841", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80864", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80901", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80903", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80904", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80905", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80906", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80907", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80908", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80909", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80910", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80911", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80912", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80913", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80914", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80915", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80916", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80917", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80918", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80919", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80920", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80921", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80922", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80923", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80924", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80925", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80926", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80927", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80928", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80929", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80930", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80931", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80932", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80933", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80934", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80935", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80936", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80937", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80938", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80939", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80940", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80941", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80942", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80943", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80944", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80945", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80946", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80947", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80949", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80950", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80951", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80960", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80962", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80970", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80977", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80995", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80997", "FIPS": "08041", "County": "El Paso", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81212", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81215", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81221", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81222", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81223", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81226", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81232", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81233", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81240", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81244", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81290", "FIPS": "08043", "County": "Fremont", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81601", "FIPS": "08045", "County": "Garfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81602", "FIPS": "08045", "County": "Garfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81623", "FIPS": "08045", "County": "Garfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81635", "FIPS": "08045", "County": "Garfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81636", "FIPS": "08045", "County": "Garfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81647", "FIPS": "08045", "County": "Garfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81650", "FIPS": "08045", "County": "Garfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81652", "FIPS": "08045", "County": "Garfield", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80422", "FIPS": "08047", "County": "Gilpin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80427", "FIPS": "08047", "County": "Gilpin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80474", "FIPS": "08047", "County": "Gilpin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80442", "FIPS": "08049", "County": "Grand", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80446", "FIPS": "08049", "County": "Grand", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80447", "FIPS": "08049", "County": "Grand", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80451", "FIPS": "08049", "County": "Grand", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80459", "FIPS": "08049", "County": "Grand", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80468", "FIPS": "08049", "County": "Grand", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80478", "FIPS": "08049", "County": "Grand", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80482", "FIPS": "08049", "County": "Grand", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81210", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81224", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81225", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81230", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81231", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81237", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81239", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81241", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81243", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81247", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81434", "FIPS": "08051", "County": "Gunnison", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81235", "FIPS": "08053", "County": "Hinsdale", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81040", "FIPS": "08055", "County": "Huerfano", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81055", "FIPS": "08055", "County": "Huerfano", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81089", "FIPS": "08055", "County": "Huerfano", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80430", "FIPS": "08057", "County": "Jackson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80434", "FIPS": "08057", "County": "Jackson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80473", "FIPS": "08057", "County": "Jackson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80480", "FIPS": "08057", "County": "Jackson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80001", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80002", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80003", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80004", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80005", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80006", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80007", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80033", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80034", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80123", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80127", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80128", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80162", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80214", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80215", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80225", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80226", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80227", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80228", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80232", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80235", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80401", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80402", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80403", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80419", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80425", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80433", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80437", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80439", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80453", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80454", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80457", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80465", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80470", "FIPS": "08059", "County": "Jefferson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81021", "FIPS": "08061", "County": "Kiowa", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81036", "FIPS": "08061", "County": "Kiowa", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81045", "FIPS": "08061", "County": "Kiowa", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81071", "FIPS": "08061", "County": "Kiowa", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80805", "FIPS": "08063", "County": "Kit Carson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80807", "FIPS": "08063", "County": "Kit Carson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80815", "FIPS": "08063", "County": "Kit Carson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80834", "FIPS": "08063", "County": "Kit Carson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80836", "FIPS": "08063", "County": "Kit Carson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80861", "FIPS": "08063", "County": "Kit Carson", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80429", "FIPS": "08065", "County": "Lake", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80461", "FIPS": "08065", "County": "Lake", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81251", "FIPS": "08065", "County": "Lake", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81122", "FIPS": "08067", "County": "La Plata", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81137", "FIPS": "08067", "County": "La Plata", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81301", "FIPS": "08067", "County": "La Plata", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81302", "FIPS": "08067", "County": "La Plata", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81303", "FIPS": "08067", "County": "La Plata", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81326", "FIPS": "08067", "County": "La Plata", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81329", "FIPS": "08067", "County": "La Plata", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "80511", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80512", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80513", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80515", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80517", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80521", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80522", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80523", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80524", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80525", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80526", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80527", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80528", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80532", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80535", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80536", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80537", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80538", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80539", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80541", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80545", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80547", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80549", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80553", "FIPS": "08069", "County": "Larimer", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81020", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81024", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81027", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81046", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81049", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81059", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81081", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81082", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81091", "FIPS": "08071", "County": "Las Animas", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80804", "FIPS": "08073", "County": "Lincoln", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80818", "FIPS": "08073", "County": "Lincoln", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80821", "FIPS": "08073", "County": "Lincoln", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80823", "FIPS": "08073", "County": "Lincoln", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80826", "FIPS": "08073", "County": "Lincoln", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80828", "FIPS": "08073", "County": "Lincoln", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80722", "FIPS": "08075", "County": "Logan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80726", "FIPS": "08075", "County": "Logan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80728", "FIPS": "08075", "County": "Logan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80736", "FIPS": "08075", "County": "Logan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80741", "FIPS": "08075", "County": "Logan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80745", "FIPS": "08075", "County": "Logan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80747", "FIPS": "08075", "County": "Logan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80751", "FIPS": "08075", "County": "Logan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81501", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81502", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81503", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81504", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81505", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81506", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81520", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81521", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81522", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81523", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81524", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81525", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81526", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81527", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81624", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81630", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81643", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81646", "FIPS": "08077", "County": "Mesa", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81130", "FIPS": "08079", "County": "Mineral", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81610", "FIPS": "08081", "County": "Moffat", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81625", "FIPS": "08081", "County": "Moffat", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81626", "FIPS": "08081", "County": "Moffat", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81633", "FIPS": "08081", "County": "Moffat", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81638", "FIPS": "08081", "County": "Moffat", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81640", "FIPS": "08081", "County": "Moffat", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81653", "FIPS": "08081", "County": "Moffat", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81321", "FIPS": "08083", "County": "Montezuma", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81323", "FIPS": "08083", "County": "Montezuma", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81327", "FIPS": "08083", "County": "Montezuma", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81328", "FIPS": "08083", "County": "Montezuma", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81330", "FIPS": "08083", "County": "Montezuma", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81331", "FIPS": "08083", "County": "Montezuma", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81334", "FIPS": "08083", "County": "Montezuma", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81335", "FIPS": "08083", "County": "Montezuma", "State": "CO", "DMA": {"Code": 790, "Name": "ALBUQUERQUE-SANTA FE"}},
  {"Postal_Code": "81220", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81401", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81402", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81411", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81422", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81424", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81425", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81429", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "81431", "FIPS": "08085", "County": "Montrose", "State": "CO", "DMA": {"Code": 773, "Name": "GRAND JUNCTION-MONTROSE"}},
  {"Postal_Code": "80649", "FIPS": "08087", "County": "Morgan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80653", "FIPS": "08087", "County": "Morgan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80654", "FIPS": "08087", "County": "Morgan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80701", "FIPS": "08087", "County": "Morgan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80705", "FIPS": "08087", "County": "Morgan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80723", "FIPS": "08087", "County": "Morgan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80733", "FIPS": "08087", "County": "Morgan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80750", "FIPS": "08087", "County": "Morgan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81030", "FIPS": "08089", "County": "Otero", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81039", "FIPS": "08089", "County": "Otero", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81050", "FIPS": "08089", "County": "Otero", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81058", "FIPS": "08089", "County": "Otero", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81067", "FIPS": "08089", "County": "Otero", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81077", "FIPS": "08089", "County": "Otero", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81427", "FIPS": "08091", "County": "Ouray", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81432", "FIPS": "08091", "County": "Ouray", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80420", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80421", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80432", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80440", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80448", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80449", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80456", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80475", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80820", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80827", "FIPS": "08093", "County": "Park", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80721", "FIPS": "08095", "County": "Phillips", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80731", "FIPS": "08095", "County": "Phillips", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80734", "FIPS": "08095", "County": "Phillips", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80746", "FIPS": "08095", "County": "Phillips", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81611", "FIPS": "08097", "County": "Pitkin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81612", "FIPS": "08097", "County": "Pitkin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81615", "FIPS": "08097", "County": "Pitkin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81642", "FIPS": "08097", "County": "Pitkin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81654", "FIPS": "08097", "County": "Pitkin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81656", "FIPS": "08097", "County": "Pitkin", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81041", "FIPS": "08099", "County": "Prowers", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81043", "FIPS": "08099", "County": "Prowers", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81047", "FIPS": "08099", "County": "Prowers", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81052", "FIPS": "08099", "County": "Prowers", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81092", "FIPS": "08099", "County": "Prowers", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81001", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81002", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81003", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81004", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81005", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81006", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81007", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81008", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81009", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81010", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81011", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81012", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81019", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81022", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81023", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81025", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81069", "FIPS": "08101", "County": "Pueblo", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "81641", "FIPS": "08103", "County": "Rio Blanco", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81648", "FIPS": "08103", "County": "Rio Blanco", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81125", "FIPS": "08105", "County": "Rio Grande", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81132", "FIPS": "08105", "County": "Rio Grande", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81135", "FIPS": "08105", "County": "Rio Grande", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81144", "FIPS": "08105", "County": "Rio Grande", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81154", "FIPS": "08105", "County": "Rio Grande", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80428", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80467", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80469", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80477", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80479", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80483", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80487", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80488", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81639", "FIPS": "08107", "County": "Routt", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81131", "FIPS": "08109", "County": "Saguache", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81143", "FIPS": "08109", "County": "Saguache", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81149", "FIPS": "08109", "County": "Saguache", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81155", "FIPS": "08109", "County": "Saguache", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81248", "FIPS": "08109", "County": "Saguache", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81433", "FIPS": "08111", "County": "San Juan", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81325", "FIPS": "08113", "County": "San Miguel", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81423", "FIPS": "08113", "County": "San Miguel", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81426", "FIPS": "08113", "County": "San Miguel", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81430", "FIPS": "08113", "County": "San Miguel", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "81435", "FIPS": "08113", "County": "San Miguel", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80737", "FIPS": "08115", "County": "Sedgwick", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80744", "FIPS": "08115", "County": "Sedgwick", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80749", "FIPS": "08115", "County": "Sedgwick", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80424", "FIPS": "08117", "County": "Summit", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80435", "FIPS": "08117", "County": "Summit", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80443", "FIPS": "08117", "County": "Summit", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80497", "FIPS": "08117", "County": "Summit", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80498", "FIPS": "08117", "County": "Summit", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80813", "FIPS": "08119", "County": "Teller", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80814", "FIPS": "08119", "County": "Teller", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80816", "FIPS": "08119", "County": "Teller", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80860", "FIPS": "08119", "County": "Teller", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80863", "FIPS": "08119", "County": "Teller", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80866", "FIPS": "08119", "County": "Teller", "State": "CO", "DMA": {"Code": 752, "Name": "COLORADO SPRINGS-PUEBLO"}},
  {"Postal_Code": "80720", "FIPS": "08121", "County": "Washington", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80740", "FIPS": "08121", "County": "Washington", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80743", "FIPS": "08121", "County": "Washington", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80757", "FIPS": "08121", "County": "Washington", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80801", "FIPS": "08121", "County": "Washington", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80812", "FIPS": "08121", "County": "Washington", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80504", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80514", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80516", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80520", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80530", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80534", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80542", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80543", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80546", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80550", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80551", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80603", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80610", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80611", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80612", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80615", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80620", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80621", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80622", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80623", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80624", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80631", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80632", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80633", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80634", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80638", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80639", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80642", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80643", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80644", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80645", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80646", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80648", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80650", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80651", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80652", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80729", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80732", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80742", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80754", "FIPS": "08123", "County": "Weld", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80727", "FIPS": "08125", "County": "Yuma", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80735", "FIPS": "08125", "County": "Yuma", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80755", "FIPS": "08125", "County": "Yuma", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80758", "FIPS": "08125", "County": "Yuma", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80759", "FIPS": "08125", "County": "Yuma", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80822", "FIPS": "08125", "County": "Yuma", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "80824", "FIPS": "08125", "County": "Yuma", "State": "CO", "DMA": {"Code": 751, "Name": "DENVER"}},
  {"Postal_Code": "06404", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06440", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06468", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06470", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06482", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06484", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06491", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06497", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06601", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06602", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06604", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06605", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06606", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06607", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06608", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06610", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06611", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06612", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06614", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06615", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06650", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06673", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06699", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06784", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06801", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06804", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06807", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06810", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06811", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06812", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06813", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06814", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06816", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06817", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06820", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06824", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06825", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06828", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06829", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06830", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06831", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06832", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06836", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06838", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06840", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06842", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06850", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06851", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06852", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06853", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06854", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06855", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06856", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06857", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06858", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06859", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06860", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06870", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06875", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06876", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06877", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06878", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06879", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06880", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06881", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06883", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06888", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06889", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06890", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06896", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06897", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06901", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06902", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06903", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06904", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06905", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06906", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06907", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06910", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06911", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06912", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06913", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06914", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06920", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06921", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06922", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06925", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06926", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06927", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06928", "FIPS": "09001", "County": "Fairfield", "State": "CT", "DMA": {"Code": 501, "Name": "NEW YORK"}},
  {"Postal_Code": "06001", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06002", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06006", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06010", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06011", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06013", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06016", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06019", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06020", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06022", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06023", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06025", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06026", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06027", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06028", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06030", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06032", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06033", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06034", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06035", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06037", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06040", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06041", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06042", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06045", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06050", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06051", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06052", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06053", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06059", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06060", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06062", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06064", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06067", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06070", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06073", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06074", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06078", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06080", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06081", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06082", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06083", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06085", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06087", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06088", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06089", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06090", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06091", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06092", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06093", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06095", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06096", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06101", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06102", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06103", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06104", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06105", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06106", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06107", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06108", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06109", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06110", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06111", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06112", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06114", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06115", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06117", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06118", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06119", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06120", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06123", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06126", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06127", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06128", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06129", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06131", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06132", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06133", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06134", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06137", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06138", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06140", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06141", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06142", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06143", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06144", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06145", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06146", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06147", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06150", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06151", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06152", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06153", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06154", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06155", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06156", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06160", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06161", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06167", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06176", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06180", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06183", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06199", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06444", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06447", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06467", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06479", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06489", "FIPS": "09003", "County": "Hartford", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06018", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06021", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06024", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06031", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06039", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06057", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06058", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06061", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06063", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06065", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06068", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06069", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06079", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06094", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06098", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06750", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06751", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06752", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06753", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06754", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06755", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06756", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06757", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06758", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06759", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06763", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06776", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06777", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06778", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06779", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06781", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06782", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06783", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06785", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06786", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06787", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06790", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06791", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06792", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06793", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06794", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06795", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06796", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06798", "FIPS": "09005", "County": "Litchfield", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06409", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06412", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06413", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06414", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06416", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06417", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06419", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06422", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06423", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06424", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06426", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06438", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06441", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06442", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06455", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06456", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06457", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06459", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06469", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06475", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06480", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06481", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06498", "FIPS": "09007", "County": "Middlesex", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06401", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06403", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06405", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06408", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06410", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06411", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06418", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06437", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06443", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06450", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06451", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06454", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06460", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06461", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06471", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06472", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06473", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06477", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06478", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06483", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06487", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06488", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06492", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06493", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06494", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06495", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06501", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06502", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06503", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06504", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06505", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06506", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06507", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06508", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06509", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06510", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06511", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06512", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06513", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06514", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06515", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06516", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06517", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06518", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06519", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06520", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06521", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06524", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06525", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06530", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06531", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06532", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06533", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06534", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06535", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06536", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06537", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06538", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06540", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06701", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06702", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06703", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06704", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06705", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06706", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06708", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06710", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06712", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06716", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06720", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06721", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06722", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06723", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06724", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06725", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06726", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06749", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06762", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06770", "FIPS": "09009", "County": "New Haven", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06249", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06254", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06320", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06330", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06333", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06334", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06335", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06336", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06338", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06339", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06340", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06349", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06350", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06351", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06353", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06355", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06357", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06359", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06360", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06365", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06370", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06371", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06372", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06375", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06376", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06378", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06379", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06380", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06382", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06383", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06384", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06385", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06386", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06388", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06389", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06415", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06420", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06439", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06474", "FIPS": "09011", "County": "New London", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06029", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06043", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06066", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06071", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06072", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06075", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06076", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06077", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06084", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06231", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06232", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06237", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06238", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06248", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06250", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06251", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06265", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06268", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06269", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06279", "FIPS": "09013", "County": "Tolland", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06226", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06230", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06233", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06234", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06235", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06239", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06241", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06242", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06243", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06244", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06245", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06246", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06247", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06255", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06256", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06258", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06259", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06260", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06262", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06263", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06264", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06266", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06267", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06277", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06278", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06280", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06281", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06282", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06331", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06332", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06354", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06373", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06374", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06377", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "06387", "FIPS": "09015", "County": "Windham", "State": "CT", "DMA": {"Code": 533, "Name": "HARTFORD-NEW HAVEN"}},
  {"Postal_Code": "19901", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19902", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19903", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19904", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19905", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19906", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19934", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19936", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19938", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19943", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19946", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19952", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19953", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19954", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19955", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19961", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19962", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19964", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19977", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19979", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19980", "FIPS": "10001", "County": "Kent", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19701", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19702", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19703", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19706", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19707", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19708", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19709", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19710", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19711", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19712", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19713", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19714", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19715", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19716", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19717", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19718", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19720", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19721", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19725", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19726", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19730", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19731", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19732", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19733", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19734", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19735", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19736", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19801", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19802", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19803", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19804", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19805", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19806", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19807", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19808", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19809", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19810", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19850", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19880", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19884", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19885", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19886", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19887", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19889", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19890", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19891", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19892", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19893", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19894", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19895", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19896", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19897", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19898", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19899", "FIPS": "10003", "County": "New Castle", "State": "DE", "DMA": {"Code": 504, "Name": "PHILADELPHIA"}},
  {"Postal_Code": "19930", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19931", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19933", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19939", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19940", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19941", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19944", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19945", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19947", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19950", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19951", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19956", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19958", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19960", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19963", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19966", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19967", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19968", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19969", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19970", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19971", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19973", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "19975", "FIPS": "10005", "County": "Sussex", "State": "DE", "DMA": {"Code": 576, "Name": "SALISBURY"}},
  {"Postal_Code": "20001", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20002", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20003", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20004", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20005", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20006", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20007", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20008", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20009", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20010", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20011", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20012", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20013", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20015", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20016", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20017", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20018", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20019", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20020", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20022", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20023", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20024", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20026", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20027", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20029", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20030", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20032", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20033", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20035", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20036", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20037", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20038", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20039", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20040", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20041", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20042", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20043", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20044", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20045", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20046", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20047", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20049", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20050", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20051", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20052", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20053", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20055", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20056", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20057", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20058", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20059", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20060", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20061", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20062", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20063", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20064", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20065", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20066", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20067", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20068", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20069", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20070", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20071", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20073", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20074", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20075", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20076", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20077", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20078", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20080", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20081", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20082", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20088", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20090", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20091", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20097", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20098", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20201", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20202", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20203", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20204", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20206", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20207", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20208", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20210", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20211", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20212", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20213", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20214", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20215", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20216", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20217", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20218", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20219", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20220", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20221", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20222", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20223", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20224", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20226", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20227", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20228", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20229", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20230", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20232", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20233", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20235", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20237", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20238", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20239", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20240", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20241", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20242", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20244", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20245", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20250", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20251", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20254", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20260", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20261", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20262", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20265", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20266", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20268", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20270", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20277", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20289", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20299", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20301", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20303", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20306", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20307", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20310", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20314", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20317", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20318", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20319", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20330", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20340", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20350", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20355", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20370", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20372", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20373", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20374", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20375", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20376", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20380", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20388", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20389", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20390", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20391", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20392", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20393", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20394", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20395", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20398", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20401", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20402", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20403", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20404", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20405", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20406", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20407", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20408", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20409", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20410", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20411", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20412", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20413", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20414", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20415", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20416", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20418", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20419", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20420", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20421", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20422", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20423", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20424", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20425", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20426", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20427", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20428", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20429", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20431", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20433", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20434", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20435", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20436", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20437", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20439", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20440", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20441", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20442", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20444", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20447", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20451", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20453", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20456", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20460", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20463", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20468", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20469", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20470", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20472", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20500", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20501", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20502", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20503", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20504", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20505", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20506", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20507", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20508", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20509", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20510", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20511", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20515", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20520", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20521", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20522", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20523", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20524", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20525", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20526", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20527", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20528", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20529", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20530", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20531", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20532", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20533", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20534", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20535", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20536", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20537", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20538", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20539", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20540", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20541", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20542", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20543", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20544", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20546", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20547", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20548", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20549", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20551", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20552", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20553", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20554", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20555", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20557", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20558", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20559", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20560", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20565", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20566", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20570", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20571", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20572", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20573", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20575", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20576", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20577", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20578", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20579", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20580", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20581", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20585", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20586", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20590", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20591", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20593", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20594", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20597", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "20599", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "56901", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "56915", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "56920", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "56933", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "56944", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "56972", "FIPS": "11001", "County": "District of Columbia", "State": "DC", "DMA": {"Code": 511, "Name": "WASHINGTON, DC-HAGRSTWN"}},
  {"Postal_Code": "32601", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32602", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32603", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32604", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32605", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32606", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32607", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32608", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32609", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32610", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32611", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32612", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32613", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32614", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32615", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32616", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32618", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32627", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32631", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32633", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32635", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32640", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32641", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32643", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32653", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32654", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32655", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32658", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32662", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32667", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32669", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32694", "FIPS": "12001", "County": "Alachua", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32040", "FIPS": "12003", "County": "Baker", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32063", "FIPS": "12003", "County": "Baker", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32072", "FIPS": "12003", "County": "Baker", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32087", "FIPS": "12003", "County": "Baker", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32401", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32402", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32403", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32404", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32405", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32406", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32407", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32408", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32409", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32410", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32411", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32412", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32413", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32417", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32438", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32444", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32466", "FIPS": "12005", "County": "Bay", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32042", "FIPS": "12007", "County": "Bradford", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32044", "FIPS": "12007", "County": "Bradford", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32058", "FIPS": "12007", "County": "Bradford", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32091", "FIPS": "12007", "County": "Bradford", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32622", "FIPS": "12007", "County": "Bradford", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32754", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32775", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32780", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32781", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32782", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32783", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32796", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32815", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32899", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32901", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32902", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32903", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32904", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32905", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32906", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32907", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32908", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32909", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32910", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32911", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32912", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32919", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32920", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32922", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32923", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32924", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32925", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32926", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32927", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32931", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32932", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32934", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32935", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32936", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32937", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32940", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32941", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32949", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32950", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32951", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32952", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32953", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32954", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32955", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32956", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32959", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32976", "FIPS": "12009", "County": "Brevard", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "33004", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33008", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33009", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33019", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33020", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33021", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33022", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33023", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33024", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33025", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33026", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33027", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33028", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33029", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33060", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33061", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33062", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33063", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33064", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33065", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33066", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33067", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33068", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33069", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33071", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33072", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33073", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33074", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33075", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33076", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33077", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33081", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33082", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33083", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33084", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33093", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33097", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33301", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33302", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33303", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33304", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33305", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33306", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33307", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33308", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33309", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33310", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33311", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33312", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33313", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33314", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33315", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33316", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33317", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33318", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33319", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33320", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33321", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33322", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33323", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33324", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33325", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33326", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33327", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33328", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33329", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33330", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33331", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33332", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33334", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33335", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33336", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33337", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33338", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33339", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33340", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33345", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33346", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33348", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33349", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33351", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33355", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33359", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33388", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33394", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33441", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33442", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33443", "FIPS": "12011", "County": "Broward", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "32421", "FIPS": "12013", "County": "Calhoun", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32424", "FIPS": "12013", "County": "Calhoun", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32430", "FIPS": "12013", "County": "Calhoun", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32449", "FIPS": "12013", "County": "Calhoun", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "33927", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33938", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33946", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33947", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33948", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33949", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33950", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33951", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33952", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33953", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33954", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33955", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33980", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33981", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33982", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33983", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34224", "FIPS": "12015", "County": "Charlotte", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34423", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34428", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34429", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34433", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34434", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34436", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34442", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34445", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34446", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34447", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34448", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34450", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34451", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34452", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34453", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34460", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34461", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34464", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34465", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34487", "FIPS": "12017", "County": "Citrus", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "32003", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32006", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32030", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32043", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32050", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32065", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32067", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32068", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32073", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32079", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32160", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32656", "FIPS": "12019", "County": "Clay", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "34101", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34102", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34103", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34104", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34105", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34106", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34107", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34108", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34109", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34110", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34112", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34113", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34114", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34116", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34117", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34119", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34120", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34137", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34138", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34139", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34140", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34141", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34142", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34143", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34145", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34146", "FIPS": "12021", "County": "Collier", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "32024", "FIPS": "12023", "County": "Columbia", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32025", "FIPS": "12023", "County": "Columbia", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32038", "FIPS": "12023", "County": "Columbia", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32055", "FIPS": "12023", "County": "Columbia", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32056", "FIPS": "12023", "County": "Columbia", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32061", "FIPS": "12023", "County": "Columbia", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "34265", "FIPS": "12027", "County": "De Soto", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34266", "FIPS": "12027", "County": "De Soto", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34267", "FIPS": "12027", "County": "De Soto", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34268", "FIPS": "12027", "County": "De Soto", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34269", "FIPS": "12027", "County": "De Soto", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "32628", "FIPS": "12029", "County": "Dixie", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32648", "FIPS": "12029", "County": "Dixie", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32680", "FIPS": "12029", "County": "Dixie", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32692", "FIPS": "12029", "County": "Dixie", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32099", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32201", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32202", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32203", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32204", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32205", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32206", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32207", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32208", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32209", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32210", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32211", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32212", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32214", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32215", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32216", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32217", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32218", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32219", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32220", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32221", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32222", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32223", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32224", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32225", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32226", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32227", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32228", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32229", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32230", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32231", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32232", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32233", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32234", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32235", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32236", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32237", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32238", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32239", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32240", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32241", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32244", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32245", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32246", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32247", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32250", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32254", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32255", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32256", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32257", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32258", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32266", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32267", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32277", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32290", "FIPS": "12031", "County": "Duval", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32501", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32502", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32503", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32504", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32505", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32506", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32507", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32508", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32509", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32511", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32512", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32513", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32514", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32516", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32520", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32521", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32522", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32523", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32524", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32526", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32533", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32534", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32535", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32559", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32560", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32568", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32577", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32590", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32591", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32592", "FIPS": "12033", "County": "Escambia", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32110", "FIPS": "12035", "County": "Flagler", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32135", "FIPS": "12035", "County": "Flagler", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32136", "FIPS": "12035", "County": "Flagler", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32137", "FIPS": "12035", "County": "Flagler", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32142", "FIPS": "12035", "County": "Flagler", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32164", "FIPS": "12035", "County": "Flagler", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32320", "FIPS": "12037", "County": "Franklin", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32322", "FIPS": "12037", "County": "Franklin", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32323", "FIPS": "12037", "County": "Franklin", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32328", "FIPS": "12037", "County": "Franklin", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32329", "FIPS": "12037", "County": "Franklin", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32324", "FIPS": "12039", "County": "Gadsden", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32330", "FIPS": "12039", "County": "Gadsden", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32332", "FIPS": "12039", "County": "Gadsden", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32333", "FIPS": "12039", "County": "Gadsden", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32343", "FIPS": "12039", "County": "Gadsden", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32351", "FIPS": "12039", "County": "Gadsden", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32352", "FIPS": "12039", "County": "Gadsden", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32353", "FIPS": "12039", "County": "Gadsden", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32619", "FIPS": "12041", "County": "Gilchrist", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32693", "FIPS": "12041", "County": "Gilchrist", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "33471", "FIPS": "12043", "County": "Glades", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33944", "FIPS": "12043", "County": "Glades", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "32456", "FIPS": "12045", "County": "Gulf", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32457", "FIPS": "12045", "County": "Gulf", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32465", "FIPS": "12045", "County": "Gulf", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32052", "FIPS": "12047", "County": "Hamilton", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32053", "FIPS": "12047", "County": "Hamilton", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32096", "FIPS": "12047", "County": "Hamilton", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "33834", "FIPS": "12049", "County": "Hardee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33865", "FIPS": "12049", "County": "Hardee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33873", "FIPS": "12049", "County": "Hardee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33890", "FIPS": "12049", "County": "Hardee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33440", "FIPS": "12051", "County": "Hendry", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33930", "FIPS": "12051", "County": "Hendry", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33935", "FIPS": "12051", "County": "Hendry", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33975", "FIPS": "12051", "County": "Hendry", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34601", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34602", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34603", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34604", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34605", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34606", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34607", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34608", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34609", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34611", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34613", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34614", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34636", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34661", "FIPS": "12053", "County": "Hernando", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33825", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33826", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33852", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33857", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33862", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33870", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33871", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33872", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33875", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33876", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33960", "FIPS": "12055", "County": "Highlands", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33503", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33508", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33509", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33510", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33511", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33527", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33530", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33534", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33547", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33548", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33549", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33550", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33556", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33558", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33559", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33563", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33564", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33565", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33566", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33567", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33568", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33569", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33570", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33571", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33572", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33573", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33575", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33583", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33584", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33586", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33587", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33592", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33594", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33595", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33598", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33601", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33602", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33603", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33604", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33605", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33606", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33607", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33608", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33609", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33610", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33611", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33612", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33613", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33614", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33615", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33616", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33617", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33618", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33619", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33620", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33621", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33622", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33623", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33624", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33625", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33626", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33629", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33630", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33631", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33633", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33634", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33635", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33637", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33647", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33650", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33651", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33655", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33660", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33661", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33662", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33663", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33664", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33672", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33673", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33674", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33675", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33677", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33679", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33680", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33681", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33682", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33684", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33685", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33686", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33687", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33688", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33689", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33690", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33694", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "33697", "FIPS": "12057", "County": "Hillsborough", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "32425", "FIPS": "12059", "County": "Holmes", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32452", "FIPS": "12059", "County": "Holmes", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32455", "FIPS": "12059", "County": "Holmes", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32464", "FIPS": "12059", "County": "Holmes", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32948", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32957", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32958", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32960", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32961", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32962", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32963", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32964", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32965", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32966", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32967", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32968", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32969", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32970", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32971", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32978", "FIPS": "12061", "County": "Indian River", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32420", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32423", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32426", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32431", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32432", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32440", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32442", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32443", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32445", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32446", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32447", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32448", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32460", "FIPS": "12063", "County": "Jackson", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32336", "FIPS": "12065", "County": "Jefferson", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32337", "FIPS": "12065", "County": "Jefferson", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32344", "FIPS": "12065", "County": "Jefferson", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32345", "FIPS": "12065", "County": "Jefferson", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32361", "FIPS": "12065", "County": "Jefferson", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32013", "FIPS": "12067", "County": "Lafayette", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32066", "FIPS": "12067", "County": "Lafayette", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32102", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32158", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32159", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32702", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32726", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32727", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32735", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32736", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32756", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32757", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32767", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32776", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32778", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32784", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34705", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34711", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34712", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34713", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34714", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34715", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34729", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34731", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34736", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34737", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34748", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34749", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34753", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34755", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34756", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34762", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34788", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34789", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34797", "FIPS": "12069", "County": "Lake", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "33901", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33902", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33903", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33904", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33905", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33906", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33907", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33908", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33909", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33910", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33911", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33912", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33913", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33914", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33915", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33916", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33917", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33918", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33919", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33920", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33921", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33922", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33924", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33928", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33931", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33932", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33936", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33945", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33956", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33957", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33965", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33966", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33967", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33970", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33971", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33972", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33990", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33991", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33993", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "33994", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34133", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34134", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34135", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "34136", "FIPS": "12071", "County": "Lee", "State": "FL", "DMA": {"Code": 571, "Name": "FORT MYERS-NAPLES"}},
  {"Postal_Code": "32301", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32302", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32303", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32304", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32305", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32306", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32307", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32308", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32309", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32310", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32311", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32312", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32313", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32314", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32315", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32316", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32317", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32318", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32362", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32395", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32399", "FIPS": "12073", "County": "Leon", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32621", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32625", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32626", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32639", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32644", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32668", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32683", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32696", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "34449", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "34498", "FIPS": "12075", "County": "Levy", "State": "FL", "DMA": {"Code": 592, "Name": "GAINESVILLE"}},
  {"Postal_Code": "32321", "FIPS": "12077", "County": "Liberty", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32334", "FIPS": "12077", "County": "Liberty", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32335", "FIPS": "12077", "County": "Liberty", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32360", "FIPS": "12077", "County": "Liberty", "State": "FL", "DMA": {"Code": 656, "Name": "PANAMA CITY"}},
  {"Postal_Code": "32059", "FIPS": "12079", "County": "Madison", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32331", "FIPS": "12079", "County": "Madison", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32340", "FIPS": "12079", "County": "Madison", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32341", "FIPS": "12079", "County": "Madison", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "32350", "FIPS": "12079", "County": "Madison", "State": "FL", "DMA": {"Code": 530, "Name": "TALLAHASSEE-THOMASVILLE"}},
  {"Postal_Code": "34201", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34202", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34203", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34204", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34205", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34206", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34207", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34208", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34209", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34210", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34211", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34212", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34215", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34216", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34217", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34218", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34219", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34220", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34221", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34222", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34228", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34243", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34250", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34251", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34260", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34264", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34270", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34280", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34281", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "34282", "FIPS": "12081", "County": "Manatee", "State": "FL", "DMA": {"Code": 539, "Name": "TAMPA-ST PETERSBURG-SARASOTA"}},
  {"Postal_Code": "32111", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32113", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32133", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32134", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32179", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32182", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32183", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32192", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32195", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32617", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32634", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32663", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32664", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32681", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32686", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34420", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34421", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34430", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34431", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34432", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34470", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34471", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34472", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34473", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34474", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34475", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34476", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34477", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34478", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34479", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34480", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34481", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34482", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34483", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34488", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34489", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34491", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34492", "FIPS": "12083", "County": "Marion", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "33455", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "33475", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34956", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34957", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34958", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34990", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34991", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34992", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34994", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34995", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34996", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34997", "FIPS": "12085", "County": "Martin", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "33002", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33010", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33011", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33012", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33013", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33014", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33015", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33016", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33017", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33018", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33030", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33031", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33032", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33033", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33034", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33035", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33039", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33054", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33055", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33056", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33090", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33092", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33101", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33102", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33107", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33109", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33110", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33111", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33112", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33114", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33116", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33119", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33121", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33122", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33124", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33125", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33126", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33127", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33128", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33129", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33130", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33131", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33132", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33133", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33134", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33135", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33136", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33137", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33138", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33139", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33140", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33141", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33142", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33143", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33144", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33145", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33146", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33147", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33148", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33149", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33150", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33151", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33152", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33153", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33154", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33155", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33156", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33157", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33158", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33159", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33160", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33161", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33162", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33163", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33164", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33165", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33166", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33167", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33168", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33169", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33170", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33172", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33173", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33174", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33175", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33176", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33177", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33178", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33179", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33180", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33181", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33182", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33183", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33184", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33185", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33186", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33187", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33188", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33189", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33190", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33193", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33194", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33195", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33196", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33197", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33199", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33231", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33233", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33234", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33238", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33239", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33242", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33243", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33245", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33247", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33255", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33256", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33257", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33261", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33265", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33266", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33269", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33280", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33283", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33296", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33299", "FIPS": "12086", "County": "Miami-Dade", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33001", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33036", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33037", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33040", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33041", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33042", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33043", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33045", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33050", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33051", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33052", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "33070", "FIPS": "12087", "County": "Monroe", "State": "FL", "DMA": {"Code": 528, "Name": "MIAMI-FORT LAUDERDALE"}},
  {"Postal_Code": "32009", "FIPS": "12089", "County": "Nassau", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32011", "FIPS": "12089", "County": "Nassau", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32034", "FIPS": "12089", "County": "Nassau", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32035", "FIPS": "12089", "County": "Nassau", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32041", "FIPS": "12089", "County": "Nassau", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32046", "FIPS": "12089", "County": "Nassau", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32097", "FIPS": "12089", "County": "Nassau", "State": "FL", "DMA": {"Code": 561, "Name": "JACKSONVILLE"}},
  {"Postal_Code": "32531", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32536", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32537", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32539", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32540", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32541", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32542", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32544", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32547", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32548", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32549", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32564", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32567", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32569", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32578", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32579", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32580", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "32588", "FIPS": "12091", "County": "Okaloosa", "State": "FL", "DMA": {"Code": 686, "Name": "MOBILE-PENSACOLA"}},
  {"Postal_Code": "34972", "FIPS": "12093", "County": "Okeechobee", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34973", "FIPS": "12093", "County": "Okeechobee", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "34974", "FIPS": "12093", "County": "Okeechobee", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "32703", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32704", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32709", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32710", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32712", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32751", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32768", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32777", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32789", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32790", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32792", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32793", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32794", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32798", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32801", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32802", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32803", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32804", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32805", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32806", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32807", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32808", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32809", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32810", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32811", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32812", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32814", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32816", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32817", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32818", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32819", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32820", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32821", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32822", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32824", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32825", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32826", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32827", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32828", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32829", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32830", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32831", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32832", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32833", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32834", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32835", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32836", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32837", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32839", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32853", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32854", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32855", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32856", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32857", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32858", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32859", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32860", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32861", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32862", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32867", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32868", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32869", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32872", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32877", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32878", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32885", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32886", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32887", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32890", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32891", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32893", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32896", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32897", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "32898", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34734", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34740", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34760", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34761", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34777", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34778", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34786", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34787", "FIPS": "12095", "County": "Orange", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "33848", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34739", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34741", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34742", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34743", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34744", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34745", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34746", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34747", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34758", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34769", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34770", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34771", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34772", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "34773", "FIPS": "12097", "County": "Osceola", "State": "FL", "DMA": {"Code": 534, "Name": "ORLANDO-DAYTONA BEACH-MELBOURNE"}},
  {"Postal_Code": "33401", "FIPS": "12099", "County": "Palm Beach", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "33402", "FIPS": "12099", "County": "Palm Beach", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "33403", "FIPS": "12099", "County": "Palm Beach", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "33404", "FIPS": "12099", "County": "Palm Beach", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "33405", "FIPS": "12099", "County": "Palm Beach", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "33406", "FIPS": "12099", "County": "Palm Beach", "State": "FL", "DMA": {"Code": 548, "Name": "WEST PALM BEACH-FT PIERCE"}},
  {"Postal_Code": "33407", "FIPS": "12099", "County": "Palm Beach", "State": "FL"