from dataclasses import dataclass
from rekuest.messages import Assignation, Provision
from rekuest.actors.helper import AssignationHelper, ProvisionHelper
from rekuest.actors.base import Actor
from rekuest.actors.vars import current_assignation_helper, current_provision_helper


@dataclass
class AssignationContext:
    assignation: Assignation
    _helper = None

    def __enter__(self):

        self._helper = AssignationHelper(assignation=self.assignation)

        current_assignation_helper.set(self._helper)
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        current_assignation_helper.set(None)
        self._helper = None


@dataclass
class ProvisionContext:
    provision: Provision
    _helper = None

    def __enter__(self):

        self._helper = ProvisionHelper(provision=self.provision)

        current_provision_helper.set(self._helper)
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        current_provision_helper.set(None)
        self._helper = None
