(self["webpackChunk_epi2melabs_epi2melabs_wfpage"] = self["webpackChunk_epi2melabs_epi2melabs_wfpage"] || []).push([["lib_index_js-node_modules_moment_locale_sync_recursive_"],{

/***/ "./lib/asset.js":
/*!**********************!*\
  !*** ./lib/asset.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "logoSVG": () => (/* binding */ logoSVG),
/* harmony export */   "labsLogoIcon": () => (/* binding */ labsLogoIcon)
/* harmony export */ });
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);

const logoSVG = `
  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="148" height="198" viewBox="0 0 148 198">
    <defs>
      <filter id="Rectangle_1" x="0" y="0" width="148" height="68" filterUnits="userSpaceOnUse">
        <feOffset dy="3" input="SourceAlpha"/>
        <feGaussianBlur stdDeviation="3" result="blur"/>
        <feFlood flood-opacity="0.098"/>
        <feComposite operator="in" in2="blur"/>
        <feComposite in="SourceGraphic"/>
      </filter>
      <filter id="Rectangle_2" x="0" y="130" width="148" height="68" filterUnits="userSpaceOnUse">
        <feOffset dy="3" input="SourceAlpha"/>
        <feGaussianBlur stdDeviation="3" result="blur-2"/>
        <feFlood flood-opacity="0.098"/>
        <feComposite operator="in" in2="blur-2"/>
        <feComposite in="SourceGraphic"/>
      </filter>
      <filter id="Rectangle_3" x="0" y="65" width="73" height="68" filterUnits="userSpaceOnUse">
        <feOffset dy="3" input="SourceAlpha"/>
        <feGaussianBlur stdDeviation="3" result="blur-3"/>
        <feFlood flood-opacity="0.098"/>
        <feComposite operator="in" in2="blur-3"/>
        <feComposite in="SourceGraphic"/>
      </filter>
    </defs>
    <g id="Component_1_2" data-name="Component 1 – 2" transform="translate(9 6)">
      <g transform="matrix(1, 0, 0, 1, -9, -6)" filter="url(#Rectangle_1)">
        <rect id="Rectangle_1-2" data-name="Rectangle 1" width="130" height="50" rx="5" transform="translate(9 6)" fill="#08bbb2"/>
      </g>
      <g transform="matrix(1, 0, 0, 1, -9, -6)" filter="url(#Rectangle_2)">
        <rect id="Rectangle_2-2" data-name="Rectangle 2" width="130" height="50" rx="5" transform="translate(9 136)" fill="#0179a4"/>
      </g>
      <g transform="matrix(1, 0, 0, 1, -9, -6)" filter="url(#Rectangle_3)">
        <rect id="Rectangle_3-2" data-name="Rectangle 3" width="55" height="50" rx="5" transform="translate(9 71)" fill="#fccb10"/>
      </g>
    </g>
  </svg>
`;
const logoSVGSmall = `
  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="42" height="51" viewBox="0 0 42 51">
    <defs>
        <filter id="Rectangle_1" x="0" y="0" width="42" height="27" filterUnits="userSpaceOnUse">
        <feOffset dy="3" input="SourceAlpha"/>
        <feGaussianBlur stdDeviation="3" result="blur"/>
        <feFlood flood-opacity="0.098"/>
        <feComposite operator="in" in2="blur"/>
        <feComposite in="SourceGraphic"/>
        </filter>
        <filter id="Rectangle_2" x="0" y="24" width="42" height="27" filterUnits="userSpaceOnUse">
        <feOffset dy="3" input="SourceAlpha"/>
        <feGaussianBlur stdDeviation="3" result="blur-2"/>
        <feFlood flood-opacity="0.098"/>
        <feComposite operator="in" in2="blur-2"/>
        <feComposite in="SourceGraphic"/>
        </filter>
        <filter id="Rectangle_3" x="0" y="12" width="28" height="27" filterUnits="userSpaceOnUse">
        <feOffset dy="3" input="SourceAlpha"/>
        <feGaussianBlur stdDeviation="3" result="blur-3"/>
        <feFlood flood-opacity="0.098"/>
        <feComposite operator="in" in2="blur-3"/>
        <feComposite in="SourceGraphic"/>
        </filter>
    </defs>
    <g id="Component_2_1" data-name="Component 2 – 1" transform="translate(9 6)">
        <g transform="matrix(1, 0, 0, 1, -9, -6)" filter="url(#Rectangle_1)">
        <rect id="Rectangle_1-2" data-name="Rectangle 1" width="24" height="9" rx="1" transform="translate(9 6)" fill="#08bbb2"/>
        </g>
        <g transform="matrix(1, 0, 0, 1, -9, -6)" filter="url(#Rectangle_2)">
        <rect id="Rectangle_2-2" data-name="Rectangle 2" width="24" height="9" rx="1" transform="translate(9 30)" fill="#0179a4"/>
        </g>
        <g transform="matrix(1, 0, 0, 1, -9, -6)" filter="url(#Rectangle_3)">
        <rect id="Rectangle_3-2" data-name="Rectangle 3" width="10" height="9" rx="1" transform="translate(9 18)" fill="#fccb10"/>
        </g>
    </g>
  </svg>
`;
const labsLogoIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'ui-components:labs',
    svgstr: logoSVGSmall
});


/***/ }),

/***/ "./lib/components/Footer.js":
/*!**********************************!*\
  !*** ./lib/components/Footer.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);



const Footer = ({ className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("footer", { className: `footer ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
        "@2008 - ",
        moment__WEBPACK_IMPORTED_MODULE_1___default()().year(),
        " Oxford Nanopore Technologies. All rights reserved")));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledFooter = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(Footer) `
  width: 100%;
  padding: 25px;
  text-align: center;
  box-sizing: border-box;
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledFooter);


/***/ }),

/***/ "./lib/components/Header.js":
/*!**********************************!*\
  !*** ./lib/components/Header.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LabsLogo": () => (/* binding */ LabsLogo),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _asset__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../asset */ "./lib/asset.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);




const LabsLogo = () => {
    const logoSVGBlob = new Blob([_asset__WEBPACK_IMPORTED_MODULE_3__.logoSVG], { type: 'image/svg+xml' });
    const url = URL.createObjectURL(logoSVGBlob);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "labsLogo" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", { src: url, alt: "The EPI2ME Labs logo" })));
};
const Header = ({ className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("header", { className: `header ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "header-section left-navigation" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_1__.Link, { to: "/workflows" }, "Workflows"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_1__.Link, { to: "/instances" }, "History")),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "header-section center-navigation" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_1__.Link, { to: "/" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabsLogo, null))),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "header-section right-navigation" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { href: "https://labs.epi2me.io/" }, "Labs Blog"))));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledHeader = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(Header) `
  padding: 15px 25px;
  display: flex;
  justify-content: space-between;
  background-color: #00485b;
  color: white;

  .labsLogo img {
    width: 25px;
  }

  .header-section {
    width: calc(100% / 3);
    display: flex;
    align-items: center;
  }

  .left-navigation a {
    padding-right: 25px;
  }

  .center-navigation {
    justify-content: center;
  }

  .right-navigation {
    justify-content: right;
  }

  a {
    font-weight: bold;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledHeader);


/***/ }),

/***/ "./lib/components/HeaderTitle.js":
/*!***************************************!*\
  !*** ./lib/components/HeaderTitle.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);


const HeaderTitle = ({ title, className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `header-title ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null, title)));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledHeaderTitle = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(HeaderTitle) `
  div {
    padding: 75px 50px 75px 50px;
    display: flex;
    align-items: center;
    flex-direction: column;
    background-color: white;

    h1 {
      padding: 25px 0;
      text-align: center;
    }
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledHeaderTitle);


/***/ }),

/***/ "./lib/components/IndexPanel.js":
/*!**************************************!*\
  !*** ./lib/components/IndexPanel.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _workflow_WorkflowList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./workflow/WorkflowList */ "./lib/components/workflow/WorkflowList.js");
/* harmony import */ var _instance_InstanceList__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./instance/InstanceList */ "./lib/components/instance/InstanceList.js");




const IndexPanel = ({ className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `index-panel ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "index-panel-intro" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null, "EPI2ME Labs Workflows (Beta)"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "EPI2ME Labs maintains a growing collection of workflows covering a range of everyday bioinformatics needs. These are free and open to use by anyone. Browse the list below and get started.")),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "index-panel-section" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Available workflows"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_workflow_WorkflowList__WEBPACK_IMPORTED_MODULE_2__["default"], null)),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "index-panel-section" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Tracked instances"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_instance_InstanceList__WEBPACK_IMPORTED_MODULE_3__["default"], { onlyTracked: true }))));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledIndexPanel = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(IndexPanel) `
  div {
    background-color: #f6f6f6;
    padding-bottom: 100px;

    .index-panel-intro {
      padding: 75px 50px 75px 50px;
      display: flex;
      align-items: center;
      flex-direction: column;
      background-color: white;
    }

    .index-panel-intro h1 {
      padding: 25px 0;
      text-align: center;
    }

    .index-panel-intro p {
      max-width: 800px;
      text-align: center;
      font-size: 16px;
      line-height: 1.7em;
    }

    .index-panel-section {
      padding: 0 35px;
      max-width: 1200px;
      margin: 50px auto 0 auto;
    }
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledIndexPanel);


/***/ }),

/***/ "./lib/components/InstancesPanel.js":
/*!******************************************!*\
  !*** ./lib/components/InstancesPanel.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _HeaderTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./HeaderTitle */ "./lib/components/HeaderTitle.js");
/* harmony import */ var _instance_InstanceList__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./instance/InstanceList */ "./lib/components/instance/InstanceList.js");




const InstancesPanel = ({ className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `instances-panel ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_HeaderTitle__WEBPACK_IMPORTED_MODULE_2__["default"], { title: "History" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instances-panel-section" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_instance_InstanceList__WEBPACK_IMPORTED_MODULE_3__["default"], null))));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledInstancesPanel = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(InstancesPanel) `
  background-color: #f6f6f6;
  padding-bottom: 100px;

  .instances-panel-section {
    padding: 0 35px;
    max-width: 1200px;
    margin: 50px auto 0 auto;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledInstancesPanel);


/***/ }),

/***/ "./lib/components/WorkflowsPanel.js":
/*!******************************************!*\
  !*** ./lib/components/WorkflowsPanel.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _HeaderTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./HeaderTitle */ "./lib/components/HeaderTitle.js");
/* harmony import */ var _workflow_WorkflowList__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./workflow/WorkflowList */ "./lib/components/workflow/WorkflowList.js");




const WorkflowsPanel = ({ className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `workflows-panel ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_HeaderTitle__WEBPACK_IMPORTED_MODULE_2__["default"], { title: "Workflows" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflows-panel-section" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_workflow_WorkflowList__WEBPACK_IMPORTED_MODULE_3__["default"], null))));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledWorkflowsPanel = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(WorkflowsPanel) `
  background-color: #f6f6f6;
  padding-bottom: 100px;

  .workflows-panel-section {
    padding: 0 35px;
    max-width: 1200px;
    margin: 50px auto 0 auto;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledWorkflowsPanel);


/***/ }),

/***/ "./lib/components/inputs/BooleanInput.js":
/*!***********************************************!*\
  !*** ./lib/components/inputs/BooleanInput.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BOOL_INPUT": () => (/* binding */ BOOL_INPUT),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);


// -----------------------------------------------------------------------------
// Type definitions
// -----------------------------------------------------------------------------
const BOOL_INPUT = 'boolean';
const BooleanInput = ({ id, label, format, description, defaultValue, error, onChange, className }) => {
    const [isChecked, setIsChecked] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(defaultValue);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `BooleanInput ${className} ${isChecked ? 'checked' : 'unchecked'}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, label),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, description),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: id },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { id: id, className: "boolInput", type: "checkbox", defaultChecked: defaultValue, onChange: (e) => {
                    setIsChecked(e.target.value);
                    onChange(id, format, e.target.checked ? true : false);
                } }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "\u2713")),
        error ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                "Error: ",
                error))) : ('')));
};
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledBooleanInput = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(BooleanInput) `
  .input-container {
    margin: 25px 0 0 0;
    padding: 25px;
    background-color: #1e1e1e;
    border-radius: 4px;
  }

  p {
    padding: 15px 0;
    margin: 0 0 10px 0;
  }

  label {
    padding: 15px 0 0 0;
    position: relative;
  }

  input {
    position: absolute;
    top: 0;
    left: 0;
    opacity: 0;
  }

  label span {
    cursor: pointer;
    border: 0;
    padding: 0;
    margin: 0;
    transition: 0.2s ease-in-out all;
  }

  label span {
    margin-right: 15px;
    cursor: pointer;
    outline: none;
    background-color: transparent;
    padding: 10px 15px;
    border: 1px solid black;
    color: black;
    text-transform: uppercase;
    font-size: 11px;
    border-radius: 4px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;
    -moz-appearance: textfield;
  }

  label span {
    font-size: 20px;
  }

  input:checked + span {
    background-color: black;
    color: white;
  }

  .error {
    padding: 15px 0 0 0;
    color: #e34040;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledBooleanInput);


/***/ }),

/***/ "./lib/components/inputs/NumInput.js":
/*!*******************************************!*\
  !*** ./lib/components/inputs/NumInput.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NUM_INPUT": () => (/* binding */ NUM_INPUT),
/* harmony export */   "INT_INPUT": () => (/* binding */ INT_INPUT),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);


// -----------------------------------------------------------------------------
// Type definitions
// -----------------------------------------------------------------------------
const NUM_INPUT = 'number';
const INT_INPUT = 'integer';
const NumInput = ({ id, label, format, description, defaultValue, min, max, error, onChange, className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `NumInput ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, label),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, description),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: id },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { id: id, type: "number", defaultValue: defaultValue, min: min, max: max, onChange: (e) => onChange(id, format, Number(e.target.value)) })),
    error ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
            "Error: ",
            error))) : ('')));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledNumInput = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(NumInput) `
  .input-container {
    margin: 25px 0 0 0;
    padding: 25px;
    background-color: #1e1e1e;
    border-radius: 4px;
  }

  .input-container p {
    padding: 15px 0;
  }

  input {
    cursor: pointer;
    border: 0;
    padding: 0;
    margin: 0;
    transition: 0.2s ease-in-out all;
  }
  input {
    margin-right: 15px;
    cursor: pointer;
    outline: none;
    background-color: transparent;
    padding: 15px 25px;
    border: 1px solid black;
    color: black;
    text-transform: uppercase;
    font-size: 11px;
    border-radius: 4px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;

    -moz-appearance: textfield;
  }
  input::-webkit-inner-spin-button {
    -webkit-appearance: none;
  }

  .error {
    padding: 15px 0 0 0;
    color: #e34040;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledNumInput);


/***/ }),

/***/ "./lib/components/inputs/SelectInput.js":
/*!**********************************************!*\
  !*** ./lib/components/inputs/SelectInput.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SELECT_INPUT": () => (/* binding */ SELECT_INPUT),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);


// -----------------------------------------------------------------------------
// Type definitions
// -----------------------------------------------------------------------------
const SELECT_INPUT = 'select';
const SelectInput = ({ id, label, format, description, defaultValue, choices, error, onChange, className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `SelectInput ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, label),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, description),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: id },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { id: id, onChange: (e) => onChange(id, format, e.target.value) },
            defaultValue ? ('') : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { className: "placeholder", selected: true, disabled: true, hidden: true, value: "Select an option" }, "Select an option")),
            choices.map(Choice => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: Choice.label, selected: !!(Choice.value === defaultValue), value: Choice.value }, Choice.label))))),
    error ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
            "Error: ",
            error))) : ('')));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledSelectInput = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(SelectInput) `
  .input-container {
    margin: 25px 0 0 0;
    padding: 25px;
    background-color: #1e1e1e;
    border-radius: 4px;
  }

  .input-container p {
    padding: 15px 0;
  }

  select {
    cursor: pointer;
    border: 0;
    padding: 0;
    margin: 0;
    transition: 0.2s ease-in-out all;
  }

  select {
    position: relative;
    cursor: pointer;
    outline: none;
    background-color: transparent;
    padding: 15px 25px;
    border: 1px solid black;
    color: black;
    text-transform: uppercase;
    font-size: 11px;
    border-radius: 4px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;
    /* for Firefox */
    appearance: none;
    -moz-appearance: none;
    /* for Chrome */
    -webkit-appearance: none;
  }

  .error {
    padding: 15px 0 0 0;
    color: #e34040;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledSelectInput);


/***/ }),

/***/ "./lib/components/inputs/TextInput.js":
/*!********************************************!*\
  !*** ./lib/components/inputs/TextInput.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STR_INPUT": () => (/* binding */ STR_INPUT),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);


// -----------------------------------------------------------------------------
// Type definitions
// -----------------------------------------------------------------------------
const STR_INPUT = 'string';
const TextInput = ({ id, label, format, description, defaultValue, minLength, maxLength, pattern, error, onChange, className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `TextInput ${className}` },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, label),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, description),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: id },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { id: id, type: "text", placeholder: 'Enter a value', defaultValue: defaultValue, pattern: pattern, minLength: minLength, maxLength: maxLength, onChange: e => onChange(id, format, e.target.value) })),
    error ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
            "Error: ",
            error))) : ('')));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledTextInput = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(TextInput) `
  .input-container {
    margin: 25px 0 0 0;
    padding: 25px;
    background-color: #1e1e1e;
    border-radius: 4px;
  }

  .input-container p {
    padding: 15px 0;
  }

  input {
    border: 0;
    padding: 0;
    margin: 0;
    transition: 0.2s ease-in-out all;
  }
  input {
    min-width: 50%;
    margin-right: 15px;
    outline: none;
    background-color: transparent;
    padding: 15px 25px;
    border: 1px solid black;
    color: black;
    font-size: 11px;
    border-radius: 4px;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;
  }

  .error {
    padding: 15px 0 0 0;
    color: #e34040;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledTextInput);


/***/ }),

/***/ "./lib/components/instance/Instance.js":
/*!*********************************************!*\
  !*** ./lib/components/instance/Instance.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _StatusIndicator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./StatusIndicator */ "./lib/components/instance/StatusIndicator.js");
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../handler */ "./lib/handler.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);





const InstanceComponent = ({ className, docTrack }) => {
    // ------------------------------------
    // Set up state
    // ------------------------------------
    const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_1__.useNavigate)();
    const routerParams = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_1__.useParams)();
    const [instanceData, setInstanceData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
    const [instanceStatus, setInstanceStatus] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [instanceParams, setInstanceParams] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [instanceOutputs, setInstanceOutputs] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [instanceLogs, setInstanceLogs] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    // ------------------------------------
    // Handle instance initialisation
    // ------------------------------------
    const getInstanceData = async () => {
        const data = await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)(`instances/${routerParams.id}`);
        setInstanceData(data);
        setInstanceStatus(data.status);
        return data;
    };
    const getInstanceParams = async () => {
        const { params } = await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)(`params/${routerParams.id}`);
        if (params !== null) {
            setInstanceParams(params);
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const init = async () => {
            await getInstanceData();
            getInstanceParams();
            getInstanceLogs();
        };
        init();
        const statusMonitor = setInterval(() => getInstanceData(), 5000);
        return () => {
            clearInterval(statusMonitor);
        };
    }, []);
    // ------------------------------------
    // Handle instance logs / outputs
    // ------------------------------------
    const getInstanceLogs = async () => {
        const { logs } = await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)(`logs/${routerParams.id}`);
        setInstanceLogs(logs);
    };
    const getInstanceOutputs = async (instanceData) => {
        if (!instanceData) {
            return;
        }
        const path = `${instanceData.path}/output`;
        try {
            const files = await (await docTrack.services.contents.get(path)).content.filter((Item) => Item.type !== 'directory');
            setInstanceOutputs(files);
        }
        catch (error) {
            console.log('Instance outputs not available yet');
        }
    };
    const handleOpenOutput = (path) => {
        docTrack.open(path);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (['COMPLETED_SUCCESSFULLY', 'TERMINATED', 'ENCOUNTERED_ERROR'].includes(instanceStatus)) {
            getInstanceOutputs(instanceData);
            getInstanceLogs();
            return;
        }
        else {
            const filesMonitor = setInterval(() => getInstanceOutputs(instanceData), 10000);
            const logsMonitor = setInterval(() => getInstanceLogs(), 7500);
            return () => {
                getInstanceOutputs(instanceData);
                getInstanceLogs();
                clearInterval(filesMonitor);
                clearInterval(logsMonitor);
            };
        }
    }, [instanceStatus]);
    // ------------------------------------
    // Handle instance deletion
    // ------------------------------------
    const handleInstanceDelete = async (d) => {
        const outcome = await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)(`instances/${routerParams.id}`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                delete: d
            })
        });
        if (d && outcome.deleted) {
            navigate('/instances');
        }
    };
    const isRunning = ['LAUNCHED'].includes(instanceStatus);
    if (!instanceData) {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `instance ${className}` }, "Loading...");
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `instance ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-container" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section instance-header" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-header-top" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", { className: "instance-workflow" },
                        "Workflow: ",
                        instanceData.workflow),
                    isRunning ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => handleInstanceDelete(false) }, "Stop Instance")) : ('')),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null,
                    "ID: ",
                    routerParams.id),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-details" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-status" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_StatusIndicator__WEBPACK_IMPORTED_MODULE_4__["default"], { status: instanceStatus || 'UNKNOWN' }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, instanceStatus)),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                        "Created: ",
                        instanceData.created_at),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                        "Updated: ",
                        instanceData.updated_at))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section instance-params" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Instance params"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section-contents" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, Object.entries(instanceParams).map(([key, value]) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
                        key,
                        ": ",
                        value.toString())))))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section instance-logs" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Instance logs"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section-contents" }, instanceLogs ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, instanceLogs.map(Item => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, Item)))))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Logs are loading...")))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section instance-outputs" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Output files"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section-contents" }, instanceOutputs.length ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, instanceOutputs.map(Item => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => handleOpenOutput(Item.path) }, Item.name)))))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section-contents" }, "No outputs yet...")))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section instance-delete" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Danger zone"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-section-contents" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `${!isRunning ? 'active' : 'inactive'}` },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => (!isRunning ? handleInstanceDelete(true) : null) }, "Delete Instance")))))));
};
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledInstanceComponent = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(InstanceComponent) `
  background-color: #f6f6f6;

  .instance-container {
    padding: 50px 0 100px 0 !important;
  }

  .instance-section {
    width: 100%;
    padding: 15px;
    max-width: 1200px;
    margin: 0 auto 25px auto;
    background-color: white;
    box-shadow: 0 6px 15px rgb(36 37 38 / 8%);
    border-radius: 4px;
    transition: box-shadow 0.25s ease, transform 0.25s ease;
    background-color: #ffffff;
  }

  .instance-section > h2 {
    padding-bottom: 15px;
  }

  .instance-section-contents {
    padding: 15px;
    border-radius: 4px;
  }

  .instance-header-top {
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
  }

  .instance-header-top h2 {
    padding-bottom: 15px;
  }

  .instance-header-top button {
    cursor: pointer;
    padding: 8px 15px;
    border: 1px solid #e34040;
    color: #e34040;
    text-transform: uppercase;
    font-size: 11px;
    border-radius: 4px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;
    outline: none;
    background-color: transparent;
  }

  .instance-header-top button:hover {
    cursor: pointer;
    background-color: #e34040;
    color: white;
  }

  .instance-details {
    display: flex;
    align-items: center;
  }

  .instance-details p {
    padding-left: 15px;
    text-transform: uppercase;
    font-size: 11px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    color: rgba(0, 0, 0, 0.5);
  }

  .instance-status {
    display: flex;
    align-items: center;
  }

  .instance-status p {
    color: black;
    padding-left: 15px;
  }

  .instance-params .instance-section-contents {
    background-color: #f6f6f6;
  }

  .instance-params li {
    font-size: 12px;
    font-family: monospace;
  }

  .instance-logs .instance-section-contents {
    background-color: #f6f6f6;
    font-size: 12px;
    font-family: monospace;
    overflow: auto;
    text-overflow: initial;
    max-height: 500px;
    white-space: pre;
    color: black;
    border-radius: 4px;
  }

  .instance-logs .instance-section-contents span {
    font-size: 12px;
    font-family: monospace;
  }

  .instance-outputs li {
    margin: 0 0 5px 0;
    display: flex;
    background-color: #f6f6f6;
  }

  .instance-outputs button {
    width: 100%;
    text-align: left;
    padding: 5px;
    font-size: 12px;
    font-family: monospace;
    border: none;
    outline: none;
    background: transparent;
    border: 1px solid #f6f6f6;
  }

  .instance-outputs button:hover {
    border: 1px solid #005c75;
  }

  .instance-delete .instance-section-contents {
    background-color: #f6f6f6;
  }

  .instance-delete button {
    padding: 15px 25px;
    margin: 0 15px 0 0;
    border: 1px solid lightgray;
    color: lightgray;
    text-transform: uppercase;
    font-size: 11px;
    border-radius: 4px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;
    outline: none;
    background-color: transparent;
  }
  .instance-delete .active button {
    border: 1px solid #e34040;
    color: #e34040;
  }
  .instance-delete .active button:hover {
    cursor: pointer;
    background-color: #e34040;
    color: white;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledInstanceComponent);


/***/ }),

/***/ "./lib/components/instance/InstanceList.js":
/*!*************************************************!*\
  !*** ./lib/components/instance/InstanceList.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _StatusIndicator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./StatusIndicator */ "./lib/components/instance/StatusIndicator.js");
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../handler */ "./lib/handler.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_2__);





const InstanceList = ({ className, onlyTracked }) => {
    // ------------------------------------
    // Set up state
    // ------------------------------------
    const [instances, setInstances] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [trackedInstances, setTrackedInstances] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    // ------------------------------------
    // Handle instance initialisation
    // ------------------------------------
    const getInstances = async () => {
        const instances = await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)('instances');
        const instanceList = Object.values(instances);
        const trackedInstanceList = instanceList.filter((I) => ['LAUNCHED'].includes(I.status));
        setInstances(instanceList);
        setTrackedInstances(trackedInstanceList);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        getInstances();
    }, []);
    // ------------------------------------
    // Handle updating instances
    // ------------------------------------
    // Note: this should be changed to a single get request
    const updateTrackedInstances = async () => {
        const tracked = await Promise.all(trackedInstances.map(async (I) => {
            return await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)(`instances/${I.id}`, {
                method: 'GET',
                headers: {
                    'Content-Type': 'application/json'
                }
                // Can't do this at the moment because the fetch guys think they're cool
                // body: JSON.stringify({
                //   instances: trackedIds
                // })
            });
        }));
        setTrackedInstances(tracked);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const insMonitor = setInterval(() => updateTrackedInstances(), 5000);
        return () => {
            clearInterval(insMonitor);
        };
    }, [trackedInstances]);
    // ------------------------------------
    // Handle displaying instances
    // ------------------------------------
    const sortInstances = (a, b) => {
        if (a.created_at < b.created_at) {
            return 1;
        }
        if (a.created_at > b.created_at) {
            return -1;
        }
        return 0;
    };
    const visibleInstances = onlyTracked ? trackedInstances : instances;
    const sortedVisibleInstances = visibleInstances.sort(sortInstances);
    return sortedVisibleInstances.length !== 0 ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `instance-list ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, sortedVisibleInstances.map((Instance) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-header" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null,
                            "ID: ",
                            Instance.id),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null,
                            Instance.workflow,
                            " | Created: ",
                            Instance.created_at)),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-bar" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "instance-status" },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_StatusIndicator__WEBPACK_IMPORTED_MODULE_4__["default"], { status: Instance.status }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, Instance.status)),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_2__.Link, { className: "instance-link", to: `/instances/${Instance.id}` },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "View Instance"))))))))))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `instance-list ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "empty" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "No workflows currently running..."),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_2__.Link, { className: "instance-link", to: '/instances' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "View history"))))));
};
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledInstanceList = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(InstanceList) `
  max-width: 1200px;
  margin: 50px auto 0 auto;

  .empty {
    width: 100%;
    height: 250px;
    display: flex;
    text-align: center;
    align-items: center;
    justify-content: center;
    background-color: white;
    box-shadow: 0 6px 15px rgb(36 37 38 / 8%);
    border-radius: 4px;
    transition: box-shadow 0.25s ease, transform 0.25s ease;
  }

  .empty p {
    padding-bottom: 10px;
  }

  > ul {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
    grid-template-rows: minmax(min-content, max-content);
    grid-column-gap: 20px;
    grid-row-gap: 20px;
    list-style: none;
  }
  .instance {
    padding: 15px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    background-color: white;
    box-shadow: 0 6px 15px rgb(36 37 38 / 8%);
    border-radius: 4px;
    transition: box-shadow 0.25s ease, transform 0.25s ease;
  }
  h3 {
    font-size: 24px;
  }
  .instance span {
    color: #333;
  }
  .instance-header h2 {
    padding: 5px 0;
  }
  .instance-header span {
    text-transform: uppercase;
    font-size: 12px;
    color: #a0a0a0;
  }
  .instance-header {
    display: flex;
    justify-content: space-between;
    flex-direction: column-reverse;
    padding-bottom: 15px;
  }
  .instance-bar {
    display: flex;
    justify-content: space-between;
    align-items: flex-end;
  }
  .instance-status {
    display: flex;
    text-transform: uppercase;
    font-size: 11px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    align-items: center;
  }
  .instance-status p {
    padding-left: 15px;
  }
  .instance-link {
    color: #005c75;
  }
  .instance-link div {
    padding: 15px 25px;
    border: 1px solid #005c75;
    color: #005c75;
    text-transform: uppercase;
    font-size: 11px;
    border-radius: 4px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;
  }
  .instance-link div:hover {
    background-color: #005c75;
    color: white;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledInstanceList);


/***/ }),

/***/ "./lib/components/instance/StatusIndicator.js":
/*!****************************************************!*\
  !*** ./lib/components/instance/StatusIndicator.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);


const UNKNOWN = 'UNKNOWN';
const LAUNCHED = 'LAUNCHED';
const ENCOUNTERED_ERROR = 'ENCOUNTERED_ERROR';
const COMPLETED_SUCCESSFULLY = 'COMPLETED_SUCCESSFULLY';
const TERMINATED = 'TERMINATED';
const statuses = {
    [UNKNOWN]: {
        name: 'UNKNOWN',
        className: 'grey'
    },
    [LAUNCHED]: {
        name: 'LAUNCHED',
        className: 'blue'
    },
    [ENCOUNTERED_ERROR]: {
        name: 'ENCOUNTERED_ERROR',
        className: 'orange'
    },
    [COMPLETED_SUCCESSFULLY]: {
        name: 'COMPLETED_SUCCESSFULLY',
        className: 'green'
    },
    [TERMINATED]: {
        name: 'TERMINATED',
        className: 'black'
    }
};
const StatusIndicator = ({ status, className }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `status-indicator ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: statuses[status].className })));
};
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledStatusIndicator = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(StatusIndicator) `
  > div {
    width: 18px;
    height: 18px;
    padding: 0;
    border-radius: 100%;
    line-height: 18px;
    text-align: center;
    font-size: 10px;
    color: white;
  }

  .blue {
    cursor: pointer;
    background-color: #005c75;
    box-shadow: 0 0 0 rgba(204, 169, 44, 0.4);
    animation: pulse-blue 2s infinite;
  }

  @keyframes pulse-blue {
    0% {
      -moz-box-shadow: 0 0 0 0 rgba(44, 119, 204, 0.4);
      box-shadow: 0 0 0 0 rgba(44, 119, 204, 0.4);
    }
    70% {
      -moz-box-shadow: 0 0 0 10px rgba(44, 119, 204, 0);
      box-shadow: 0 0 0 10px rgba(44, 119, 204, 0);
    }
    100% {
      -moz-box-shadow: 0 0 0 0 rgba(44, 119, 204, 0);
      box-shadow: 0 0 0 0 rgba(44, 119, 204, 0);
    }
  }

  .orange {
    cursor: pointer;
    background-color: #e34040;
    box-shadow: 0 0 0 rgba(23, 187, 117, 0.4);
    animation: pulse-orange 2s infinite;
  }

  @keyframes pulse-orange {
    0% {
      -moz-box-shadow: 0 0 0 0 rgba(255, 140, 0, 0.4);
      box-shadow: 0 0 0 0 rgba(255, 140, 0, 0.4);
    }
    70% {
      -moz-box-shadow: 0 0 0 10px rgba(255, 140, 0, 0);
      box-shadow: 0 0 0 10px rgba(255, 140, 0, 0);
    }
    100% {
      -moz-box-shadow: 0 0 0 0 rgba(255, 140, 0, 0);
      box-shadow: 0 0 0 0 rgba(255, 140, 0, 0);
    }
  }

  .green {
    cursor: pointer;
    background-color: #17bb75;
    box-shadow: 0 0 0 rgba(23, 187, 117, 0.4);
    animation: pulse-green 2s infinite;
  }

  @keyframes pulse-green {
    0% {
      -moz-box-shadow: 0 0 0 0 rgba(23, 187, 117, 0.4);
      box-shadow: 0 0 0 0 rgba(23, 187, 117, 0.4);
    }
    70% {
      -moz-box-shadow: 0 0 0 10px rgba(23, 187, 117, 0);
      box-shadow: 0 0 0 10px rgba(23, 187, 117, 0);
    }
    100% {
      -moz-box-shadow: 0 0 0 0 rgba(23, 187, 117, 0);
      box-shadow: 0 0 0 0 rgba(23, 187, 117, 0);
    }
  }

  .grey {
    background-color: #707070;
  }

  .black {
    background-color: black;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledStatusIndicator);


/***/ }),

/***/ "./lib/components/workflow/Workflow.js":
/*!*********************************************!*\
  !*** ./lib/components/workflow/Workflow.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../handler */ "./lib/handler.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _schema__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../schema */ "./lib/schema.js");
/* harmony import */ var _WorkflowParameterSection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./WorkflowParameterSection */ "./lib/components/workflow/WorkflowParameterSection.js");
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};






const WorkflowComponent = ({ className }) => {
    // ------------------------------------
    // Set up state
    // ------------------------------------
    const params = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_2__.useParams)();
    const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_2__.useNavigate)();
    const [workflowData, setWorkflowData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
    const [workflowParams, setWorkflowParams] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [workflowParamsValid, setWorkflowParamsValid] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [workflowParamsErrors, setWorkflowParamsErrors] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [workflowActiveSections, setWorkflowActiveSections] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    // ------------------------------------
    // Handle component initialisation
    // ------------------------------------
    const getWorkflowData = async () => {
        return await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)(`workflows/${params.name}`);
    };
    const filterHiddenParameters = (parameters) => Object.entries(parameters)
        .filter(([key, Property]) => !Property.hidden && key !== 'out_dir')
        .reduce((obj, prop) => (Object.assign({ [prop[0]]: prop[1] }, obj)), {});
    const filterSchemaSections = (definitions) => {
        return Object.values(definitions)
            .map(Section => (Object.assign(Object.assign({}, Section), { properties: filterHiddenParameters(Section.properties) })))
            .filter(Def => Object.keys(Def.properties).length !== 0);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const init = async () => {
            const workflowData = await getWorkflowData();
            setWorkflowData(workflowData);
            setWorkflowParams(workflowData.defaults);
            const sections = filterSchemaSections(workflowData.schema.definitions);
            setWorkflowActiveSections(sections);
        };
        init();
    }, []);
    // ------------------------------------
    // Handle parameter validation
    // ------------------------------------
    const filterErrorsByParameters = (parameters, errors) => Object.keys(parameters).reduce((obj, key) => Object.prototype.hasOwnProperty.call(errors, key)
        ? Object.assign(Object.assign({}, obj), { [key]: errors[key] }) : obj, {});
    const handleInputChange = (id, format, value) => {
        if (value === '') {
            const _a = workflowParams, _b = id, _ = _a[_b], rest = __rest(_a, [typeof _b === "symbol" ? _b : _b + ""]);
            setWorkflowParams(rest);
            return;
        }
        if (['file-path', 'directory-path', 'path'].includes(format)) {
            let fmt;
            switch (format) {
                case 'file-path':
                    fmt = 'file';
                    break;
                case 'directory-path':
                    fmt = 'directory';
                    break;
                default:
                    fmt = 'path';
            }
            validatePath(id, value, fmt);
            return;
        }
        setWorkflowParams(Object.assign(Object.assign({}, workflowParams), { [id]: value }));
    };
    const validatePath = async (id, path, format = 'file') => {
        const encodedPath = encodeURIComponent(path);
        const data = await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)(`${format}/${encodedPath}`, {
            method: 'GET'
        });
        if (!data.exists) {
            setWorkflowParamsErrors(Object.assign(Object.assign({}, workflowParamsErrors), { [id]: [data.error] }));
            setWorkflowParamsValid(false);
            return;
        }
        setWorkflowParamsErrors(Object.assign(Object.assign({}, workflowParamsErrors), { [id]: [] }));
        setWorkflowParams(Object.assign(Object.assign({}, workflowParams), { [id]: path }));
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (workflowData) {
            const { valid, errors } = (0,_schema__WEBPACK_IMPORTED_MODULE_4__.validateSchema)(workflowParams, workflowData.schema);
            valid
                ? setWorkflowParamsErrors({})
                : setWorkflowParamsErrors((0,_schema__WEBPACK_IMPORTED_MODULE_4__.parseValidationErrors)(errors));
            setWorkflowParamsValid(valid);
        }
    }, [workflowParams]);
    // ------------------------------------
    // Handle workflow launch
    // ------------------------------------
    const launchWorkflow = async () => {
        if (!workflowParamsValid) {
            return;
        }
        const { instance } = await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)('instances', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                workflow: params.name,
                params: workflowParams
            })
        });
        navigate(`/instances/${instance.id}`);
    };
    return workflowData ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `workflow ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-container" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-section workflow-header" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null,
                    "Workflow: ",
                    params.name),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-details" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, workflowData.desc),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                        "Version ",
                        workflowData.defaults.wfversion))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-section workflow-parameter-sections" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "1. Choose parameters"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-section-contents" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, workflowActiveSections.map(Section => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_WorkflowParameterSection__WEBPACK_IMPORTED_MODULE_5__["default"], { title: Section.title, description: Section.description, fa_icon: Section.fa_icon, properties: Section.properties, errors: filterErrorsByParameters(Section.properties, workflowParamsErrors), onChange: handleInputChange }))))))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-section workflow-launch-control" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "2. Launch workflow"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-section-contents" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `launch-control ${workflowParamsValid ? 'active' : 'inactive'}` },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => launchWorkflow() }, "Run command"))))))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null));
};
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledWorkflowComponent = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(WorkflowComponent) `
  background-color: #f6f6f6;

  .workflow-container {
    padding: 50px 0 100px 0 !important;
  }

  .workflow-section {
    width: 100%;
    padding: 15px;
    max-width: 1200px;
    margin: 0 auto 25px auto;
    background-color: white;
    box-shadow: 0 6px 15px rgb(36 37 38 / 8%);
    border-radius: 4px;
    transition: box-shadow 0.25s ease, transform 0.25s ease;
    background-color: #ffffff;
  }

  .workflow-section > h2 {
    padding-bottom: 15px;
  }

  .workflow-details div {
    color: #333;
    font-weight: normal;
    font-size: 14px;
    padding-bottom: 5px;
  }

  .workflow-parameter-sections .workflow-section-contents > ul > li {
    background-color: #f6f6f6;
    padding: 15px;
    margin: 0 0 15px 0;
    border-radius: 4px;
  }

  .workflow-launch-control .workflow-section-contents {
    padding: 15px;
    border-radius: 4px;
    background-color: #f6f6f6;
  }

  .workflow-launch-control button {
    padding: 15px 25px;
    margin: 0 15px 0 0;
    border: 1px solid lightgray;
    color: lightgray;
    text-transform: uppercase;
    font-size: 11px;
    border-radius: 4px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;
    outline: none;
    background-color: transparent;
  }

  .workflow-launch-control .active button {
    border: 1px solid #1d9655;
    color: #1d9655;
  }
  .workflow-launch-control .active button:hover {
    cursor: pointer;
    background-color: #1d9655;
    color: white;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledWorkflowComponent);


/***/ }),

/***/ "./lib/components/workflow/WorkflowList.js":
/*!*************************************************!*\
  !*** ./lib/components/workflow/WorkflowList.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../handler */ "./lib/handler.js");




const WorkflowsList = ({ className }) => {
    // ------------------------------------
    // Set up state
    // ------------------------------------
    const [workflows, setWorkflows] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    // ------------------------------------
    // Handle component initialisation
    // ------------------------------------
    const getWorkflows = async () => {
        const wfs = await (0,_handler__WEBPACK_IMPORTED_MODULE_3__.requestAPI)('workflows');
        setWorkflows(wfs);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        getWorkflows();
    }, []);
    return workflows ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `workflows-list ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, Object.values(workflows).map((Workflow) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-header" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null,
                            "Version ",
                            Workflow.defaults.wfversion),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, Workflow.name)),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "workflow-buttons" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { className: "workflow-url", href: Workflow.url }, "Github"),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_2__.Link, { className: "workflow-link", to: `/workflows/${Workflow.name}` },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Open workflow"))))))))))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `workflows-list empty ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "empty" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "No workflows to display."))));
};
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledWorkflowsList = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(WorkflowsList) `
  max-width: 1200px;
  margin: 50px auto 0 auto;

  > ul {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
    grid-template-rows: minmax(min-content, max-content);
    grid-column-gap: 20px;
    grid-row-gap: 20px;
    list-style: none;
  }

  .empty {
    width: 100%;
    height: 250px;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: white;
    box-shadow: 0 6px 15px rgb(36 37 38 / 8%);
    border-radius: 4px;
    transition: box-shadow 0.25s ease, transform 0.25s ease;
    background-color: #ffffff;
  }

  .workflow {
    padding: 15px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    background-color: white;
    box-shadow: 0 6px 15px rgb(36 37 38 / 8%);
    border-radius: 4px;
    transition: box-shadow 0.25s ease, transform 0.25s ease;
  }
  h3 {
    font-size: 24px;
  }

  .workflow span {
    color: #333;
  }

  .workflow-header span {
    text-transform: uppercase;
    font-size: 12px;
    padding-bottom: 5px;
    color: #a0a0a0;
  }
  .workflow-header {
    display: flex;
    justify-content: space-between;
    flex-direction: column-reverse;
  }
  .workflow-buttons {
    display: flex;
    justify-content: space-between;
    align-items: flex-end;
  }
  .workflow-link {
    color: #1d9655;
  }
  .workflow-buttons div {
    padding: 15px 25px;
    border: 1px solid #1d9655;
    color: #1d9655;
    text-transform: uppercase;
    font-size: 11px;
    border-radius: 4px;
    font-weight: bold;
    line-height: 1em;
    letter-spacing: 0.05em;
    transition: 0.2s ease-in-out all;
  }
  .workflow-buttons div:hover {
    background-color: #1d9655;
    color: white;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledWorkflowsList);


/***/ }),

/***/ "./lib/components/workflow/WorkflowParameter.js":
/*!******************************************************!*\
  !*** ./lib/components/workflow/WorkflowParameter.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inputs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./inputs */ "./lib/components/workflow/inputs.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);



const ParameterComponent = ({ id, schema, error, onChange, className }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `parameter ${className}` }, (0,_inputs__WEBPACK_IMPORTED_MODULE_2__.getInputComponent)(id, schema, error, onChange)));
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledParameterComponent = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(ParameterComponent) `
  padding: 25px 0;
  border-top: 1px solid #ccc;

  h4 {
    padding: 0 0 5px 0;
    font-size: 12px;
    font-weight: bold;
    text-transform: uppercase;
  }

  p {
    padding: 0 0 10px 0;
  }

  input {
    font-size: 12px;
    font-family: monospace;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledParameterComponent);


/***/ }),

/***/ "./lib/components/workflow/WorkflowParameterSection.js":
/*!*************************************************************!*\
  !*** ./lib/components/workflow/WorkflowParameterSection.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @fortawesome/fontawesome-svg-core */ "webpack/sharing/consume/default/@fortawesome/fontawesome-svg-core/@fortawesome/fontawesome-svg-core?2b54");
/* harmony import */ var _fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @fortawesome/react-fontawesome */ "webpack/sharing/consume/default/@fortawesome/react-fontawesome/@fortawesome/react-fontawesome");
/* harmony import */ var _fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _fortawesome_free_solid_svg_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @fortawesome/free-solid-svg-icons */ "webpack/sharing/consume/default/@fortawesome/free-solid-svg-icons/@fortawesome/free-solid-svg-icons");
/* harmony import */ var _fortawesome_free_solid_svg_icons__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_fortawesome_free_solid_svg_icons__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _fortawesome_free_brands_svg_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @fortawesome/free-brands-svg-icons */ "webpack/sharing/consume/default/@fortawesome/free-brands-svg-icons/@fortawesome/free-brands-svg-icons");
/* harmony import */ var _fortawesome_free_brands_svg_icons__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_fortawesome_free_brands_svg_icons__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _WorkflowParameter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./WorkflowParameter */ "./lib/components/workflow/WorkflowParameter.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_5__);








const ParameterSectionComponent = ({ title, fa_icon, properties, errors, onChange, className }) => {
    // ------------------------------------
    // Set up state
    // ------------------------------------
    const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const isValid = Object.keys(errors).length === 0 ? true : false;
    // ------------------------------------
    // Handle fa_icon
    // ------------------------------------
    _fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_1__.library.add(_fortawesome_free_solid_svg_icons__WEBPACK_IMPORTED_MODULE_3__.fas, _fortawesome_free_brands_svg_icons__WEBPACK_IMPORTED_MODULE_4__.fab);
    const iconName = fa_icon === null || fa_icon === void 0 ? void 0 : fa_icon.split(' ')[1];
    const iconPrefix = fa_icon === null || fa_icon === void 0 ? void 0 : fa_icon.split(' ')[0];
    const iconNameStripped = (iconName === null || iconName === void 0 ? void 0 : iconName.startsWith('fa-')) ? iconName.split('fa-')[1]
        : iconName;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `parameter-section ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `parameter-section-container ${isValid ? 'valid' : ''}` },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => setIsOpen(!isOpen) },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null,
                    typeof fa_icon === 'string' ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_2__.FontAwesomeIcon, { icon: [iconPrefix, iconNameStripped] })) : (''),
                    title),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_2__.FontAwesomeIcon, { icon: _fortawesome_free_solid_svg_icons__WEBPACK_IMPORTED_MODULE_3__.faCaretDown }))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { className: `parameter-section-items ${isOpen ? 'open' : 'closed'}` }, Object.entries(properties).map(([key, value]) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: "parameter" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_WorkflowParameter__WEBPACK_IMPORTED_MODULE_6__["default"], { id: key, schema: value, error: errors[key], onChange: onChange }))))))));
};
// -----------------------------------------------------------------------------
// Component Styles
// -----------------------------------------------------------------------------
const StyledParameterSectionComponent = styled_components__WEBPACK_IMPORTED_MODULE_5___default()(ParameterSectionComponent) `
  .parameter-section-container button {
    width: 100%;
    display: flex;
    padding: 15px 0;
    justify-content: space-between;
    align-items: center;
    border: none;
    outline: none;
    background: transparent;
    cursor: pointer;
  }

  .parameter-section-container button h3 svg {
    margin-right: 15px;
  }

  .parameter-section-container button h3 {
    font-size: 16px;
    font-weight: normal;
    color: #e34040;
  }

  .parameter-section-container.valid button h3 {
    color: black;
  }

  .parameter-section-items {
    transition: 0.2s ease-in-out all;
  }

  .parameter-section-items.closed {
    display: none;
  }

  .parameter-section-items.open {
    padding-top: 15px;
    display: block;
  }
`;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyledParameterSectionComponent);


/***/ }),

/***/ "./lib/components/workflow/inputs.js":
/*!*******************************************!*\
  !*** ./lib/components/workflow/inputs.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "mapSchemaToBooleanInput": () => (/* binding */ mapSchemaToBooleanInput),
/* harmony export */   "isBooleanInput": () => (/* binding */ isBooleanInput),
/* harmony export */   "mapSchemaToFileInput": () => (/* binding */ mapSchemaToFileInput),
/* harmony export */   "isFileInput": () => (/* binding */ isFileInput),
/* harmony export */   "mapSchemaToNumInput": () => (/* binding */ mapSchemaToNumInput),
/* harmony export */   "isNumInput": () => (/* binding */ isNumInput),
/* harmony export */   "mapSchemaToSelectInput": () => (/* binding */ mapSchemaToSelectInput),
/* harmony export */   "isSelectInput": () => (/* binding */ isSelectInput),
/* harmony export */   "mapSchemaToTextInput": () => (/* binding */ mapSchemaToTextInput),
/* harmony export */   "isTextInput": () => (/* binding */ isTextInput),
/* harmony export */   "getInputComponent": () => (/* binding */ getInputComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inputs_BooleanInput__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../inputs/BooleanInput */ "./lib/components/inputs/BooleanInput.js");
/* harmony import */ var _inputs_SelectInput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../inputs/SelectInput */ "./lib/components/inputs/SelectInput.js");
/* harmony import */ var _inputs_TextInput__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../inputs/TextInput */ "./lib/components/inputs/TextInput.js");
/* harmony import */ var _inputs_NumInput__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../inputs/NumInput */ "./lib/components/inputs/NumInput.js");





// -----------------------------------------------------------------------------
// Boolean input mapping
// -----------------------------------------------------------------------------
const mapSchemaToBooleanInput = (id, schema) => ({
    id: id,
    label: id,
    format: schema.format || '',
    description: schema.description || schema.help_text,
    defaultValue: schema.default
});
const isBooleanInput = (schema) => schema.type === 'boolean' ? true : false;
// -----------------------------------------------------------------------------
// File input mapping
// -----------------------------------------------------------------------------
const mapSchemaToFileInput = (id, schema) => ({
    id: id,
    label: id,
    description: schema.description || schema.help_text,
    multiple: false
});
const isFileInput = (schema) => schema.type === 'string' && schema.format === 'file-path' ? true : false;
// -----------------------------------------------------------------------------
// Num input mapping
// -----------------------------------------------------------------------------
const mapSchemaToNumInput = (id, schema) => ({
    id: id,
    label: id,
    format: schema.format || '',
    description: schema.description || schema.help_text,
    defaultValue: schema.default,
    min: schema.minimum,
    max: schema.maximum
});
const isNumInput = (schema) => ['integer', 'number'].includes(schema.type) ? true : false;
// -----------------------------------------------------------------------------
// Select input mapping
// -----------------------------------------------------------------------------
const mapSchemaToSelectInput = (id, schema) => ({
    id: id,
    label: id,
    format: schema.format || '',
    description: schema.description || schema.help_text,
    defaultValue: schema.default,
    choices: schema.enum.map(Item => ({ value: Item, label: Item }))
});
const isSelectInput = (schema) => schema.enum ? true : false;
// -----------------------------------------------------------------------------
// Text input mapping
// -----------------------------------------------------------------------------
const mapSchemaToTextInput = (id, schema) => ({
    id: id,
    label: id,
    format: schema.format || '',
    description: schema.description || schema.help_text,
    defaultValue: schema.default
});
const isTextInput = (schema) => schema.type === 'string' && !schema.enum ? true : false;
// -----------------------------------------------------------------------------
// Input component mapper
// -----------------------------------------------------------------------------
const getInputComponent = (id, schema, error, onChange) => {
    if (isBooleanInput(schema)) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_inputs_BooleanInput__WEBPACK_IMPORTED_MODULE_1__["default"], Object.assign({}, mapSchemaToBooleanInput(id, schema), { error: error, onChange: onChange })));
    }
    else if (isSelectInput(schema)) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_inputs_SelectInput__WEBPACK_IMPORTED_MODULE_2__["default"], Object.assign({}, mapSchemaToSelectInput(id, schema), { error: error, onChange: onChange })));
    }
    else if (isFileInput(schema)) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_inputs_TextInput__WEBPACK_IMPORTED_MODULE_3__["default"], Object.assign({}, mapSchemaToTextInput(id, schema), { error: error, onChange: onChange })));
    }
    else if (isTextInput(schema)) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_inputs_TextInput__WEBPACK_IMPORTED_MODULE_3__["default"], Object.assign({}, mapSchemaToTextInput(id, schema), { error: error, onChange: onChange })));
    }
    else if (isNumInput(schema)) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_inputs_NumInput__WEBPACK_IMPORTED_MODULE_4__["default"], Object.assign({}, mapSchemaToNumInput(id, schema), { error: error, onChange: onChange })));
    }
    else {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_inputs_TextInput__WEBPACK_IMPORTED_MODULE_3__["default"], Object.assign({}, mapSchemaToTextInput(id, schema), { error: error, onChange: onChange })));
    }
};


/***/ }),

/***/ "./lib/handler.js":
/*!************************!*\
  !*** ./lib/handler.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "requestAPI": () => (/* binding */ requestAPI)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);


/**
 * Call the API extension
 *
 * @param endPoint API REST end point for the extension
 * @param init Initial values for the request
 * @returns The response body interpreted as JSON
 */
async function requestAPI(endPoint = '', init = {}) {
    // Make request to Jupyter API
    const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
    const requestUrl = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(settings.baseUrl, 'epi2melabs-wfpage', // API Namespace
    endPoint);
    let response;
    try {
        response = await _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(requestUrl, init, settings);
    }
    catch (error) {
        throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.NetworkError(error);
    }
    let data = await response.text();
    if (data.length > 0) {
        try {
            data = JSON.parse(data);
        }
        catch (error) {
            console.log('Not a JSON response body.', response);
        }
    }
    if (!response.ok) {
        throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response, data.message || data);
    }
    return data;
}


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/settingregistry */ "webpack/sharing/consume/default/@jupyterlab/settingregistry");
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/docmanager */ "webpack/sharing/consume/default/@jupyterlab/docmanager");
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/launcher */ "webpack/sharing/consume/default/@jupyterlab/launcher");
/* harmony import */ var _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _asset__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./asset */ "./lib/asset.js");
/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./widget */ "./lib/widget.js");






const PLUGIN_ID = '@epi2melabs/epi2melabs-wfpage:plugin';
const COMMAND = 'create-epi2me-labs-launcher';
const CATEGORY = 'EPI2ME Labs';
/**
 * Initialization data for the epi2melabs-wfpage extension.
 */
const plugin = {
    id: PLUGIN_ID,
    autoStart: true,
    requires: [_jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_3__.ILauncher, _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_0__.ISettingRegistry, _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_1__.IDocumentManager],
    activate: (app, launcher, settings, docTrack) => {
        const { commands, shell } = app;
        Promise.all([app.restored, settings.load(PLUGIN_ID)]).then(([, setting]) => {
            commands.addCommand(COMMAND, {
                caption: 'Create an EPI2ME Labs workflow launcher',
                label: 'Workflows (Beta)',
                icon: _asset__WEBPACK_IMPORTED_MODULE_4__.labsLogoIcon,
                execute: () => {
                    const content = new _widget__WEBPACK_IMPORTED_MODULE_5__.Launcher(docTrack);
                    const widget = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.MainAreaWidget({ content });
                    widget.title.label = 'EPI2ME Labs';
                    shell.add(widget, 'main');
                }
            });
            if (launcher) {
                launcher.add({
                    command: COMMAND,
                    category: CATEGORY
                });
            }
        });
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);


/***/ }),

/***/ "./lib/schema.js":
/*!***********************!*\
  !*** ./lib/schema.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "validateSchema": () => (/* binding */ validateSchema),
/* harmony export */   "parseValidationErrors": () => (/* binding */ parseValidationErrors)
/* harmony export */ });
/* harmony import */ var ajv__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ajv */ "webpack/sharing/consume/default/ajv/ajv");
/* harmony import */ var ajv__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(ajv__WEBPACK_IMPORTED_MODULE_0__);

function validateSchema(data, schema) {
    // Slower, todo: manage workflow schemas
    // and use ajv singleton
    const ajv = new (ajv__WEBPACK_IMPORTED_MODULE_0___default())({
        allErrors: true,
        strictSchema: false,
        verbose: true
    });
    const validate = ajv.compile(schema);
    const valid = validate(data);
    return { valid, errors: validate.errors };
}
const parseValidationErrors = (errors) => {
    const errorMapping = {};
    errors.forEach(Error => {
        Object.values(Error.params).forEach(key => {
            errorMapping[key] = [...(errorMapping[key] || []), Error.message || ''];
        });
    });
    return errorMapping;
};


/***/ }),

/***/ "./lib/widget.js":
/*!***********************!*\
  !*** ./lib/widget.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Launcher": () => (/* binding */ Launcher)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_instance_Instance__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/instance/Instance */ "./lib/components/instance/Instance.js");
/* harmony import */ var _components_workflow_Workflow__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/workflow/Workflow */ "./lib/components/workflow/Workflow.js");
/* harmony import */ var _components_WorkflowsPanel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/WorkflowsPanel */ "./lib/components/WorkflowsPanel.js");
/* harmony import */ var _components_InstancesPanel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/InstancesPanel */ "./lib/components/InstancesPanel.js");
/* harmony import */ var _components_IndexPanel__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/IndexPanel */ "./lib/components/IndexPanel.js");
/* harmony import */ var _components_Header__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/Header */ "./lib/components/Header.js");
/* harmony import */ var _components_Footer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/Footer */ "./lib/components/Footer.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_3__);











const LauncherContainer = (styled_components__WEBPACK_IMPORTED_MODULE_2___default().div) ``;
class Launcher extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    constructor(docTrack) {
        super();
        this.docTrack = docTrack;
        this.addClass('jp-ReactWidget');
        this.addClass('epi2melabs-wfpage-widget');
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.MemoryRouter, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LauncherContainer, null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("main", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_Header__WEBPACK_IMPORTED_MODULE_4__["default"], null),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.Routes, null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.Route, { path: "/workflows/:name", element: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_workflow_Workflow__WEBPACK_IMPORTED_MODULE_5__["default"], null) }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.Route, { path: "/workflows", element: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_WorkflowsPanel__WEBPACK_IMPORTED_MODULE_6__["default"], null) }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.Route, { path: "/instances/:id", element: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_instance_Instance__WEBPACK_IMPORTED_MODULE_7__["default"], { docTrack: this.docTrack }) }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.Route, { path: "/instances", element: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_InstancesPanel__WEBPACK_IMPORTED_MODULE_8__["default"], null) }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.Route, { path: "/", element: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_IndexPanel__WEBPACK_IMPORTED_MODULE_9__["default"], null) }))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_Footer__WEBPACK_IMPORTED_MODULE_10__["default"], null)))));
    }
}


/***/ }),

/***/ "./node_modules/moment/locale sync recursive ^\\.\\/.*$":
/*!***************************************************!*\
  !*** ./node_modules/moment/locale/ sync ^\.\/.*$ ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./af": "./node_modules/moment/locale/af.js",
	"./af.js": "./node_modules/moment/locale/af.js",
	"./ar": "./node_modules/moment/locale/ar.js",
	"./ar-dz": "./node_modules/moment/locale/ar-dz.js",
	"./ar-dz.js": "./node_modules/moment/locale/ar-dz.js",
	"./ar-kw": "./node_modules/moment/locale/ar-kw.js",
	"./ar-kw.js": "./node_modules/moment/locale/ar-kw.js",
	"./ar-ly": "./node_modules/moment/locale/ar-ly.js",
	"./ar-ly.js": "./node_modules/moment/locale/ar-ly.js",
	"./ar-ma": "./node_modules/moment/locale/ar-ma.js",
	"./ar-ma.js": "./node_modules/moment/locale/ar-ma.js",
	"./ar-sa": "./node_modules/moment/locale/ar-sa.js",
	"./ar-sa.js": "./node_modules/moment/locale/ar-sa.js",
	"./ar-tn": "./node_modules/moment/locale/ar-tn.js",
	"./ar-tn.js": "./node_modules/moment/locale/ar-tn.js",
	"./ar.js": "./node_modules/moment/locale/ar.js",
	"./az": "./node_modules/moment/locale/az.js",
	"./az.js": "./node_modules/moment/locale/az.js",
	"./be": "./node_modules/moment/locale/be.js",
	"./be.js": "./node_modules/moment/locale/be.js",
	"./bg": "./node_modules/moment/locale/bg.js",
	"./bg.js": "./node_modules/moment/locale/bg.js",
	"./bm": "./node_modules/moment/locale/bm.js",
	"./bm.js": "./node_modules/moment/locale/bm.js",
	"./bn": "./node_modules/moment/locale/bn.js",
	"./bn-bd": "./node_modules/moment/locale/bn-bd.js",
	"./bn-bd.js": "./node_modules/moment/locale/bn-bd.js",
	"./bn.js": "./node_modules/moment/locale/bn.js",
	"./bo": "./node_modules/moment/locale/bo.js",
	"./bo.js": "./node_modules/moment/locale/bo.js",
	"./br": "./node_modules/moment/locale/br.js",
	"./br.js": "./node_modules/moment/locale/br.js",
	"./bs": "./node_modules/moment/locale/bs.js",
	"./bs.js": "./node_modules/moment/locale/bs.js",
	"./ca": "./node_modules/moment/locale/ca.js",
	"./ca.js": "./node_modules/moment/locale/ca.js",
	"./cs": "./node_modules/moment/locale/cs.js",
	"./cs.js": "./node_modules/moment/locale/cs.js",
	"./cv": "./node_modules/moment/locale/cv.js",
	"./cv.js": "./node_modules/moment/locale/cv.js",
	"./cy": "./node_modules/moment/locale/cy.js",
	"./cy.js": "./node_modules/moment/locale/cy.js",
	"./da": "./node_modules/moment/locale/da.js",
	"./da.js": "./node_modules/moment/locale/da.js",
	"./de": "./node_modules/moment/locale/de.js",
	"./de-at": "./node_modules/moment/locale/de-at.js",
	"./de-at.js": "./node_modules/moment/locale/de-at.js",
	"./de-ch": "./node_modules/moment/locale/de-ch.js",
	"./de-ch.js": "./node_modules/moment/locale/de-ch.js",
	"./de.js": "./node_modules/moment/locale/de.js",
	"./dv": "./node_modules/moment/locale/dv.js",
	"./dv.js": "./node_modules/moment/locale/dv.js",
	"./el": "./node_modules/moment/locale/el.js",
	"./el.js": "./node_modules/moment/locale/el.js",
	"./en-au": "./node_modules/moment/locale/en-au.js",
	"./en-au.js": "./node_modules/moment/locale/en-au.js",
	"./en-ca": "./node_modules/moment/locale/en-ca.js",
	"./en-ca.js": "./node_modules/moment/locale/en-ca.js",
	"./en-gb": "./node_modules/moment/locale/en-gb.js",
	"./en-gb.js": "./node_modules/moment/locale/en-gb.js",
	"./en-ie": "./node_modules/moment/locale/en-ie.js",
	"./en-ie.js": "./node_modules/moment/locale/en-ie.js",
	"./en-il": "./node_modules/moment/locale/en-il.js",
	"./en-il.js": "./node_modules/moment/locale/en-il.js",
	"./en-in": "./node_modules/moment/locale/en-in.js",
	"./en-in.js": "./node_modules/moment/locale/en-in.js",
	"./en-nz": "./node_modules/moment/locale/en-nz.js",
	"./en-nz.js": "./node_modules/moment/locale/en-nz.js",
	"./en-sg": "./node_modules/moment/locale/en-sg.js",
	"./en-sg.js": "./node_modules/moment/locale/en-sg.js",
	"./eo": "./node_modules/moment/locale/eo.js",
	"./eo.js": "./node_modules/moment/locale/eo.js",
	"./es": "./node_modules/moment/locale/es.js",
	"./es-do": "./node_modules/moment/locale/es-do.js",
	"./es-do.js": "./node_modules/moment/locale/es-do.js",
	"./es-mx": "./node_modules/moment/locale/es-mx.js",
	"./es-mx.js": "./node_modules/moment/locale/es-mx.js",
	"./es-us": "./node_modules/moment/locale/es-us.js",
	"./es-us.js": "./node_modules/moment/locale/es-us.js",
	"./es.js": "./node_modules/moment/locale/es.js",
	"./et": "./node_modules/moment/locale/et.js",
	"./et.js": "./node_modules/moment/locale/et.js",
	"./eu": "./node_modules/moment/locale/eu.js",
	"./eu.js": "./node_modules/moment/locale/eu.js",
	"./fa": "./node_modules/moment/locale/fa.js",
	"./fa.js": "./node_modules/moment/locale/fa.js",
	"./fi": "./node_modules/moment/locale/fi.js",
	"./fi.js": "./node_modules/moment/locale/fi.js",
	"./fil": "./node_modules/moment/locale/fil.js",
	"./fil.js": "./node_modules/moment/locale/fil.js",
	"./fo": "./node_modules/moment/locale/fo.js",
	"./fo.js": "./node_modules/moment/locale/fo.js",
	"./fr": "./node_modules/moment/locale/fr.js",
	"./fr-ca": "./node_modules/moment/locale/fr-ca.js",
	"./fr-ca.js": "./node_modules/moment/locale/fr-ca.js",
	"./fr-ch": "./node_modules/moment/locale/fr-ch.js",
	"./fr-ch.js": "./node_modules/moment/locale/fr-ch.js",
	"./fr.js": "./node_modules/moment/locale/fr.js",
	"./fy": "./node_modules/moment/locale/fy.js",
	"./fy.js": "./node_modules/moment/locale/fy.js",
	"./ga": "./node_modules/moment/locale/ga.js",
	"./ga.js": "./node_modules/moment/locale/ga.js",
	"./gd": "./node_modules/moment/locale/gd.js",
	"./gd.js": "./node_modules/moment/locale/gd.js",
	"./gl": "./node_modules/moment/locale/gl.js",
	"./gl.js": "./node_modules/moment/locale/gl.js",
	"./gom-deva": "./node_modules/moment/locale/gom-deva.js",
	"./gom-deva.js": "./node_modules/moment/locale/gom-deva.js",
	"./gom-latn": "./node_modules/moment/locale/gom-latn.js",
	"./gom-latn.js": "./node_modules/moment/locale/gom-latn.js",
	"./gu": "./node_modules/moment/locale/gu.js",
	"./gu.js": "./node_modules/moment/locale/gu.js",
	"./he": "./node_modules/moment/locale/he.js",
	"./he.js": "./node_modules/moment/locale/he.js",
	"./hi": "./node_modules/moment/locale/hi.js",
	"./hi.js": "./node_modules/moment/locale/hi.js",
	"./hr": "./node_modules/moment/locale/hr.js",
	"./hr.js": "./node_modules/moment/locale/hr.js",
	"./hu": "./node_modules/moment/locale/hu.js",
	"./hu.js": "./node_modules/moment/locale/hu.js",
	"./hy-am": "./node_modules/moment/locale/hy-am.js",
	"./hy-am.js": "./node_modules/moment/locale/hy-am.js",
	"./id": "./node_modules/moment/locale/id.js",
	"./id.js": "./node_modules/moment/locale/id.js",
	"./is": "./node_modules/moment/locale/is.js",
	"./is.js": "./node_modules/moment/locale/is.js",
	"./it": "./node_modules/moment/locale/it.js",
	"./it-ch": "./node_modules/moment/locale/it-ch.js",
	"./it-ch.js": "./node_modules/moment/locale/it-ch.js",
	"./it.js": "./node_modules/moment/locale/it.js",
	"./ja": "./node_modules/moment/locale/ja.js",
	"./ja.js": "./node_modules/moment/locale/ja.js",
	"./jv": "./node_modules/moment/locale/jv.js",
	"./jv.js": "./node_modules/moment/locale/jv.js",
	"./ka": "./node_modules/moment/locale/ka.js",
	"./ka.js": "./node_modules/moment/locale/ka.js",
	"./kk": "./node_modules/moment/locale/kk.js",
	"./kk.js": "./node_modules/moment/locale/kk.js",
	"./km": "./node_modules/moment/locale/km.js",
	"./km.js": "./node_modules/moment/locale/km.js",
	"./kn": "./node_modules/moment/locale/kn.js",
	"./kn.js": "./node_modules/moment/locale/kn.js",
	"./ko": "./node_modules/moment/locale/ko.js",
	"./ko.js": "./node_modules/moment/locale/ko.js",
	"./ku": "./node_modules/moment/locale/ku.js",
	"./ku.js": "./node_modules/moment/locale/ku.js",
	"./ky": "./node_modules/moment/locale/ky.js",
	"./ky.js": "./node_modules/moment/locale/ky.js",
	"./lb": "./node_modules/moment/locale/lb.js",
	"./lb.js": "./node_modules/moment/locale/lb.js",
	"./lo": "./node_modules/moment/locale/lo.js",
	"./lo.js": "./node_modules/moment/locale/lo.js",
	"./lt": "./node_modules/moment/locale/lt.js",
	"./lt.js": "./node_modules/moment/locale/lt.js",
	"./lv": "./node_modules/moment/locale/lv.js",
	"./lv.js": "./node_modules/moment/locale/lv.js",
	"./me": "./node_modules/moment/locale/me.js",
	"./me.js": "./node_modules/moment/locale/me.js",
	"./mi": "./node_modules/moment/locale/mi.js",
	"./mi.js": "./node_modules/moment/locale/mi.js",
	"./mk": "./node_modules/moment/locale/mk.js",
	"./mk.js": "./node_modules/moment/locale/mk.js",
	"./ml": "./node_modules/moment/locale/ml.js",
	"./ml.js": "./node_modules/moment/locale/ml.js",
	"./mn": "./node_modules/moment/locale/mn.js",
	"./mn.js": "./node_modules/moment/locale/mn.js",
	"./mr": "./node_modules/moment/locale/mr.js",
	"./mr.js": "./node_modules/moment/locale/mr.js",
	"./ms": "./node_modules/moment/locale/ms.js",
	"./ms-my": "./node_modules/moment/locale/ms-my.js",
	"./ms-my.js": "./node_modules/moment/locale/ms-my.js",
	"./ms.js": "./node_modules/moment/locale/ms.js",
	"./mt": "./node_modules/moment/locale/mt.js",
	"./mt.js": "./node_modules/moment/locale/mt.js",
	"./my": "./node_modules/moment/locale/my.js",
	"./my.js": "./node_modules/moment/locale/my.js",
	"./nb": "./node_modules/moment/locale/nb.js",
	"./nb.js": "./node_modules/moment/locale/nb.js",
	"./ne": "./node_modules/moment/locale/ne.js",
	"./ne.js": "./node_modules/moment/locale/ne.js",
	"./nl": "./node_modules/moment/locale/nl.js",
	"./nl-be": "./node_modules/moment/locale/nl-be.js",
	"./nl-be.js": "./node_modules/moment/locale/nl-be.js",
	"./nl.js": "./node_modules/moment/locale/nl.js",
	"./nn": "./node_modules/moment/locale/nn.js",
	"./nn.js": "./node_modules/moment/locale/nn.js",
	"./oc-lnc": "./node_modules/moment/locale/oc-lnc.js",
	"./oc-lnc.js": "./node_modules/moment/locale/oc-lnc.js",
	"./pa-in": "./node_modules/moment/locale/pa-in.js",
	"./pa-in.js": "./node_modules/moment/locale/pa-in.js",
	"./pl": "./node_modules/moment/locale/pl.js",
	"./pl.js": "./node_modules/moment/locale/pl.js",
	"./pt": "./node_modules/moment/locale/pt.js",
	"./pt-br": "./node_modules/moment/locale/pt-br.js",
	"./pt-br.js": "./node_modules/moment/locale/pt-br.js",
	"./pt.js": "./node_modules/moment/locale/pt.js",
	"./ro": "./node_modules/moment/locale/ro.js",
	"./ro.js": "./node_modules/moment/locale/ro.js",
	"./ru": "./node_modules/moment/locale/ru.js",
	"./ru.js": "./node_modules/moment/locale/ru.js",
	"./sd": "./node_modules/moment/locale/sd.js",
	"./sd.js": "./node_modules/moment/locale/sd.js",
	"./se": "./node_modules/moment/locale/se.js",
	"./se.js": "./node_modules/moment/locale/se.js",
	"./si": "./node_modules/moment/locale/si.js",
	"./si.js": "./node_modules/moment/locale/si.js",
	"./sk": "./node_modules/moment/locale/sk.js",
	"./sk.js": "./node_modules/moment/locale/sk.js",
	"./sl": "./node_modules/moment/locale/sl.js",
	"./sl.js": "./node_modules/moment/locale/sl.js",
	"./sq": "./node_modules/moment/locale/sq.js",
	"./sq.js": "./node_modules/moment/locale/sq.js",
	"./sr": "./node_modules/moment/locale/sr.js",
	"./sr-cyrl": "./node_modules/moment/locale/sr-cyrl.js",
	"./sr-cyrl.js": "./node_modules/moment/locale/sr-cyrl.js",
	"./sr.js": "./node_modules/moment/locale/sr.js",
	"./ss": "./node_modules/moment/locale/ss.js",
	"./ss.js": "./node_modules/moment/locale/ss.js",
	"./sv": "./node_modules/moment/locale/sv.js",
	"./sv.js": "./node_modules/moment/locale/sv.js",
	"./sw": "./node_modules/moment/locale/sw.js",
	"./sw.js": "./node_modules/moment/locale/sw.js",
	"./ta": "./node_modules/moment/locale/ta.js",
	"./ta.js": "./node_modules/moment/locale/ta.js",
	"./te": "./node_modules/moment/locale/te.js",
	"./te.js": "./node_modules/moment/locale/te.js",
	"./tet": "./node_modules/moment/locale/tet.js",
	"./tet.js": "./node_modules/moment/locale/tet.js",
	"./tg": "./node_modules/moment/locale/tg.js",
	"./tg.js": "./node_modules/moment/locale/tg.js",
	"./th": "./node_modules/moment/locale/th.js",
	"./th.js": "./node_modules/moment/locale/th.js",
	"./tk": "./node_modules/moment/locale/tk.js",
	"./tk.js": "./node_modules/moment/locale/tk.js",
	"./tl-ph": "./node_modules/moment/locale/tl-ph.js",
	"./tl-ph.js": "./node_modules/moment/locale/tl-ph.js",
	"./tlh": "./node_modules/moment/locale/tlh.js",
	"./tlh.js": "./node_modules/moment/locale/tlh.js",
	"./tr": "./node_modules/moment/locale/tr.js",
	"./tr.js": "./node_modules/moment/locale/tr.js",
	"./tzl": "./node_modules/moment/locale/tzl.js",
	"./tzl.js": "./node_modules/moment/locale/tzl.js",
	"./tzm": "./node_modules/moment/locale/tzm.js",
	"./tzm-latn": "./node_modules/moment/locale/tzm-latn.js",
	"./tzm-latn.js": "./node_modules/moment/locale/tzm-latn.js",
	"./tzm.js": "./node_modules/moment/locale/tzm.js",
	"./ug-cn": "./node_modules/moment/locale/ug-cn.js",
	"./ug-cn.js": "./node_modules/moment/locale/ug-cn.js",
	"./uk": "./node_modules/moment/locale/uk.js",
	"./uk.js": "./node_modules/moment/locale/uk.js",
	"./ur": "./node_modules/moment/locale/ur.js",
	"./ur.js": "./node_modules/moment/locale/ur.js",
	"./uz": "./node_modules/moment/locale/uz.js",
	"./uz-latn": "./node_modules/moment/locale/uz-latn.js",
	"./uz-latn.js": "./node_modules/moment/locale/uz-latn.js",
	"./uz.js": "./node_modules/moment/locale/uz.js",
	"./vi": "./node_modules/moment/locale/vi.js",
	"./vi.js": "./node_modules/moment/locale/vi.js",
	"./x-pseudo": "./node_modules/moment/locale/x-pseudo.js",
	"./x-pseudo.js": "./node_modules/moment/locale/x-pseudo.js",
	"./yo": "./node_modules/moment/locale/yo.js",
	"./yo.js": "./node_modules/moment/locale/yo.js",
	"./zh-cn": "./node_modules/moment/locale/zh-cn.js",
	"./zh-cn.js": "./node_modules/moment/locale/zh-cn.js",
	"./zh-hk": "./node_modules/moment/locale/zh-hk.js",
	"./zh-hk.js": "./node_modules/moment/locale/zh-hk.js",
	"./zh-mo": "./node_modules/moment/locale/zh-mo.js",
	"./zh-mo.js": "./node_modules/moment/locale/zh-mo.js",
	"./zh-tw": "./node_modules/moment/locale/zh-tw.js",
	"./zh-tw.js": "./node_modules/moment/locale/zh-tw.js"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "./node_modules/moment/locale sync recursive ^\\.\\/.*$";

/***/ })

}]);
//# sourceMappingURL=lib_index_js-node_modules_moment_locale_sync_recursive_.5bfb58713e466e938f0e.js.map