"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Variable = exports.Stack = exports.BaseStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tfe = require("@cdktf/provider-tfe");
const cdktf_1 = require("cdktf");
const MULTI_STACK_BASE_SYMBOL = Symbol(`multi-stack-tfe-base`);
const MULTI_STACK_STACK_SYMBOL = Symbol(`multi-stack-tfe-stack`);
class BaseStack extends cdktf_1.TerraformStack {
    constructor(scope, organizationName, prefix, options = {}) {
        super(scope, "base");
        this.organizationName = organizationName;
        this.prefix = prefix;
        this.options = options;
        this.stackTfeWorkspaceMap = {};
        Object.defineProperty(this, MULTI_STACK_BASE_SYMBOL, { value: true });
        this.tfeProvider = new tfe.TfeProvider(this, "tfe", {
            hostname: options.hostname,
            token: options.token,
            sslSkipVerify: options.sslSkipVerify,
        });
        new cdktf_1.RemoteBackend(this, this.getRemoteBackendOptions("base"));
        this.organization = new tfe.DataTfeOrganization(this, "organization", {
            name: organizationName,
        });
    }
    static isBaseStack(x) {
        return x !== null && typeof x === "object" && MULTI_STACK_BASE_SYMBOL in x;
    }
    static baseStackOf(construct) {
        const app = cdktf_1.App.of(construct);
        const base = app.node.children.find(BaseStack.isBaseStack);
        if (!base) {
            throw new Error(`No BaseStack for multi-stack app could be identified for the construct at path '${construct.node.path}'. The base stack needs to have the same app as the scope as this construct.`);
        }
        return base;
    }
    getRemoteBackendOptions(stackName) {
        return {
            workspaces: {
                name: this.getWorkspaceName(stackName),
            },
            organization: this.organizationName,
            // optional
            hostname: this.options.hostname,
            token: this.options.token,
        };
    }
    /**
     * If you want to have more control over the workspace name, you can override this method.
     */
    getWorkspaceName(stackName) {
        return `${this.prefix}-${stackName}`;
    }
    bootstrapWorkspace(stackName, stackConfig = {}) {
        const config = {
            ...(this.options.defaultWorkspaceConfig || {}),
            ...stackConfig,
        };
        const workspace = new tfe.Workspace(this, `tfe-multi-stack-workspace-${stackName}`, {
            ...config,
            name: this.getWorkspaceName(stackName),
            organization: this.organization.name,
            tagNames: [this.prefix, ...(config.tagNames || [])],
            remoteStateConsumerIds: [...(config.remoteStateConsumerIds || [])],
        });
        this.stackTfeWorkspaceMap[stackName] = workspace;
        return workspace;
    }
    createSecret(targetStack, secretName, config) {
        const targetStackName = targetStack.node.id;
        const workspace = this.stackTfeWorkspaceMap[targetStackName];
        if (!workspace) {
            throw new Error(`No workspace found for stack ${targetStackName} in multi-stack app. This is a bug.`);
        }
        const variableInBaseStack = new cdktf_1.TerraformVariable(this, `var-${targetStackName}-${secretName}`, config);
        variableInBaseStack.overrideLogicalId(secretName);
        new tfe.Variable(this, `tfe-var-${targetStackName}-${secretName}`, {
            key: secretName,
            value: variableInBaseStack.value,
            category: "terraform",
            description: config.description,
            hcl: false,
            sensitive: config.sensitive,
            workspaceId: workspace.id,
        });
    }
}
exports.BaseStack = BaseStack;
_a = JSII_RTTI_SYMBOL_1;
BaseStack[_a] = { fqn: "cdktf-multi-stack-tfe.BaseStack", version: "0.0.35" };
class Stack extends cdktf_1.TerraformStack {
    constructor(scope, stackName, config) {
        super(scope, stackName);
        Object.defineProperty(this, MULTI_STACK_STACK_SYMBOL, { value: true });
        const baseStack = BaseStack.baseStackOf(this);
        this.workspace = baseStack.bootstrapWorkspace(stackName, config);
        new cdktf_1.RemoteBackend(this, baseStack.getRemoteBackendOptions(stackName));
    }
    static isMultiStackStack(x) {
        return x !== null && typeof x === "object" && MULTI_STACK_STACK_SYMBOL in x;
    }
    static multiStackOf(construct) {
        return _lookup(construct);
        function _lookup(c) {
            if (Stack.isMultiStackStack(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                throw new Error(`No stack could be identified for the construct at path '${construct.node.path}'`);
            }
            return _lookup(node.scope);
        }
    }
    addDependency(dependency) {
        var _d, _e;
        if (!this.dependencies.includes(dependency) &&
            Stack.isMultiStackStack(dependency)) {
            (_d = dependency.workspace.remoteStateConsumerIdsInput) === null || _d === void 0 ? void 0 : _d.push(this.workspace.id);
            const currentDependencies = (_e = dependency.workspace.dependsOn) !== null && _e !== void 0 ? _e : [];
            currentDependencies.push(cdktf_1.insideTfExpression(this.workspace.fqn));
            // This is not working as the result is wrapped in a terraform expression where it's not allowed to
            dependency.workspace.dependsOn = currentDependencies;
        }
        super.addDependency(dependency);
    }
}
exports.Stack = Stack;
_b = JSII_RTTI_SYMBOL_1;
Stack[_b] = { fqn: "cdktf-multi-stack-tfe.Stack", version: "0.0.35" };
// Creates a TerraformVariable from creating a tfe.Variable in the base stack
class Variable extends cdktf_1.TerraformVariable {
    constructor(scope, id, config) {
        super(scope, id, {
            ...config,
        });
        this.overrideLogicalId(id);
        const baseStack = BaseStack.baseStackOf(this);
        baseStack.createSecret(Stack.multiStackOf(this), id, config);
    }
}
exports.Variable = Variable;
_c = JSII_RTTI_SYMBOL_1;
Variable[_c] = { fqn: "cdktf-multi-stack-tfe.Variable", version: "0.0.35" };
//# sourceMappingURL=data:application/json;base64,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