# Financial Trading Tools (FTT)

> Finance is hard. Programming is hard.

![PyPI](https://img.shields.io/pypi/v/ftt)
[![Testing](https://github.com/ftt-project/ftt/actions/workflows/testing.yml/badge.svg)](https://github.com/ftt-project/ftt/actions/workflows/testing.yml)
[![Linting](https://github.com/ftt-project/ftt/actions/workflows/linting.yml/badge.svg)](https://github.com/ftt-project/ftt/actions/workflows/linting.yml)
![GitHub](https://img.shields.io/github/license/ftt-project/ftt)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/ftt)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/ftt-project/ftt.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/ftt-project/ftt/context:python)

FTT is a financial asset management application that helps to make right decision on time.

## Mission

To enable every private investor to make a rational algorithmic decision.

## Vision

To create a compelling service that provides private investors opportunities to cast their investing believes through prism of statistic and analysis.

## Problem statement

FTT solves a concrete problem by assembling multiple features in one place. Refer to [PROBLEM_STATEMENT](PROBLEM_STATEMENT.md) document for details.

## Main features

### Done

* Foundation for organized data storing and viewing.
* Calculation of weights in portfolio using multiple algorithms.
* CLI Interface

### Not done

* Backtest portfolios to choose one.
* Complement portfolio with additional securities for better balancing.
* Initiate and control financial operations in the brokerage system.
* Monitor portfolio performance and automatically rebalance it.
* Take automated decisions on buy and sell operations to prevent losses.
* Web interface


## Collaborators
- [Artem M](https://github.com/ignar)
- [Ihor M](https://github.com/IhorMok)


## Quickstart

```
$> pip install ftt
$> ftt
ftt> example
```
