"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BundledNodejsFunction = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
/**
 * Lambda Function wrapper that uses pre-bundled JavaScript file from the known folder `lib/lambdas` with some reasonable defaults. The bundled files are put there by projen tasks that use esbuild to bundle TypeScript files from `src/lambdas`. This code is found in `.projenrc.js`.
 */
class BundledNodejsFunction extends aws_cdk_lib_1.aws_lambda.Function {
    constructor(scope, id, props, srcId) {
        super(scope, id, {
            ...props,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', srcId ?? id)),
            handler: 'index.handler',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        this.props = props;
        this.addEnvironment('AWS_NODEJS_CONNECTION_REUSE_ENABLED', '1', { removeInEdge: true });
    }
    static singleton(scope, id, props) {
        const constructName = `${id}-dcc036c8-876b-451e-a2c1-552f9e06e9e1`;
        const existing = cdk.Stack.of(scope).node.tryFindChild(constructName);
        if (existing) {
            // Just assume this is true
            return existing;
        }
        return new BundledNodejsFunction(cdk.Stack.of(scope), constructName, props, id);
    }
}
exports.BundledNodejsFunction = BundledNodejsFunction;
//# sourceMappingURL=data:application/json;base64,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