"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticRunnerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild_1 = require("../codebuild");
const common_1 = require("../common");
const codebuild_2 = require("./codebuild");
/**
 * Helper class with methods to use static images that are built outside the context of this project.
 */
class StaticRunnerImage {
    /**
     * Create a builder (that doesn't actually build anything) from an existing image in an existing repository. The image must already have GitHub Actions runner installed. You are responsible to update it and remove it when done.
     *
     * @param repository ECR repository
     * @param tag image tag
     * @param architecture image architecture
     * @param os image OS
     */
    static fromEcrRepository(repository, tag = 'latest', architecture = common_1.Architecture.X86_64, os = common_1.Os.LINUX) {
        return {
            bind() {
                return {
                    imageRepository: repository,
                    imageTag: tag,
                    imageDigest: 'unknown',
                    architecture,
                    os,
                };
            },
        };
    }
    /**
     * Create a builder from an existing Docker Hub image. The image must already have GitHub Actions runner installed. You are responsible to update it and remove it when done.
     *
     * We create a CodeBuild image builder behind the scenes to copy the image over to ECR. This helps avoid Docker Hub rate limits and prevent failures.
     *
     * @param scope
     * @param id
     * @param image Docker Hub image with optional tag
     * @param architecture image architecture
     * @param os image OS
     */
    static fromDockerHub(scope, id, image, architecture = common_1.Architecture.X86_64, os = common_1.Os.LINUX) {
        const builder = new codebuild_2.CodeBuildImageBuilder(scope, id, {
            dockerfilePath: codebuild_1.CodeBuildRunner.LINUX_X64_DOCKERFILE_PATH,
            architecture,
            os,
        });
        builder.addPreBuildCommand(`echo "FROM ${image}" > Dockerfile`);
        return builder;
    }
}
exports.StaticRunnerImage = StaticRunnerImage;
_a = JSII_RTTI_SYMBOL_1;
StaticRunnerImage[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.StaticRunnerImage", version: "0.3.0" };
//# sourceMappingURL=data:application/json;base64,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