"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/lambdas/update-lambda/index.ts
var update_lambda_exports = {};
__export(update_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(update_lambda_exports);
var AWS = __toESM(require("aws-sdk"));
var cfn = new AWS.CloudFormation();
var lambda = new AWS.Lambda();
async function handler(event) {
  var _a;
  console.log(event);
  const stacks = await cfn.describeStacks({
    StackName: event.stackName
  }).promise();
  if (((_a = stacks.Stacks) == null ? void 0 : _a.length) != 1) {
    console.error(`Unable to find stack ${event.stackName}`);
    return;
  }
  if (stacks.Stacks[0].StackStatus.endsWith("_IN_PROGRESS")) {
    console.error(`Stack ${event.stackName} is already in progress, skipping Lambda update as the stack will do it for us. If we update here, it may conflict with the stack operation.`);
    return;
  }
  await lambda.updateFunctionCode({
    FunctionName: event.lambdaName,
    ImageUri: `${event.repositoryUri}:${event.repositoryTag}`,
    Publish: true
  }).promise();
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
