"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType = exports.ImageRepositoryType || (exports.ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) { return new Cpu(unit); }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.38.1-alpha.0" };
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) { return new Memory(unit); }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.38.1-alpha.0" };
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.38.1-alpha.0" };
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.38.1-alpha.0" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.38.1-alpha.0" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.38.1-alpha.0" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.38.1-alpha.0" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.38.1-alpha.0" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType = exports.ConfigurationSourceType || (exports.ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    constructor(arn) {
        this.connectionArn = arn;
    }
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.38.1-alpha.0" };
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service
         */
        this.environment = {};
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        // generate an IAM role only when ImageRepositoryType is ECR and props.role is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ? this.props.accessRole : this.generateDefaultRole() : undefined;
        if (source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            source.codeRepository?.codeConfiguration.configurationValues) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            instanceConfiguration: {
                cpu: props.cpu?.unit,
                memory: props.memory?.unit,
                instanceRoleArn: props.instanceRole?.roleArn,
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                imageRepository: source.imageRepository ? this.renderImageRepository() : undefined,
                codeRepository: source.codeRepository ? this.renderCodeConfiguration() : undefined,
            },
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
            },
        });
        // grant required privileges for the role
        if (source.ecrRepository && this.accessRole) {
            source.ecrRepository.grantPull(this.accessRole);
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        this.serviceName = resource.ref;
    }
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration() {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(this.source.codeRepository.codeConfiguration.configurationValues) : undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        this.environment = props.environment;
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: this.renderEnvironmentVariables(),
            startCommand: props.startCommand,
        };
    }
    renderImageRepository() {
        const repo = this.source.imageRepository;
        this.environment = repo.imageConfiguration?.environment;
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: this.renderEnvironmentVariables(),
            },
        });
    }
    renderEnvironmentVariables() {
        if (this.environment) {
            let env = [];
            for (const [key, value] of Object.entries(this.environment)) {
                if (key.startsWith('AWSAPPRUNNER')) {
                    throw new Error(`Environment variable key ${key} with a prefix of AWSAPPRUNNER is not allowed`);
                }
                env.push({ name: key, value: value });
            }
            return env;
        }
        else {
            return undefined;
        }
    }
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
}
exports.Service = Service;
_k = JSII_RTTI_SYMBOL_1;
Service[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.38.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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