"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secrets = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Secrets required for GitHub runners operation.
 */
class Secrets extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.webhook = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Webhook', {
            generateSecretString: {
                secretStringTemplate: '{}',
                generateStringKey: 'webhookSecret',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        this.github = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    domain: 'github.com',
                    clientSecret: '',
                    clientId: '',
                    appId: '',
                    installationId: '',
                    personalAuthToken: '',
                }),
                generateStringKey: 'dummy',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        // we create a separate secret for the private key because putting it in JSON secret is hard for the user
        this.githubPrivateKey = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub Private Key', {
            secretStringValue: cdk.SecretValue.unsafePlainText('-----BEGIN RSA PRIVATE KEY-----\n...\n-----END RSA PRIVATE KEY-----'),
        });
    }
}
exports.Secrets = Secrets;
_a = JSII_RTTI_SYMBOL_1;
Secrets[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.Secrets", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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