/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.ColorSchemeModel;
import TCGA.ContrastControlPanel;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.Options;
import TCGA.SampleSubsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class SampleSummaryInfo {
    private static final int TRACK_COUNT = 100;
    private GenomicMeasurement gm;
    private HashMap<String, int[]> sample2abs_counts;
    private HashMap<String, int[]> subset2abs_counts;
    private int[] global_abs_counts;

    public SampleSummaryInfo(GenomicMeasurement gm) {
        this.gm = gm;
        this.setup();
    }

    private void setup() {
        int i;
        int[] abs_counts;
        ArrayList<GenomicSample> rows = this.gm.get_rows();
        this.sample2abs_counts = new HashMap();
        this.subset2abs_counts = new HashMap();
        for (GenomicSample gs : rows) {
            abs_counts = new int[100];
            for (i = 0; i < gs.copynum_data.length; ++i) {
                int n = Math.abs(gs.copynum_data[i]);
                abs_counts[n] = abs_counts[n] + 1;
            }
            this.sample2abs_counts.put(gs.sample_id, abs_counts);
        }
        this.global_abs_counts = new int[100];
        for (GenomicSample gs : rows) {
            abs_counts = this.sample2abs_counts.get(gs.sample_id);
            for (i = 0; i < abs_counts.length; ++i) {
                int n = i;
                this.global_abs_counts[n] = this.global_abs_counts[n] + abs_counts[i];
            }
        }
        SampleSubsets ss = this.gm.get_sample_subsets();
        if (ss != null && !ss.isEmpty()) {
            for (String subset : ss.get_subsets_arraylist()) {
                int[] subset_counts = new int[100];
                for (GenomicSample gs : rows) {
                    if (gs.sample_id.indexOf(subset) < 0) continue;
                    abs_counts = this.sample2abs_counts.get(gs.sample_id);
                    for (i = 0; i < abs_counts.length; ++i) {
                        int n = i;
                        subset_counts[n] = subset_counts[n] + abs_counts[i];
                    }
                }
                this.subset2abs_counts.put(subset, subset_counts);
            }
        }
    }

    public int[] get_global_abs_counts() {
        return this.global_abs_counts;
    }

    public int[] get_subset_abs_counts(String subset) {
        return this.subset2abs_counts.get(subset);
    }

    public ColorSchemeModel calculate_gradients(String subset) {
        int i;
        int[] abs_counts = subset == null ? this.get_global_abs_counts() : this.get_subset_abs_counts(subset);
        int total_active = 0;
        int skip = Math.abs(-99);
        for (i = 1; i < 100; ++i) {
            if (i == skip) continue;
            total_active += abs_counts[i];
        }
        HashSet<Integer> hs = new HashSet<Integer>();
        float[] rungs_to_generate = new float[]{0.25f, 0.5f, 0.75f, 0.9f, 0.95f, 0.97f, 0.99f};
        for (i = 0; i < rungs_to_generate.length; ++i) {
            int rung = this.find_rung(abs_counts, total_active, rungs_to_generate[i]);
            hs.add(new Integer(rung));
        }
        ArrayList al = new ArrayList(hs);
        Collections.sort(al);
        int grad_count = al.size();
        if (grad_count > Options.SLIDER_COUNT) {
            grad_count = Options.SLIDER_COUNT;
        }
        ColorSchemeModel gr = new ColorSchemeModel();
        gr.gradients = new int[grad_count];
        i = 0;
        for (int al_i = al.size() - grad_count; al_i < al.size(); ++al_i) {
            gr.gradients[i] = (Integer)al.get(al_i);
            ++i;
        }
        gr.min_intensity_percent = ContrastControlPanel.calculate_minimum_intensity(gr.gradients.length);
        if (gr.min_intensity_percent < 10) {
            gr.min_intensity_percent = 10;
        }
        return gr;
    }

    public int find_rung(int[] abs_counts, int total, float rung_level) {
        int threshold = (int)((float)total * rung_level);
        int so_far = 0;
        int rung = 0;
        int skip = Math.abs(-99);
        for (int i = 1; i < 100; ++i) {
            if (i == skip || (so_far += abs_counts[i]) < threshold) continue;
            rung = i;
            break;
        }
        return rung;
    }
}

