/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.Str;
import TCGA.CombineInfo;
import TCGA.DataScale;
import TCGA.DataScales;
import TCGA.GISTIC;
import TCGA.TrackInfo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentOptions {
    private HashMap<String, String> options = new HashMap();
    private ArrayList<TrackInfo> tracks;
    private ArrayList<CombineInfo> combines;
    private TrackInfo current_track;
    private DataScales data_scales;
    private CombineInfo current_combine;
    private GISTIC gistic;

    public CommentOptions() {
        this.put("genome", "on");
        this.tracks = new ArrayList();
        this.combines = new ArrayList();
    }

    public String get(String key) {
        return this.options.get(key);
    }

    public void put(String key, String value) {
        this.options.put(key, value);
    }

    public boolean has_option(String key) {
        return this.options.containsKey(key);
    }

    public boolean parse_line(String line) {
        boolean status = false;
        if (line == null || line.length() == 0) {
            System.err.println("WARNING: null line in input file");
        } else if (line.charAt(0) == '#') {
            status = true;
            int ei = line.indexOf(61);
            if (ei > 0) {
                String key = Str.trim_whitespace(line.substring(1, ei)).toLowerCase();
                String value = Str.trim_whitespace(line.substring(ei + 1));
                if (key.equals("data_scale")) {
                    if (this.data_scales == null) {
                        this.data_scales = new DataScales();
                    }
                    try {
                        this.data_scales.add(new DataScale(value));
                    }
                    catch (ParseException e) {
                        System.err.println("ERROR parsing data scale: " + e);
                    }
                } else if (key.equals("gistic_data")) {
                    if (this.gistic == null) {
                        this.gistic = new GISTIC(this);
                    }
                    this.gistic.add(value);
                } else if (key.indexOf("combine_resource_") == 0) {
                    if (key.equals("combine_resource_label")) {
                        this.current_combine = new CombineInfo();
                        this.combines.add(this.current_combine);
                    }
                    if (this.combines != null) {
                        this.current_combine.add(key, value);
                    }
                } else {
                    if (key.equals("track_name")) {
                        this.current_track = new TrackInfo();
                        this.tracks.add(this.current_track);
                    }
                    if (this.current_track != null) {
                        this.current_track.add(key, value);
                    }
                }
                this.options.put(key, value);
            } else {
                System.err.println("ignoring comment " + line);
            }
        }
        return status;
    }

    public boolean option_equals_lc(String key, String want_value) {
        String value = this.get(key);
        return value == null ? false : value.toLowerCase().equals(want_value);
    }

    public int[] get_int_list(String key) {
        int[] list = null;
        String s = this.get(key);
        if (s != null) {
            String[] f = s.split(",");
            list = new int[f.length];
            for (int i = 0; i < f.length; ++i) {
                list[i] = Integer.parseInt(f[i]);
            }
        }
        return list;
    }

    private int average(int[] list) {
        int result = 0;
        if (list != null) {
            int total = 0;
            for (int i = 0; i < list.length; ++i) {
                total += list[i];
            }
            result = total / list.length;
        }
        return result;
    }

    public int get_single_neutral_level() {
        return this.average(this.get_int_list("neutral"));
    }

    public ArrayList<TrackInfo> get_tracks() {
        return this.tracks;
    }

    public ArrayList<CombineInfo> get_combines() {
        return this.combines;
    }

    public DataScales get_data_scales() {
        return this.data_scales;
    }

    public GISTIC get_gistic() {
        return this.gistic;
    }

    public boolean has_gistic() {
        return this.gistic != null;
    }

    public boolean has_combines() {
        return this.combines != null && this.combines.size() > 0;
    }
}

