/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import java.util.ArrayList;
import java.util.HashMap;
import net.sf.samtools.SAMRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMMateFinder {
    HashMap<String, SAMRecord> mate_map;

    public SAMMateFinder(ArrayList<SAMRecord> sams) {
        this.setup(sams);
    }

    public void setup(ArrayList<SAMRecord> sams) {
        this.mate_map = new HashMap();
        for (SAMRecord sr : sams) {
            if (sr.getReadUnmappedFlag()) continue;
            this.mate_map.put(this.get_key(sr, true), sr);
        }
    }

    public SAMRecord queryMate(SAMRecord sr) {
        return sr.getMateUnmappedFlag() ? null : this.mate_map.get(this.get_key(sr, false));
    }

    private String get_key(SAMRecord sr, boolean use_primary) {
        String result = null;
        result = use_primary ? sr.getReadName() + "_" + sr.getReferenceIndex() + "_" + (sr.getReadNegativeStrandFlag() ? "-" : "+") + "_" + sr.getAlignmentStart() : sr.getReadName() + "_" + sr.getMateReferenceIndex() + "_" + (sr.getMateNegativeStrandFlag() ? "-" : "+") + "_" + sr.getMateAlignmentStart();
        return result;
    }
}

