/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IndelInfo;
import Ace2.ReferenceOrVariant;
import Ace2.SNPTrackInfo;
import Ace2.Strand;
import Ace2.TumorNormal;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TumorNormalReferenceTracker {
    EnumMap<ReferenceOrVariant, ArrayList<SNPTrackInfo>> tracker;
    EnumMap<ReferenceOrVariant, EnumMap<TumorNormal, EnumMap<Strand, Integer>>> counter;
    public static ArrayList<ReferenceOrVariant> all_rov;
    public static ArrayList<Strand> all_strand;
    public static ArrayList<TumorNormal> all_tn;

    public TumorNormalReferenceTracker() {
        if (all_rov == null) {
            all_rov = new ArrayList();
            all_rov.add(ReferenceOrVariant.REFERENCE);
            all_rov.add(ReferenceOrVariant.VARIANT);
            all_strand = new ArrayList();
            all_strand.add(Strand.STRAND_POSITIVE);
            all_strand.add(Strand.STRAND_NEGATIVE);
            all_tn = new ArrayList();
            all_tn.add(TumorNormal.TUMOR);
            all_tn.add(TumorNormal.NORMAL);
            all_tn.add(TumorNormal.UNKNOWN);
        }
        this.reset_counts();
    }

    private void reset_counts() {
        this.tracker = new EnumMap(ReferenceOrVariant.class);
        this.counter = new EnumMap(ReferenceOrVariant.class);
        for (ReferenceOrVariant rov : all_rov) {
            EnumMap tn_bucket = new EnumMap(TumorNormal.class);
            this.counter.put(rov, tn_bucket);
            for (TumorNormal tn : all_tn) {
                EnumMap<Strand, Integer> strand_bucket = new EnumMap<Strand, Integer>(Strand.class);
                tn_bucket.put(tn, strand_bucket);
                for (Strand str : all_strand) {
                    strand_bucket.put(str, new Integer(0));
                }
            }
        }
    }

    public void add(IndelInfo ii) {
        this.bucket_add(ReferenceOrVariant.VARIANT, new SNPTrackInfo(ii.sr, -1, ii.tumor_normal));
    }

    public void add(ReferenceOrVariant rov, SNPTrackInfo sti) {
        this.bucket_add(rov, sti);
    }

    public void addAll(ArrayList<IndelInfo> iis) {
        for (IndelInfo ii : iis) {
            this.add(ii);
        }
    }

    private String get_name(SAMRecord sr) {
        return sr.getReadName() + "." + (sr.getReadNegativeStrandFlag() ? "R" : "F");
    }

    public void add_set(ReferenceOrVariant rov, Strand strand, TumorNormal tn, int count) {
        EnumMap<Strand, Integer> bucket = this.counter.get((Object)rov).get((Object)tn);
        int current = bucket.get((Object)strand);
        bucket.put(strand, current + count);
    }

    public ArrayList<SNPTrackInfo> get_sti(ReferenceOrVariant rov) {
        return this.tracker.get((Object)rov);
    }

    public void analyze() {
        ArrayList<SNPTrackInfo> refs = this.tracker.get((Object)ReferenceOrVariant.REFERENCE);
        ArrayList<SNPTrackInfo> variants = this.tracker.get((Object)ReferenceOrVariant.VARIANT);
        HashSet<String> variant_names = new HashSet<String>();
        if (variants != null && refs != null) {
            for (SNPTrackInfo sti : variants) {
                variant_names.add(this.get_name(sti.sr));
            }
            ArrayList<SNPTrackInfo> remove = new ArrayList<SNPTrackInfo>();
            for (SNPTrackInfo sti : refs) {
                if (!variant_names.contains(this.get_name(sti.sr))) continue;
                remove.add(sti);
            }
            refs.removeAll(remove);
        }
        int error_count = 0;
        error_count += this.bucket_rov_tn(ReferenceOrVariant.REFERENCE);
        if ((error_count += this.bucket_rov_tn(ReferenceOrVariant.VARIANT)) > 0) {
            System.err.println("ERROR: can't track tumor/normal counts for " + error_count + " reads.  Don't know whether is BAM data is normal or tumor; use \"-tn [N|T]\" command line parameter");
        }
    }

    protected void bucket_add(ReferenceOrVariant rov, SNPTrackInfo sti) {
        ArrayList<SNPTrackInfo> bucket = this.tracker.get((Object)rov);
        if (bucket == null) {
            bucket = new ArrayList();
            this.tracker.put(rov, bucket);
        }
        bucket.add(sti);
    }

    public int get_count(ReferenceOrVariant rov, TumorNormal tn) {
        int total = 0;
        for (Integer count : this.counter.get((Object)rov).get((Object)tn).values()) {
            total += count.intValue();
        }
        return total;
    }

    public int get_count(ReferenceOrVariant rov, TumorNormal tn, Strand str) {
        return this.counter.get((Object)rov).get((Object)tn).get((Object)str);
    }

    public int get_coverage() {
        return this.get_count(ReferenceOrVariant.REFERENCE, TumorNormal.NORMAL) + this.get_count(ReferenceOrVariant.REFERENCE, TumorNormal.TUMOR) + this.get_count(ReferenceOrVariant.VARIANT, TumorNormal.NORMAL) + this.get_count(ReferenceOrVariant.VARIANT, TumorNormal.TUMOR);
    }

    public int get_coverage_fwd() {
        int count = 0;
        for (ReferenceOrVariant rov : all_rov) {
            EnumMap<TumorNormal, EnumMap<Strand, Integer>> bucket = this.counter.get((Object)rov);
            for (TumorNormal tn : all_tn) {
                count += bucket.get((Object)tn).get((Object)Strand.STRAND_POSITIVE).intValue();
            }
        }
        return count;
    }

    public int get_coverage_rev() {
        int count = 0;
        for (ReferenceOrVariant rov : all_rov) {
            EnumMap<TumorNormal, EnumMap<Strand, Integer>> bucket = this.counter.get((Object)rov);
            for (TumorNormal tn : all_tn) {
                count += bucket.get((Object)tn).get((Object)Strand.STRAND_NEGATIVE).intValue();
            }
        }
        return count;
    }

    public int get_variant_fwd_count() {
        EnumMap<TumorNormal, EnumMap<Strand, Integer>> bucket = this.counter.get((Object)ReferenceOrVariant.VARIANT);
        int count = 0;
        for (TumorNormal tn : all_tn) {
            count += bucket.get((Object)tn).get((Object)Strand.STRAND_POSITIVE).intValue();
        }
        return count;
    }

    public int get_variant_rev_count() {
        EnumMap<TumorNormal, EnumMap<Strand, Integer>> bucket = this.counter.get((Object)ReferenceOrVariant.VARIANT);
        int count = 0;
        for (TumorNormal tn : all_tn) {
            count += bucket.get((Object)tn).get((Object)Strand.STRAND_NEGATIVE).intValue();
        }
        return count;
    }

    public boolean get_variant_fwd_reverse_confirmation() {
        return this.get_variant_fwd_count() > 0 && this.get_variant_rev_count() > 0;
    }

    private int bucket_rov_tn(ReferenceOrVariant rov) {
        int errors = 0;
        ArrayList<SNPTrackInfo> set = this.tracker.get((Object)rov);
        if (set != null) {
            for (SNPTrackInfo i : set) {
                Strand str = Strand.valueOfSAMRecord(i.sr);
                if (i.tumor_normal == 78) {
                    this.add_set(rov, str, TumorNormal.NORMAL, 1);
                    continue;
                }
                if (i.tumor_normal == 84) {
                    this.add_set(rov, str, TumorNormal.TUMOR, 1);
                    continue;
                }
                ++errors;
            }
        }
        return errors;
    }

    public int get_unique_read_name_count(ReferenceOrVariant rov) {
        ArrayList<SNPTrackInfo> list = this.tracker.get((Object)rov);
        int count = 0;
        if (list != null) {
            HashSet<String> names = new HashSet<String>();
            for (SNPTrackInfo sti : list) {
                names.add(sti.sr.getReadName());
            }
            count = names.size();
        }
        return count;
    }
}

